/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportSchedulerUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static String getFileStoragePath() throws Exception {
        String fileStoragePath = null;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDScheduler"));
        query.addSelectColumn(Column.getColumn((String)"AUDScheduler", (String)"SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"AUDScheduler", (String)"FILE_STORAGE_PATH"));
        query.addSelectColumn(Column.getColumn((String)"AUDScheduler", (String)"MODIFICATION_TIME"));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"AUDScheduler", (String)"MODIFICATION_TIME"), false);
        query.addSortColumn(sortColumn);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("AUDScheduler");
            fileStoragePath = (String)row.get("FILE_STORAGE_PATH");
        } else {
            fileStoragePath = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "schedule-reports" + File.separator;
        }
        reportLogger.log(Level.FINE, "fileStoragePath is " + fileStoragePath);
        return fileStoragePath;
    }

    public static void enableDisableScheduler(Long schedulerId, String status) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)schedulerId, 0);
        DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", criteria);
        Iterator iter = dob.getRows("Scheduled_Task");
        while (iter.hasNext()) {
            Row r = (Row)iter.next();
            if (status.equalsIgnoreCase("Disable")) {
                r.set("ADMIN_STATUS", (Object)4);
            } else {
                r.set("ADMIN_STATUS", (Object)3);
            }
            dob.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dob);
        }
    }

    public static void deleteScheduler(Long scheduleId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        CommonUtil.getPersistenceLite().delete(criteria);
    }

    public static ArrayList getReportSchedulerHistory(Long scheduleId) throws Exception {
        ArrayList historyList = new ArrayList();
        DataObject dObj = ReportSchedulerUtil.getSuccessScheduledAuditDO(scheduleId);
        if (!dObj.isEmpty()) {
            Iterator ite = dObj.getRows("Schedule_Audit");
            while (ite.hasNext()) {
                HashMap<String, String> historyMap = new HashMap<String, String>();
                Row row = (Row)ite.next();
                Long auditId = (Long)row.get("AUDIT_ID");
                String dateValue = TimeUtil.getSimpleDateFormat(new Date(((Timestamp)row.get("SCHEDULE_START_TIME")).getTime()));
                historyMap.put("scheduleTime", dateValue);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDSchedulerAuditMapping", (String)"AUDIT_ID"), (Object)auditId, 0);
                Row mapRow = dObj.getRow("AUDSchedulerAuditMapping", crit);
                historyMap.put("fileStoragePath", (String)mapRow.get("DIRECTORY_NAME"));
                historyMap.put("status", (String)mapRow.get("MESSAGE"));
                historyList.add(historyMap);
            }
        }
        return historyList;
    }

    public static JSONArray getReportSchedulerHistory2(Long scheduleId) throws Exception {
        JSONArray historyList = new JSONArray();
        DataObject dObj = ReportSchedulerUtil.getSuccessScheduledAuditDO(scheduleId);
        if (!dObj.isEmpty()) {
            Iterator ite = dObj.getRows("Schedule_Audit");
            while (ite.hasNext()) {
                JSONObject historyMap = new JSONObject();
                Row row = (Row)ite.next();
                Long auditId = (Long)row.get("AUDIT_ID");
                String dateValue = TimeUtil.getSimpleDateFormat(new Date(((Timestamp)row.get("SCHEDULE_START_TIME")).getTime()));
                historyMap.put("scheduleTime", (Object)dateValue);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDSchedulerAuditMapping", (String)"AUDIT_ID"), (Object)auditId, 0);
                Row mapRow = dObj.getRow("AUDSchedulerAuditMapping", crit);
                historyMap.put("fileStoragePath", (Object)((String)mapRow.get("DIRECTORY_NAME")));
                historyMap.put("status", (Object)((String)mapRow.get("MESSAGE")));
                historyMap.put("scheduleId", (Object)scheduleId);
                historyList.put((Object)historyMap);
            }
        }
        return historyList;
    }

    public static void createScheduler(DataObject dataObject) throws Exception {
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public static void updateScheduler(DataObject dataObject, Long scheduleId, String scheduleType) throws Exception {
        Criteria c1 = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).getForPersonality("ScheduledReports", c1);
        Row taskRow = dObj.getFirstRow("Scheduled_Task");
        Row scheduleRow = dObj.getFirstRow("AUDScheduler");
        DataObject diffDO = dObj.diff(dataObject);
        if (diffDO.size("Scheduled_Task") > 0) {
            Row row = diffDO.getFirstRow("Scheduled_Task");
            row.set("ADMIN_STATUS", taskRow.get("ADMIN_STATUS"));
            diffDO.updateRow(row);
        }
        Row audSchedulerRow = diffDO.getFirstRow("AUDScheduler");
        audSchedulerRow.set("CREATION_TIME", scheduleRow.get("CREATION_TIME"));
        diffDO.updateRow(audSchedulerRow);
        CommonUtil.getPersistence(new boolean[0]).update(diffDO);
    }

    public static ArrayList getSchedulersList(String sortColumn, String sortOrder) throws Exception {
        ArrayList schedulersList = new ArrayList();
        String[] taskIdStr = new String[]{"TaskEngine_Task:task_id:2", "TaskEngine_Task:task_id:6", "TaskEngine_Task:task_id:7"};
        Long[] taskId = new Long[taskIdStr.length];
        for (int i = 0; i < taskIdStr.length; ++i) {
            taskId[i] = DBObjectUtil.getUVHValues("TaskEngine_Task", taskIdStr[i]);
        }
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"TaskEngine_Task"));
        Criteria criteria = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_ID"), (Object)taskId, 8);
        Join scheduleTaskJoin = new Join("TaskEngine_Task", "Scheduled_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 2);
        Join scheduleJoin = new Join("Scheduled_Task", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
        Join audschedulerJoin = new Join("Schedule", "AUDScheduler", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
        Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
        Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
        query.setCriteria(criteria);
        query.addJoin(scheduleTaskJoin);
        query.addJoin(scheduleJoin);
        query.addJoin(audschedulerJoin);
        query.addJoin(periodicJoin);
        query.addJoin(calendarJoin);
        query.addSelectColumns((List)ReportSchedulerUtil.getColumnList("Schedule", new String[]{"SCHEDULE_ID", "SCHEDULE_NAME"}));
        query.addSelectColumns((List)ReportSchedulerUtil.getColumnList("Scheduled_Task", new String[]{"SCHEDULE_ID", "TASK_ID", "ADMIN_STATUS"}));
        query.addSelectColumns((List)ReportSchedulerUtil.getColumnList("AUDScheduler", new String[]{"SCHEDULE_ID", "MODIFICATION_TIME"}));
        query.addSelectColumns((List)ReportSchedulerUtil.getColumnList("Calendar", new String[]{"SCHEDULE_ID", "REPEAT_FREQUENCY", "UNIT_OF_TIME", "TIME_OF_DAY", "DAY_OF_WEEK", "DATE_OF_MONTH"}));
        query.addSelectColumns((List)ReportSchedulerUtil.getColumnList("Periodic", new String[]{"SCHEDULE_ID", "TIME_PERIOD", "UNIT_OF_TIME", "START_DATE"}));
        SortColumn sortCol = null;
        if (sortColumn != null && sortOrder != null) {
            reportLogger.log(Level.INFO, "index is " + sortColumn.indexOf("-"));
            String tableName = sortColumn.substring(0, sortColumn.indexOf("-"));
            String columnName = sortColumn.substring(sortColumn.indexOf("-") + 1);
            reportLogger.log(Level.INFO, "column and table name is " + tableName + "   " + columnName);
            sortCol = sortOrder.equalsIgnoreCase("desc") ? new SortColumn(Column.getColumn((String)tableName, (String)columnName), false) : new SortColumn(Column.getColumn((String)tableName, (String)columnName), true);
        }
        if (sortCol == null) {
            sortCol = new SortColumn(Column.getColumn((String)"AUDScheduler", (String)"MODIFICATION_TIME"), false);
        }
        query.addSortColumn(sortCol);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        if (dObj.size("Schedule") > 0) {
            Iterator iterator = dObj.getRows("Schedule");
            while (iterator.hasNext()) {
                Hashtable<String, Object> scheduleDetails = new Hashtable<String, Object>();
                Row scheduleRow = (Row)iterator.next();
                scheduleDetails.put("SCHEDULE_ID", (Long)scheduleRow.get("SCHEDULE_ID"));
                scheduleDetails.put("SCHEDULE_NAME", rb.getString((String)scheduleRow.get("SCHEDULE_NAME")));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDScheduler", (String)"SCHEDULE_ID"), (Object)((Long)scheduleRow.get("SCHEDULE_ID")), 0);
                Row audschedulerRow = dObj.getRow("AUDScheduler", crit);
                boolean isDefaultScheduler = true;
                if (audschedulerRow != null) {
                    scheduleDetails.put("MODIFICATION_TIME", (Long)audschedulerRow.get("MODIFICATION_TIME"));
                    isDefaultScheduler = false;
                }
                scheduleDetails.put("IS_DEFAULT_SCHEDULER", isDefaultScheduler);
                Criteria taskInputCrit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)((Long)scheduleRow.get("SCHEDULE_ID")), 0);
                Row taskInputRow = dObj.getRow("Scheduled_Task", taskInputCrit);
                scheduleDetails.put("STATUS", (Integer)taskInputRow.get("ADMIN_STATUS"));
                scheduleDetails.put("SCHEDULE_TIME", ReportSchedulerUtil.getTimePeriod(dObj, (Long)scheduleRow.get("SCHEDULE_ID")));
                DataObject dataObject = ReportSchedulerUtil.getRecentScheduleAuditDO((Long)scheduleRow.get("SCHEDULE_ID"));
                if (!dataObject.isEmpty()) {
                    if (dataObject.containsTable("AUDSchedulerAuditMapping")) {
                        Row auditRow = dataObject.getFirstRow("AUDSchedulerAuditMapping");
                        scheduleDetails.put("MESSAGE", (String)auditRow.get("MESSAGE"));
                        scheduleDetails.put("SCHEDULE_STATUS", (String)auditRow.get("STATUS"));
                    } else {
                        scheduleDetails.put("MESSAGE", "-");
                        scheduleDetails.put("SCHEDULE_STATUS", "SUCCESS");
                    }
                    Row scheduledAuditRow = dataObject.getFirstRow("Schedule_Audit");
                    String dateValue = TimeUtil.getSimpleDateFormat(new Date(((Timestamp)scheduledAuditRow.get("SCHEDULE_START_TIME")).getTime()));
                    scheduleDetails.put("LAST_SCHEDULE_TIME", dateValue);
                } else {
                    scheduleDetails.put("MESSAGE", "-");
                    scheduleDetails.put("SCHEDULE_STATUS", "SUCCESS");
                    scheduleDetails.put("LAST_SCHEDULE_TIME", "-");
                }
                schedulersList.add(scheduleDetails);
            }
        }
        return schedulersList;
    }

    public static String getTimePeriod(DataObject dObj, Long scheduleId) throws Exception {
        String timePeriod = null;
        String[] daysOfWeek = new DateFormatSymbols().getWeekdays();
        Criteria periodicCrit = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        Row periodicRow = dObj.getRow("Periodic", periodicCrit);
        if (periodicRow != null) {
            Date date = (Date)periodicRow.get("START_DATE");
            timePeriod = rb.handleGetObject("adap.ReportSchedulerUtil.Every_hour_at_th_minute", new String[]{Integer.valueOf(date.getHours()).toString(), Integer.valueOf(date.getMinutes()).toString()});
        } else {
            Criteria calendarCrit = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            Row calendarRow = dObj.getRow("Calendar", calendarCrit);
            String repeatFrequency = (String)calendarRow.get("REPEAT_FREQUENCY");
            Long timeOfDay = (Long)calendarRow.get("TIME_OF_DAY");
            String unitOfTime = (String)calendarRow.get("UNIT_OF_TIME");
            if (repeatFrequency.equalsIgnoreCase("daily")) {
                timePeriod = unitOfTime.equalsIgnoreCase("Hours") ? rb.getString("adap.ReportSchedulerUtil.Everyday_at__TimeUtilgetHourtimeOfDay") + TimeUtil.getHour(timeOfDay * 60L) : rb.getString("adap.ReportSchedulerUtil.Everyday_at__TimeUtilgetHourtimeOfDay") + TimeUtil.getHour(timeOfDay);
            } else if (repeatFrequency.equalsIgnoreCase("weekly")) {
                timePeriod = rb.handleGetObject("adap.ReportSchedulerUtil.Every__daysOfWeekIntegercalendarRowgetDAY_OF_WEEK__at", new String[]{daysOfWeek[(Integer)calendarRow.get("DAY_OF_WEEK")], TimeUtil.getHour(timeOfDay)});
            } else if (repeatFrequency.equalsIgnoreCase("monthly")) {
                timePeriod = rb.handleGetObject("adap.ReportSchedulerUtil.Every_month_on_day", new String[]{calendarRow.get("DATE_OF_MONTH").toString(), TimeUtil.getHour(timeOfDay)});
            }
        }
        return timePeriod;
    }

    private static DataObject getSuccessScheduledAuditDO(Long scheduleId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDSchedulerAuditMapping", (String)"STATUS"), (Object)"ERROR", 1);
        return ReportSchedulerUtil.getScheduleAuditMapDO(scheduleId, criteria);
    }

    private static DataObject getRecentScheduleAuditDO(Long scheduleId) throws Exception {
        return ReportSchedulerUtil.getScheduleAuditMapDO(scheduleId, null);
    }

    private static DataObject getScheduleAuditMapDO(Long scheduleId, Criteria crit) throws Exception {
        Criteria scheAuditCrit = new Criteria(Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        if (crit != null) {
            scheAuditCrit = scheAuditCrit.and(crit);
        }
        SelectQueryImpl statusQuery = new SelectQueryImpl(Table.getTable((String)"Schedule_Audit"));
        statusQuery.setCriteria(scheAuditCrit);
        statusQuery.addSelectColumn(Column.getColumn((String)"Schedule_Audit", (String)"*"));
        Criteria crit1 = new Criteria(Column.getColumn((String)"AUDScheduler", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject d = CommonUtil.getPersistence(new boolean[0]).get("AUDScheduler", crit1);
        if (!d.isEmpty()) {
            Join auditJoin = new Join("Schedule_Audit", "AUDSchedulerAuditMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            statusQuery.addJoin(auditJoin);
            statusQuery.addSelectColumn(Column.getColumn((String)"AUDSchedulerAuditMapping", (String)"*"));
        }
        SortColumn auditSort = new SortColumn(Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_START_TIME"), false);
        statusQuery.addSortColumn(auditSort);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)statusQuery);
        return dObj;
    }

    public static ArrayList getColumnList(String tableName, String[] cols) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < cols.length; ++i) {
            list.add(Column.getColumn((String)tableName, (String)cols[i]));
        }
        return list;
    }

    public static HashMap formInputParamsMap(HashMap inputParams, HashMap inputParamsMap, Long reportId) throws Exception {
        HashMap<String, Object> reportMap = AuditReportAPI.getInstance().getReportDetails(reportId);
        String expectedObjClass = reportMap.get("EXPECTED_OBJECT_CLASS") != null ? (String)reportMap.get("EXPECTED_OBJECT_CLASS") : "";
        return ReportSchedulerUtil.formInputParamsMap(expectedObjClass, inputParams, inputParamsMap);
    }

    public static HashMap formInputParamsMap(String expectedObjClass, HashMap inputParams, HashMap inputParamsMap) throws Exception {
        boolean condition2;
        ArrayList guidList = (ArrayList)inputParams.get("object_guid");
        boolean condition1 = !expectedObjClass.equalsIgnoreCase((String)inputParams.get("objectClass")) && expectedObjClass.length() > 0;
        boolean bl = condition2 = inputParams.get("objectClass") != null;
        if (condition1 && condition2) {
            ArrayList<String> sidList = new ArrayList<String>();
            ArrayList<String> sidNameList = new ArrayList<String>();
            for (Object guid : guidList) {
                ArrayList hashMapList = DirectoryObjectAPI.getInstance().getChildObjects((String)inputParamsMap.get("domainDNSName"), (String)inputParams.get("objectClass"), expectedObjClass, (String)guid);
                for (HashMap map1 : hashMapList) {
                    sidList.add("'" + (String)map1.get("SID_STRING") + "'");
                    sidNameList.add("'" + EscapeUtil.escSplCharsAsSQL(((String)map1.get("SAM_ACCOUNT_NAME")).toLowerCase()) + "'");
                }
            }
            if (!sidNameList.isEmpty()) {
                String sidString = Arrays.toString(sidList.toArray(new String[sidList.size()]));
                String sidNameString = Arrays.toString(sidNameList.toArray(new String[sidNameList.size()]));
                inputParamsMap.put("objectSIDStr", sidString.substring(1, sidString.length() - 1));
                String[] sidStringArray = sidList.toArray(new String[sidList.size()]);
                String objectSidString = "";
                for (int i = 0; i < sidStringArray.length; ++i) {
                    String tempString = sidStringArray[i].replaceAll("'", "");
                    objectSidString = objectSidString + "'%{" + tempString + "}'";
                    if (i == sidStringArray.length - 1) continue;
                    objectSidString = objectSidString + ",";
                }
                inputParamsMap.put("objectSID", objectSidString);
                inputParamsMap.put("objectName", sidNameString.substring(1, sidNameString.length() - 1));
            } else {
                inputParamsMap.put("objectSIDStr", "'-'");
                inputParamsMap.put("objectSID", "'-'");
            }
        }
        return inputParamsMap;
    }

    public static String delReports(String type) {
        reportLogger.log(Level.FINE, "Deleting Reports : " + type);
        String status = "false";
        String reportLife = "";
        try {
            Criteria c = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
            DataObject d = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", c);
            Iterator rs = d.getRows("SystemParams", (Criteria)null);
            if (d.isEmpty()) {
                reportLogger.log(Level.INFO, "Cleaing Schedule Reports : Not Scheduled");
                return "notScheduled";
            }
            Row r = d.getFirstRow("SystemParams");
            reportLife = (String)r.get("PARAM_VALUE");
            if (reportLife.equals("-1")) {
                reportLogger.log(Level.INFO, "Cleaing Schedule Reports : Not Scheduled");
                return "notScheduled";
            }
            Criteria c1 = new Criteria(new Column("AUDScheduler", "IS_SINGLE_FOLDER"), (Object)false, 0);
            DataObject d1 = CommonUtil.getPersistence(new boolean[0]).get("AUDScheduler", c1);
            Iterator rs1 = d1.getRows("AUDScheduler", (Criteria)null);
            while (rs1.hasNext()) {
                Row r1 = (Row)rs1.next();
                Criteria c2 = new Criteria(new Column("Schedule_Audit", "SCHEDULE_ID"), r1.get("SCHEDULE_ID"), 0);
                c2 = c2.and(new Criteria(new Column("Schedule_Audit", "TASK_EXECUTION_STATUS"), (Object)"SUCCESS", 0));
                Table table1 = new Table("Schedule_Audit");
                SelectQueryImpl sq = new SelectQueryImpl(table1);
                sq.setCriteria(c2);
                Column col1 = Column.getColumn(null, (String)"*");
                ArrayList<Column> colList = new ArrayList<Column>();
                colList.add(col1);
                sq.addSelectColumns(colList);
                Join join = new Join("Schedule_Audit", "AUDSchedulerAuditMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
                sq.addJoin(join);
                DataObject d2 = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                Iterator i2 = d2.getRows("Schedule_Audit", (Criteria)null);
                while (i2.hasNext()) {
                    String path;
                    Row r2 = (Row)i2.next();
                    Criteria c3 = new Criteria(new Column("AUDSchedulerAuditMapping", "AUDIT_ID"), r2.get("AUDIT_ID"), 0);
                    Row r3 = d2.getRow("AUDSchedulerAuditMapping", c3);
                    Date date = (Date)r2.get("SCHEDULE_START_TIME");
                    Long ctime = date.getTime();
                    Long diff = System.currentTimeMillis() - ctime;
                    diff = diff / 1000L / 60L / 60L;
                    Long life = Long.parseLong(reportLife) * 24L;
                    if (diff < life || (path = (String)r3.get("DIRECTORY_NAME")) == null || path.trim().equals("")) continue;
                    String storagePath = "";
                    storagePath = path.substring(0, 2).equals("\\\\") ? path : (path.substring(1, 2).equals(":") ? path : System.getProperty("server.dir") + File.separator + "webapps" + File.separator + r3.get("DIRECTORY_NAME"));
                    File index = new File(storagePath);
                    String[] entries = index.list();
                    if (entries != null) {
                        for (String s : entries) {
                            File currentFile = new File(index.getPath(), s);
                            reportLogger.log(Level.INFO, "Cleaning Schedule Reports : " + index.getAbsolutePath() + " " + currentFile.getName());
                            currentFile.delete();
                        }
                        index.delete();
                    }
                    Criteria c4 = new Criteria(new Column("Schedule_Audit", "AUDIT_ID"), r2.get("AUDIT_ID"), 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(c4);
                }
            }
            status = "true";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = "false";
        }
        return status;
    }
}

