/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;

public class ReportUtil {
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static ReportUtil repUtil = null;
    protected static ArrayList<String> reservedKeywordsList = new ArrayList();
    public static String pdf_FontName = "FontName";
    public static String pdf_FontEncoding = "Encoding";
    public static String pdf_FontEmbedded = "Embedded";

    public static ReportUtil getInstance() {
        if (repUtil == null) {
            try {
                repUtil = new ReportUtil();
            }
            catch (Exception e) {
                e.printStackTrace();
                repUtil = new ReportUtil();
            }
        }
        return repUtil;
    }

    public static HashMap<String, Object> formMap(String[] keys, Object[] values) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.setMap(map, keys, values);
        return map;
    }

    public static void setMap(HashMap<String, Object> map, String[] keys, Object[] values) throws Exception {
        for (int size = 0; size < keys.length; ++size) {
            map.put(keys[size], values[size]);
        }
    }

    public static String queryBuilder(String[] queryStrs) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < queryStrs.length; ++i) {
            sb.append(queryStrs[i]);
        }
        return sb.toString();
    }

    public HashMap applyOtherLanguageStyle(String locale) {
        HashMap<String, Object> fontStyle = new HashMap<String, Object>();
        if ("ru".equals(locale)) {
            logger.log(Level.FINE, "RussianFont ");
            File f = new File("C:\\Windows\\fonts\\tahoma.ttf");
            if (f.exists()) {
                fontStyle.put(pdf_FontName, "C:\\Windows\\fonts\\tahoma.ttf");
                fontStyle.put(pdf_FontEncoding, "Cp1251");
                fontStyle.put(pdf_FontEmbedded, true);
            } else {
                logger.log(Level.FINE, "NormalFont ");
                fontStyle.put(pdf_FontName, "Helvetica-Oblique");
                fontStyle.put(pdf_FontEncoding, "Cp1252");
                fontStyle.put(pdf_FontEmbedded, false);
            }
        } else if ("ar".equals(locale)) {
            logger.log(Level.FINE, "ArabicFont ");
            File f = new File("C:\\Windows\\fonts\\arial.ttf");
            if (f.exists()) {
                fontStyle.put(pdf_FontName, "C:\\Windows\\fonts\\arial.ttf");
                fontStyle.put(pdf_FontEncoding, "Identity-H");
                fontStyle.put(pdf_FontEmbedded, true);
            } else {
                logger.log(Level.FINE, "NormalFont ");
                fontStyle.put(pdf_FontName, "Helvetica-Oblique");
                fontStyle.put(pdf_FontEncoding, "Cp1252");
                fontStyle.put(pdf_FontEmbedded, false);
            }
        } else if ("ja".equals(locale)) {
            fontStyle.put(pdf_FontName, "HeiseiKakuGo-W5");
            fontStyle.put(pdf_FontEncoding, "UniJIS-UCS2-H");
            fontStyle.put(pdf_FontEmbedded, true);
        } else if ("zh".equals(locale)) {
            fontStyle.put(pdf_FontName, "STSong-Light");
            fontStyle.put(pdf_FontEncoding, "UniGB-UCS2-H");
            fontStyle.put(pdf_FontEmbedded, true);
        } else if ("pl".equals(locale)) {
            fontStyle.put(pdf_FontName, "Helvetica-Oblique");
            fontStyle.put(pdf_FontEncoding, "Cp1250");
            fontStyle.put(pdf_FontEmbedded, false);
        } else if ("tr".equals(locale)) {
            fontStyle.put(pdf_FontName, "Helvetica-Oblique");
            fontStyle.put(pdf_FontEncoding, "Cp1254");
            fontStyle.put(pdf_FontEmbedded, false);
        } else if ("ko".equals(locale)) {
            fontStyle.put(pdf_FontName, "HYGoThic-Medium");
            fontStyle.put(pdf_FontEncoding, "UniKS-UCS2-H");
            fontStyle.put(pdf_FontEmbedded, false);
        } else {
            logger.log(Level.FINE, "NormalFont ");
            fontStyle.put(pdf_FontName, "Helvetica-Oblique");
            fontStyle.put(pdf_FontEncoding, "Cp1252");
            fontStyle.put(pdf_FontEmbedded, false);
        }
        return fontStyle;
    }

    public static Row formRow(String tableName, String[] columnNames, Object[] columnValues) throws Exception {
        Row row = new Row(tableName);
        return ReportUtil.formRow(row, columnNames, columnValues);
    }

    public static Row formRow(Row row, String[] columnNames, Object[] columnValues) throws Exception {
        for (int i = 0; i < columnNames.length; ++i) {
            row.set(columnNames[i], columnValues[i]);
        }
        return row;
    }

    public static Integer getCategoryType(Long categoryId) throws Exception {
        Integer categoryType = 1;
        Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)categoryId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", crit);
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("AUDReports");
            categoryType = (Integer)row.get("REPORT_CATEGORY_TYPE");
        }
        return categoryType;
    }

    public static SelectQuery getSelectQuery(String[] tableNames, boolean[] isLeftJoins, Criteria crit) throws Exception {
        ArrayList<String> tableList = new ArrayList<String>();
        for (int i = 0; i < tableNames.length; ++i) {
            tableList.add(tableNames[i]);
        }
        SelectQuery sq = QueryConstructor.get(tableList, (boolean[])isLeftJoins, (Criteria)crit);
        return sq;
    }

    public static String addQuotes(String inputString) throws Exception {
        StringTokenizer st = new StringTokenizer(inputString, ",");
        String outputStr = null;
        while (st.hasMoreTokens()) {
            outputStr = outputStr != null ? outputStr + " , " + "'" + st.nextToken() + "'" : "'" + st.nextToken() + "'";
        }
        return outputStr;
    }

    public static String removeQuotes(String inputString) throws Exception {
        StringTokenizer st = new StringTokenizer(inputString, ",");
        String outputStr = null;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken().trim();
            temp = temp.indexOf("'") == 0 ? temp.substring(1, temp.length() - 1) : temp;
            outputStr = outputStr != null ? outputStr + " , " + temp : temp;
        }
        return outputStr;
    }

    public static Long isReportAvailable(Long reportId, String selectedTab) throws Exception {
        String pattern = selectedTab.equals("reports") ? "AUDReports:audit_report_id:57" : "AUDReports:audit_report_id:10801";
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
        if (dataObject.isEmpty()) {
            reportId = DBObjectUtil.getUVHValues("AUDReports", pattern);
        }
        return reportId;
    }

    public static String addRowToPattern(String patternValue) throws Exception {
        String[] patternValues = new String[]{patternValue.replace(",", "+"), patternValue, patternValue.replace(",", "+").replace("CAST(", "").replace(" as VARCHAR)", "")};
        String patternName = patternValue.replace(" , ", "_").replace("CAST(", "").replace(" as VARCHAR)", "");
        Properties patternMap = ADAPSQLQueryUtil.getFunctionPattern("MSSQL_COLUMN_VALUE");
        if (patternMap.get(patternName) == null) {
            ReportUtil.addRowToPattern(patternName, patternValues);
        }
        QueryBuilder queryBuilder = QueryBuilderAPI.getInstance().getQueryBuilder();
        queryBuilder.updatePatternMap();
        return ReportUtil.queryBuilder(new String[]{"${PATTERNREPLACE:", patternName, "}"});
    }

    public static void addRowToPattern(String patternName, String[] patternValues) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row row = ReportUtil.formRow("AUDSQLQueryColumnPattern", new String[]{"MSSQL_COLUMN_VALUE", "POSTGRES_COLUMN_VALUE", "MYSQL_COLUMN_VALUE"}, (Object[])patternValues);
        row.set("PATTERN_NAME", (Object)patternName);
        dataObject.addRow(row);
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public static Long addNewReportCategory(String categoryName) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row row = ReportUtil.formRow("AUDReportCategories", new String[]{"NAME", "SR_NAME", "PRIORITY"}, new Object[]{categoryName, categoryName, ReportUtil.getMaxPriorityId() + 1L});
        dataObject.addRow(row);
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        return (Long)row.get("REPORT_CATEGORY_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getMaxPriorityId() throws Exception {
        DataSet dataSet = null;
        Long priorityId = 0L;
        try (Connection connection = null;){
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDReportCategories"));
            query.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"PRIORITY").maximum());
            query.setCriteria(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"NAME"), (Object)"adap.AUDReportCategories.name.My_Reports", 1));
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)query, connection);
            if (dataSet != null) {
                while (dataSet.next()) {
                    priorityId = dataSet.getValue(1) != null ? (Long)dataSet.getValue(1) : 0L;
                }
            }
        }
        return priorityId;
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Row getFirstRow(String tableName, String columnName, Object columnValue, int operator) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), columnValue, operator);
        return ReportUtil.getFirstRow(crit, tableName);
    }

    public static Row getFirstRow(Criteria criteria, String tableName) throws Exception {
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
        if (dObj.size(tableName) <= 0) {
            return null;
        }
        return dObj.getFirstRow(tableName);
    }

    public static ArrayList getDCFromScheduleId(ArrayList scheduleIds) throws Exception {
        ArrayList<String> dcList = new ArrayList<String>();
        Criteria crit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"SCHEDULE_ID"), (Object)scheduleIds.toArray(), 8);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("ADSMDCConfiguration");
        tableList.add("AUDDCEventRead");
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
        Iterator iterator = dObj.getRows("ADSMDCConfiguration");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            dcList.add((String)row.get("DOMAIN_CONTROLLER_NAME"));
        }
        return dcList;
    }

    public static Iterator getRows(String tableName, String columnName, Object[] columnValues) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)columnValues, 8);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
        return dObj.getRows(tableName);
    }

    public static String getColumnFromRows(Iterator<Row> iterator, String columnName, AdventNetResourceBundle rb) throws Exception {
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Row row = iterator.next();
            sb.append(rb.getString((String)row.get(columnName))).append("\n");
        }
        return sb.toString();
    }

    public static ArrayList getMSNamesFromId(ArrayList msIds, String columnName) throws Exception {
        ArrayList<String> msList = new ArrayList<String>();
        Criteria crit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)columnName), (Object)msIds.toArray(), 8);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("ADSMComputerGeneralDetails");
        tableList.add("AUDComputerEventRead");
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
        Iterator iterator = dObj.getRows("ADSMComputerGeneralDetails");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            msList.add((String)row.get("NAME"));
        }
        return msList;
    }

    public static String getReportIdfromCustomId(Long customReportId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"CUSTOM_REPORT_ID"), (Object)customReportId, 0);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("AUDCustomReports");
        tableList.add("AUDReports");
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
        Row row = dObj.getFirstRow("AUDReports");
        return (String)row.get("TITLE");
    }

    public static String getFirstDomainFromList(ArrayList domainsList) {
        Properties prop = (Properties)domainsList.get(0);
        return (String)prop.get("DOMAIN_NAME");
    }

    public static Long[] jsonArrayToLongArray(JSONArray jsonArrStr) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < jsonArrStr.length(); ++i) {
            list.add(Long.parseLong(jsonArrStr.getString(i)));
        }
        Long[] longArr = new Long[list.size()];
        longArr = list.toArray(longArr);
        return longArr;
    }

    public static Row getComputerObjRow(String domainName, String value, String columnName, String objectClass) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)value, 0);
        crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)value, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", crit);
        Row row = null;
        if (dObj.isEmpty()) {
            row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, value, "NAME", objectClass);
            if (row == null) {
                row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, value, "DNS_NAME", objectClass);
            }
        } else {
            row = dObj.getFirstRow("ADSMComputerGeneralDetails");
        }
        return row;
    }

    public static Long getDefaultSAReportId(HttpSession session, Long categoryType, String uvhPattern) {
        Long reportId = DBObjectUtil.getUVHValues("AUDReports", uvhPattern);
        try {
            Row row;
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)authObject.getUserActins().toArray(), 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", crit);
            if (dataObject.isEmpty()) {
                crit = new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), (Object)authObject.getUserActins().toArray(), 8);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), (Object)1L, 0));
                dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReportCategories", crit);
                if (!dataObject.isEmpty()) {
                    crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)1L, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)categoryType, 0));
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", crit);
                }
            }
            if ((row = dataObject.getRow("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0))) == null && !dataObject.isEmpty()) {
                row = dataObject.getFirstRow("AUDReports");
            }
            reportId = row != null ? (Long)row.get("AUDIT_REPORT_ID") : reportId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportId;
    }

    public static String strToStrWithQuote(String str, String delimiter) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] str1 = str.split(delimiter);
            for (int i = 0; i < str1.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'").append(str1[i]).append("'");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static boolean checkFilter(String criteriaValue, Boolean[] valueArr) {
        boolean status = true;
        String[] arr = criteriaValue.replace("  ", " ").replace("  (", " (").replace(")  ", ") ").replace("(  ", "( ").replace("  )", " )").toLowerCase().split(" ");
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].equals("(") || arr[i].equals(")") || arr[i].equals("and") || arr[i].equals("or") || "".equals(arr[i])) continue;
            arr[i] = valueArr[Integer.parseInt(arr[i]) - 1] != false ? "true" : "false";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < arr.length; ++i) {
            String topToken;
            if (!arr[i].equals(")")) {
                stack.push(arr[i]);
                continue;
            }
            boolean result = true;
            String oper = "and";
            while (!(topToken = stack.pop().toString()).equals("(")) {
                if (topToken.equals("and") || topToken.equals("or")) {
                    oper = topToken;
                    continue;
                }
                if (oper.equals("and")) {
                    result = Boolean.valueOf(result) & Boolean.valueOf(topToken);
                    continue;
                }
                result = Boolean.valueOf(result) | Boolean.valueOf(topToken);
            }
            stack.push(Boolean.valueOf(result).toString());
        }
        boolean result = true;
        String oper = "and";
        while (!stack.empty()) {
            String topToken = stack.pop().toString();
            if (topToken.equals("and") || topToken.equals("or")) {
                oper = topToken;
                continue;
            }
            if (oper.equals("and")) {
                result = Boolean.valueOf(result) & Boolean.valueOf(topToken);
                continue;
            }
            result = Boolean.valueOf(result) | Boolean.valueOf(topToken);
        }
        stack.push(Boolean.valueOf(result).toString());
        status = Boolean.valueOf((String)stack.peek());
        return status;
    }

    public static boolean compareStringValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            String conditionString = conditionValue.toString().toLowerCase();
            String valueString = String.valueOf(value).toLowerCase();
            if (operation == 1) {
                if (conditionString.startsWith("pattern:")) {
                    flag = Pattern.matches(conditionString.substring(conditionString.indexOf(":") + 1), valueString);
                } else if (conditionString.equalsIgnoreCase("${CONFOBJ}")) {
                    valueString = valueString.replace("%{", "");
                    valueString = valueString.replace("}", "");
                    flag = SchemaAPI.getInstance().isConfigurationClass(valueString) >= 0;
                } else {
                    flag = valueString.equalsIgnoreCase(conditionString);
                }
            } else if (operation == 2) {
                if (conditionString.startsWith("pattern:")) {
                    flag = !Pattern.matches(conditionString.substring(conditionString.indexOf(":") + 1), valueString);
                } else if (conditionString.equalsIgnoreCase("${CONFOBJ}")) {
                    valueString = valueString.replace("%{", "");
                    valueString = valueString.replace("}", "");
                    flag = SchemaAPI.getInstance().isConfigurationClass(valueString) < 0;
                } else {
                    flag = !valueString.equalsIgnoreCase(conditionString);
                }
            } else if (operation == 7) {
                flag = valueString.startsWith(conditionString);
            } else if (operation == 9) {
                flag = !valueString.startsWith(conditionString);
            } else if (operation == 8) {
                flag = valueString.endsWith(conditionString);
            } else if (operation == 10) {
                flag = !valueString.endsWith(conditionString);
            } else if (operation == 13) {
                flag = valueString.contains(conditionString);
            } else if (operation == 14) {
                flag = !valueString.contains(conditionString);
            } else if (operation == 11) {
                flag = valueString.contains(conditionString);
            } else if (operation == 12) {
                flag = !valueString.contains(conditionString);
            } else if (operation == 0) {
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean compareNumericValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            long conditionInt = Long.parseLong(conditionValue.toString());
            long valueInt = Long.parseLong(value.toString());
            if (operation == 1) {
                flag = valueInt == conditionInt;
            } else if (operation == 2) {
                flag = valueInt != conditionInt;
            } else if (operation == 3) {
                flag = valueInt < conditionInt;
            } else if (operation == 4) {
                flag = valueInt <= conditionInt;
            } else if (operation == 5) {
                flag = valueInt > conditionInt;
            } else if (operation == 6) {
                flag = valueInt < conditionInt;
            } else if (operation == 0) {
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

