/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchReports {
    private static Logger reportLogger = Logger.getLogger("com.adventnet.sym.adsm.auditing.server.reports.SearchReports.class");
    private static volatile SearchReports searchReports = null;

    private SearchReports() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchReports getInstance() {
        if (searchReports != null) return searchReports;
        Class<SearchReports> clazz = SearchReports.class;
        synchronized (SearchReports.class) {
            if (searchReports != null) return searchReports;
            searchReports = new SearchReports();
            // ** MonitorExit[var0] (shouldn't be in output)
            return searchReports;
        }
    }

    public static LinkedHashMap getAllCategories(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        LinkedHashMap<Long, String> categoryMap = new LinkedHashMap<Long, String>();
        DataObject dObj = CustomReportUtil.getReportCategoriesDO(null);
        if (!dObj.isEmpty()) {
            Iterator iterator = dObj.getRows("AUDReportCategories");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                categoryMap.put((Long)row.get("REPORT_CATEGORY_ID"), rb.getString((String)row.get("NAME")));
            }
        }
        return categoryMap;
    }

    public JSONArray getAllCategoriesEmber(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONArray reportCategoryList = new JSONArray();
        DataObject dObj = CustomReportUtil.getReportCategoriesDO(null);
        if (!dObj.isEmpty()) {
            Iterator iterator = dObj.getRows("AUDReportCategories");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject categoryMap = new JSONObject();
                categoryMap.put("value", (Object)((Long)row.get("REPORT_CATEGORY_ID")));
                categoryMap.put("name", (Object)rb.getString((String)row.get("NAME")));
                reportCategoryList.put((Object)categoryMap);
            }
        }
        return reportCategoryList;
    }

    public Long saveSearchReportsResult(Long categoryId, String reportName, String description, Long currReportId, String searchCriteria, Long loginId) throws Exception {
        AuditReportAPI.getInstance();
        DataObject dObj = AuditReportAPI.getReportsDO(currReportId);
        HashMap<String, Cloneable> reportDetailsMap = new HashMap<String, Cloneable>();
        reportDetailsMap.put("AUDReports", SearchReports.getAUDReportsDetails(dObj, categoryId, reportName, description, loginId));
        reportDetailsMap.put("AUDSQLQuery", SearchReports.getAUDSQLQueryDetails(dObj, searchCriteria, reportName));
        Row viewRow = dObj.getFirstRow("AUDTableViewConfig");
        HashMap<String, Object> viewConfigMap = new HashMap<String, Object>();
        viewConfigMap.put("EMPTY_TABLE_MESSAGE", "adap.AudMonitorReportHandler.No_Result_Found");
        viewConfigMap.put("PAGELENGTH", 25);
        viewConfigMap.put("SORTCOLUMN", viewRow.get("SORTCOLUMN"));
        viewConfigMap.put("SORTORDER", viewRow.get("SORTORDER"));
        reportDetailsMap.put("AUDTableViewConfig", viewConfigMap);
        HashMap elementMap = SearchReports.getElementMap(dObj);
        Long reportId = AuditReportHandler.saveNewReportDetails(reportDetailsMap, elementMap);
        return reportId;
    }

    private static HashMap getAUDReportsDetails(DataObject dObj, Long categoryId, String reportName, String description, Long loginId) throws Exception {
        Row row = dObj.getRow("AUDReports");
        String[] keys = new String[]{"REPORT_CATEGORY_TYPE", "REPORT_CATEGORY_ID", "AUDIT_REPORT_NAME", "DISPLAY_TYPE", "TITLE", "DESCRIPTION", "TILE_NAME", "PRIORITY", "IS_INPUT_NEEDED", "JASPER_NAME", "LOGIN_ID", "DOMAIN_DISPLAY_TYPE", "IS_CUSTOMIZABLE"};
        Object[] values = new Object[]{ReportUtil.getCategoryType(categoryId), categoryId, reportName, row.get("DISPLAY_TYPE"), reportName, description != null ? description : (String)row.get("DESCRIPTION"), "report", SearchReports.getMaxPriority(categoryId) + 1L, true, "UserDetails.xml", loginId, "single", "true"};
        HashMap<String, Object> audReportsMap = ReportUtil.formMap(keys, values);
        return audReportsMap;
    }

    private static ArrayList getAUDSQLQueryDetails(DataObject dObj, String searchCriteria, String reportName) throws Exception {
        ArrayList queryList = new ArrayList();
        Iterator iter = dObj.getRows("AUDSQLQuery");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> sqlQueryMap = new HashMap<String, Object>();
            sqlQueryMap.put("SQL_STRING", ((String)row.get("SQL_STRING")).replace("${SCRITERIA}", searchCriteria + " AND ${SCRITERIA}"));
            sqlQueryMap.put("COUNT_SQL_STRING", ((String)row.get("COUNT_SQL_STRING")).replace("${SCRITERIA}", searchCriteria + " AND ${SCRITERIA}"));
            sqlQueryMap.put("GROUPBYUSED", row.get("GROUPBYUSED"));
            sqlQueryMap.put("GROUP_BY", row.get("GROUP_BY"));
            sqlQueryMap.put("UNION_USED", row.get("UNION_USED"));
            ArrayList uqList = new ArrayList();
            Iterator iterator = dObj.getRows("AUDUnionQuery", new Criteria(Column.getColumn((String)"AUDUnionQuery", (String)"QUERY_ID"), (Object)((Long)row.get("QUERY_ID")), 0));
            while (iterator.hasNext()) {
                Row uqRow = (Row)iterator.next();
                HashMap<String, String> uqMap = new HashMap<String, String>();
                uqMap.put("UNION_QUERY", ((String)uqRow.get("UNION_QUERY")).replace("${SCRITERIA}", searchCriteria + " AND ${SCRITERIA}"));
                uqMap.put("UNION_COUNT_QUERY", ((String)uqRow.get("UNION_COUNT_QUERY")).replace("${SCRITERIA}", searchCriteria + " AND ${SCRITERIA}"));
                uqList.add(uqMap);
            }
            sqlQueryMap.put("AUDUnionQuery", uqList);
            Long cvId = (Long)row.get("CV_ID");
            Row graphRow = dObj.getRow("AUDGraphOptions", new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)cvId, 0));
            if (graphRow != null) {
                HashMap<String, Object> graphMap = new HashMap<String, Object>();
                List list = graphRow.getColumns();
                for (Object obj : list) {
                    String str = (String)obj;
                    if (str.equalsIgnoreCase("CV_ID") || str.equalsIgnoreCase("GRAPH_OPT_ID")) continue;
                    graphMap.put(str, graphRow.get(str));
                }
                sqlQueryMap.put("AUDGraphOptions", graphMap);
            }
            Row cvConfigRow = dObj.getRow("AUDCVConfig", new Criteria(Column.getColumn((String)"AUDCVConfig", (String)"CV_ID"), (Object)cvId, 0));
            HashMap<String, String> cvConfigMap = new HashMap<String, String>();
            cvConfigMap.put("CV_NAME", reportName);
            sqlQueryMap.put("AUDCVConfig", cvConfigMap);
            sqlQueryMap.put("AUDColumnConfiguration", SearchReports.getColumnMap(dObj, cvId, null));
            queryList.add(sqlQueryMap);
        }
        return queryList;
    }

    private static HashMap getElementMap(DataObject dObj) throws Exception {
        HashMap elementMap = new HashMap();
        ArrayList<Long> elementId = new ArrayList<Long>();
        ArrayList<Long> priorityId = new ArrayList<Long>();
        ArrayList<Boolean> isScheInput = new ArrayList<Boolean>();
        Iterator iter = dObj.getRows("AUDReportElementMap");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            elementId.add((Long)row.get("ELEMENT_ID"));
            priorityId.add((Long)row.get("PRIORITY_ID"));
            isScheInput.add((Boolean)row.get("IS_SCHEDULER_INPUT"));
        }
        elementMap.put("ELEMENT_ID", elementId);
        elementMap.put("PRIORITY_ID", priorityId);
        elementMap.put("IS_SCHEDULER_INPUT", isScheInput);
        return elementMap;
    }

    public static HashMap getColumnMap(DataObject dObj, Long cvId, String[] columnNames) throws Exception {
        HashMap columnMap = new HashMap();
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
        if (cvId == null) {
            criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNALIAS"), (Object)columnNames, 8);
        }
        Iterator iter = dObj.getRows("AUDColumnConfiguration", criteria);
        while (iter.hasNext()) {
            Row colRow = (Row)iter.next();
            Long columnId = (Long)colRow.get("COLUMN_CONF_ID");
            List list = colRow.getColumns();
            HashMap<String, Object> columnDetailsMap = new HashMap<String, Object>();
            for (Object obj : list) {
                String str = (String)obj;
                if (str.equalsIgnoreCase("CV_ID") || str.equalsIgnoreCase("COLUMN_CONF_ID")) continue;
                columnDetailsMap.put(str, colRow.get(str));
            }
            columnMap.put(columnId, columnDetailsMap);
        }
        return columnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getMaxPriority(Long categoryId) throws Exception {
        DataSet dataSet = null;
        Connection connection = null;
        Long priorityId = 0L;
        try {
            Column maxColumn = Column.getColumn((String)"AUDReports", (String)"PRIORITY").maximum();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReports"));
            selectQuery.addSelectColumn(maxColumn);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)categoryId, 0);
            selectQuery.setCriteria(crit);
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selectQuery, connection);
            if (dataSet != null) {
                while (dataSet.next()) {
                    priorityId = dataSet.getValue(1) != null ? (Long)dataSet.getValue(1) : 0L;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return priorityId;
    }
}

