/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.SearchReports;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class CustomReportHandler {
    private static HashMap<String, Long> tableCVIDMap = null;
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static HashMap<String, ArrayList> elementMap = null;
    private static String dbName = CommonUtil.getDBServerName();

    private static void getTableCVIDMap() {
        tableCVIDMap = new HashMap();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReportQueryMapping", (String)"TABLE_NAME"), null, 1);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomReportQueryMapping", crit);
            Iterator iter = dObj.getRows("AUDCustomReportQueryMapping");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                tableCVIDMap.put((String)row.get("TABLE_NAME") + ',' + Long.toString((Long)row.get("REPORT_VIEW")), (Long)row.get("CV_ID"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void getElementsDetails() {
        try {
            elementMap = new HashMap();
            String[] elements = new String[]{"AudElement:element_id:12", "AudElement:element_id:513", "AudElement:element_id:515", "AudElement:element_id:516"};
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"UVHValues"));
            query.setCriteria(new Criteria(Column.getColumn((String)"UVHValues", (String)"PATTERN"), (Object)elements, 8));
            query.addSelectColumn(Column.getColumn((String)"UVHValues", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"UVHValues", (String)"GENVALUES"), true));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Long priority = 1L;
            ArrayList<Long> idList = new ArrayList<Long>();
            ArrayList<Long> priorityList = new ArrayList<Long>();
            Iterator iter = dObj.getRows("UVHValues");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                idList.add((Long)row.get("GENVALUES"));
                priorityList.add(priority);
                Long l = priority;
                Long l2 = priority = Long.valueOf(priority + 1L);
            }
            elementMap.put("ELEMENT_ID", idList);
            elementMap.put("PRIORITY_ID", priorityList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createReports(DataObject dataObject) throws Exception {
        Row repRow = dataObject.getRow("AUDCustomReports");
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public static void deleteReports(Long customReportId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"CUSTOM_REPORT_ID"), (Object)customReportId, 0);
        String[] tableNames = new String[]{"AUDCustomReports", "AUDCustomReportSchedulerMap"};
        boolean[] isLeftJoins = new boolean[]{true, true};
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(tableNames, isLeftJoins, crit));
        Long reportId = (Long)dObj.getFirstRow("AUDCustomReports").get("AUDIT_REPORT_ID");
        Criteria reportCrit = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)((Long)dObj.getFirstRow("AUDCustomReports").get("AUDIT_REPORT_ID")), 0);
        CommonUtil.getPersistenceLite().delete(reportCrit);
        if (dObj.size("AUDCustomReportSchedulerMap") > 0) {
            Criteria scheCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)((Long)dObj.getFirstRow("AUDCustomReportSchedulerMap").get("SCHEDULE_ID")), 0);
            CommonUtil.getPersistenceLite().delete(scheCrit);
        }
        CommonUtil.getPersistenceLite().delete(crit);
        MyFavRepHandler.deleteReport((String)Long.toString(reportId));
    }

    public static boolean deleteFromReportsTab(Long reportId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomReports", crit);
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("AUDCustomReports");
            CustomReportHandler.deleteReports((Long)row.get("CUSTOM_REPORT_ID"));
            return true;
        }
        crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
        CommonUtil.getPersistence(new boolean[0]).delete(crit);
        MyFavRepHandler.deleteReport((String)Long.toString(reportId));
        return true;
    }

    public static Long saveThisAsNewReport(Long categoryId, String reportName, String description, boolean isPublic, Long loginId, Integer chartId, Long viewType, Long moduleId, ArrayList selecteSM, DataObject customDO, LinkedHashMap criteriaMap, String domainName) throws Exception {
        HashMap<String, Cloneable> reportDetailsMap = new HashMap<String, Cloneable>();
        reportDetailsMap.put("AUDReports", CustomReportHandler.getReportDetails(categoryId, reportName, description, isPublic, loginId, chartId, viewType));
        reportDetailsMap.put("AUDSQLQuery", CustomReportHandler.getSQLString(moduleId, selecteSM, chartId, reportName, customDO, criteriaMap, domainName, viewType));
        String sortColumn = viewType == 3L ? "SUMMARY_VALUE" : "TIME_GENERATED";
        reportDetailsMap.put("AUDTableViewConfig", ReportUtil.formMap(new String[]{"EMPTY_TABLE_MESSAGE", "PAGELENGTH", "SORTCOLUMN", "SORTORDER"}, new Object[]{"adap.AudMonitorReportHandler.No_Result_Found", 25, sortColumn, "DESC"}));
        Long reportId = AuditReportHandler.saveNewReportDetails(reportDetailsMap, elementMap);
        return reportId;
    }

    public static String updateThisReport(Long customReportId, DataObject oldDO, Long moduleId, ArrayList selectedSM, Integer chartId, Long reportId, DataObject customDO, LinkedHashMap criteriaMap, String domainName, Long viewType, String reportName, String description) throws Exception {
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        customRow.set("AUDIT_REPORT_ID", (Object)reportId);
        AuditReportAPI.getInstance();
        DataObject reportDo = AuditReportAPI.getReportsDO(reportId);
        Row reportRow = reportDo.getFirstRow("AUDReports");
        String[] stringArray = new String[]{"AUDIT_REPORT_ID", "DISPLAY_TYPE", "REPORT_CATEGORY_ID", "PRIORITY", "AUDIT_REPORT_NAME", "TITLE", "DESCRIPTION", "TILE_NAME", "REPORT_CATEGORY_TYPE", "IS_PUBLIC"};
        Object[] objectArray = new Object[10];
        objectArray[0] = reportId;
        objectArray[1] = CustomReportUtil.getDisplayType(viewType, chartId);
        objectArray[2] = customRow.get("REPORT_CATEGORY_ID");
        SearchReports.getInstance();
        objectArray[3] = SearchReports.getMaxPriority((Long)customRow.get("REPORT_CATEGORY_ID")) + 1L;
        objectArray[4] = reportName;
        objectArray[5] = reportName;
        objectArray[6] = description;
        objectArray[7] = CustomReportUtil.getTileType(viewType);
        objectArray[8] = ReportUtil.getCategoryType((Long)customRow.get("REPORT_CATEGORY_ID"));
        objectArray[9] = customRow.get("IS_PUBLIC");
        ReportUtil.formRow(reportRow, stringArray, objectArray);
        customDO.addRow(reportRow);
        Iterator iter = reportDo.getRows("AUDReportElementMap");
        while (iter.hasNext()) {
            customDO.addRow((Row)iter.next());
        }
        ArrayList sqlStringList = CustomReportHandler.getSQLString(moduleId, selectedSM, chartId, (String)reportRow.get("AUDIT_REPORT_NAME"), customDO, criteriaMap, domainName, viewType);
        CustomReportHandler.updateQueryDetails(customDO, reportDo, sqlStringList, chartId, viewType);
        DataObject diffDO = oldDO.diff(customDO);
        logger.log(Level.FINE, "Diff DataObject is " + diffDO);
        CommonUtil.getPersistence(new boolean[0]).update(diffDO);
        Row row = oldDO.getFirstRow("AUDReports");
        MyFavRepHandler.renameReport((Long)reportId, (String)((String)row.get("AUDIT_REPORT_NAME")), (String)((String)reportRow.get("AUDIT_REPORT_NAME")));
        return "Success";
    }

    public static DataObject getConfiguredReportDetails(Long customReportId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"CUSTOM_REPORT_ID"), (Object)customReportId, 0);
        String[] tableNames = new String[]{"AUDCustomReports", "AUDCustomReportColumnsMapping", "AUDCustomReportFilterMapping", "AUDChartProperties", "AUDCustomReportSchedulerMap", "AUDCustomReportSubModuleMap", "AUDCustomReportSummaryDetails", "AUDMatrixReportDetails", "AUDSummaryReportDetails", "AUDReports"};
        boolean[] isLeftJoins = new boolean[]{true, true, true, true, true, true, true, true, true, true};
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(tableNames, isLeftJoins, crit));
        return dObj;
    }

    public static DataObject getDataObject(Long customReportId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"CUSTOM_REPORT_ID"), (Object)customReportId, 0);
        String[] tableNames = new String[]{"AUDCustomReports", "AUDCustomReportColumnsMapping", "AUDCustomReportFilterMapping", "AUDChartProperties", "AUDCustomReportSchedulerMap", "AUDCustomReportSubModuleMap", "AUDCustomReportSummaryDetails", "AUDMatrixReportDetails", "AUDSummaryReportDetails"};
        boolean[] isLeftJoins = new boolean[]{true, true, true, true, true, true, true, true, true};
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(tableNames, isLeftJoins, crit));
        Row reportRow = dObj.getFirstRow("AUDCustomReports");
        crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), reportRow.get("AUDIT_REPORT_ID"), 0);
        tableNames = new String[]{"AUDReports", "AUDReportElementMap", "AUDReportCVMapping", "AUDCVConfig", "AUDColumnConfiguration", "AUDTableViewConfig", "AUDSQLQuery", "AUDUnionQuery", "AUDGraphOptions"};
        isLeftJoins = new boolean[]{true, true, true, true, true, true, true, true, true};
        DataObject reportDo = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(tableNames, isLeftJoins, crit));
        dObj.merge(reportDo);
        return dObj;
    }

    public static HashMap getReportDetails(Long categoryId, String reportName, String description, boolean isPublic, Long loginId, Integer chartId, Long viewType) throws Exception {
        String[] stringArray = new String[]{"REPORT_CATEGORY_ID", "REPORT_CATEGORY_TYPE", "AUDIT_REPORT_NAME", "DISPLAY_TYPE", "TITLE", "DESCRIPTION", "PRIORITY", "TILE_NAME", "IS_PUBLIC", "LOGIN_ID", "JASPER_NAME", "IS_INPUT_NEEDED", "IS_CUSTOMIZABLE"};
        Object[] objectArray = new Object[13];
        objectArray[0] = categoryId;
        objectArray[1] = ReportUtil.getCategoryType(categoryId);
        objectArray[2] = reportName;
        objectArray[3] = CustomReportUtil.getDisplayType(viewType, chartId);
        objectArray[4] = reportName;
        objectArray[5] = description;
        SearchReports.getInstance();
        objectArray[6] = SearchReports.getMaxPriority(categoryId) + 1L;
        objectArray[7] = CustomReportUtil.getTileType(viewType);
        objectArray[8] = isPublic;
        objectArray[9] = loginId;
        objectArray[10] = "UserDetails.xml";
        objectArray[11] = true;
        objectArray[12] = true;
        HashMap<String, Object> reportMap = ReportUtil.formMap(stringArray, objectArray);
        return reportMap;
    }

    public static ArrayList getSQLString(Long moduleId, ArrayList selecteSM, Integer chartId, String reportName, DataObject customDO, LinkedHashMap criteriaMap, String domainName, Long viewType) throws Exception {
        Criteria crit = null;
        HashMap critMap = new HashMap();
        if (selecteSM.size() == 0) {
            crit = new Criteria(Column.getColumn((String)"AUDCustomReportQueryMapping", (String)"MODULE_ID"), (Object)moduleId, 0);
        } else {
            DataObject subModuleDO = CustomReportHandler.getSubModuleDO(selecteSM);
            ArrayList tableList = CustomReportHandler.getTableList(subModuleDO);
            crit = new Criteria(Column.getColumn((String)"AUDCustomReportQueryMapping", (String)"TABLE_NAME"), (Object)tableList.toArray(), 8);
            critMap = CustomReportHandler.formCriteriaStringMap(subModuleDO);
        }
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDCustomReportQueryMapping", (String)"REPORT_VIEW"), (Object)viewType, 0));
        DataObject queryDO = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomReportQueryMapping", crit);
        return CustomReportHandler.getSQLString(queryDO, critMap, chartId, reportName, customDO, criteriaMap, domainName, viewType);
    }

    private static ArrayList getSQLString(DataObject queryDO, HashMap critFromSM, Integer chartId, String reportName, DataObject customDO, LinkedHashMap criteriaMap, String domainName, Long viewType) throws Exception {
        ArrayList<HashMap<Object, Object>> queryList = new ArrayList<HashMap<Object, Object>>();
        HashMap<String, Long> tableMap = new HashMap<String, Long>();
        Iterator iter = queryDO.getRows("AUDCustomReportQueryMapping");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            tableMap.put((String)row.get("TABLE_NAME"), (Long)row.get("CV_ID"));
        }
        HashMap graphMap = new HashMap();
        if (chartId != -1) {
            graphMap = CustomReportHandler.getGraphDetails(chartId, customDO, reportName);
        }
        ArrayList<Long> cvIdList = CustomReportHandler.getCVIdList(tableMap, viewType);
        DataObject dObj = AUDCustomViewAPI.getInstance().getCustomViewDO(cvIdList.toArray());
        HashMap columnsMap = AuditCategoryHandler.getInstance().getColumnsMap();
        HashMap summaryColsMap = new HashMap();
        if (viewType == 3L) {
            summaryColsMap = CustomReportHandler.getSummaryColumnString(columnsMap, customDO);
        }
        Iterator iterator = dObj.getRows("AUDSQLQuery");
        while (iterator.hasNext()) {
            HashMap<Long, HashMap> columnMap;
            HashMap<Object, Object> sqlQueryMap = new HashMap();
            Row sqlRow = (Row)iterator.next();
            sqlQueryMap = ReportUtil.formMap(new String[]{"SQL_STRING", "GROUPBYUSED", "GROUP_BY", "UNION_USED", "COUNT_SQL_STRING", "CV_ID"}, new Object[]{((String)sqlRow.get("SQL_STRING")).replace("${SUMMARY_COLUMNS_FINAL}", (String)summaryColsMap.get("SUMMARY_COLUMNS_FINAL") != null ? (String)summaryColsMap.get("SUMMARY_COLUMNS_FINAL") : "${SUMMARY_COLUMNS_FINAL_INNER}").replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${COLUMNS}", viewType == 4L ? "${SUMMARY_COLUMNS_FINAL}" : "${COLUMNS}"), sqlRow.get("GROUPBYUSED"), sqlRow.get("GROUP_BY"), sqlRow.get("UNION_USED"), ((String)sqlRow.get("COUNT_SQL_STRING")).replace("COUNT(DISTINCT(${SUMMARY_GROUP_BY}))", (String)summaryColsMap.get("SUMMARY_COUNT_REPLACE") != null ? "COUNT(DISTINCT(" + (String)summaryColsMap.get("SUMMARY_COUNT_REPLACE") + "))" : "COUNT(DISTINCT(${SUMMARY_GROUP_BY}))").replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${SUMMARY_FCOL_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_FCOL_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_FCOL_GROUP_BY") : "${SUMMARY_FCOL_GROUP_BY}"), (Long)sqlRow.get("CV_ID")});
            Long cvId = (Long)sqlRow.get("CV_ID");
            Criteria unionQueryCrit = new Criteria(Column.getColumn((String)"AUDUnionQuery", (String)"QUERY_ID"), sqlRow.get("QUERY_ID"), 0);
            ArrayList<HashMap> unionQueryList = CustomReportHandler.getUnionQueryList(dObj, unionQueryCrit, domainName, critFromSM, criteriaMap, columnsMap, summaryColsMap, cvIdList, customDO);
            sqlQueryMap.put("AUDUnionQuery", unionQueryList);
            HashMap<String, String> cvConfigMap = new HashMap<String, String>();
            Criteria cvConfCrit = new Criteria(Column.getColumn((String)"AUDCVConfig", (String)"CV_ID"), (Object)cvId, 0);
            Row cvRow = dObj.getRow("AUDCVConfig", cvConfCrit);
            cvConfigMap.put("CV_NAME", (String)cvRow.get("CV_NAME"));
            sqlQueryMap.put("AUDCVConfig", cvConfigMap);
            if (!graphMap.isEmpty()) {
                sqlQueryMap.put("AUDGraphOptions", graphMap);
            }
            if (viewType == 1L || viewType == 2L) {
                if (cvIdList.size() == 1) {
                    sqlQueryMap.put("AUDColumnConfiguration", CustomReportHandler.getColumnMap(columnsMap, customDO));
                } else {
                    sqlQueryMap.put("AUDColumnConfiguration", CustomReportHandler.getColumnMap(dObj, cvId));
                }
            } else if (viewType == 3L) {
                Row summaryRow = customDO.getFirstRow("AUDSummaryReportDetails");
                columnMap = CustomReportHandler.getColumnMap(columnsMap, new Long[]{(Long)summaryRow.get("GROUP_LEFT_COLUMN_1"), (Long)summaryRow.get("GROUP_LEFT_COLUMN_2"), (Long)summaryRow.get("GROUP_LEFT_COLUMN_3")}, new Boolean[]{true, true, true});
                if ("count".equals((String)summaryRow.get("SUMMARY_TYPE"))) {
                    columnMap.put(0L, ReportUtil.formMap(new String[]{"COLUMN_NAME", "SEARCHENABLED", "COLUMN_DISPLAY_NAME", "PRIORITY_ID", "SORTENABLED", "VISIBLE", "TRANSFORMER"}, new Object[]{"SUMMARY_VALUE", false, "adap.AUDColumnConfiguration.displayname.COUNT", 4, true, true, "com.adventnet.client.components.table.web.DefaultTransformer"}));
                } else {
                    HashMap summaryColumn = (HashMap)columnsMap.get((Long)summaryRow.get("SUMMARY_COLUMN"));
                    columnMap.put(0L, ReportUtil.formMap(new String[]{"COLUMN_NAME", "SEARCHENABLED", "COLUMN_DISPLAY_NAME", "PRIORITY_ID", "SORTENABLED", "VISIBLE", "TRANSFORMER", "DATE_FORMAT"}, new Object[]{"SUMMARY_VALUE", false, summaryColumn.get("COLUMN_DISPLAY_NAME"), 4, true, true, "com.adventnet.client.components.table.web.DefaultTransformer", summaryColumn.get("DATE_FORMAT")}));
                }
                sqlQueryMap.put("AUDColumnConfiguration", columnMap);
            } else if (viewType == 4L) {
                Row matrixRow = customDO.getFirstRow("AUDMatrixReportDetails");
                columnMap = CustomReportHandler.getColumnMap(columnsMap, new Long[]{(Long)matrixRow.get("GROUP_TOP_COLUMN"), (Long)matrixRow.get("GROUP_LEFT_COLUMN"), (Long)matrixRow.get("SUMMARY_COLUMN")}, new Boolean[]{true, true});
                columnMap.put(0L, ReportUtil.formMap(new String[]{"COLUMN_NAME", "SEARCHENABLED", "COLUMN_DISPLAY_NAME", "PRIORITY_ID", "SORTENABLED", "VISIBLE", "TRANSFORMER"}, new Object[]{"SUMMARY_VALUE", false, "adap.AUDColumnConfiguration.displayname.COUNT", 4, true, true, "com.adventnet.client.components.table.web.DefaultTransformer"}));
                sqlQueryMap.put("AUDColumnConfiguration", columnMap);
            }
            queryList.add(sqlQueryMap);
        }
        return queryList;
    }

    private static ArrayList<HashMap> getUnionQueryList(DataObject dObj, Criteria unionQueryCrit, String domainName, HashMap critFromSM, LinkedHashMap criteriaMap, HashMap columnsMap, HashMap summaryColsMap, ArrayList cvIdList, DataObject customDO) throws Exception {
        ArrayList<HashMap> unionQueryList = new ArrayList<HashMap>();
        String filterString = CustomReportHandler.formFilterString(criteriaMap, columnsMap, domainName, customDO);
        String domainDNSName = DomainDetailsAPI.getDomainDNSName(domainName);
        String domainFlatName = DomainDetailsAPI.getDomainFlatName(domainName, true);
        Iterator queryIter = dObj.getRows("AUDUnionQuery", unionQueryCrit);
        while (queryIter.hasNext()) {
            Row unionQueryRow = (Row)queryIter.next();
            String unionQuery = (String)unionQueryRow.get("UNION_QUERY");
            if (!critFromSM.isEmpty()) {
                Matcher match = ADAPSQLQueryUtil.TABLE_NAME_PATTERN.matcher(unionQuery);
                if (!match.find()) continue;
                String tableName = match.group().replace("${TABLE:", "").replace("}", "");
                if (!tableName.equals("AUDLogonInfo") && !tableName.equals("AUDFileAuditInfo") && filterString.indexOf("USERNAME") != -1 && cvIdList.size() > 1) {
                    filterString = filterString.replace("USERNAME", "CALLER_USER_NAME");
                }
                if (critFromSM.get(tableName) == null) continue;
                String criteriaString = "".equals((String)critFromSM.get(tableName)) ? "1=1" : (String)critFromSM.get(tableName);
                String searchString = null;
                searchString = !filterString.equalsIgnoreCase("") ? filterString + " AND ( " + criteriaString + ") " : "( " + criteriaString + " )";
                searchString = searchString + " AND ${SCRITERIA}";
                HashMap<String, Object> unionQueryMap = ReportUtil.formMap(new String[]{"UNION_COUNT_QUERY", "UNION_QUERY"}, new Object[]{((String)unionQueryRow.get("UNION_COUNT_QUERY")).replace("${SCRITERIA}", searchString).replace("${domainDNSName}", domainDNSName).replace("${domainFlatName}", domainFlatName).replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${SUMMARY_COL_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_COL_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_COL_GROUP_BY") : "${SUMMARY_COL_GROUP_BY}"), ((String)unionQueryRow.get("UNION_QUERY")).replace("${SCRITERIA}", searchString).replace("${domainDNSName}", domainDNSName).replace("${domainFlatName}", domainFlatName).replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${SUMMARY_COLUMNS}", (String)summaryColsMap.get("SUMMARY_COLUMNS") != null ? (String)summaryColsMap.get("SUMMARY_COLUMNS") : "${SUMMARY_COLUMNS}")});
                unionQueryList.add(unionQueryMap);
                continue;
            }
            String searchString = filterString != "" ? filterString + " AND ${SCRITERIA}" : "${SCRITERIA}";
            HashMap<String, Object> unionQueryMap = ReportUtil.formMap(new String[]{"UNION_COUNT_QUERY", "UNION_QUERY"}, new Object[]{((String)unionQueryRow.get("UNION_COUNT_QUERY")).replace("${SCRITERIA}", searchString).replace("${domainDNSName}", domainDNSName).replace("${domainFlatName}", domainFlatName).replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${SUMMARY_COL_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_COL_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_COL_GROUP_BY") : "${SUMMARY_COL_GROUP_BY}"), ((String)unionQueryRow.get("UNION_QUERY")).replace("${SCRITERIA}", searchString).replace("${domainDNSName}", domainDNSName).replace("${domainFlatName}", domainFlatName).replace("${SUMMARY_GROUP_BY}", (String)summaryColsMap.get("SUMMARY_GROUP_BY") != null ? (String)summaryColsMap.get("SUMMARY_GROUP_BY") : "${SUMMARY_GROUP_BY}").replace("${SUMMARY_COLUMNS}", (String)summaryColsMap.get("SUMMARY_COLUMNS") != null ? (String)summaryColsMap.get("SUMMARY_COLUMNS") : "${SUMMARY_COLUMNS}")});
            unionQueryList.add(unionQueryMap);
        }
        return unionQueryList;
    }

    private static String formFilterString(LinkedHashMap criteriaMap, HashMap columnsMap, String domainName, DataObject customDO) throws Exception {
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        String criteriaPattern = (String)customRow.get("CRITERIA_PATTERN");
        if (!criteriaMap.isEmpty()) {
            if (("".equals(criteriaPattern) || "-".equals(criteriaPattern)) && criteriaMap.size() == 1) {
                criteriaPattern = "1";
            }
            for (int j = 0; j < criteriaMap.size(); ++j) {
                criteriaPattern = criteriaPattern.replaceFirst(Integer.toString(j + 1), Integer.toString(j + 1) + "_PATTERN");
            }
            Set strValue = criteriaMap.keySet();
            int i = 0;
            Iterator itr = strValue.iterator();
            while (itr.hasNext()) {
                HashMap inputParams = (HashMap)criteriaMap.get((Integer)itr.next());
                if (inputParams.size() > 0) {
                    String logicalOper = (String)inputParams.get("logicalOper");
                    HashMap columnDetails = (HashMap)columnsMap.get(Long.parseLong((String)inputParams.get("columnField")));
                    String value = (String)inputParams.get("names");
                    if (inputParams.get("objectClass") != null && !"-".equalsIgnoreCase((String)inputParams.get("objectClass"))) {
                        value = "${OBJECTREPLACE:";
                        if ("share".equalsIgnoreCase((String)inputParams.get("objectClass"))) {
                            value = "${SHAREREPLACE:";
                        }
                        value = value + inputParams.get("objectClass") + ";;;" + (String)columnDetails.get("EXPECTED_OBJECT_CLASS") + ";;;" + (String)columnDetails.get("INPUT_VALUE") + ";;;" + (String)inputParams.get("objectGuidStr") + "}";
                    }
                    String val = "";
                    if ((Integer)columnDetails.get("COLUMN_DATA_TYPE") == 1001 || (Integer)columnDetails.get("COLUMN_DATA_TYPE") == 1005) {
                        Integer relOper = Integer.parseInt((String)inputParams.get("relOper"));
                        val = CustomReportUtil.formStringValues(relOper, value, CustomReportUtil.convertColumnsToVarchar(columnDetails, dbName, true));
                        val = val.replace("\\", "\\\\");
                    } else {
                        val = CustomReportUtil.formNumericValues(Integer.parseInt((String)inputParams.get("relOper")), value, (String)columnDetails.get("COLUMN_NAME"));
                    }
                    criteriaPattern = criteriaPattern.replaceFirst(Integer.toString(i + 1) + "_PATTERN", val.replace("$", "\\$"));
                } else {
                    criteriaPattern = criteriaPattern.replaceFirst(Integer.toString(i + 1) + "_PATTERN", "1=1");
                }
                ++i;
            }
            criteriaPattern = "(" + criteriaPattern + ")";
        } else {
            criteriaPattern = "";
        }
        logger.log(Level.INFO, "At last " + criteriaPattern);
        return criteriaPattern;
    }

    private static ArrayList<Long> getCVIdList(HashMap tableMap, Long viewType) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        if (tableMap.get("AUDFileAuditInfo") != null) {
            list.add((Long)tableMap.remove("AUDFileAuditInfo"));
        }
        if (tableMap.get("AUDLogonInfo") != null) {
            list.add((Long)tableMap.remove("AUDLogonInfo"));
        }
        if (tableMap.size() > 1) {
            list.add(tableCVIDMap.get("All," + Long.toString(viewType)));
        } else if (tableMap.size() == 1) {
            list.addAll(tableMap.values());
        }
        return list;
    }

    private static HashMap formCriteriaStringMap(DataObject subModuleDO) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = subModuleDO.getRows("AUDCustomReportSubModule");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String tableName = (String)row.get("TABLE_NAME");
            String str = map.get(tableName) == null ? "" : (String)map.get(tableName);
            String criteriaColumn = (String)row.get("CRITERIA_COLUMN");
            str = criteriaColumn != null ? CustomReportHandler.formString(str, criteriaColumn, (String)row.get("CRITERIA_VALUE"), (String)row.get("CRITERIA_DATA_TYPE")) : (row.get("CRITERIA_VALUE") != null ? CustomReportHandler.formString(str, new String[]{(String)row.get("CRITERIA_VALUE")}) : str);
            map.put(tableName, str);
        }
        return map;
    }

    private static String formString(String str, String criteriaColumn, String criteriaValue, String dataType) throws Exception {
        if (dataType.equalsIgnoreCase("1001")) {
            return CustomReportHandler.formString(str, new String[]{"(", criteriaColumn, " = '", criteriaValue, "')"});
        }
        if (dataType.equalsIgnoreCase("1002")) {
            return CustomReportHandler.formString(str, new String[]{"(", criteriaColumn, " IN (", criteriaValue, "))"});
        }
        return null;
    }

    private static String formString(String str, String[] criteria) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        if (!"".equals(str)) {
            sb.append(" OR ");
        }
        for (int i = 0; i < criteria.length; ++i) {
            sb.append(criteria[i]);
        }
        return sb.toString();
    }

    private static ArrayList getTableList(DataObject subModuleDO) throws Exception {
        ArrayList<String> tableList = new ArrayList<String>();
        Iterator iterator = subModuleDO.getRows("AUDCustomReportSubModule");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (tableList.contains((String)row.get("TABLE_NAME"))) continue;
            tableList.add((String)row.get("TABLE_NAME"));
        }
        return tableList;
    }

    private static DataObject getSubModuleDO(ArrayList selecteSM) throws Exception {
        Criteria crit1 = new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"SUB_MODULE_ID"), (Object)selecteSM.toArray(), 8);
        DataObject subModuleDO = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomReportSubModule", crit1);
        return subModuleDO;
    }

    private static HashMap getGraphDetails(Integer chartId, DataObject customDO, String reportName) throws Exception {
        String xColumn;
        HashMap<String, String> detailsMap = CustomReportUtil.getChartDetails(chartId);
        Row row = customDO.getFirstRow("AUDChartProperties");
        String groupBy = "";
        String limitValue = null;
        String sortOrder = null;
        String mColumn = null;
        String xLabel = null;
        HashMap columnsMap = AuditCategoryHandler.getInstance().getColumnsMap();
        if (chartId == 6 || chartId == 5) {
            xColumn = (String)row.get("DATEFORMAT");
            groupBy = CustomReportHandler.getGroupByColumn(xColumn);
            xLabel = xColumn.indexOf("HOUR") != -1 ? "adap.AUDGraphOptions.xlabel.HOUR" : "adap.AUDGraphOptions.xlabel.DAY";
            mColumn = ((String)((HashMap)columnsMap.get((Long)row.get("GROUPBY"))).get("COLUMN_NAME")).toLowerCase();
        } else if (chartId == 7) {
            xColumn = groupBy = ((String)((HashMap)columnsMap.get((Long)row.get("XCOLUMN"))).get("COLUMN_NAME") + "," + (String)((HashMap)columnsMap.get((Long)row.get("XCOLUMN2"))).get("COLUMN_NAME")).toLowerCase();
            xLabel = "-";
        } else {
            xColumn = groupBy = ((String)((HashMap)columnsMap.get((Long)row.get("XCOLUMN"))).get("COLUMN_NAME")).toLowerCase();
            xLabel = (String)((HashMap)columnsMap.get((Long)row.get("XCOLUMN"))).get("COLUMN_DISPLAY_NAME");
            if ((chartId == 3 || chartId == 4) && (Integer)row.get("LIMIT_VALUE") > 0) {
                limitValue = ((Integer)row.get("LIMIT_VALUE")).toString();
                sortOrder = "DESC";
            }
        }
        return ReportUtil.formMap(new String[]{"CRITERIA", "GRAPH_NAME", "GRAPH_TITLE", "GRAPH_TYPE", "GROUP_BY", "IS_SHOW", "LIMIT_VALUE", "SORT_ORDER", "XCOLUMN", "XLABEL", "YCOLUMN", "YLABEL", "MCOLUMN"}, new Object[]{"-", reportName.replace(" ", "_"), reportName, detailsMap.get("CHART_TYPE"), groupBy, true, limitValue, sortOrder, xColumn, xLabel, (String)row.get("YCOLUMN"), "adap.AUDGraphOptions.ylabel.COUNT", mColumn});
    }

    private static HashMap getSummaryColumnString(HashMap columnsMap, DataObject customDO) throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilder countStr = new StringBuilder();
        StringBuilder distStr = new StringBuilder();
        String delimiter = " , ";
        if (dbName.equals("mssql")) {
            delimiter = " + ";
        }
        Row row = customDO.getFirstRow("AUDSummaryReportDetails");
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        HashMap<String, String> summaryColMap = new HashMap<String, String>();
        sb.append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_1")), dbName, false));
        countStr.append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_1")), dbName, true));
        distStr.append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_1")), dbName, true));
        if (row.get("GROUP_LEFT_COLUMN_2") != null) {
            sb.append(" , ").append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_2")), dbName, false));
            countStr.append(" , ").append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_2")), dbName, true));
            distStr.append(delimiter).append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_2")), dbName, true));
        }
        if (row.get("GROUP_LEFT_COLUMN_3") != null) {
            sb.append(" , ").append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_3")), dbName, false));
            countStr.append(" , ").append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_3")), dbName, true));
            distStr.append(delimiter).append(CustomReportUtil.convertColumnsToVarchar((HashMap)columnsMap.get((Long)row.get("GROUP_LEFT_COLUMN_3")), dbName, true));
        }
        summaryColMap.put("SUMMARY_GROUP_BY", countStr.toString());
        summaryColMap.put("SUMMARY_FCOL_GROUP_BY", distStr.toString());
        summaryColMap.put("SUMMARY_COL_GROUP_BY", sb.toString());
        summaryColMap.put("SUMMARY_COUNT_REPLACE", ReportUtil.addRowToPattern(countStr.toString()));
        sb.append(" , ");
        if (((String)row.get("SUMMARY_TYPE")).equalsIgnoreCase("count")) {
            Long moduleId = DBObjectUtil.getUVHValues("AUDCustomReportModule", "AUDCustomReportModule.MODULE_ID:10");
            if (moduleId != null && moduleId == (Long)customRow.get("MODULE_ID")) {
                sb.append("COUNT(DISTINCT(UNIQUE_ID)) as SUMMARY_VALUE");
            } else {
                sb.append("COUNT(DISTINCT(TIME_GENERATED+RECORD_NUMBER)) as SUMMARY_VALUE");
            }
            summaryColMap.put("SUMMARY_COLUMNS_FINAL", (String)summaryColMap.get("SUMMARY_COL_GROUP_BY") + ",SUM(SUMMARY_VALUE) AS SUMMARY_VALUE");
        } else {
            sb.append((String)row.get("SUMMARY_TYPE"));
            sb.append("(");
            sb.append((String)((HashMap)columnsMap.get((Long)row.get("SUMMARY_COLUMN"))).get("COLUMN_NAME"));
            sb.append(") as SUMMARY_VALUE");
            summaryColMap.put("SUMMARY_COLUMNS_FINAL", (String)summaryColMap.get("SUMMARY_COL_GROUP_BY") + "," + (String)row.get("SUMMARY_TYPE") + "(SUMMARY_VALUE) AS SUMMARY_VALUE");
        }
        summaryColMap.put("SUMMARY_COLUMNS", sb.toString());
        return summaryColMap;
    }

    private static void updateQueryDetails(DataObject customDO, DataObject reportDo, ArrayList sqlStringList, Integer chartId, Long viewType) throws Exception {
        int size = 0;
        if (reportDo.size("AUDSQLQuery") == 1 && sqlStringList.size() == 1) {
            Iterator iter = reportDo.getRows("AUDSQLQuery");
            while (iter.hasNext()) {
                customDO.addRow(reportDo.getFirstRow("AUDReportCVMapping"));
                HashMap sqlQueryMap = (HashMap)sqlStringList.get(size);
                Row sqlQueryRow = (Row)iter.next();
                Row tableRow = reportDo.getRow("AUDTableViewConfig", new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)((Long)sqlQueryRow.get("CV_ID")), 0));
                tableRow.set("SORTCOLUMN", (Object)(viewType == 3L ? "SUMMARY_VALUE" : "TIME_GENERATED"));
                customDO.addRow(tableRow);
                customDO.addRow(reportDo.getRow("AUDCVConfig", new Criteria(Column.getColumn((String)"AUDCVConfig", (String)"CV_ID"), (Object)((Long)sqlQueryRow.get("CV_ID")), 0)));
                HashMap columnMap = (HashMap)sqlQueryMap.get("AUDColumnConfiguration");
                Set columnSet = columnMap.keySet();
                Iterator iterator = columnSet.iterator();
                while (iterator.hasNext()) {
                    HashMap columnDetailsMap = (HashMap)columnMap.get(iterator.next());
                    logger.log(Level.INFO, "columnDetailsMap is " + columnDetailsMap);
                    Criteria columnCriteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNALIAS"), (Object)((String)columnDetailsMap.get("COLUMN_NAME") != null ? (String)columnDetailsMap.get("COLUMN_NAME") : (String)columnDetailsMap.get("COLUMNALIAS")), 0);
                    columnCriteria = columnCriteria.and(new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)((Long)sqlQueryRow.get("CV_ID")), 0));
                    Row columnRow = reportDo.getRow("AUDColumnConfiguration", columnCriteria);
                    if (columnRow == null) {
                        columnRow = new Row("AUDColumnConfiguration");
                        ReportUtil.formRow(columnRow, new String[]{"CV_ID", "COLUMNINDEX", "COLUMNALIAS", "SEARCHENABLED", "DISPLAYNAME", "SORTENABLED", "VISIBLE", "TABLEALIAS", "TRANSFORMER"}, new Object[]{(Long)sqlQueryRow.get("CV_ID"), columnDetailsMap.get("PRIORITY_ID") != null ? columnDetailsMap.get("PRIORITY_ID") : columnDetailsMap.get("COLUMNINDEX"), (String)columnDetailsMap.get("COLUMN_NAME") != null ? (String)columnDetailsMap.get("COLUMN_NAME") : (String)columnDetailsMap.get("COLUMNALIAS"), columnDetailsMap.get("SEARCHENABLED"), (String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") != null ? (String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") : (String)columnDetailsMap.get("DISPLAYNAME"), columnDetailsMap.get("SORTENABLED"), columnDetailsMap.get("VISIBLE"), columnDetailsMap.get("TABLEALIAS"), columnDetailsMap.get("TRANSFORMER")});
                        if (columnDetailsMap.get("DATE_FORMAT") != null) {
                            columnRow.set("DATE_FORMAT", columnDetailsMap.get("DATE_FORMAT"));
                        }
                    } else {
                        Row detRow = customDO.getRow("AUDCustomReportColumnsMapping", new Criteria(Column.getColumn((String)"AUDCustomReportColumnsMapping", (String)"COLUMN_ID"), (Object)((Long)columnDetailsMap.get("COLUMN_ID")), 0));
                        columnRow.set("VISIBLE", detRow != null ? detRow.get("VISIBLE") : columnDetailsMap.get("VISIBLE"));
                        columnRow.set("COLUMNINDEX", detRow != null ? detRow.get("COLUMNINDEX") : columnDetailsMap.get("PRIORITY_ID"));
                    }
                    customDO.addRow(columnRow);
                }
                if (chartId != -1) {
                    Row graphRow = reportDo.getRow("AUDGraphOptions", new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)((Long)sqlQueryRow.get("CV_ID")), 0)) == null ? new Row("AUDGraphOptions") : reportDo.getRow("AUDGraphOptions", new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)((Long)sqlQueryRow.get("CV_ID")), 0));
                    HashMap graphMap = (HashMap)sqlQueryMap.get("AUDGraphOptions");
                    Set keyValue = graphMap.keySet();
                    for (String val : keyValue) {
                        graphRow.set(val, graphMap.get(val));
                    }
                    graphRow.set("CV_ID", (Object)((Long)sqlQueryRow.get("CV_ID")));
                    customDO.addRow(graphRow);
                }
                ReportUtil.formRow(sqlQueryRow, new String[]{"SQL_STRING", "GROUPBYUSED", "GROUP_BY", "UNION_USED", "COUNT_SQL_STRING"}, new Object[]{sqlQueryMap.get("SQL_STRING"), sqlQueryMap.get("GROUPBYUSED"), sqlQueryMap.get("GROUP_BY"), sqlQueryMap.get("UNION_USED"), sqlQueryMap.get("COUNT_SQL_STRING")});
                customDO.addRow(sqlQueryRow);
                ArrayList unionQueryList = (ArrayList)sqlQueryMap.get("AUDUnionQuery");
                for (int count = 0; count < unionQueryList.size(); ++count) {
                    HashMap unionQueryMap = (HashMap)unionQueryList.get(count);
                    Row unionQueryRow = ReportUtil.formRow("AUDUnionQuery", new String[]{"QUERY_ID", "UNION_QUERY", "UNION_COUNT_QUERY"}, new Object[]{sqlQueryRow.get("QUERY_ID"), unionQueryMap.get("UNION_QUERY"), unionQueryMap.get("UNION_COUNT_QUERY")});
                    customDO.addRow(unionQueryRow);
                }
                ++size;
            }
        } else {
            logger.log(Level.INFO, "Am goig to update all  changtes");
            for (size = 0; size < sqlStringList.size(); ++size) {
                HashMap sqlQueryMap = (HashMap)sqlStringList.get(size);
                Row cvConfigRow = new Row("AUDCVConfig");
                cvConfigRow.set("CV_NAME", ((HashMap)sqlQueryMap.get("AUDCVConfig")).get("CV_NAME"));
                customDO.addRow(cvConfigRow);
                Row cvMapRow = new Row("AUDReportCVMapping");
                cvMapRow.set("AUDIT_REPORT_ID", reportDo.getFirstRow("AUDReportCVMapping").get("AUDIT_REPORT_ID"));
                cvMapRow.set("CV_ID", cvConfigRow.get("CV_ID"));
                customDO.addRow(cvMapRow);
                Row sqlQueryRow = new Row("AUDSQLQuery");
                sqlQueryRow.set("CV_ID", cvConfigRow.get("CV_ID"));
                Row tableRow = new Row("AUDTableViewConfig");
                ReportUtil.formRow(tableRow, new String[]{"CV_ID", "SORTCOLUMN", "EMPTY_TABLE_MESSAGE", "PAGELENGTH", "SORTORDER"}, new Object[]{cvConfigRow.get("CV_ID"), viewType == 3L ? "SUMMARY_VALUE" : "TIME_GENERATED", "adap.AudMonitorReportHandler.No_Result_Found", 25, "DESC"});
                customDO.addRow(tableRow);
                HashMap columnMap = (HashMap)sqlQueryMap.get("AUDColumnConfiguration");
                Set columnSet = columnMap.keySet();
                Iterator iterator = columnSet.iterator();
                while (iterator.hasNext()) {
                    HashMap columnDetailsMap = (HashMap)columnMap.get(iterator.next());
                    logger.log(Level.FINE, "columnDetailsMap is " + columnDetailsMap);
                    Row columnRow = new Row("AUDColumnConfiguration");
                    ReportUtil.formRow(columnRow, new String[]{"CV_ID", "COLUMNINDEX", "COLUMNALIAS", "SEARCHENABLED", "DISPLAYNAME", "SORTENABLED", "VISIBLE", "TABLEALIAS", "TRANSFORMER"}, new Object[]{cvConfigRow.get("CV_ID"), columnDetailsMap.get("PRIORITY_ID") != null ? columnDetailsMap.get("PRIORITY_ID") : columnDetailsMap.get("COLUMNINDEX"), (String)columnDetailsMap.get("COLUMN_NAME") != null ? (String)columnDetailsMap.get("COLUMN_NAME") : (String)columnDetailsMap.get("COLUMNALIAS"), columnDetailsMap.get("SEARCHENABLED"), (String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") != null ? (String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") : (String)columnDetailsMap.get("DISPLAYNAME"), columnDetailsMap.get("SORTENABLED"), columnDetailsMap.get("VISIBLE"), columnDetailsMap.get("TABLEALIAS"), columnDetailsMap.get("TRANSFORMER")});
                    if (columnDetailsMap.get("DATE_FORMAT") != null) {
                        columnRow.set("DATE_FORMAT", columnDetailsMap.get("DATE_FORMAT"));
                    }
                    customDO.addRow(columnRow);
                }
                if (chartId != -1) {
                    Row graphRow = new Row("AUDGraphOptions");
                    HashMap graphMap = (HashMap)sqlQueryMap.get("AUDGraphOptions");
                    Set keyValue = graphMap.keySet();
                    for (String val : keyValue) {
                        graphRow.set(val, graphMap.get(val));
                    }
                    graphRow.set("CV_ID", cvConfigRow.get("CV_ID"));
                    customDO.addRow(graphRow);
                }
                ReportUtil.formRow(sqlQueryRow, new String[]{"SQL_STRING", "GROUPBYUSED", "GROUP_BY", "UNION_USED", "COUNT_SQL_STRING"}, new Object[]{sqlQueryMap.get("SQL_STRING"), sqlQueryMap.get("GROUPBYUSED"), sqlQueryMap.get("GROUP_BY"), sqlQueryMap.get("UNION_USED"), sqlQueryMap.get("COUNT_SQL_STRING")});
                customDO.addRow(sqlQueryRow);
                ArrayList unionQueryList = (ArrayList)sqlQueryMap.get("AUDUnionQuery");
                for (int count = 0; count < unionQueryList.size(); ++count) {
                    HashMap unionQueryMap = (HashMap)unionQueryList.get(count);
                    Row unionQueryRow = ReportUtil.formRow("AUDUnionQuery", new String[]{"QUERY_ID", "UNION_QUERY", "UNION_COUNT_QUERY"}, new Object[]{sqlQueryRow.get("QUERY_ID"), unionQueryMap.get("UNION_QUERY"), unionQueryMap.get("UNION_COUNT_QUERY")});
                    customDO.addRow(unionQueryRow);
                }
            }
        }
    }

    private static HashMap<Long, HashMap> getColumnMap(HashMap columnsMap, DataObject dObj) throws Exception {
        Long[] columnIds = new Long[dObj.size("AUDCustomReportColumnsMapping")];
        Boolean[] visible = new Boolean[dObj.size("AUDCustomReportColumnsMapping")];
        int i = 0;
        Iterator iter = dObj.getRows("AUDCustomReportColumnsMapping");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            columnIds[i] = (Long)row.get("COLUMN_ID");
            visible[i] = (Boolean)row.get("VISIBLE");
            ++i;
        }
        return CustomReportHandler.getColumnMap(columnsMap, columnIds, visible);
    }

    private static HashMap<Long, HashMap> getColumnMap(HashMap columnsMap, Long[] columnIds, Boolean[] visible) throws Exception {
        HashMap<Long, HashMap> columnMap = new HashMap<Long, HashMap>();
        for (int i = 0; i < columnIds.length; ++i) {
            if (columnIds[i] == null) continue;
            HashMap columnDetails = (HashMap)columnsMap.get(columnIds[i]);
            columnDetails.put("PRIORITY_ID", i + 1);
            columnDetails.put("VISIBLE", visible[i]);
            columnMap.put(columnIds[i], columnDetails);
        }
        return columnMap;
    }

    private static HashMap<Long, HashMap> getColumnMap(DataObject dObj, Long cvId) throws Exception {
        SearchReports.getInstance();
        HashMap columnMap = SearchReports.getColumnMap(dObj, cvId, null);
        if (columnMap.isEmpty()) {
            Long fileAuditID = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:55001");
            Long columnSelectionId = 16L;
            if (fileAuditID.longValue() == cvId.longValue()) {
                columnSelectionId = 8L;
            }
            String query = CustomReportUtil.queryBuilder(new String[]{"SELECT COLUMN_ID, COLUMN_NAME,COLUMN_DATA_TYPE,COLUMN_DISPLAY_NAME,COLUMN_SELECTION_ID,ELEMENT_ID,VISIBLE,SORTENABLED, SEARCHENABLED,DATE_FORMAT,TRANSFORMER,MANDATORY,BGCOLUMN,ESCAPE_HTML FROM AUDReportColumns WHERE COLUMN_SELECTION_ID&", columnSelectionId.toString(), "=", columnSelectionId.toString(), " ORDER BY COLUMN_ID"});
            ArrayList<Object> columnsList = CustomReportUtil.getColumnList(query, ResourceBundleMgr.getInstance().getBundle());
            for (int i = 0; i < columnsList.size(); ++i) {
                HashMap map = (HashMap)columnsList.get(i);
                map.put("COLUMNINDEX", i + 1);
                columnMap.put((Long)map.get("COLUMN_ID"), map);
            }
        }
        return columnMap;
    }

    private static String getGroupByColumn(String xColumn) throws Exception {
        if (xColumn.indexOf("PATTERNREPLACE:XCOLUMN_DAY_BASED") != -1) {
            return "${PATTERNREPLACE:GROUP_BY_DAY_BASED}";
        }
        return "${PATTERNREPLACE:GROUP_BY_HOUR_BASED}";
    }

    public static void createReportsEmber(DataObject dataObject) throws Exception {
        Row repRow = dataObject.getRow("AUDCustomReports");
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public static void copyCustomReport(Long customReportId, String reportName, String domainName, Boolean domainChanged) throws Exception {
        Iterator iter;
        DataObject dobj = CustomReportHandler.getDataObject(customReportId);
        DataObject copyCRDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row customRow = new Row("AUDCustomReports");
        Row oldCRRow = dobj.getFirstRow("AUDCustomReports");
        List columnList = oldCRRow.getColumns();
        for (String columnName : columnList) {
            if (columnName.equalsIgnoreCase("CUSTOM_REPORT_ID") || columnName.equalsIgnoreCase("AUDIT_REPORT_ID")) continue;
            customRow.set(columnName, oldCRRow.get(columnName));
        }
        copyCRDO.addRow(customRow);
        String[] tableNames = new String[]{"AUDCustomReportColumnsMapping", "AUDChartProperties", "AUDCustomReportSummaryDetails", "AUDMatrixReportDetails", "AUDSummaryReportDetails"};
        for (int i = 0; i < tableNames.length; ++i) {
            if (dobj.size(tableNames[i]) <= 0) continue;
            iter = dobj.getRows(tableNames[i]);
            while (iter.hasNext()) {
                CustomReportHandler.setRowDetails(tableNames[i], copyCRDO, (Row)iter.next(), customRow);
            }
        }
        ArrayList<Long> selectedSM = new ArrayList<Long>();
        iter = dobj.getRows("AUDCustomReportSubModuleMap");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            CustomReportHandler.setRowDetails("AUDCustomReportSubModuleMap", copyCRDO, row, customRow);
            selectedSM.add((Long)row.get("SUB_MODULE_ID"));
        }
        LinkedHashMap<Integer, HashMap> criteriaMap = new LinkedHashMap<Integer, HashMap>();
        if (!domainChanged.booleanValue()) {
            Iterator iter2 = dobj.getRows("AUDCustomReportFilterMapping");
            while (iter2.hasNext()) {
                CustomReportHandler.setRowDetails("AUDCustomReportFilterMapping", copyCRDO, (Row)iter2.next(), customRow);
            }
            CustomReportHandler.getCriteriaMap(criteriaMap, copyCRDO);
        } else {
            customRow.set("DOMAIN_NAME", (Object)domainName);
        }
        Long reportId = CustomReportHandler.saveThisAsNewReport((Long)customRow.get("REPORT_CATEGORY_ID"), reportName, reportName, (Boolean)customRow.get("IS_PUBLIC"), (Long)customRow.get("LOGIN_ID"), (Integer)customRow.get("CHART_ID"), (Long)customRow.get("REPORT_VIEW"), (Long)customRow.get("MODULE_ID"), selectedSM, copyCRDO, criteriaMap, domainName);
        customRow.set("AUDIT_REPORT_ID", (Object)reportId);
        if (dobj.size("AUDCustomReportSchedulerMap") > 0) {
            Row oldScheRow = dobj.getFirstRow("AUDCustomReportSchedulerMap");
            Row row = new Row("AUDCustomReportSchedulerMap");
            row.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), oldScheRow.get("SCHEDULE_ID"), 0);
            DataObject schedulerDO = CommonUtil.getPersistence(new boolean[0]).getForPersonality("ScheduledReports", crit);
            Row scheRow = new Row("Schedule");
            scheRow.set("SCHEDULE_NAME", (Object)(reportName + "_" + reportId));
            scheRow.set("DESCRIPTION", (Object)reportName);
            copyCRDO.addRow(scheRow);
            row.set("SCHEDULE_ID", scheRow.get("SCHEDULE_ID"));
            copyCRDO.addRow(row);
            Row reportRow = new Row("AUDScheduler");
            Row scheRepRow = schedulerDO.getFirstRow("AUDScheduler");
            CustomReportHandler.setScheduleRowDetails("AUDScheduler", copyCRDO, scheRepRow, scheRow);
            if (schedulerDO.size("Periodic") > 0) {
                CustomReportHandler.setScheduleRowDetails("Periodic", copyCRDO, schedulerDO.getFirstRow("Periodic"), scheRow);
            } else {
                CustomReportHandler.setScheduleRowDetails("Calendar", copyCRDO, schedulerDO.getFirstRow("Calendar"), scheRow);
            }
            Row repSchMapRow = new Row("AUDReportSchedulerMap");
            repSchMapRow.set("AUDIT_REPORT_ID", (Object)reportId);
            repSchMapRow.set("SCHEDULE_ID", scheRow.get("SCHEDULE_ID"));
            copyCRDO.addRow(repSchMapRow);
            if (!domainChanged.booleanValue()) {
                Iterator iter3 = schedulerDO.getRows("AUDSchedulerInputMap");
                while (iter3.hasNext()) {
                    Row newIpRow = new Row("AUDSchedulerInputMap");
                    Row inputRow = (Row)iter3.next();
                    for (String columnName : columnList) {
                        if (columnName.equalsIgnoreCase("SCHEDULE_ID")) {
                            newIpRow.set("SCHEDULE_ID", customRow.get("SCHEDULE_ID"));
                            continue;
                        }
                        if (columnName.equalsIgnoreCase("AUDIT_REPORT_ID")) {
                            newIpRow.set("AUDIT_REPORT_ID", (Object)reportId);
                            continue;
                        }
                        newIpRow.set(columnName, inputRow.get(columnName));
                    }
                    copyCRDO.addRow(newIpRow);
                }
            }
            Long time = System.currentTimeMillis();
            Row taskInputRow = ReportUtil.formRow("Task_Input", new String[]{"SCHEDULE_ID", "TASK_ID", "SCHEDULE_TIME"}, new Object[]{scheRow.get("SCHEDULE_ID"), SchedulerUtil.getTaskID("ReportScheduler"), new Timestamp(time)});
            copyCRDO.addRow(taskInputRow);
            Row taskRow = ReportUtil.formRow("Scheduled_Task", new String[]{"SCHEDULE_ID", "AUDIT_FLAG", "TASK_ID", "TRANSACTION_TIME", "SKIP_MISSED_SCHEDULE"}, new Object[]{scheRow.get("SCHEDULE_ID"), true, SchedulerUtil.getTaskID("ReportScheduler"), -1, true});
            copyCRDO.addRow(taskRow);
        }
        CustomReportHandler.createReports(copyCRDO);
    }

    private static void setScheduleRowDetails(String tableName, DataObject copyCRDO, Row oldRow, Row scheduleRow) throws Exception {
        Row row = new Row(tableName);
        List columnList = oldRow.getColumns();
        for (String columnName : columnList) {
            if (columnName.equalsIgnoreCase("SCHEDULE_ID")) {
                row.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                continue;
            }
            row.set(columnName, oldRow.get(columnName));
        }
        copyCRDO.addRow(row);
    }

    private static void setRowDetails(String tableName, DataObject copyCRDO, Row oldRow, Row customRow) throws Exception {
        Row row = new Row(tableName);
        List columnList = oldRow.getColumns();
        for (String columnName : columnList) {
            if (columnName.equalsIgnoreCase("CUSTOM_REPORT_ID")) {
                row.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
                continue;
            }
            if (columnName.equalsIgnoreCase("FILTER_ID")) {
                logger.log(Level.INFO, "No Need to update");
                continue;
            }
            row.set(columnName, oldRow.get(columnName));
        }
        copyCRDO.addRow(row);
    }

    private static void getCriteriaMap(LinkedHashMap<Integer, HashMap> criteriaMap, DataObject copyCRDO) throws Exception {
        Iterator iter = copyCRDO.getRows("AUDCustomReportFilterMapping");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("logicalOper", (String)row.get("LOGICAL_OPERATOR"));
            valueMap.put("columnField", Long.toString((Long)row.get("COLUMN_ID")));
            valueMap.put("relOper", Long.toString((Long)row.get("RELATIONAL_OPERATOR")));
            String[] value = ((String)row.get("VALUE")).split(";;;");
            if (value.length == 1) {
                valueMap.put("names", value[0]);
            } else {
                valueMap.put("objectClass", value[0]);
                valueMap.put("objectGuidStr", value[1]);
            }
            criteriaMap.put((Integer)row.get("PRIORITY_ID"), valueMap);
        }
    }

    static {
        CustomReportHandler.getTableCVIDMap();
        CustomReportHandler.getElementsDetails();
    }
}

