/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports.customreport;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportUtil {
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static String dbName = CommonUtil.getDBServerName();
    private static HashMap<Long, LinkedHashMap> moduleIdVsviewIdMap = null;
    private static HashMap<Long, String> subModuleIdVsTableName = null;
    private static HashMap<Long, Long> subModuleIdVsColSelId = null;
    private static HashMap<Long, HashMap> moduleDetails = null;
    private static LinkedHashMap<Integer, HashMap<String, String>> chartDetails = null;
    public static LinkedHashMap<Long, Row> subModuleDetails = null;
    public static Long elementId = null;

    private static void getSubModuleVsTableNames() {
        try {
            if (subModuleIdVsTableName == null) {
                subModuleIdVsTableName = new HashMap();
                subModuleIdVsColSelId = new HashMap();
            }
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomReportSubModule", (Criteria)null);
            Iterator iterator = dObj.getRows("AUDCustomReportSubModule");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                subModuleIdVsTableName.put((Long)row.get("SUB_MODULE_ID"), (String)row.get("TABLE_NAME"));
                subModuleIdVsColSelId.put((Long)row.get("SUB_MODULE_ID"), (Long)row.get("COLUMN_SELECTION_ID"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static LinkedHashMap getViewTypeMap() throws Exception {
        LinkedHashMap viewTypeMap = new LinkedHashMap();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportView"));
        query.setCriteria((Criteria)null);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportView", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportView", (String)"REPORT_VIEW"), true));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iter = dObj.getRows("AUDCustomReportView");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("DISPLAY_NAME", (String)row.get("REPORT_VIEW_DISPLAY_NAME"));
            details.put("DESCRIPTION", (String)row.get("REPORT_VIEW_DESCRIPTION"));
            viewTypeMap.put((Long)row.get("REPORT_VIEW"), details);
        }
        return viewTypeMap;
    }

    public static LinkedHashMap<Long, String> getModuleMap(Long viewType) throws Exception {
        return moduleIdVsviewIdMap.get(viewType);
    }

    public static void getSubModuleMap() {
        try {
            subModuleDetails = new LinkedHashMap();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            HashMap hashMap = CustomReportUtil.getSubModuleMap(rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap getSubModuleMap(AdventNetResourceBundle rb) throws Exception {
        HashMap<Long, LinkedHashMap> moduleMap = new HashMap<Long, LinkedHashMap>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportSubModule"));
        Join leftJoin = new Join("AUDCustomReportSubModule", "AUDCustomReportModule", new String[]{"MODULE_ID"}, new String[]{"MODULE_ID"}, 1);
        Criteria crit = null;
        if (!LicenseUtil.isProfEdn()) {
            crit = new Criteria(Column.getColumn((String)"AUDCustomReportModule", (String)"LICENSE_TYPE"), (Object)1, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"LICENSE_TYPE"), (Object)1, 0));
        }
        query.setCriteria(crit);
        query.addJoin(leftJoin);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportModule", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"SUB_MODULE_ID"), true));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iter = dObj.getRows("AUDCustomReportModule");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            moduleMap.put((Long)row.get("MODULE_ID"), CustomReportUtil.getSubModule(dObj, (Long)row.get("MODULE_ID")));
        }
        return moduleMap;
    }

    private static LinkedHashMap getSubModule(DataObject dObj, Long moduleId) throws Exception {
        LinkedHashMap<Long, HashMap<String, Object>> subModuleMap = new LinkedHashMap<Long, HashMap<String, Object>>();
        Iterator iter = dObj.getRows("AUDCustomReportSubModule", new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"MODULE_ID"), (Object)moduleId, 0));
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> innerSubModule = new HashMap<String, Object>();
            String[] columns = new String[]{"TABLE_NAME", "CRITERIA_DATA_TYPE", "CRITERIA_VALUE", "CRITERIA_COLUMN", "MODULE_ID", "SUB_MODULE_DISPLAY_NAME", "SUB_MODULE_NAME", "SUB_MODULE_ID"};
            CustomReportUtil.insertMapValues(innerSubModule, row, columns);
            innerSubModule.put("INNER_SUB_MODULE_ID", CustomReportUtil.getInnerSubModules(dObj, (Long)row.get("SUB_MODULE_ID")));
            subModuleMap.put((Long)row.get("SUB_MODULE_ID"), innerSubModule);
            subModuleDetails.put((Long)row.get("SUB_MODULE_ID"), row);
        }
        return subModuleMap;
    }

    private static LinkedHashMap getInnerSubModules(DataObject dObj, Long subModuleId) throws Exception {
        LinkedHashMap<Long, HashMap<String, Object>> subModMap = new LinkedHashMap<Long, HashMap<String, Object>>();
        Iterator iter = dObj.getRows("AUDCustomReportSubModule", new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"INNER_SUB_MODULE_ID"), (Object)subModuleId, 0));
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> innerSubModMap = new HashMap<String, Object>();
            String[] columns = new String[]{"TABLE_NAME", "CRITERIA_DATA_TYPE", "CRITERIA_VALUE", "CRITERIA_COLUMN", "MODULE_ID", "SUB_MODULE_DISPLAY_NAME", "SUB_MODULE_NAME", "SUB_MODULE_ID"};
            CustomReportUtil.insertMapValues(innerSubModMap, row, columns);
            if (row.get("INNER_SUB_MODULE_ID") != null) {
                innerSubModMap.put("INNER_SUB_MODULE_ID", CustomReportUtil.getInnerSubModules(dObj, (Long)row.get("SUB_MODULE_ID")));
            }
            subModuleDetails.put((Long)row.get("SUB_MODULE_ID"), row);
            subModMap.put((Long)row.get("SUB_MODULE_ID"), innerSubModMap);
        }
        return subModMap;
    }

    private static void insertMapValues(HashMap<String, Object> map, Row row, String[] columns) throws Exception {
        for (int i = 0; i < columns.length; ++i) {
            map.put(columns[i], row.get(columns[i]));
        }
    }

    private static void getModulesVsView() {
        try {
            if (moduleIdVsviewIdMap == null) {
                moduleIdVsviewIdMap = new HashMap();
            }
            if (moduleDetails == null) {
                moduleDetails = new HashMap();
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportModule"));
            Join join = new Join("AUDCustomReportModule", "AUDCustomReportModuleViewMap", new String[]{"MODULE_ID"}, new String[]{"MODULE_ID"}, 2);
            query.addJoin(join);
            Criteria crit = null;
            if (!LicenseUtil.isProfEdn()) {
                crit = new Criteria(Column.getColumn((String)"AUDCustomReportModule", (String)"LICENSE_TYPE"), (Object)1, 0);
            }
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReportModule", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReportModuleViewMap", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportModule", (String)"MODULE_ID"), true));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            LinkedHashMap moduleMap = null;
            Iterator iter = dObj.getRows("AUDCustomReportModuleViewMap");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Long viewId = (Long)row.get("REPORT_VIEW");
                moduleMap = moduleIdVsviewIdMap.get(viewId) != null ? moduleIdVsviewIdMap.get(viewId) : new LinkedHashMap();
                Row row1 = dObj.getRow("AUDCustomReportModule", new Criteria(Column.getColumn((String)"AUDCustomReportModule", (String)"MODULE_ID"), row.get("MODULE_ID"), 0));
                moduleMap.put((Long)row1.get("MODULE_ID"), (String)row1.get("MODULE_DISPLAY_NAME"));
                HashMap<String, Object> moduleDetail = new HashMap<String, Object>();
                moduleDetail.put("MODULE_NAME", (String)row1.get("MODULE_NAME"));
                moduleDetail.put("MODULE_DISPLAY_NAME", (String)row1.get("MODULE_DISPLAY_NAME"));
                moduleDetail.put("COLUMN_SELECTION_ID", (Long)row1.get("COLUMN_SELECTION_ID"));
                moduleDetails.put((Long)row1.get("MODULE_ID"), moduleDetail);
                moduleIdVsviewIdMap.put(viewId, moduleMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setChartDetails() {
        try {
            chartDetails = new LinkedHashMap();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportChartDetails"));
            query.setCriteria((Criteria)null);
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReportChartDetails", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportChartDetails", (String)"CHART_ID"), true));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iter = dObj.getRows("AUDCustomReportChartDetails");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                HashMap<String, String> detailsMap = new HashMap<String, String>();
                detailsMap.put("CHART_TYPE", (String)row.get("CHART_TYPE"));
                detailsMap.put("CHART_DISPLAY_NAME", (String)row.get("CHART_DISPLAY_NAME"));
                chartDetails.put((Integer)row.get("CHART_ID"), detailsMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap<String, String> getChartDetails(Integer chartId) throws Exception {
        return chartDetails.get(chartId);
    }

    public static LinkedHashMap<Integer, HashMap<String, String>> getChartDetails() throws Exception {
        return chartDetails;
    }

    public static HashMap getModuleDetail(Long moduleId) throws Exception {
        return moduleDetails.get(moduleId);
    }

    public static ArrayList<Object> getColumnList(Long moduleId, String subModuleIds, AdventNetResourceBundle rb) throws Exception {
        HashMap moduleDetail = CustomReportUtil.getModuleDetail(moduleId);
        ArrayList<Long> selectedSM = CustomReportUtil.getSelectedSubModule(subModuleIds);
        Long columnSelectionId = (Long)moduleDetail.get("COLUMN_SELECTION_ID");
        if (selectedSM.size() > 0) {
            ArrayList<Long> colSelIdList = new ArrayList<Long>();
            for (int i = 0; i < selectedSM.size(); ++i) {
                if (colSelIdList.contains(subModuleIdVsColSelId.get(selectedSM.get(i)))) continue;
                colSelIdList.add(subModuleIdVsColSelId.get(selectedSM.get(i)));
            }
            columnSelectionId = colSelIdList.size() == 1 ? (Long)colSelIdList.get(0) : CustomReportUtil.getSelectionId(columnSelectionId, colSelIdList);
            logger.log(Level.INFO, "Column Selection Id list is " + colSelIdList);
        }
        String query = CustomReportUtil.queryBuilder(new String[]{"SELECT a.COLUMN_ID, COLUMN_NAME,COLUMN_DATA_TYPE,COLUMN_DISPLAY_NAME,COLUMN_SELECTION_ID,ELEMENT_ID,VISIBLE,SEARCHENABLED,SORTENABLED,DATE_FORMAT,TRANSFORMER,MANDATORY,BGCOLUMN,ESCAPE_HTML FROM AUDReportColumns a, (SELECT MAX(COLUMN_ID) AS COLUMN_ID FROM AUDReportColumns WHERE COLUMN_SELECTION_ID&", columnSelectionId.toString(), "=", columnSelectionId.toString(), " GROUP BY COLUMN_NAME) as b WHERE a.COLUMN_ID=b.COLUMN_ID ORDER BY a.COLUMN_ID"});
        return CustomReportUtil.getColumnList(query, rb);
    }

    public static String queryBuilder(String[] queryStrs) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < queryStrs.length; ++i) {
            sb.append(queryStrs[i]);
        }
        return sb.toString();
    }

    private static DataObject getSubModules(String tableName, Criteria crit) throws Exception {
        return CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
    }

    public static ArrayList<Long> getSelectedSubModule(String subModuleIds) throws Exception {
        ArrayList<Long> selectedSM = new ArrayList<Long>();
        if (subModuleIds != null) {
            StringTokenizer strings = new StringTokenizer(subModuleIds, ";;;");
            while (strings.hasMoreElements()) {
                selectedSM.add(Long.parseLong(strings.nextElement().toString()));
            }
        }
        logger.log(Level.INFO, "Selected Sub Module List is " + selectedSM);
        return selectedSM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object> getColumnList(String query, AdventNetResourceBundle rb) {
        ArrayList<Object> columnsList = new ArrayList<Object>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Get Column Details for Custom Reports", statement, query);
            while (resultSet.next()) {
                columnsList.add(ReportUtil.formMap(new String[]{"COLUMN_ID", "COLUMN_NAME", "COLUMN_DATA_TYPE", "COLUMN_DISPLAY_NAME", "COLUMN_SELECTION_ID", "ELEMENT_ID", "VISIBLE", "SEARCHENABLED", "SORTENABLED", "DATE_FORMAT", "TRANSFORMER", "MANDATORY", "BGCOLUMN", "ESCAPE_HTML"}, new Object[]{resultSet.getLong("COLUMN_ID"), resultSet.getString("COLUMN_NAME"), resultSet.getInt("COLUMN_DATA_TYPE"), rb.getString(resultSet.getString("COLUMN_DISPLAY_NAME")), resultSet.getLong("COLUMN_SELECTION_ID"), resultSet.getLong("ELEMENT_ID"), resultSet.getBoolean("VISIBLE"), resultSet.getBoolean("SEARCHENABLED"), resultSet.getBoolean("SORTENABLED"), resultSet.getString("DATE_FORMAT"), resultSet.getString("TRANSFORMER"), resultSet.getBoolean("MANDATORY"), resultSet.getBoolean("BGCOLUMN"), resultSet.getBoolean("ESCAPE_HTML")}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return columnsList;
    }

    public static HashMap<String, String[]> getTimePeriods(AdventNetResourceBundle rb) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportTimePeriodLists"));
        query.setCriteria((Criteria)null);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportTimePeriodLists", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportTimePeriodLists", (String)"TIME_PERIOD_ID"), false));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Object moduleMap = null;
        int size = dObj.size("AUDCustomReportTimePeriodLists");
        String[] clientValues = new String[size];
        String[] serverValues = new String[size];
        int i = 0;
        Iterator iter = dObj.getRows("AUDCustomReportTimePeriodLists");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            clientValues[i] = rb.getString((String)row.get("TIME_DISPLAY_NAME"));
            serverValues[i] = (String)row.get("TIME_PERIOD");
            ++i;
        }
        HashMap<String, String[]> timeMap = new HashMap<String, String[]>();
        timeMap.put("clientValues", clientValues);
        timeMap.put("serverValues", serverValues);
        return timeMap;
    }

    public static DataObject getReportCategoriesDO(Long loginId) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDReportCategories"));
        Join innerJoin = new Join(Table.getTable((String)"AUDReportCategories"), Table.getTable((String)"AUDReports"), new String[]{"REPORT_CATEGORY_ID"}, new String[]{"REPORT_CATEGORY_ID"}, 1);
        if (loginId != null) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), (Object)new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 9L, 16L, 10L, 11L, 12L, 13L, 14L, 15L, 17L, 18L, 19L, 20L, 21L, 31L, 33L, 40L, 50L, 22L, 61L, 62L, 63L, 64L, 65L, 66L, 67L, 68L, 69L, 70L, 71L}, 9));
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), (Object)7L, 0));
            query.setCriteria(crit);
        } else {
            query.setCriteria(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), (Object)1L, 1));
        }
        query.addJoin(innerJoin);
        query.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), true), 0);
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportCategories", (String)"PRIORITY"), true), 1);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        return dObj;
    }

    public static HashMap<String, Object[]> getReportCategories(AdventNetResourceBundle rb, Long loginId) throws Exception {
        HashMap<String, Object[]> categoryMap = new HashMap<String, Object[]>();
        DataObject dObj = CustomReportUtil.getReportCategoriesDO(loginId);
        int size = dObj.size("AUDReportCategories");
        String[] clientValues = new String[size];
        Long[] serverValues = new Long[size];
        int i = 0;
        Iterator iter = dObj.getRows("AUDReportCategories");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            clientValues[i] = rb.getString((String)row.get("NAME"));
            serverValues[i] = (Long)row.get("REPORT_CATEGORY_ID");
            ++i;
        }
        categoryMap.put("clientValues", clientValues);
        categoryMap.put("serverValues", serverValues);
        return categoryMap;
    }

    public static ArrayList getReportsList(AdventNetResourceBundle rb, String domainName, Long loginId, Boolean isEmber) {
        ArrayList reportsList = new ArrayList();
        try {
            String[] viewTypes = new String[]{rb.getString("adap.AUDCustomReportView.report_view_display_name.Tabular"), rb.getString("adap.AUDCustomReportView.report_view_display_name.Graphical"), rb.getString("adap.AUDCustomReportView.report_view_display_name.Summary"), rb.getString("adap.AUDCustomReportView.report_view_display_name.Pivotal")};
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReports"));
            Join innerJoin2 = new Join(Table.getTable((String)"AUDCustomReports"), Table.getTable((String)"AUDReports"), new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            Join innerJoin3 = new Join(Table.getTable((String)"AUDReports"), Table.getTable((String)"AUDReportCategories"), new String[]{"REPORT_CATEGORY_ID"}, new String[]{"REPORT_CATEGORY_ID"}, 2);
            query.addJoin(innerJoin2);
            query.addJoin(innerJoin3);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"IS_PUBLIC"), (Object)true, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"LOGIN_ID"), (Object)new Long[]{loginId}, 8));
            if (domainName != null) {
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReports", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReports", (String)"MODIFICATION_TIME"), false));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iter = dObj.getRows("AUDCustomReports");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                HashMap<String, Object> reportDetails = new HashMap<String, Object>();
                reportDetails.put("CUSTOM_REPORT_ID", row.get("CUSTOM_REPORT_ID"));
                reportDetails.put("DOMAIN_NAME", row.get("DOMAIN_NAME"));
                if (isEmber.booleanValue()) {
                    reportDetails.put("REPORT_VIEW", viewTypes[((Long)row.get("REPORT_VIEW")).intValue() - 1]);
                } else {
                    reportDetails.put("REPORT_VIEW", row.get("REPORT_VIEW"));
                }
                String defaultReportPeriod = (String)row.get("DEFAULT_REPORT_PERIOD");
                reportDetails.put("DEFAULT_REPORT_PERIOD", defaultReportPeriod);
                if (defaultReportPeriod.equalsIgnoreCase("customPeriod")) {
                    reportDetails.put("FROM", row.get("FROM_TIME"));
                    reportDetails.put("TO", row.get("TO_TIME"));
                }
                Row reportsRow = dObj.getRow("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), row.get("AUDIT_REPORT_ID"), 0));
                Row categoryRow = dObj.getRow("AUDReportCategories", new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), reportsRow.get("REPORT_CATEGORY_ID"), 0));
                reportDetails.put("REPORT_NAME", reportsRow.get("AUDIT_REPORT_NAME"));
                reportDetails.put("REPORT_CATEGORY_NAME", rb.getString(categoryRow.get("NAME").toString()));
                reportDetails.put("AUDIT_REPORT_ID", reportsRow.get("AUDIT_REPORT_ID"));
                reportDetails.put("DESCRIPTION", reportsRow.get("DESCRIPTION"));
                reportsList.add(reportDetails);
            }
            logger.log(Level.INFO, "The List of Custom Reports : " + reportsList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportsList;
    }

    private static Long getSelectionId(Long moduleColSelId, ArrayList<Long> colSelIdList) throws Exception {
        if (moduleColSelId == 256L) {
            if (!(colSelIdList.contains(4L) || colSelIdList.contains(8L) || colSelIdList.contains(32L))) {
                return 16L;
            }
            if (colSelIdList.contains(4L) && colSelIdList.contains(8L) && colSelIdList.contains(32L) && colSelIdList.contains(16L) || !colSelIdList.contains(32L) && !colSelIdList.contains(16L) || !colSelIdList.contains(16L) || !colSelIdList.contains(4L) && !colSelIdList.contains(16L) || !colSelIdList.contains(4L) || !colSelIdList.contains(4L) && !colSelIdList.contains(8L)) {
                return moduleColSelId;
            }
        } else {
            return moduleColSelId;
        }
        return moduleColSelId;
    }

    public static String getDisplayType(Long viewType, Integer chartId) throws Exception {
        String dispType = "BOTH";
        if (chartId == -1 || viewType == 3L || viewType == 4L) {
            dispType = "TABLE";
        } else if (viewType == 2L) {
            dispType = "GRAPH";
        }
        return dispType;
    }

    public static String getTileType(Long viewType) throws Exception {
        String tileType = "report";
        if (viewType == 3L) {
            tileType = "report";
        } else if (viewType == 4L) {
            tileType = "matrix";
        }
        return tileType;
    }

    public static String formStringValues(Integer relOper, String value, String columnName) throws Exception {
        value = EscapeUtil.escSplCharsAsSQLForLike(value);
        int operation = relOper;
        if ((operation == 1 || operation == 2) && value.indexOf("${OBJECTREPLACE") != 0) {
            value = ReportUtil.addQuotes(value);
        }
        String val = "";
        switch (operation) {
            case 1: {
                if (dbName.equalsIgnoreCase("mssql")) {
                    val = "CAST(" + columnName + " AS VARCHAR(MAX))" + " IN (" + value + " )";
                    break;
                }
                val = columnName + " IN (" + value + " )";
                break;
            }
            case 2: {
                if (dbName.equalsIgnoreCase("mssql")) {
                    val = "CAST(" + columnName + " AS VARCHAR(MAX))" + " NOT IN (" + value + " )";
                    break;
                }
                val = columnName + " NOT IN (" + value + " )";
                break;
            }
            case 7: {
                val = CustomReportUtil.formStringValues(columnName, " LIKE '", value, "%'");
                break;
            }
            case 9: {
                val = CustomReportUtil.formStringValues(columnName, " NOT LIKE '", value, "%'");
                break;
            }
            case 8: {
                val = CustomReportUtil.formStringValues(columnName, " LIKE '%", value, "'");
                break;
            }
            case 10: {
                val = CustomReportUtil.formStringValues(columnName, " NOT LIKE '%", value, "%'");
                break;
            }
            case 13: {
                val = CustomReportUtil.formStringValues(columnName, " LIKE '%", value, "%'");
                break;
            }
            case 14: {
                val = CustomReportUtil.formStringValues(columnName, " NOT LIKE '%", value, "%'");
                break;
            }
            case 11: {
                val = CustomReportUtil.formStringValues(columnName, " LIKE '%", value, "%'");
                break;
            }
            case 12: {
                val = CustomReportUtil.formStringValues(columnName, " LIKE '%", value, "%'");
                break;
            }
            default: {
                val = "";
            }
        }
        return val;
    }

    private static String formStringValues(String columnName, String prefix, String value, String suffix) throws Exception {
        String retVal = columnName + prefix + value + suffix;
        if (value.indexOf("${OBJECTREPLACE") == 0) {
            retVal = columnName + " NOT IN (" + value + " )";
            if (prefix.indexOf("NOT IN") == -1 && prefix.indexOf("NOT LIKE") == -1) {
                retVal = columnName + " IN (" + value + " )";
            }
        }
        return retVal;
    }

    public static String formNumericValues(Integer relOper, String value, String columnName) throws Exception {
        int operation = relOper;
        String val = "";
        switch (operation) {
            case 1: {
                val = columnName + " = " + value;
                break;
            }
            case 2: {
                val = columnName + " != " + value;
                break;
            }
            case 3: {
                val = columnName + " < " + value;
                break;
            }
            case 4: {
                val = columnName + " <= " + value;
                break;
            }
            case 5: {
                val = columnName + " > " + value;
                break;
            }
            case 6: {
                val = columnName + " >= " + value;
                break;
            }
            default: {
                val = "";
            }
        }
        return val;
    }

    public static String convertColumnsToVarchar(HashMap<String, Object> columnMap, String dbName, Boolean isCountRplc) throws Exception {
        String columnName = (String)columnMap.get("COLUMN_NAME");
        Boolean isTextColumn = (Boolean)columnMap.get("IS_TEXT_COLUMN");
        Long elemId = (Long)columnMap.get("ELEMENT_ID");
        if (elemId.longValue() == elementId.longValue() && isCountRplc.booleanValue()) {
            columnName = "CAST(" + columnName + " as VARCHAR)";
        } else if (isTextColumn.booleanValue() && dbName.equalsIgnoreCase("mssql") && isCountRplc.booleanValue()) {
            columnName = "CONVERT(VARCHAR(max) , " + columnName + ")";
        } else if (isTextColumn.booleanValue() && dbName.equalsIgnoreCase("mssql")) {
            columnName = "CONVERT(VARCHAR(max) , " + columnName + ") as " + columnName;
        }
        return columnName;
    }

    public static ArrayList<HashMap<Object, Object>> getViewTypeMapEmber(AdventNetResourceBundle rb) throws Exception {
        ArrayList<HashMap<Object, Object>> l1 = new ArrayList<HashMap<Object, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportView"));
        query.setCriteria((Criteria)null);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportView", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportView", (String)"REPORT_VIEW"), true));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iter = dObj.getRows("AUDCustomReportView");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> details = new HashMap<String, Object>();
            Long reportTypeId = (Long)row.get("REPORT_VIEW");
            details.put("DISPLAY_NAME", rb.getString((String)row.get("REPORT_VIEW_DISPLAY_NAME")));
            details.put("DESCRIPTION", rb.getString((String)row.get("REPORT_VIEW_DESCRIPTION")));
            details.put("displayName", rb.getString((String)row.get("REPORT_VIEW_DISPLAY_NAME")));
            details.put("description", rb.getString((String)row.get("REPORT_VIEW_DESCRIPTION")));
            details.put("reportTypeId", (Long)row.get("REPORT_VIEW"));
            if (reportTypeId.equals(1L)) {
                details.put("class", "tabular");
            } else if (reportTypeId.equals(2L)) {
                details.put("class", "graphical");
            } else if (reportTypeId.equals(3L)) {
                details.put("class", "summary");
            } else if (reportTypeId.equals(4L)) {
                details.put("class", "pivotal");
            }
            l1.add(details);
        }
        return l1;
    }

    public static ArrayList<HashMap<String, Object>> getModulesEmber(AdventNetResourceBundle rb) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportSubModule"));
        Join leftJoin = new Join("AUDCustomReportSubModule", "AUDCustomReportModule", new String[]{"MODULE_ID"}, new String[]{"MODULE_ID"}, 1);
        Criteria crit = null;
        if (!LicenseUtil.isProfEdn()) {
            crit = new Criteria(Column.getColumn((String)"AUDCustomReportModule", (String)"LICENSE_TYPE"), (Object)1, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"LICENSE_TYPE"), (Object)1, 0));
        }
        query.setCriteria(crit);
        query.addJoin(leftJoin);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportModule", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"SUB_MODULE_ID"), true));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        ArrayList<HashMap<String, Object>> l1 = new ArrayList<HashMap<String, Object>>();
        Iterator iter = dObj.getRows("AUDCustomReportModule");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", (Long)row.get("MODULE_ID"));
            map1.put("name", rb.getString((String)row.get("MODULE_DISPLAY_NAME")));
            map1.put("tabId", (String)row.get("MODULE_NAME") + "_" + (Long)row.get("MODULE_ID"));
            map1.put("tabIdh", "#" + (String)row.get("MODULE_NAME") + "_" + (Long)row.get("MODULE_ID"));
            l1.add(map1);
        }
        return l1;
    }

    public static ArrayList<HashMap<String, Object>> getSubModuleMapEmber(AdventNetResourceBundle rb) throws Exception {
        ArrayList<HashMap<String, Object>> l1 = new ArrayList<HashMap<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportSubModule"));
        Join leftJoin = new Join("AUDCustomReportSubModule", "AUDCustomReportModule", new String[]{"MODULE_ID"}, new String[]{"MODULE_ID"}, 1);
        Criteria crit = null;
        if (!LicenseUtil.isProfEdn()) {
            crit = new Criteria(Column.getColumn((String)"AUDCustomReportModule", (String)"LICENSE_TYPE"), (Object)1, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"LICENSE_TYPE"), (Object)1, 0));
        }
        query.setCriteria(crit);
        query.addJoin(leftJoin);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportModule", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"SUB_MODULE_ID"), true));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iter = dObj.getRows("AUDCustomReportModule");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", rb.getString((String)row.get("MODULE_DISPLAY_NAME")));
            map.put("id", (Long)row.get("MODULE_ID"));
            map.put("tabId", (String)row.get("MODULE_NAME") + "_" + (Long)row.get("MODULE_ID"));
            map.put("tabIdh", "#" + (String)row.get("MODULE_NAME") + "_" + (Long)row.get("MODULE_ID"));
            map.put("list", CustomReportUtil.getSubModuleEmber(dObj, (Long)row.get("MODULE_ID"), rb));
            l1.add(map);
        }
        return l1;
    }

    private static ArrayList getSubModuleEmber(DataObject dObj, Long moduleId, AdventNetResourceBundle rb) throws Exception {
        LinkedHashMap<Long, HashMap<String, Object>> subModuleMap = new LinkedHashMap<Long, HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> l1 = new ArrayList<HashMap<String, Object>>();
        Iterator iter = dObj.getRows("AUDCustomReportSubModule", new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"MODULE_ID"), (Object)moduleId, 0));
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> innerSubModule = new HashMap<String, Object>();
            String[] columns = new String[]{"TABLE_NAME", "CRITERIA_DATA_TYPE", "CRITERIA_VALUE", "CRITERIA_COLUMN", "MODULE_ID", "SUB_MODULE_DISPLAY_NAME", "SUB_MODULE_NAME", "SUB_MODULE_ID"};
            CustomReportUtil.insertMapValuesEmber(innerSubModule, row, columns, rb);
            ArrayList l2 = CustomReportUtil.getInnerSubModulesEmber(dObj, (Long)row.get("SUB_MODULE_ID"), rb);
            if (l2.size() > 0) {
                innerSubModule.put("hasDropdown", true);
                innerSubModule.put("list", l2);
            }
            l1.add(innerSubModule);
            subModuleMap.put((Long)row.get("SUB_MODULE_ID"), innerSubModule);
            subModuleDetails.put((Long)row.get("SUB_MODULE_ID"), row);
        }
        return l1;
    }

    private static ArrayList getInnerSubModulesEmber(DataObject dObj, Long subModuleId, AdventNetResourceBundle rb) throws Exception {
        ArrayList<HashMap<String, Object>> l1 = new ArrayList<HashMap<String, Object>>();
        LinkedHashMap<Long, HashMap<String, Object>> subModMap = new LinkedHashMap<Long, HashMap<String, Object>>();
        Iterator iter = dObj.getRows("AUDCustomReportSubModule", new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"INNER_SUB_MODULE_ID"), (Object)subModuleId, 0));
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> innerSubModMap = new HashMap<String, Object>();
            String[] columns = new String[]{"TABLE_NAME", "CRITERIA_DATA_TYPE", "CRITERIA_VALUE", "CRITERIA_COLUMN", "MODULE_ID", "SUB_MODULE_DISPLAY_NAME", "SUB_MODULE_NAME", "SUB_MODULE_ID"};
            CustomReportUtil.insertMapValuesEmber(innerSubModMap, row, columns, rb);
            ArrayList l2 = null;
            if (row.get("INNER_SUB_MODULE_ID") != null) {
                l2 = CustomReportUtil.getInnerSubModulesEmber(dObj, (Long)row.get("SUB_MODULE_ID"), rb);
                innerSubModMap.put("INNER_SUB_MODULE_ID", l2);
            }
            if (l2 != null && l2.size() > 0) {
                innerSubModMap.put("hasDropdown", true);
                innerSubModMap.put("list", l2);
            }
            subModuleDetails.put((Long)row.get("SUB_MODULE_ID"), row);
            subModMap.put((Long)row.get("SUB_MODULE_ID"), innerSubModMap);
            l1.add(innerSubModMap);
        }
        return l1;
    }

    private static void insertMapValuesEmber(HashMap<String, Object> map, Row row, String[] columns, AdventNetResourceBundle rb) throws Exception {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].equals("SUB_MODULE_DISPLAY_NAME")) {
                map.put(columns[i], rb.getString((String)row.get(columns[i])));
                continue;
            }
            map.put(columns[i], row.get(columns[i]));
        }
    }

    public static HashMap<String, Object> getTimePeriodsEmber(AdventNetResourceBundle rb) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportTimePeriodLists"));
        query.setCriteria((Criteria)null);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportTimePeriodLists", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportTimePeriodLists", (String)"TIME_PERIOD_ID"), false));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        int size = dObj.size("AUDCustomReportTimePeriodLists");
        String[] clientValues = new String[size];
        String[] serverValues = new String[size];
        ArrayList<String> clientList = new ArrayList<String>();
        ArrayList<String> serverList = new ArrayList<String>();
        int i = 0;
        ArrayList timeList = new ArrayList();
        Iterator iter = dObj.getRows("AUDCustomReportTimePeriodLists");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, String> map1 = new HashMap<String, String>();
            clientValues[i] = rb.getString((String)row.get("TIME_DISPLAY_NAME"));
            serverValues[i] = (String)row.get("TIME_PERIOD");
            clientList.add(rb.getString((String)row.get("TIME_DISPLAY_NAME")));
            serverList.add((String)row.get("TIME_PERIOD"));
            map1.put("name", rb.getString((String)row.get("TIME_DISPLAY_NAME")));
            map1.put("value", rb.getString((String)row.get("TIME_PERIOD")));
            timeList.add(map1);
            ++i;
        }
        HashMap<String, Object> timeMap = new HashMap<String, Object>();
        timeMap.put("clientValues", clientValues);
        timeMap.put("serverValues", serverValues);
        timeMap.put("clientList", clientList);
        timeMap.put("serverList", serverList);
        timeMap.put("timeList", timeList);
        return timeMap;
    }

    public static ArrayList<Object> getColumnListEmber(Long moduleId, ArrayList selectedSM, AdventNetResourceBundle rb) throws Exception {
        HashMap moduleDetail = CustomReportUtil.getModuleDetail(moduleId);
        Long columnSelectionId = (Long)moduleDetail.get("COLUMN_SELECTION_ID");
        if (selectedSM.size() > 0) {
            ArrayList<Long> colSelIdList = new ArrayList<Long>();
            for (int i = 0; i < selectedSM.size(); ++i) {
                if (colSelIdList.contains(subModuleIdVsColSelId.get(Long.valueOf(selectedSM.get(i).toString())))) continue;
                colSelIdList.add(subModuleIdVsColSelId.get(Long.valueOf(selectedSM.get(i).toString())));
            }
            columnSelectionId = colSelIdList.size() == 1 ? (Long)colSelIdList.get(0) : CustomReportUtil.getSelectionId(columnSelectionId, colSelIdList);
            logger.log(Level.INFO, "Column Selection Id list is " + colSelIdList);
        }
        String query = CustomReportUtil.queryBuilder(new String[]{"SELECT a.COLUMN_ID, COLUMN_NAME,COLUMN_DATA_TYPE,COLUMN_DISPLAY_NAME,COLUMN_SELECTION_ID,ELEMENT_ID,VISIBLE,SEARCHENABLED,SORTENABLED,DATE_FORMAT,TRANSFORMER,MANDATORY,BGCOLUMN,ESCAPE_HTML FROM AUDReportColumns a, (SELECT MAX(COLUMN_ID) AS COLUMN_ID FROM AUDReportColumns WHERE COLUMN_SELECTION_ID&", columnSelectionId.toString(), "=", columnSelectionId.toString(), " GROUP BY COLUMN_NAME) as b WHERE a.COLUMN_ID=b.COLUMN_ID ORDER BY a.COLUMN_ID"});
        return CustomReportUtil.getColumnList(query, rb);
    }

    public static JSONArray getSubModulesEmber(DataObject dObj) throws Exception {
        String subModuleIds = null;
        StringBuilder sb = new StringBuilder();
        JSONArray selectedSubModules = new JSONArray();
        if (dObj.size("AUDCustomReportSubModuleMap") > 0) {
            int i = 0;
            Iterator iterator = dObj.getRows("AUDCustomReportSubModuleMap");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (i != 0) {
                    sb.append(";;;");
                }
                sb.append(row.get("SUB_MODULE_ID"));
                selectedSubModules.put(row.get("SUB_MODULE_ID"));
                ++i;
            }
            subModuleIds = sb.toString();
        }
        return selectedSubModules;
    }

    public static ArrayList<HashMap<String, Object[]>> getReportCategoriesEmber(AdventNetResourceBundle rb, Long loginId, JSONObject reportData) throws Exception {
        HashMap<String, Object[]> categoryMap = new HashMap<String, Object[]>();
        DataObject dObj = CustomReportUtil.getReportCategoriesDO(loginId);
        int size = dObj.size("AUDReportCategories");
        String[] clientValues = new String[size];
        Long[] serverValues = new Long[size];
        int i = 0;
        ArrayList<HashMap<String, Object[]>> reportCategoryList = new ArrayList<HashMap<String, Object[]>>();
        Iterator iter = dObj.getRows("AUDReportCategories");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            clientValues[i] = rb.getString((String)row.get("NAME"));
            serverValues[i] = (Long)row.get("REPORT_CATEGORY_ID");
            map1.put("name", rb.getString((String)row.get("NAME")));
            map1.put("value", (Long)row.get("REPORT_CATEGORY_ID"));
            if (row.get("NAME").toString().equals("adap.AUDReportCategories.name.My_Reports")) {
                reportData.put("selectedFolder", (Object)serverValues[i]);
            }
            reportCategoryList.add(map1);
            ++i;
        }
        categoryMap.put("clientValues", clientValues);
        categoryMap.put("serverValues", serverValues);
        return reportCategoryList;
    }

    static {
        CustomReportUtil.getSubModuleVsTableNames();
        CustomReportUtil.getModulesVsView();
        CustomReportUtil.setChartDetails();
        CustomReportUtil.getSubModuleMap();
        elementId = DBObjectUtil.getUVHValues("AUDElement", "AudElement:element_id:510");
    }
}

