/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports.customreport;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportParams;
import com.adventnet.sym.adsm.common.server.export.ReportExporter;
import com.adventnet.sym.adsm.common.server.export.SetupMatrixReportPage;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;

public class MatrixExportUtil {
    private static String virtualizerDirName = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "Matrix";
    private static Logger logger = Logger.getLogger("QueryLogger");

    public static void exportReport(HttpServletRequest request, HttpServletResponse response, Long reportId, HashMap inputParamsMap, String searchCriteria, HashMap addnSQLPropsMap, Long cvId, String reportType, Long loginId, String matrixType) throws Exception {
        StringBuilder logBuilder = new StringBuilder();
        Long startTime = System.currentTimeMillis();
        ResourceBundleMgr.getInstance();
        Locale locale = ResourceBundleMgr.getLocale(loginId);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HashMap columnMap = MatrixExportUtil.getColumnMap(reportId, request);
        HashMap<String, Object> reportDetails = AuditReportAPI.getInstance().getReportDetails(reportId);
        addnSQLPropsMap.put("sortOrder", "DESC");
        JasperPrint print = MatrixExportUtil.exportReport(reportId, reportDetails, locale, rb, columnMap, inputParamsMap, searchCriteria, addnSQLPropsMap, cvId, reportType, loginId, matrixType);
        String reportFileName = rb.getString((String)reportDetails.get("TITLE")).replaceAll(" ", "_");
        ArrayList<JasperPrint> list = new ArrayList<JasperPrint>();
        list.add(print);
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            response.reset();
            ReportExporter.getInstance().exportAsPdf(list, reportFileName, response, request, true);
        } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
            ReportExporter.getInstance().exportAsJpeg(print, reportFileName, response, true);
        } else if (reportType.toLowerCase().indexOf("html") != -1) {
            logger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
            ReportExporter.getInstance().exportAsHtml(list, reportFileName, response, request.getSession(), "", true);
        } else if (reportType.toLowerCase().indexOf("xls") != -1) {
            ReportExporter.getInstance().exportAsXls(list, reportFileName, response, request, true);
        } else if (reportType.toLowerCase().indexOf("csv") != -1) {
            ReportExporter.getInstance().exportAsCsv(list, reportFileName, response, request, true);
        } else {
            logger.log(Level.INFO, "Invalid Report Type");
        }
    }

    public static int exportReport(String storagePath, Long scheduleId, Long reportId, HashMap inputParamsMap, String searchCriteria, HashMap addnSQLPropsMap, Long cvId, String fileFormat, Long loginId, String matrixType) {
        int isEmpty = 0;
        try {
            StringBuilder logBuilder = new StringBuilder();
            Long startTime = System.currentTimeMillis();
            ResourceBundleMgr.getInstance();
            Locale locale = ResourceBundleMgr.getLocale(loginId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            HashMap columnMap = MatrixExportUtil.getColumnMap(reportId, null);
            HashMap<String, Object> reportDetails = AuditReportAPI.getInstance().getReportDetails(reportId);
            addnSQLPropsMap.put("sortOrder", "DESC");
            JasperPrint print = MatrixExportUtil.exportReport(reportId, reportDetails, locale, rb, columnMap, inputParamsMap, searchCriteria, addnSQLPropsMap, cvId, fileFormat, loginId, matrixType);
            String reportFileName = rb.getString((String)reportDetails.get("TITLE")).replaceAll(" ", "_");
            ArrayList<JasperPrint> list = new ArrayList<JasperPrint>();
            list.add(print);
            if (fileFormat.toLowerCase().indexOf("pdf") != -1) {
                ReportExporter.getInstance().exportAsPdf(list, reportFileName, cvId, storagePath, true);
            } else if (fileFormat.toLowerCase().indexOf("html") != -1) {
                logger.log(Level.INFO, "The reportFileName in exportreport is : " + reportFileName);
                ReportExporter.getInstance().exportAsHTML(list, reportFileName, cvId, storagePath, "", true);
            } else if (fileFormat.toLowerCase().indexOf("xls") != -1) {
                ReportExporter.getInstance().exportAsXLS(list, reportFileName, cvId, storagePath, true);
            } else if (fileFormat.toLowerCase().indexOf("csv") != -1) {
                ReportExporter.getInstance().exportAsCSV(list, reportFileName, cvId, storagePath, true);
            } else {
                logger.log(Level.INFO, "Invalid Report Type");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isEmpty = 1;
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperPrint exportReport(Long reportId, HashMap reportDetails, Locale locale, AdventNetResourceBundle rb, HashMap<String, Object> columnMap, HashMap<String, Object> inputParamsMap, String searchCriteria, HashMap<String, Object> addnSQLPropsMap, Long cvId, String reportType, Long loginId, String matrixType) throws Exception {
        String jasperFile = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "jrxml" + File.separator + reportId + ".jasper";
        searchCriteria = "".equalsIgnoreCase(searchCriteria) ? null : searchCriteria;
        String sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, new HashMap(), 0);
        sqlString = sqlString.replace("${GROUP_BY}", "");
        sqlString = MatrixReportHandler.getConstructedSQL(sqlString, addnSQLPropsMap, columnMap, (String)columnMap.get("SUMMARY_TYPE"), inputParamsMap);
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        parametersMap.put("reportName", (String)reportDetails.get("AUDIT_REPORT_NAME"));
        parametersMap.put("description", (String)reportDetails.get("DESCRIPTION"));
        parametersMap.put("domainName", (String)inputParamsMap.get("domainDNSName"));
        parametersMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        parametersMap.put("reportGeneratedAt", new SimpleDateFormat(TimeUtil.getDateFormat()).format(new Date()));
        parametersMap.put("duration", rb.handleGetObject("adap.MatrixReportHandler.Period_From_To", new String[]{TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("FROM")) * 1000L), TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("TO")) * 1000L)}));
        if (reportDetails.get("type") != null && !"simple".equalsIgnoreCase((String)reportDetails.get("type"))) {
            return null;
        }
        SetupMatrixReportPage smrp = new SetupMatrixReportPage();
        smrp.replaceNullValueAs(rb.getString("adap.MatrixReportHandler.replace_null_value"));
        smrp.setCellWidth(90);
        smrp.setCellHeight(30);
        smrp.setDateFormat(TimeUtil.getDateFormat());
        smrp.setGroupDateFormat(TimeUtil.getDate());
        smrp.setLogo((String)reportDetails.get("logo"));
        JasperDesign jd = smrp.getJasperDesign(MatrixReportHandler.formHashMap((HashMap)columnMap.get("TOP_COL_DETAILS")), MatrixReportHandler.formHashMap((HashMap)columnMap.get("LEFT_COL_DETAILS")), columnMap.get("SUMMARY_COL_DETAILS") != null ? MatrixReportHandler.formHashMap((HashMap)columnMap.get("SUMMARY_COL_DETAILS")) : MatrixReportHandler.formHashMap((HashMap)columnMap.get("LEFT_COL_DETAILS")), (String)columnMap.get("SUMMARY_TYPE"), sqlString, locale.getLanguage(), false, parametersMap);
        JasperCompileManager.compileReportToFile((JasperDesign)jd, (String)jasperFile);
        parametersMap.put("Details", new LinkedHashMap());
        parametersMap.put("query", sqlString);
        parametersMap.put("domainNameText", rb.getString("adap.admin.administration.technician.domain_name"));
        parametersMap.put("annoText", rb.getString("adap.ExportUtil.annotation"));
        parametersMap.put("reportGenAtText", rb.getString("adap.ExportUtil.Report_Generated_at"));
        parametersMap.put("durationText", rb.getString("adap.common.text.period"));
        RelationalAPI relapi = RelationalAPI.getInstance();
        JasperPrint print = null;
        try (Connection conn = null;){
            int j;
            conn = RelationalAPI.getInstance().getConnection();
            JRFileVirtualizer virtualizer = new JRFileVirtualizer(50, virtualizerDirName);
            parametersMap.put("REPORT_VIRTUALIZER", virtualizer);
            print = JasperFillManager.fillReport((String)jasperFile, parametersMap, (Connection)conn);
            virtualizer.setReadOnly(true);
            if (print == null) {
                throw new Exception("Unable to generate html file!!!");
            }
            List list1 = print.getPages();
            JRPrintPage jpp = (JRPrintPage)list1.get(0);
            List list2 = jpp.getElements();
            JRPrintElement jpe = null;
            int max = 0;
            boolean index = false;
            for (j = 0; j < list2.size(); ++j) {
                jpe = (JRPrintElement)list2.get(j);
                if (jpe.getX() <= max) continue;
                max = jpe.getX();
            }
            for (j = 0; j < list2.size(); ++j) {
                jpe = (JRPrintElement)list2.get(j);
                if (jpe.getWidth() == 100000) {
                    jpe.setWidth(max + 100);
                    list2.set(j, jpe);
                    continue;
                }
                if (jpe.getWidth() == 100001) {
                    jpe.setWidth(max + 100);
                    list2.set(j, jpe);
                    continue;
                }
                if (jpe.getWidth() == 100002) {
                    jpe.setWidth(265);
                    jpe.setX(max - 165);
                    list2.set(j, jpe);
                    continue;
                }
                if (jpe.getWidth() == 100003) {
                    jpe.setWidth(max / 2);
                    jpe.setX(5);
                    list2.set(j, jpe);
                    continue;
                }
                if (jpe.getWidth() != 100004) continue;
                jpe.setWidth(max / 2 + 90);
                jpe.setX(max / 2 + 10);
                list2.set(j, jpe);
            }
            print.setPageWidth(max + 100);
        }
        return print;
    }

    private static HashMap getColumnMap(Long reportId, HttpServletRequest request) throws Exception {
        if (request != null) {
            MatrixReportParams matrixParams = (MatrixReportParams)request.getSession().getAttribute("matrixParams");
            return matrixParams.getColumnDetails();
        }
        return MatrixReportHandler.getMatrixReportDetails(reportId);
    }
}

