/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports.customreport;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportParams;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class MatrixReportHandler {
    private static ArrayList<Object> columnNameList = new ArrayList();
    private static HashMap<String, Long> firstColMap = new HashMap();
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static String dbName = CommonUtil.getDBServerName();

    public static void generateMatrixReport(HttpServletRequest request, Long reportId, HashMap<String, Object> inputParamsMap, String searchCriteria, HashMap<String, Object> addnSQLPropsMap, Long cvId) throws Exception {
        Long currTime = System.currentTimeMillis();
        LinkedHashMap<Object, Object> pivotDetails = new LinkedHashMap();
        columnNameList = new ArrayList();
        firstColMap = new HashMap();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Locale locale = request.getLocale();
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> columnMap = MatrixReportHandler.getMatrixReportDetails(reportId);
        String sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, new HashMap(), 0);
        sqlString = sqlString.replace("${GROUP_BY}", "");
        sqlString = MatrixReportHandler.getConstructedSQL(sqlString, addnSQLPropsMap, columnMap, (String)columnMap.get("SUMMARY_TYPE"), inputParamsMap);
        Connection conn = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            conn = relAPI.getConnection();
            statement = conn.createStatement();
            resultSet = QueryUtil.executeQuery("Report ", statement, sqlString);
            pivotDetails = MatrixReportHandler.getSimplePivotableViewDetails(resultSet, columnMap);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            request.setAttribute("pivotDetails", pivotDetails);
            request.setAttribute("columnNameList", columnNameList);
            currTime = System.currentTimeMillis() - currTime;
            StringBuilder logBuilder = new StringBuilder("Time Taken to Generate this Report : ").append(Long.toString(currTime)).append("ms");
            logger.log(Level.INFO, logBuilder.toString());
            request.setAttribute("timeTaken", (Object)logBuilder.toString());
            MatrixReportParams matrixParams = new MatrixReportParams();
            matrixParams.setColumnNamesList(columnNameList);
            matrixParams.setPivotDetails(pivotDetails);
            matrixParams.setTimeTakenStr(logBuilder.toString());
            matrixParams.setFirstColMap(firstColMap);
            matrixParams.setFirstColValList(firstColMap, null);
            matrixParams.setColumnDetails(columnMap);
            request.getSession().setAttribute("matrixParams", (Object)matrixParams);
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static String getSimpleMatrixSummaryType(HashMap reportDetails) {
        if (reportDetails.get("summaryType") != null) {
            return (String)reportDetails.get("summaryType");
        }
        return "Count";
    }

    public static HashMap<String, Object> getMatrixReportDetails(Long reportId) throws Exception {
        HashMap<String, Object> columnDetails = new HashMap<String, Object>();
        HashMap columnsMap = AuditCategoryHandler.getInstance().getColumnsMap();
        Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
        String[] tableNames = new String[]{"AUDCustomReports", "AUDMatrixReportDetails"};
        boolean[] isLeftJoins = new boolean[]{true, true};
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(tableNames, isLeftJoins, crit));
        if (dObj.size("AUDMatrixReportDetails") > 0) {
            Row matrixRow = dObj.getFirstRow("AUDMatrixReportDetails");
            columnDetails.put("TOP_COL_DETAILS", (HashMap)columnsMap.get((Long)matrixRow.get("GROUP_TOP_COLUMN")));
            columnDetails.put("LEFT_COL_DETAILS", (HashMap)columnsMap.get((Long)matrixRow.get("GROUP_LEFT_COLUMN")));
            if (!"count".equalsIgnoreCase((String)matrixRow.get("SUMMARY_TYPE"))) {
                columnDetails.put("SUMMARY_COL_DETAILS", (HashMap)columnsMap.get((Long)matrixRow.get("SUMMARY_COLUMN")));
            } else {
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                detailMap.put("COLUMN_NAME", "SUMMARY_VALUE");
                detailMap.put("COLUMN_DISPLAY_NAME", "Sum of Total Record count");
                detailMap.put("COLUMN_DATA_TYPE", new Integer(1002));
                columnDetails.put("SUMMARY_COL_DETAILS", detailMap);
            }
            columnDetails.put("SUMMARY_TYPE", (String)matrixRow.get("SUMMARY_TYPE"));
            columnDetails.put("MATRIX_TYPE", "simple");
        }
        return columnDetails;
    }

    public static HashMap formHashMap(HashMap columnMap) throws Exception {
        HashMap<String, String> columnDetails = new HashMap<String, String>();
        columnDetails.put("DISPLAY_NAME", (String)columnMap.get("COLUMN_NAME"));
        String dataType = "java.lang.String";
        if ((Integer)columnMap.get("COLUMN_DATA_TYPE") == 1002 && columnMap.get("DATE_FORMAT") == null) {
            dataType = "java.lang.Long";
        }
        columnDetails.put("COLUMN_DATA_TYPE", dataType);
        return columnDetails;
    }

    private static LinkedHashMap<Object, Object> getSimplePivotableViewDetails(ResultSet resultSet, HashMap<String, Object> columnMap) throws Exception {
        LinkedHashMap<Object, Object> pivotDetails = new LinkedHashMap<Object, Object>();
        HashMap map = (HashMap)columnMap.get("LEFT_COL_DETAILS");
        String leftColumn = (String)map.get("COLUMN_NAME");
        map = (HashMap)columnMap.get("TOP_COL_DETAILS");
        String topColumn = (String)map.get("COLUMN_NAME");
        String summaryType = (String)columnMap.get("SUMMARY_TYPE");
        while (resultSet.next()) {
            String leftVal = resultSet.getString(leftColumn);
            String topVal = resultSet.getString(topColumn);
            HashMap details = pivotDetails.get(leftVal) == null ? new HashMap() : (HashMap)pivotDetails.get(leftVal);
            Long value = resultSet.getLong("SUMMARY_VALUE");
            Long oldVal = details.get(topVal) == null ? 0L : (Long)details.get(topVal);
            Long count = firstColMap.get(leftVal) != null ? firstColMap.get(leftVal) + value : value;
            topVal = topVal == null ? "-" : topVal;
            String string = leftVal = leftVal == null ? "-" : leftVal;
            if (summaryType.equalsIgnoreCase("count")) {
                details.put(topVal, oldVal + value);
            } else if (summaryType.equalsIgnoreCase("min")) {
                details.put(topVal, oldVal < value ? oldVal : value);
            } else if (summaryType.equalsIgnoreCase("max")) {
                details.put(topVal, oldVal > value ? oldVal : value);
            }
            if (!columnNameList.contains(topVal)) {
                columnNameList.add(topVal);
            }
            firstColMap.put(leftVal, count);
            pivotDetails.put(leftVal, details);
        }
        return pivotDetails;
    }

    public static String getConstructedSQL(String constructedSQL, HashMap<String, Object> addnSQLPropsMap, HashMap<String, Object> columnDetails, String summaryType, HashMap<String, Object> inputParamsMap) throws Exception {
        constructedSQL = MatrixReportHandler.replaceColumnString(constructedSQL, columnDetails, addnSQLPropsMap, summaryType, inputParamsMap);
        constructedSQL = ADAPSQLQueryAPI.getInstance().setAdditionalSQLOptions(addnSQLPropsMap, constructedSQL, 0);
        constructedSQL = ADAPSQLQueryAPI.getInstance().replaceFunctionPattern(constructedSQL);
        constructedSQL = ADAPSQLQueryAPI.getInstance().objectReplaceString(constructedSQL);
        return constructedSQL;
    }

    private static String replaceColumnString(String constructedSQL, HashMap<String, Object> columnDetails, HashMap addnSQLPropsMap, String summaryType, HashMap inputParamsMap) throws Exception {
        if (columnDetails.get("COLUMN_NAME") != null) {
            addnSQLPropsMap.put("sortColumn", columnDetails.get("COLUMN_NAME"));
            constructedSQL = constructedSQL.replace("${SUMMARY_COLUMNS_FINAL}", (String)columnDetails.get("DISPLAY_NAME")).replace("${SUMMARY_GROUP_BY}", (String)columnDetails.get("DISPLAY_NAME")).replace("${SUMMARY_COLUMNS}", (String)columnDetails.get("DISPLAY_NAME")).replace("${SUMMARY_COLUMNS_FINAL_INNER}", (String)columnDetails.get("DISPLAY_NAME"));
        } else {
            HashMap leftCol = (HashMap)columnDetails.get("LEFT_COL_DETAILS");
            addnSQLPropsMap.put("sortColumn", "SUMMARY_VALUE");
            HashMap topCol = (HashMap)columnDetails.get("TOP_COL_DETAILS");
            HashMap summaryColumn = (HashMap)columnDetails.get("SUMMARY_COL_DETAILS");
            String summaryGroupBy = ReportUtil.queryBuilder(new String[]{MatrixReportHandler.getColumnName(leftCol, true), ",", MatrixReportHandler.getColumnName(topCol, true)});
            String summaryColumnsFinal = ReportUtil.queryBuilder(new String[]{MatrixReportHandler.getColumnName(leftCol, false), ",", MatrixReportHandler.getColumnName(topCol, false), ",", "SUMMARY_VALUE"});
            String summaryColumnsFinalInner = ReportUtil.queryBuilder(new String[]{MatrixReportHandler.getColumnName(leftCol, false), ",", MatrixReportHandler.getColumnName(topCol, false), ",", "SUM(SUMMARY_VALUE) as SUMMARY_VALUE"});
            String summaryColumns = ReportUtil.queryBuilder(new String[]{MatrixReportHandler.getColumnName((HashMap<String, String>)leftCol, inputParamsMap), " , ", MatrixReportHandler.getColumnName((HashMap<String, String>)topCol, inputParamsMap), ",", summaryType.equalsIgnoreCase("count") ? "COUNT(DISTINCT(TIME_GENERATED+RECORD_NUMBER)) AS SUMMARY_VALUE" : ReportUtil.queryBuilder(new String[]{summaryType, "(", (String)summaryColumn.get("COLUMN_NAME"), ") as SUMMARY_VALUE"})});
            constructedSQL = constructedSQL.replace("${SUMMARY_COLUMNS_FINAL}", summaryColumnsFinal).replace("${SUMMARY_GROUP_BY}", summaryGroupBy).replace("${SUMMARY_COLUMNS}", summaryColumns).replace("${SUMMARY_COLUMNS_FINAL_INNER}", summaryColumnsFinalInner);
        }
        return constructedSQL;
    }

    private static String getColumnName(HashMap<String, String> columnDetails, HashMap inputParamsMap) throws Exception {
        if (columnDetails.get("DATE_FORMAT") != null && !"".equalsIgnoreCase(columnDetails.get("DATE_FORMAT"))) {
            Long timeDiff = Long.parseLong((String)inputParamsMap.get("TO")) - Long.parseLong((String)inputParamsMap.get("FROM"));
            if (timeDiff <= 86400L) {
                return "${PATTERNREPLACE:XCOLUMN_HOUR_BASED} as TIME_GENERATED";
            }
            return "${PATTERNREPLACE:XCOLUMN_DAY_BASED} as TIME_GENERATED";
        }
        return MatrixReportHandler.getColumnName(columnDetails, false);
    }

    private static String getColumnName(HashMap columnDetails, boolean isGroupBy) throws Exception {
        String columnName = (String)columnDetails.get("COLUMN_NAME");
        Boolean isTextColumn = (Boolean)columnDetails.get("IS_TEXT_COLUMN");
        if (isTextColumn.booleanValue() && dbName.equalsIgnoreCase("mssql")) {
            columnName = isGroupBy ? "CONVERT(NVARCHAR(MAX), " + columnName + ")" : "CONVERT(NVARCHAR(MAX), " + columnName + ") as " + columnName;
        }
        return columnName;
    }
}

