/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.task;

import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODCDetailsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.util.AlertSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.BackupTableUtil;
import com.adventnet.sym.adsm.common.server.util.CleanUpUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.validation.NonConfiguredDCDetails;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClearAlertsTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the Alert Deleting Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
        try {
            Long scheduleId = taskContext.getScheduleID();
            reportLogger.log(Level.INFO, "Backing up Tables");
            BackupTableUtil.backupData();
            RestoreArchivedEventTable.deleteFromDB();
            reportLogger.log(Level.INFO, "Start to Move hs_err files.....");
            CleanUpUtil.moveHsErrLogFiles();
            reportLogger.log(Level.INFO, "Start to Copy the Pgsql Logs.....");
            CleanUpUtil.copyPgSQLLogFiles();
            LicenseUtil.validateLicense();
            GPODCDetailsAPI.getInstance().setPrefDCPropeties();
            reportLogger.log(Level.INFO, "Clearing Alerts");
            AlertSchedulerUtil.deleteAlerts();
            reportLogger.log(Level.INFO, "Clearing scheduled Reports");
            String stat = ReportSchedulerUtil.delReports(" From Scheduler");
            reportLogger.log(Level.INFO, "Clearing scheduled Reports " + stat);
            DNSResolver.getInstance();
            DNSResolver.clearCache();
            reportLogger.log(Level.INFO, "Going to clean share access info tables");
            FileAuditIpResolverUtil.cleanShareAccessInfoTable();
            ExchangeCallerUserNameUtil.canoNameCache.clear();
            ADAPObjectCacheAPI.getInstance().checkCacheStatus();
            reportLogger.log(Level.INFO, "Going to get product folder size details");
            ArrayList<String> fileList = new ArrayList<String>();
            NonConfiguredDCDetails.getFolderSizeDetails("", fileList);
        }
        catch (Exception ex) {
            reportLogger.log(Level.INFO, "DBG:: Exception while Alert Deleting task..");
            ex.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Completed the Alert Deleting Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "EventUpdateTask";
    }
}

