/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.task;

import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.adventnet.tools.prevalent.ConsoleOut;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventUpdateTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        block3: {
            reportLogger.log(Level.INFO, "Scheduling the Event Updating Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
            try {
                Long scheduleId = taskContext.getScheduleID();
                EventSchedulerUtil.fetchData(scheduleId);
            }
            catch (Exception ex) {
                reportLogger.log(Level.INFO, "DBG:: Exception while Event Update task..");
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OutOfMemoryError)) break block3;
                System.out.println("NativeThread Exception ....");
                System.out.println("JVM will be Restarted due to out of memory from event update task ....");
                ConsoleOut.println((String)"ADAP-OUTOFMEMORY");
            }
        }
        reportLogger.log(Level.INFO, "Completed the Event Updating Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "EventUpdateTask";
    }
}

