/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.task;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerHandler;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportSchedulerTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the Audit Reports Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
        try {
            Long scheduleId = taskContext.getScheduleID();
            DataObject auditObject = taskContext.getAuditInfo();
            Row auditRow = auditObject.getRow("Schedule_Audit");
            Long auditId = (Long)auditRow.get(1);
            ReportSchedulerHandler.runSchedulerReports(scheduleId, auditId);
        }
        catch (Exception ex) {
            reportLogger.log(Level.INFO, "DBG:: Exception while Report Scheduler task..");
            ex.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Completed the Audit Reports Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "ReportSchedulerTask";
    }
}

