/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.template;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.ADAPTemplateMetaHandler;
import com.adventnet.sym.adsm.common.server.sql.DumpFileToDB;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;

public class ComputerTableHandler {
    public static Logger logger = Logger.getLogger("Logger");
    private static ComputerTableHandler computerTableHandler = null;
    public static ArrayList<String> templateTableList = new ArrayList();
    public static HashMap<String, HashMap> computerDetailsMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComputerTableHandler getInstance() {
        if (computerTableHandler != null) return computerTableHandler;
        Class<ComputerTableHandler> clazz = ComputerTableHandler.class;
        synchronized (ComputerTableHandler.class) {
            computerTableHandler = new ComputerTableHandler();
            computerDetailsMap = new HashMap();
            ComputerTableHandler.addTemplateTable();
            ComputerTableHandler.addComputerDetailsInMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return computerTableHandler;
        }
    }

    private static void addTemplateTable() {
        try {
            templateTableList.add("AUDLogonLogoffInfo");
            templateTableList.add("AUDComputerAuditInfo");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createTableInstance(Long computerId, Integer machineType) {
        try {
            if (computerId != null) {
                for (String templateName : templateTableList) {
                    String instanceName = computerId.toString() + "_" + machineType.toString();
                    DataAccess.createTableInstance((String)templateName, (String)instanceName, null);
                    ComputerTableHandler.addRowInMetatable(templateName, instanceName, computerId, machineType);
                    DumpFileToDB.getInstance().updateMetaTableList();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addRowInMetatable(String templateName, String instanceName, Long computerId, Integer machineType) {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("AUDTemplateMetaTable");
            row.set("COMPUTER_ID", (Object)computerId);
            row.set("MACHINE_TYPE", (Object)machineType);
            row.set("TEMPLATE_NAME", (Object)templateName);
            row.set("TABLE_NAME", (Object)(templateName + "_" + instanceName));
            row.set("LOOKUP_TABLENAME", (Object)(templateName + "_" + instanceName));
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getTableName(String templateName, Hashtable<String, Object> eventTbl) {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(templateName);
            if (eventTbl.containsKey("UniqueId") && !eventTbl.get("UniqueId").equals("0")) {
                buff = buff.append("_");
                buff = buff.append(eventTbl.get("UniqueId").toString());
                buff = buff.append("_");
                buff = buff.append(eventTbl.get("MachineType"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public static ArrayList<String> getTemplateTableList(String templateName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDTemplateMetaTable"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDTemplateMetaTable", (String)"TEMPLATE_NAME"), (Object)templateName, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDTemplateMetaTable", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator detailsItr = dataObject.getRows("AUDTemplateMetaTable");
            while (detailsItr.hasNext()) {
                Row row = (Row)detailsItr.next();
                list.add((String)row.get("LOOKUP_TABLENAME"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static Long getComputerId(String instanceName) {
        Long computerId = 0L;
        try {
            ADAPTemplateMetaHandler templateName = new ADAPTemplateMetaHandler();
            String instanceId = templateName.getInstanceId(instanceName);
            int length = instanceId.indexOf("_");
            computerId = new Long(instanceId.substring(1, length - 1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return computerId;
    }

    public static Integer getMachineType(String instanceName) {
        Integer machineType = 0;
        try {
            ADAPTemplateMetaHandler templateName = new ADAPTemplateMetaHandler();
            String instanceId = templateName.getInstanceId(instanceName);
            int indexLen = instanceId.indexOf("_");
            machineType = new Integer(instanceId.substring(indexLen + 1, instanceId.length()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineType;
    }

    public static void addComputerDetailsInMap() {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ADSMDCConfiguration"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("ADSMDCConfiguration");
            while (iterator.hasNext()) {
                Row dcRow = (Row)iterator.next();
                String dcName = dcRow.get("DOMAIN_CONTROLLER_NAME").toString();
                ArrayList<String> domainNameList = new ArrayList<String>();
                domainNameList.add(dcRow.get("DOMAIN_NAME").toString());
                String objectSID = ComputerTableHandler.getObjectSID(dcName, domainNameList);
                if (objectSID == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("MachineType", 1);
                map.put("UniqueId", dcRow.get("DOMAIN_CONTROLLER_ID"));
                computerDetailsMap.put(objectSID.toLowerCase(), map);
            }
            selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDComputerEventRead"));
            Join join = new Join("AUDComputerEventRead", "ADSMComputerGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator2 = dataObject.getRows("ADSMComputerGeneralDetails");
            while (iterator2.hasNext()) {
                Row row = (Row)iterator2.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                Criteria crit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), row.get("OBJECT_GUID"), 0);
                Row eventRow = dataObject.getRow("AUDComputerEventRead", crit);
                map.put("MachineType", eventRow.get("MACHINE_TYPE"));
                map.put("UniqueId", eventRow.get("COMPUTER_ID"));
                computerDetailsMap.put(row.get("SID_STRING").toString().toLowerCase(), map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getObjectSID(String name, ArrayList<String> domainNameList) {
        String objectSID = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ADSMComputerGeneralDetails"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)name, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)name, 0));
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMMON_NAME"), (Object)name, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainNameList.toArray(), 8));
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (dataObject.getTableNames().contains("ADSMComputerGeneralDetails")) {
                Row row = dataObject.getFirstRow("ADSMComputerGeneralDetails");
                objectSID = row.get("SID_STRING").toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objectSID;
    }

    public static HashMap getComputerMap(String objectSID) {
        HashMap map = null;
        try {
            if (computerDetailsMap.get(objectSID) != null) {
                map = computerDetailsMap.get(objectSID);
            } else {
                ComputerTableHandler.addComputerDetailsInMap();
                map = computerDetailsMap.get(objectSID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static ArrayList<String> getTemplateTables(String tableName, HashMap inputParamsMap) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (inputParamsMap.get("objectSIDStr") != null) {
                String[] sidList;
                String objectsSID = inputParamsMap.get("objectSIDStr").toString().toLowerCase();
                for (String objectSID : sidList = objectsSID.split(",")) {
                    HashMap map = ComputerTableHandler.getComputerMap(objectSID = objectSID.replaceAll("'", ""));
                    if (map == null) continue;
                    StringBuffer buff = new StringBuffer();
                    buff.append(tableName);
                    buff.append("_");
                    buff.append(map.get("UniqueId").toString());
                    buff.append("_");
                    buff.append(map.get("MachineType").toString());
                    list.add(buff.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static Row getComputerRow(String name, ArrayList<String> domainNameList) {
        Row row = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ADSMComputerGeneralDetails"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)name, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)name, 0));
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMMON_NAME"), (Object)name, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainNameList.toArray(), 8));
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            row = dataObject.getFirstRow("ADSMComputerGeneralDetails");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }
}

