/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class AccountLockoutTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        StringBuilder columnBuilder = new StringBuilder();
        if (displayName != null) {
            Object workstation = resultSet.getObject("CALLER_MACHINE_NAME");
            Object accountName = resultSet.getObject("ACCOUNT_NAME");
            String timeGenerated = resultSet.getObject("TIME_GENERATED").toString();
            String uniqueId = resultSet.getObject("UNIQUE_ID").toString();
            if (workstation == null) {
                workstation = "-";
            }
            if (accountName == null) {
                accountName = "-";
            }
            if (displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE")) {
                if (!isEmber.booleanValue()) {
                    columnBuilder.append("<span class=\"flLeft paddingRight10\">");
                    columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showExaminer('");
                    columnBuilder.append(accountName.toString());
                    columnBuilder.append("','");
                    columnBuilder.append(workstation.toString());
                    columnBuilder.append("','");
                    columnBuilder.append(timeGenerated);
                    columnBuilder.append("','");
                    columnBuilder.append(uniqueId);
                    columnBuilder.append("','");
                    columnBuilder.append("false");
                    columnBuilder.append("')\">");
                    columnBuilder.append(RB.getString("adap.common.text.details"));
                    columnBuilder.append("</a>");
                    columnBuilder.append("</span>");
                    columnBuilder.append("<img  height=\"16\" border=\"0\" width=\"16\" src=\"images/s_progressbar.gif\" id = \"");
                    columnBuilder.append(timeGenerated + "_details");
                    columnBuilder.append("\" style=\"display:none;\"/>");
                }
                ArrayList<Object> clickInput = new ArrayList<Object>();
                clickInput.add(workstation);
                clickInput.add(accountName);
                clickInput.add(timeGenerated);
                clickInput.add(uniqueId);
                valueMap.put("isLink", true);
                valueMap.put("actionName", "showLockoutAnalyzer");
                valueMap.put("linkInput", clickInput);
                valueMap.put("linkText", RB.getString("adap.common.text.details"));
                valueMap.put("isData", false);
            } else if (displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) {
                if (!isEmber.booleanValue()) {
                    columnBuilder.append("<span class=\"flLeft paddingRight10\">");
                    columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showHistory('");
                    columnBuilder.append(workstation.toString());
                    columnBuilder.append("','");
                    columnBuilder.append(accountName.toString());
                    columnBuilder.append("','");
                    columnBuilder.append(timeGenerated);
                    columnBuilder.append("'");
                    columnBuilder.append(")\">");
                    columnBuilder.append(RB.getString("adap.common.text.history"));
                    columnBuilder.append("</a>");
                    columnBuilder.append("</span>");
                }
                ArrayList<Object> clickInput = new ArrayList<Object>();
                clickInput.add(workstation);
                clickInput.add(accountName);
                clickInput.add(timeGenerated);
                clickInput.add(uniqueId);
                valueMap.put("isLink", true);
                valueMap.put("actionName", "showHistory");
                valueMap.put("linkInput", clickInput);
                valueMap.put("linkText", RB.getString("adap.common.text.history"));
                valueMap.put("isData", false);
            }
        }
        return columnBuilder.toString();
    }
}

