/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.jtds.jdbc.ClobImpl;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdfsClaimTransformer
extends DefaultColumnTransformer {
    protected static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        if (value == null || value.equals("")) {
            return null;
        }
        StringBuilder columnBuilder = new StringBuilder();
        if (displayName != null) {
            valueMap.put("isLink", true);
            if (columnMap.get("DISPLAYNAME").equals("adap.AUDColumnConfiguration.displayname.Issued_Claims")) {
                valueMap.put("actionName", "showClaims");
            } else {
                valueMap.put("actionName", "showCalleridentity");
            }
            valueMap.put("linkText", RB.getString("adap.common.text.details"));
            valueMap.put("isData", false);
            if (value != null) {
                valueMap.put("Value", this.parsetojson(value));
            }
        }
        return columnBuilder.toString();
    }

    private JSONObject parsetojson(Object value) throws Exception {
        String str = null;
        if (value != null && !value.equals("-") && value.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
            ClobImpl val = (ClobImpl)value;
            str = val.getSubString(1L, (int)val.length());
        } else {
            str = value.toString();
        }
        String delims = "[=$]";
        String[] tokens = str.split(delims);
        JSONArray retArray = new JSONArray();
        JSONObject arr = new JSONObject();
        try {
            for (int i = 0; i < tokens.length; ++i) {
                JSONObject jo = new JSONObject();
                jo.put("rowKey", (Object)tokens[i]);
                jo.put("rowValue", (Object)tokens[++i]);
                retArray.put((Object)jo);
            }
            arr.put("Array", (Object)retArray);
        }
        catch (Exception e) {
            REPORT_LOGGER.log(Level.WARNING, "error while parsetojson" + e);
        }
        return arr;
    }
}

