/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformer;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Iterator;

public class ColumnTransformerAPI {
    private static ColumnTransformerAPI transformerAPI = null;
    private static HashMap<Long, ColumnTransformer> columnTransformerMap = null;
    private String[] columnTransformerClasses = new String[]{"GPOSettingsTransformer", "PermissionTransformer", "FimPermissionTransformer", "AccountLockoutTransformer", "CumulativeTransformer", "NavigateTransformer", "MultiRowTransformer", "UserLogonActivityTransformer", "AdfsClaimTransformer"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColumnTransformerAPI getInstance() {
        if (transformerAPI != null) return transformerAPI;
        Class<ColumnTransformerAPI> clazz = ColumnTransformerAPI.class;
        synchronized (ColumnTransformerAPI.class) {
            transformerAPI = new ColumnTransformerAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transformerAPI;
        }
    }

    private ColumnTransformerAPI() {
        this.getColumnTransformers();
    }

    private void getColumnTransformers() {
        columnTransformerMap = new HashMap();
        try {
            String tableName = "AUDColumnConfiguration";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"TRANSFORMER"), null, 1);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"COLUMN_CONF_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"COLUMNALIAS"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"TRANSFORMER"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            for (String className : this.columnTransformerClasses) {
                Criteria classCriteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"TRANSFORMER"), (Object)className, 11);
                ColumnTransformer transformer = null;
                Iterator rowIterator = dataObject.getRows(tableName, classCriteria);
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    String columnTransformer = (String)row.get("TRANSFORMER");
                    if (!columnTransformer.equalsIgnoreCase("com.adventnet.client.components.table.web.DefaultTransformer") && transformer == null) {
                        Class<?> classToInvoke = Class.forName(columnTransformer.trim());
                        transformer = (ColumnTransformer)classToInvoke.newInstance();
                    }
                    columnTransformerMap.put((Long)row.get("COLUMN_CONF_ID"), transformer);
                }
            }
            Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer");
            ColumnTransformer transformer = (ColumnTransformer)classToInvoke.newInstance();
            columnTransformerMap.put(0L, transformer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColumnTransformer getColumnTransformer(Long columnIndex) {
        if (columnTransformerMap.get(columnIndex) != null) {
            return columnTransformerMap.get(columnIndex);
        }
        return columnTransformerMap.get(0L);
    }
}

