/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CumulativeTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        StringBuilder columnBuilder = new StringBuilder();
        if (displayName.equalsIgnoreCase("EVENT_TYPE_STATUS")) {
            String tempStr = value.toString().replace("{", "").replace("}", "");
            StringTokenizer st = new StringTokenizer(tempStr, ",");
            columnBuilder.append("<table style='width:100%;'>");
            while (st.hasMoreTokens()) {
                String object = st.nextToken();
                String[] stValue = object.split(";;");
                if (stValue[0].equalsIgnoreCase(RB.getString("adap.common.text.status_msg.success"))) {
                    columnBuilder.append("<tr><td><span class=\"valueAdded primary-color\">");
                } else if (stValue[0].equalsIgnoreCase(RB.getString("adap.DefaultCategoryListener.Failure"))) {
                    columnBuilder.append("<tr><td><span class=\"valueRemoved text-danger\">");
                }
                columnBuilder.append(stValue[0]);
                columnBuilder.append(" : ");
                columnBuilder.append(stValue[1]);
                columnBuilder.append("</span></td></tr>");
            }
            columnBuilder.append("</table>");
        } else if (displayName.equalsIgnoreCase("OPERATION")) {
            if (value.toString().equalsIgnoreCase(RB.getString("adap.AUDSQLQuery.sql_string.Settings_Added"))) {
                columnBuilder.append("<span class=\"valueAdded\">");
            } else if (value.toString().equalsIgnoreCase(RB.getString("adap.AUDSQLQuery.sql_string.Settings_Deleted"))) {
                columnBuilder.append("<span class=\"valueRemoved\">");
            } else if (value.toString().equalsIgnoreCase(RB.getString("adap.AUDSQLQuery.sql_string.Settings_Modified"))) {
                columnBuilder.append("<span class=\"valueModified\">");
            }
            columnBuilder.append(value.toString());
            columnBuilder.append("</span>");
        } else if (displayName.equalsIgnoreCase("ACCOUNT_NAME")) {
            String accountName = resultSet.getObject(displayName).toString();
            if (!isEmber.booleanValue()) {
                columnBuilder.append("&nbsp;<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showDetails.getObjectDetails('");
                columnBuilder.append(resultSet.getObject("ACCOUNT_SID").toString());
                columnBuilder.append("', '");
                columnBuilder.append(accountName);
                columnBuilder.append("')\">");
                columnBuilder.append(accountName);
                columnBuilder.append("</a>");
            }
            ArrayList<String> clickInput = new ArrayList<String>();
            clickInput.add(resultSet.getObject("ACCOUNT_SID").toString());
            clickInput.add(accountName);
            valueMap.put("isLink", true);
            valueMap.put("actionName", "getObjectDetails");
            valueMap.put("linkInput", clickInput);
            valueMap.put("linkText", accountName);
            valueMap.put("isData", false);
            valueMap.put("notShowColumnValue", true);
        } else if (displayName.equalsIgnoreCase("FILE_NAME")) {
            String accountName = resultSet.getString(displayName);
            if (!isEmber.booleanValue()) {
                columnBuilder.append("&nbsp;<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:getFileDetails('");
                columnBuilder.append(EscapeUtil.escSplCharsAsJS(resultSet.getString("FORMAT_MESSAGE")));
                columnBuilder.append("')\">");
                columnBuilder.append(accountName);
                columnBuilder.append("</a>");
            }
            ArrayList<String> clickInput = new ArrayList<String>();
            clickInput.add(resultSet.getString("FORMAT_MESSAGE").toString());
            clickInput.add(accountName);
            clickInput.add(EscapeUtil.escSplCharsAsJS(resultSet.getString("FORMAT_MESSAGE")));
            valueMap.put("isLink", true);
            valueMap.put("actionName", "getFileDetails");
            valueMap.put("linkInput", clickInput);
            valueMap.put("linkText", accountName);
            valueMap.put("isData", false);
            valueMap.put("notShowColumnValue", true);
        }
        return columnBuilder.toString();
    }
}

