/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformer;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class DefaultColumnTransformer
implements ColumnTransformer {
    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String dateFormat = (String)columnMap.get("DATE_FORMAT");
        String displayName = (String)columnMap.get("COLUMNALIAS");
        String timeZoneId = (String)columnMap.get("timeZoneId");
        Object value = resultSet.getObject(displayName);
        if (dateFormat == null && value != null && value.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
            ClobImpl val = (ClobImpl)resultSet.getObject(displayName);
            value = val.getSubString(1L, (int)val.length());
        } else if (dateFormat != null) {
            Long time = (Long)value;
            value = time > 0L ? TimeUtil.formatDate(time * 1000L, dateFormat, timeZoneId) : "-";
        }
        return value;
    }

    public boolean isColumnPresent(String columnAlias, ArrayList columnList) {
        boolean isColumnPresent = false;
        for (Object object : columnList) {
            HashMap columnMap = (HashMap)object;
            if (!columnMap.get("COLUMNALIAS").toString().equalsIgnoreCase(columnAlias)) continue;
            isColumnPresent = true;
        }
        return isColumnPresent;
    }
}

