/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class FimPermissionTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        String attributeText = null;
        String correlationStr = null;
        String uniqueId = "#";
        StringBuilder columnBuilder = new StringBuilder();
        Long action = 0L;
        if (value == null) {
            value = "-";
        }
        if (value != null && !value.equals("-") && value.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
            ClobImpl val = (ClobImpl)resultSet.getObject(displayName);
            value = val.getSubString(1L, (int)val.length());
        }
        if (!value.equals("-") && !value.equals("") && displayName != null) {
            if (displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) {
                attributeText = (String)resultSet.getObject("ATTRIBUTES_TEXT");
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    action = 0L;
                    value = RB.getString("adap.common.text.old_acl");
                    correlationStr = (String)resultSet.getObject("CORRELATION_ID");
                }
            } else if (displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE")) {
                attributeText = (String)resultSet.getObject("ATTRIBUTES_TEXT");
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    action = 1L;
                    value = RB.getString("adap.common.text.new_acl");
                    correlationStr = (String)resultSet.getObject("CORRELATION_ID");
                }
            } else if (displayName.equalsIgnoreCase("REMARKS")) {
                attributeText = (String)resultSet.getObject("ATTRIBUTES_TEXT");
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    correlationStr = (String)resultSet.getObject("CORRELATION_ID");
                }
            } else if (displayName.equalsIgnoreCase("ACL_CHANGE")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                if (value != null && value.equals("")) {
                    value = "-";
                }
            } else if (displayName.equalsIgnoreCase("NEW_SEC_DESC")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                action = 1L;
                value = RB.getString("adap.common.text.new_acl");
            } else if (displayName.equalsIgnoreCase("ORIGINAL_SEC_DESC")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                action = 0L;
                value = RB.getString("adap.common.text.old_acl");
            }
        }
        value = FimPermissionTransformer.htmlEscape(value.toString());
        columnBuilder.append(value + " ");
        if (displayName != null && attributeText != null) {
            if ((displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE") || displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showOldNewValue('");
                columnBuilder.append(correlationStr);
                columnBuilder.append("','");
                columnBuilder.append(action);
                columnBuilder.append("','");
                columnBuilder.append(attributeText);
                columnBuilder.append("','object'");
                columnBuilder.append(")\">");
                columnBuilder.append(RB.getString("adap.common.text.more"));
                columnBuilder.append("</a>");
            } else if (displayName.equalsIgnoreCase("REMARKS") && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor")) && !value.equals("User Modified") && !value.toString().equalsIgnoreCase(RB.getString("adap.ObjectAccessListener.no_changes_on_sd"))) {
                columnBuilder.append("<a class =\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showPermissions('");
                columnBuilder.append(correlationStr);
                columnBuilder.append("','userAttribute'");
                columnBuilder.append(")\">");
                columnBuilder.append(RB.getString("adap.common.text.more"));
                columnBuilder.append("</a>");
            }
        } else if (!(displayName == null || !displayName.equalsIgnoreCase("ACL_CHANGE") || value.equals("-") || value.toString().equalsIgnoreCase(RB.getString("adap.ObjectAccessListener.no_changes_on_sd")) || value.equals("") || value.toString().toLowerCase().startsWith("owner"))) {
            columnBuilder.append("<a class =\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showPermissions('");
            columnBuilder.append(uniqueId);
            columnBuilder.append("','serverAudit'");
            columnBuilder.append(")\">");
            columnBuilder.append(RB.getString("adap.common.text.more"));
            columnBuilder.append("</a>");
        } else if (displayName != null && !value.equals("-") && (displayName.equalsIgnoreCase("ORIGINAL_SEC_DESC") || displayName.equalsIgnoreCase("NEW_SEC_DESC"))) {
            columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showOldNewValue('");
            columnBuilder.append(uniqueId);
            columnBuilder.append("','");
            columnBuilder.append(action);
            columnBuilder.append("','");
            columnBuilder.append(attributeText);
            columnBuilder.append("', 'fimFolder'");
            columnBuilder.append(")\">");
            columnBuilder.append(RB.getString("adap.common.text.more"));
            columnBuilder.append("</a>");
        }
        return columnBuilder.toString();
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\""};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }
}

