/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class GPOSettingsTransformer
extends DefaultColumnTransformer {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        int i = resultSet.getRow() - 1;
        StringBuilder columnBuilder = new StringBuilder();
        if (displayName.equalsIgnoreCase("SUMMARY")) {
            ArrayList<Object> clickInput = new ArrayList<Object>();
            columnBuilder.append("<table width=\"100%\">");
            String[] summaryStrings = value.toString().split(",");
            int length = summaryStrings.length;
            for (int h = 0; h < length; ++h) {
                String summaryRowClass = "smallRowtable2";
                String summaryCellClass = "valueAdded primary-color";
                if (h % 2 == 0) {
                    summaryRowClass = "smallRowtable1";
                }
                if (h == 1) {
                    summaryCellClass = "valueRemoved text-danger";
                } else if (h == 2) {
                    summaryCellClass = "valueModified";
                }
                columnBuilder.append("<tr>");
                columnBuilder.append("<td> <span class=\"");
                columnBuilder.append(summaryCellClass);
                columnBuilder.append("\">");
                columnBuilder.append(summaryStrings[h]);
                columnBuilder.append("</span>");
                if (h + 1 == length) {
                    boolean isChangeId = false;
                    isChangeId = this.isColumnPresent("CHANGE_ID", columnsList);
                    String uniqueId = "#";
                    if (isChangeId) {
                        Object changeIdObject = resultSet.getObject("CHANGE_ID");
                        if (changeIdObject.getClass().isArray()) {
                            byte[] changeIdBytes = (byte[])changeIdObject;
                            uniqueId = new String(changeIdBytes);
                        } else if (changeIdObject.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
                            ClobImpl clobObj = (ClobImpl)changeIdObject;
                            uniqueId = clobObj.getSubString(1L, (int)clobObj.length());
                        } else {
                            uniqueId = changeIdObject.toString();
                        }
                    } else {
                        uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                    }
                    clickInput.add(uniqueId);
                    clickInput.add(isChangeId);
                    if (!isEmber.booleanValue()) {
                        columnBuilder.append("<div align=\"right\"> <a id=\"");
                        columnBuilder.append(i);
                        columnBuilder.append("_");
                        columnBuilder.append(uniqueId);
                        columnBuilder.append("_");
                        columnBuilder.append(isChangeId);
                        columnBuilder.append("_ANCHOR");
                        columnBuilder.append("\" name=\"GPO_DETAILS_ANCHOR\" href=\"#\" ");
                        columnBuilder.append("onclick=\"javascript:showGPOSettings('");
                        columnBuilder.append(uniqueId);
                        columnBuilder.append("', '");
                        columnBuilder.append(i);
                        columnBuilder.append("', '");
                        columnBuilder.append(isChangeId);
                        columnBuilder.append("')\" ");
                        columnBuilder.append("class=\"greenlinktxtbold\">");
                        columnBuilder.append("<img id=\"");
                        columnBuilder.append(i);
                        columnBuilder.append("_");
                        columnBuilder.append(uniqueId);
                        columnBuilder.append("_");
                        columnBuilder.append(isChangeId);
                        columnBuilder.append("_IMG");
                        columnBuilder.append("\" src=\"images/down-arrow.gif\" border=\"0\" width=\"10\" height=\"10\" />");
                        columnBuilder.append("<span style=\"padding-left:5px;\" id=\"");
                        columnBuilder.append(i);
                        columnBuilder.append("_");
                        columnBuilder.append(uniqueId);
                        columnBuilder.append("_");
                        columnBuilder.append(isChangeId);
                        columnBuilder.append("_SPAN\" >");
                        columnBuilder.append(rb.getString("adap.GPOSettingsTransformer.Show_details"));
                        columnBuilder.append("</span>");
                        columnBuilder.append("</a>");
                        columnBuilder.append("<div>");
                    }
                }
                columnBuilder.append("</td>");
                columnBuilder.append("</tr>");
            }
            columnBuilder.append("</table>");
            valueMap.put("isLink", true);
            valueMap.put("actionName", "showGPOChanges");
            valueMap.put("linkInput", clickInput);
            valueMap.put("linkText", "Show Details");
            valueMap.put("isData", false);
        } else if (displayName != null && displayName.equalsIgnoreCase("OBJECT_GUID")) {
            String gpoName = "-";
            String gpoGUID = "-";
            if (resultSet.getObject(displayName) != null) {
                gpoGUID = resultSet.getObject(displayName).toString();
                gpoName = GPODetailsAPI.getInstance().getGPOName(gpoGUID.toLowerCase());
            }
            if (!isEmber.booleanValue()) {
                columnBuilder.append("&nbsp;<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showHtmlPage('");
                columnBuilder.append(gpoGUID);
                columnBuilder.append("')\">");
                columnBuilder.append(gpoName);
                columnBuilder.append("</a>");
            }
            ArrayList<String> clickInput = new ArrayList<String>();
            clickInput.add(gpoGUID);
            clickInput.add(gpoName);
            valueMap.put("isLink", true);
            valueMap.put("actionName", "showGPOHtmlPage");
            valueMap.put("linkInput", clickInput);
            valueMap.put("linkText", gpoName);
            valueMap.put("isData", false);
        }
        return columnBuilder.toString();
    }
}

