/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class MultiRowTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        if (displayName.equalsIgnoreCase("USERNAME") || displayName.equalsIgnoreCase("COUNT")) {
            StringBuilder columnBuilder = new StringBuilder();
            columnBuilder.append("<span class = \"blacktxtbold\">");
            columnBuilder.append(value.toString());
            columnBuilder.append("</span>");
            return columnBuilder.toString();
        }
        HashMap inputParams = (HashMap)columnMap.get("INPUT_PARAMS");
        inputParams.put("USER_SID", value.toString());
        Long cvId = (Long)columnMap.get("SUBREPORT_CV_ID");
        ArrayList reportsList = AuditReportAPI.getInstance().getReportRows(cvId, null, inputParams, "TIME_GENERATED", "desc", 0, 0, null, 0, false);
        return reportsList;
    }

    public static Long getSubReportCvId(ArrayList<HashMap<String, Object>> columnList) {
        Long subreportCvId = 0L;
        try {
            for (HashMap<String, Object> map : columnList) {
                if (map.get("SUBREPORT_CV_ID") == null && map.get("subreport_cv_id") == null) continue;
                subreportCvId = map.get("SUBREPORT_CV_ID") != null ? (Long)map.get("SUBREPORT_CV_ID") : (Long)map.get("subreport_cv_id");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return subreportCvId;
    }
}

