/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class NavigateTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static HashMap<Long, HashMap> navigateReportMap = new HashMap();
    private static String finalnavigatorTableName = "AUDNavigationReports";

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Long columnConfId = (Long)columnMap.get("COLUMN_CONF_ID");
        StringBuilder columnBuilder = new StringBuilder();
        try {
            HashMap idDetailsMap = navigateReportMap.get(columnConfId);
            if (displayName.equals("PRINTER_NAME")) {
                String accountName = resultSet.getObject(displayName).toString();
                columnBuilder.append("&nbsp;<a class=\"greenlinktxt\" href=\"javascript:void(0)\" title=\" click to See " + accountName + " based reports\" onclick=\"javascript:navigateReports('");
                columnBuilder.append(accountName.replace("\\", "\\\\"));
                columnBuilder.append("', '");
                columnBuilder.append(idDetailsMap.get("finalReportId").toString());
                columnBuilder.append("', '");
                columnBuilder.append(idDetailsMap.get("objectClass"));
                columnBuilder.append("', '");
                columnBuilder.append(idDetailsMap.get("selectedTab"));
                columnBuilder.append("')\">");
                columnBuilder.append(accountName);
                columnBuilder.append("</a>");
            } else if (displayName.equals("COUNT")) {
                String count = resultSet.getObject(displayName).toString();
                ArrayList<Object> clickInput = new ArrayList<Object>();
                if (!isEmber.booleanValue()) {
                    columnBuilder.append("&nbsp;<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:getLogonDetails('");
                    columnBuilder.append(idDetailsMap.get("finalReportId").toString());
                    columnBuilder.append("', '");
                    columnBuilder.append(this.getSearchString(resultSet, idDetailsMap));
                    columnBuilder.append("')\">");
                    columnBuilder.append(count);
                    columnBuilder.append("</a>");
                } else {
                    JSONObject searchData = this.getSearchStringEmber(resultSet, idDetailsMap);
                    clickInput.add(searchData);
                }
                clickInput.add(idDetailsMap.get("finalReportId").toString());
                clickInput.add(count);
                valueMap.remove("isData");
                valueMap.put("isLink", true);
                valueMap.put("actionName", "navigateToReport");
                valueMap.put("linkInput", clickInput);
                valueMap.put("linkText", count);
            } else if (displayName.equals("TOTAL_COUNT") || displayName.equals("TOTAL_SUCCESS_COUNT") || displayName.equals("TOTAL_FAILURE_COUNT") || displayName.equals("FILE_READ_SUCCESS_COUNT") || displayName.equals("FILE_READ_FAILURE_COUNT") || displayName.equals("FILE_FOLDER_MODIFIED_COUNT") || displayName.equals("FILE_FOLDER_CREATED_COUNT") || displayName.equals("FILE_FOLDER_MODIFIED_FAILED_COUNT") || displayName.equals("FILE_FOLDER_MOVED_COUNT") || displayName.equals("FILE_FOLDER_RENAMED_COUNT") || displayName.equals("FILE_OR_FOLDER_COPY_PASTE_COUNT") || displayName.equals("SACL_CHANGED_COUNT") || displayName.equals("FILE_PERMISSION_CHANGED_COUNT") || displayName.equals("FILE_DELETED_COUNT") || displayName.equals("FILE_DELETE_DENIED_COUNT")) {
                String count = resultSet.getObject(displayName).toString();
                if (!isEmber.booleanValue()) {
                    columnBuilder.append(count);
                } else {
                    String searchCriteria;
                    String searchKey1 = ((HashMap)columnsList.get(0)).get("COLUMNALIAS").toString();
                    String searchValue1 = "-";
                    if (resultSet.getObject(searchKey1) != null) {
                        searchValue1 = resultSet.getObject(searchKey1).toString();
                        searchCriteria = searchKey1 + "='" + EscapeUtil.escSplCharsAsSQL(searchValue1) + "'";
                    } else {
                        searchCriteria = searchKey1 + " IS NULL";
                    }
                    JSONObject searchObj = new JSONObject("{\"TOTAL_COUNT\":\"1=1\",\"TOTAL_SUCCESS_COUNT\":\"EVENT_TYPE=8\",\"TOTAL_FAILURE_COUNT\":\"EVENT_TYPE=16\",\"FILE_READ_SUCCESS_COUNT\":\"ACCESS_TYPE=1 AND EVENT_TYPE=8\",\"FILE_READ_FAILURE_COUNT\":\"ACCESS_TYPE=1 AND EVENT_TYPE=16\",\"FILE_FOLDER_MODIFIED_COUNT\":\"ACCESS_TYPE=2 AND EVENT_TYPE=8\",\"FILE_FOLDER_CREATED_COUNT\":\"ACCESS_TYPE=5 AND EVENT_TYPE=8\",\"FILE_FOLDER_MODIFIED_FAILED_COUNT\":\"ACCESS_TYPE=2 AND EVENT_TYPE=16\",\"FILE_FOLDER_MOVED_COUNT\":\"ACCESS_TYPE=6 AND EVENT_TYPE=8\",\"FILE_FOLDER_RENAMED_COUNT\":\"ACCESS_TYPE=14 AND EVENT_TYPE=8\",\"FILE_OR_FOLDER_COPY_PASTE_COUNT\":\"ACCESS_TYPE=7 AND EVENT_TYPE=8\",\"SACL_CHANGED_COUNT\":\"ACCESS_TYPE=4 AND EVENT_TYPE=8\",\"FILE_PERMISSION_CHANGED_COUNT\":\"ACCESS_TYPE=3 AND EVENT_TYPE=8\",\"FILE_DELETED_COUNT\":\"ACCESS_TYPE=10 AND EVENT_TYPE=8\",\"FILE_DELETE_DENIED_COUNT\":\"ACCESS_TYPE=10 AND EVENT_TYPE=16\"}");
                    ArrayList<String> clickInput = new ArrayList<String>();
                    valueMap.put("fileSummaryCriteria", searchCriteria + " AND " + searchObj.getString((String)columnMap.get("COLUMNALIAS")));
                    String objectClass = columnMap.get("objectClass").toString();
                    if (objectClass.equalsIgnoreCase("user") || objectClass.equalsIgnoreCase("group") || objectClass.equalsIgnoreCase("organizationalUnit")) {
                        clickInput.add("11111");
                        clickInput.add("11101");
                    } else if (objectClass.equalsIgnoreCase("computer")) {
                        clickInput.add("11112");
                        clickInput.add("11102");
                    } else if (objectClass.equalsIgnoreCase("share")) {
                        clickInput.add("11113");
                        clickInput.add("11103");
                    } else {
                        clickInput.add("11110");
                        clickInput.add("11100");
                    }
                    valueMap.remove("isData");
                    valueMap.put("isLink", true);
                    valueMap.put("actionName", "openDrillDownReport");
                    valueMap.put("linkInput", clickInput);
                    valueMap.put("linkText", count);
                    if (searchValue1.length() > 17) {
                        searchValue1 = searchValue1.substring(0, 16) + "..";
                    }
                    valueMap.put("tabName", RB.getString((String)columnMap.get("DISPLAYNAME")) + " :: " + searchValue1 + " :: ");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return columnBuilder.toString();
    }

    private String getSearchString(ResultSet resultSet, HashMap idDetailsMap) {
        String searchString = "";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ArrayList list = (ArrayList)idDetailsMap.get("inputs");
            for (int size = 0; size < list.size(); ++size) {
                HashMap inputMap = (HashMap)list.get(size);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append("search_");
                stringBuilder.append(inputMap.get("columnConfId"));
                stringBuilder.append("=");
                stringBuilder.append(inputMap.get("criteriaColValue") == null ? (resultSet.getObject((String)inputMap.get("columnAlias")) == null ? "-" : resultSet.getObject((String)inputMap.get("columnAlias")).toString()) : inputMap.get("criteriaColValue").toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private JSONObject getSearchStringEmber(ResultSet resultSet, HashMap idDetailsMap) throws Exception {
        JSONObject searchData = new JSONObject();
        try {
            ArrayList list = (ArrayList)idDetailsMap.get("inputs");
            for (int size = 0; size < list.size(); ++size) {
                String searchValue;
                HashMap inputMap = (HashMap)list.get(size);
                String string = inputMap.get("criteriaColValue") == null ? (resultSet.getObject((String)inputMap.get("columnAlias")) == null ? "-" : resultSet.getObject((String)inputMap.get("columnAlias")).toString()) : (searchValue = inputMap.get("criteriaColValue").toString());
                if (searchValue == null || searchValue == "-") continue;
                searchData.put((String)inputMap.get("columnAlias"), (Object)searchValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchData;
    }

    public static void updateHashMap() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)finalnavigatorTableName));
            Join leftJoin = new Join(Table.getTable((String)finalnavigatorTableName), Table.getTable((String)"AUDNavigationReportInputs"), new String[]{"NAVIGATOR_ID"}, new String[]{"NAVIGATOR_ID"}, 1);
            query.addJoin(leftJoin);
            Criteria criteria = new Criteria(Column.getColumn((String)finalnavigatorTableName, (String)"NAVIGATOR_ID"), null, 1);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDNavigationReports", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDNavigationReportInputs", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(finalnavigatorTableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long columnConfId = DBObjectUtil.getUVHValues("AUDColumnConfiguration", (String)row.get("COLUMNCONF_ID"));
                HashMap<String, Object> idDetailsMap = new HashMap<String, Object>();
                idDetailsMap.put("finalReportId", (Long)row.get("FINAL_REPORT_ID"));
                idDetailsMap.put("objectClass", (String)row.get("OBJECT_CLASS"));
                idDetailsMap.put("selectedTab", NavigateTransformer.getReportTabName((Long)row.get("TAB_ID")));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDNavigationReportInputs", (String)"NAVIGATOR_ID"), (Object)((Long)row.get("NAVIGATOR_ID")), 0);
                ArrayList list = new ArrayList();
                Iterator iter = dataObject.getRows("AUDNavigationReportInputs", crit);
                while (iter.hasNext()) {
                    Row inputRow = (Row)iter.next();
                    HashMap<String, String> inputMap = new HashMap<String, String>();
                    inputMap.put("columnConfId", DBObjectUtil.getUVHValues("AUDColumnConfiguration", (String)inputRow.get("CRITERIA_COL_CONF_ID")).toString());
                    inputMap.put("columnAlias", (String)inputRow.get("CRITERIA_COLUMN_ALIAS"));
                    inputMap.put("criteriaColValue", (String)inputRow.get("CRITERIA_COLUMN_VALUE"));
                    list.add(inputMap);
                }
                idDetailsMap.put("inputs", list);
                navigateReportMap.put(columnConfId, idDetailsMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getDisplayName(Long columnId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"), (Object)columnId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDColumnConfiguration", criteria);
            Row row = dataObject.getFirstRow("AUDColumnConfiguration");
            return row != null ? RB.getString((String)row.get("COLUMNALIAS")) : "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getReportTabName(Long reportTabId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADAPTotalTabs", (String)"TAB_ID"), (Object)reportTabId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADAPTotalTabs", criteria);
            Row row = dataObject.getFirstRow("ADAPTotalTabs");
            return row != null ? (String)row.get("TAB_NAME") : "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    static {
        NavigateTransformer.updateHashMap();
    }
}

