/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class PermissionTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        String attributeText = null;
        String correlationStr = null;
        String uniqueId = "#";
        StringBuilder columnBuilder = new StringBuilder();
        Long action = 0L;
        if (value == null) {
            value = "-";
        }
        if (value != null && !value.equals("-") && value.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
            ClobImpl val = (ClobImpl)resultSet.getObject(displayName);
            value = val.getSubString(1L, (int)val.length());
        }
        if (!value.equals("-") && !value.equals("") && displayName != null) {
            if (displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) {
                String string = attributeText = resultSet.getObject("ATTRIBUTES_TEXT") != null ? resultSet.getString("ATTRIBUTES_TEXT") : null;
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    action = 0L;
                    value = RB.getString("adap.common.text.old_acl");
                    correlationStr = resultSet.getObject("CORRELATION_ID").toString();
                }
            } else if (displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE")) {
                String string = attributeText = resultSet.getObject("ATTRIBUTES_TEXT") != null ? resultSet.getString("ATTRIBUTES_TEXT") : null;
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    action = 1L;
                    value = RB.getString("adap.common.text.new_acl");
                    correlationStr = resultSet.getObject("CORRELATION_ID").toString();
                }
            } else if (displayName.equalsIgnoreCase("REMARKS")) {
                String string = attributeText = resultSet.getObject("ATTRIBUTES_TEXT") != null ? resultSet.getString("ATTRIBUTES_TEXT") : null;
                if (attributeText != null && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                    correlationStr = resultSet.getObject("CORRELATION_ID").toString();
                }
            } else if (displayName.equalsIgnoreCase("ACL_CHANGE")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                if (value != null && value.equals("")) {
                    value = "-";
                }
            } else if (displayName.equalsIgnoreCase("NEW_SEC_DESC")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                action = 1L;
                value = RB.getString("adap.common.text.new_acl");
            } else if (displayName.equalsIgnoreCase("ORIGINAL_SEC_DESC")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                action = 0L;
                value = RB.getString("adap.common.text.old_acl");
            }
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!metaData.getColumnName(i).equalsIgnoreCase("ATTRIBUTES_TEXT")) continue;
            if (resultSet.getObject("ATTRIBUTES_TEXT") == null || !resultSet.getObject("ATTRIBUTES_TEXT").toString().equalsIgnoreCase("User-Parameters")) break;
            attributeText = resultSet.getObject("ATTRIBUTES_TEXT").toString();
            if (displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE")) {
                uniqueId = resultSet.getObject("UNIQUE_ID").toString();
                action = 1L;
                break;
            }
            if (!displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) break;
            uniqueId = resultSet.getObject("UNIQUE_ID").toString();
            break;
        }
        value = PermissionTransformer.htmlEscape(value.toString());
        columnBuilder.append(value + " ");
        if (displayName != null && attributeText != null) {
            if ((displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE") || displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE")) && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor"))) {
                if (!isEmber.booleanValue()) {
                    columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showOldNewValue('");
                    columnBuilder.append(correlationStr);
                    columnBuilder.append("','");
                    columnBuilder.append(action);
                    columnBuilder.append("','");
                    columnBuilder.append(attributeText);
                    columnBuilder.append("','object'");
                    columnBuilder.append(")\">");
                    columnBuilder.append(RB.getString("adap.common.text.more"));
                    columnBuilder.append("</a>");
                }
                ArrayList<Object> clickInput = new ArrayList<Object>();
                clickInput.add(correlationStr);
                clickInput.add(action);
                clickInput.add(attributeText);
                clickInput.add("object");
                valueMap.put("isLink", true);
                valueMap.put("actionName", "showOldOrNewPermission");
                valueMap.put("linkInput", clickInput);
                valueMap.put("isData", false);
                valueMap.put("linkText", "More");
            } else if (displayName.equalsIgnoreCase("REMARKS") && (attributeText.equalsIgnoreCase("NT-Security-Descriptor") || attributeText.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor")) && !value.equals("User Modified") && !value.toString().equalsIgnoreCase(RB.getString("adap.ObjectAccessListener.no_changes_on_sd"))) {
                if (!isEmber.booleanValue()) {
                    columnBuilder.append("<a class =\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showPermissions('");
                    columnBuilder.append(correlationStr);
                    columnBuilder.append("','userAttribute'");
                    columnBuilder.append(")\">");
                    columnBuilder.append(RB.getString("adap.common.text.more"));
                    columnBuilder.append("</a>");
                }
                ArrayList<String> clickInput = new ArrayList<String>();
                clickInput.add(correlationStr);
                clickInput.add("userAttribute");
                valueMap.put("isLink", true);
                valueMap.put("actionName", "showPermissions");
                valueMap.put("linkInput", clickInput);
                valueMap.put("isData", false);
                valueMap.put("linkText", "More");
            } else if (attributeText.equalsIgnoreCase("User-Parameters") && (displayName.equalsIgnoreCase("ATTRIBUTES_NEW_VALUE") || displayName.equalsIgnoreCase("ATTRIBUTES_OLD_VALUE"))) {
                columnBuilder = new StringBuilder();
                columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showUserTsValue('");
                columnBuilder.append(uniqueId);
                columnBuilder.append("','");
                columnBuilder.append(action);
                columnBuilder.append("')\">");
                columnBuilder.append(RB.getString("adap.common.text.details"));
                columnBuilder.append("</a>");
                ArrayList<Object> clickInput = new ArrayList<Object>();
                clickInput.add(uniqueId);
                clickInput.add(action);
                valueMap.put("isLink", true);
                valueMap.put("actionName", "showUserTsValue");
                valueMap.put("linkInput", clickInput);
                valueMap.put("isData", false);
                valueMap.put("linkText", "Details");
            }
        } else if (!(displayName == null || !displayName.equalsIgnoreCase("ACL_CHANGE") || value.equals("-") || value.toString().equalsIgnoreCase(RB.getString("adap.ObjectAccessListener.no_changes_on_sd")) || value.equals("") || value.toString().toLowerCase().startsWith("owner"))) {
            if (!isEmber.booleanValue()) {
                columnBuilder.append("<a class =\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showPermissions('");
                columnBuilder.append(uniqueId);
                columnBuilder.append("','fileAudit'");
                columnBuilder.append(")\">");
                columnBuilder.append(RB.getString("adap.common.text.more"));
                columnBuilder.append("</a>");
            }
            ArrayList<String> clickInput = new ArrayList<String>();
            clickInput.add(uniqueId);
            clickInput.add("fileAudit");
            valueMap.put("isLink", true);
            valueMap.put("actionName", "showPermissions");
            valueMap.put("linkInput", clickInput);
            valueMap.put("isData", false);
            valueMap.put("linkText", "More");
        } else if (displayName != null && !value.equals("-") && !value.equals("") && (displayName.equalsIgnoreCase("ORIGINAL_SEC_DESC") || displayName.equalsIgnoreCase("NEW_SEC_DESC"))) {
            if (!isEmber.booleanValue()) {
                columnBuilder.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showOldNewValue('");
                columnBuilder.append(uniqueId);
                columnBuilder.append("','");
                columnBuilder.append(action);
                columnBuilder.append("','");
                columnBuilder.append(attributeText);
                columnBuilder.append("', 'folder'");
                columnBuilder.append(")\">");
                columnBuilder.append(RB.getString("adap.common.text.more"));
                columnBuilder.append("</a>");
            }
            ArrayList<Object> clickInput = new ArrayList<Object>();
            clickInput.add(uniqueId);
            clickInput.add(action);
            clickInput.add(attributeText);
            clickInput.add("folder");
            valueMap.put("isLink", true);
            valueMap.put("actionName", "showOldOrNewPermission");
            valueMap.put("linkInput", clickInput);
            valueMap.put("isData", false);
            valueMap.put("linkText", "More");
        }
        return columnBuilder.toString();
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\""};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }
}

