/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.transformers;

import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.transformers.DefaultColumnTransformer;
import com.adventnet.sym.adsm.auditing.server.useractivity.UserActivityUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class UserLogonActivityTransformer
extends DefaultColumnTransformer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    String dateFormat = "MMM dd,yyyy hh:mm:ss a";
    HashMap<Integer, ArrayList<HashMap>> correlateMap = new HashMap();
    ArrayList<HashMap> durationList = null;
    public static HashMap inputParams = null;

    @Override
    public Object transformColumn(HashMap columnMap, ResultSet resultSet, ArrayList columnsList, String exportType, HashMap valueMap, Boolean isEmber) throws Exception {
        String displayName = (String)columnMap.get("COLUMNALIAS");
        Object value = resultSet.getObject(displayName);
        if (displayName.equalsIgnoreCase("USERNAME") || displayName.equalsIgnoreCase("SOURCE")) {
            StringBuilder columnBuilder = new StringBuilder();
            columnBuilder.append(value.toString());
            return columnBuilder.toString();
        }
        String source = resultSet.getString("SOURCE");
        String userName = resultSet.getString("USERNAME");
        inputParams = (HashMap)columnMap.get("INPUT_PARAMS");
        HashMap paramsMap = UserActivityUtil.getInstance().getInputParams(inputParams, source);
        paramsMap.put("USERNAMETEMP", resultSet.getString("USERNAME"));
        Long cvId = (Long)columnMap.get("SUBREPORT_CV_ID");
        return this.getIdleActiveTime(source, userName, paramsMap);
    }

    public ArrayList<ArrayList<HashMap>> getReportList(String source, HashMap paramsMap) {
        ArrayList<ArrayList<HashMap>> reportList = new ArrayList<ArrayList<HashMap>>();
        try {
            ArrayList<Long> cvIdList = new ArrayList<Long>();
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15053"));
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15054"));
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15055"));
            for (Long cvId : cvIdList) {
                ArrayList<ArrayList<HashMap>> rowsList;
                if (paramsMap.containsKey("CV_ID")) {
                    paramsMap.remove("CV_ID");
                }
                if ((rowsList = this.getRowList(cvId, source, paramsMap)).isEmpty()) continue;
                for (ArrayList<HashMap> rowList : rowsList) {
                    reportList.add(rowList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportList;
    }

    public ArrayList<ArrayList<HashMap>> getRowList(Long cvId, String source, HashMap paramsMap) {
        ArrayList reportList = new ArrayList();
        try {
            HashMap<String, String> addionalSQLPropsMap = new HashMap<String, String>();
            addionalSQLPropsMap.put("sortColumn", "TIME_GENERATED");
            addionalSQLPropsMap.put("sortOrder", "ASC");
            String searchCrit = paramsMap.get("searchCritBusiness") != null ? paramsMap.get("searchCritBusiness").toString() : null;
            String sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCrit, paramsMap, new HashMap(), 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("COLUMNALIAS");
            list.add("DISPLAYNAME");
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, true, false, list);
            paramsMap.put("CV_ID", cvId);
            reportList = QueryUtil.getRows(sqlString, columnList, paramsMap, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportList;
    }

    public ArrayList<HashMap> getIterateList(ArrayList<ArrayList<HashMap>> reportList, HashMap paramsMap) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        try {
            for (ArrayList<HashMap> subList : reportList) {
                HashMap map = new HashMap();
                for (HashMap reportMap : subList) {
                    map.put(reportMap.get("COLUMNALIAS").toString(), reportMap.get("COLUMN_VALUE"));
                }
                list.add(map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public ArrayList<HashMap> getDurationList(ArrayList<ArrayList<HashMap>> reportList, HashMap paramsMap) {
        ArrayList<HashMap> rowList = new ArrayList<HashMap>();
        try {
            ArrayList<HashMap> itrList = this.getIterateList(reportList, paramsMap);
            this.iterateList(itrList);
            rowList = this.getRowList(paramsMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public void iterateList(ArrayList<HashMap> list) {
        try {
            this.durationList = new ArrayList();
            for (HashMap map : list) {
                HashMap rowMap = this.correlateEvent(map);
                if (rowMap.isEmpty()) continue;
                this.durationList.add(rowMap);
            }
            this.addLastRow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap correlateEvent(HashMap map) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        try {
            Integer eventNumber = (Integer)map.get("EVENT_NUMBER");
            if (eventNumber == 4800 || eventNumber == 4802 || eventNumber == 4647 || eventNumber == 4779) {
                HashMap cloneMap = (HashMap)map.clone();
                for (Integer key : this.correlateMap.keySet()) {
                    ArrayList<HashMap> list = this.correlateMap.get(key);
                    if (list.isEmpty()) continue;
                    rowMap.put("LOCKTIME", (Long)list.remove(0).get("TIME_GENERATED"));
                    rowMap.put("REMARKS", key.toString());
                    this.correlateMap.remove(key);
                }
                ArrayList<Object> keyList = null;
                if (this.correlateMap.get(eventNumber) == null) {
                    keyList = new ArrayList<HashMap>();
                    keyList.add(cloneMap);
                } else {
                    keyList = this.correlateMap.get(eventNumber);
                    keyList.add(cloneMap);
                }
                this.correlateMap.put(eventNumber, keyList);
            } else {
                Integer remarkEventNum = eventNumber;
                eventNumber = eventNumber == 4624 ? Integer.valueOf(4647) : (eventNumber == 4778 ? Integer.valueOf(4779) : Integer.valueOf(eventNumber - 1));
                StringBuilder sb = new StringBuilder();
                sb.append(eventNumber);
                sb.append(",");
                sb.append(remarkEventNum);
                if (this.correlateMap.get(eventNumber) != null && !this.correlateMap.get(eventNumber).isEmpty()) {
                    ArrayList<HashMap> list = this.correlateMap.get(eventNumber);
                    HashMap valMap = list.remove(0);
                    rowMap.put("LOCKTIME", (Long)valMap.get("TIME_GENERATED"));
                    rowMap.put("DURATION", (Long)map.get("TIME_GENERATED") - (Long)valMap.get("TIME_GENERATED"));
                    rowMap.put("UNLOCKTIME", (Long)map.get("TIME_GENERATED"));
                    rowMap.put("REMARKS", sb.toString());
                    rowMap.put("STATUS", RB.getString("adap.AUDColumnConfiguration.displayname.User_Status_Idle"));
                } else if (eventNumber != 4779 && eventNumber != 4647) {
                    rowMap.put("UNLOCKTIME", (Long)map.get("TIME_GENERATED"));
                    rowMap.put("REMARKS", sb.toString());
                }
                if (this.correlateMap.containsKey(eventNumber)) {
                    this.correlateMap.remove(eventNumber);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowMap;
    }

    public void addLastRow() {
        try {
            if (!this.correlateMap.isEmpty()) {
                Set<Integer> keySet = this.correlateMap.keySet();
                for (Integer key : keySet) {
                    ArrayList<HashMap> list = this.correlateMap.get(key);
                    for (HashMap map : list) {
                        if (null == map || map.isEmpty()) continue;
                        HashMap<String, Object> rowMap = new HashMap<String, Object>();
                        Integer eventNumber = (Integer)map.get("EVENT_NUMBER");
                        rowMap.put("LOCKTIME", (Long)map.get("TIME_GENERATED"));
                        rowMap.put("REMARKS", eventNumber.toString());
                        this.durationList.add(rowMap);
                    }
                }
            }
            this.correlateMap = new HashMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<HashMap<String, String>> getIdleActiveTime(String source, String userName, HashMap paramsMap) {
        ArrayList<HashMap<String, String>> rowList = new ArrayList<HashMap<String, String>>();
        try {
            ArrayList<ArrayList<HashMap>> reportList = this.getReportList(source, paramsMap);
            ArrayList<HashMap> itrList = this.getIterateList(reportList, paramsMap);
            this.iterateList(itrList);
            this.sortDurationList();
            Long idleTime = 0L;
            Long activeTime = 0L;
            ArrayList idleTimeList = new ArrayList();
            for (HashMap map : this.durationList) {
                if (map.get("STATUS") == null || !map.get("STATUS").toString().equalsIgnoreCase(RB.getString("adap.AUDColumnConfiguration.displayname.User_Status_Idle"))) continue;
                idleTime = idleTime + (Long)map.get("DURATION");
            }
            HashMap<String, String> rowMap = new HashMap<String, String>();
            String idleTimeStr = idleTime == 0L ? "-" : UserActivityUtil.getInstance().getDayString(idleTime);
            rowMap.put("IDLETIME", idleTimeStr);
            rowMap.put("DETAILS", this.getDetailLink(source, userName));
            rowList.add(rowMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public ArrayList<HashMap> getRowList(HashMap paramsMap) {
        ArrayList<HashMap> rowList = new ArrayList<HashMap>();
        try {
            this.sortDurationList();
            for (HashMap map : this.durationList) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                String remark = (String)map.get("REMARKS");
                String[] remarks = remark.split(",");
                if (map.get("LOCKTIME") != null) {
                    rowMap.put("LOCKTIME", UserActivityUtil.getInstance().getDateString((Long)map.get("LOCKTIME")) + UserActivityUtil.getInstance().getRemark(remarks[0]));
                }
                if (map.get("UNLOCKTIME") != null) {
                    rowMap.put("UNLOCKTIME", UserActivityUtil.getInstance().getDateString((Long)map.get("UNLOCKTIME")) + UserActivityUtil.getInstance().getRemark(remarks[1]));
                }
                if (map.get("DURATION") != null) {
                    rowMap.put("DURATION", UserActivityUtil.getInstance().getDayString((Long)map.get("DURATION")));
                }
                rowMap.put("REMARKS", (String)map.get("REMARKS"));
                rowList.add(rowMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public String getDetailLink(String source, String userName) {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append("<span class=\"flLeft paddingRight10\">");
            buff.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"javascript:showDetails('");
            buff.append(source);
            buff.append("','");
            buff.append(userName);
            buff.append("'");
            buff.append(")\">");
            buff.append(RB.getString("adap.common.text.details"));
            buff.append("</a>");
            buff.append("</span>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public void sortDurationList() {
        try {
            HashMap<Long, HashMap> rowMap = new HashMap<Long, HashMap>();
            HashMap<Long, HashMap> rowMapSecond = new HashMap<Long, HashMap>();
            ArrayList<Long> timeGenList = new ArrayList<Long>();
            for (HashMap map : this.durationList) {
                Long key;
                Long l = key = map.get("LOCKTIME") != null ? (Long)map.get("LOCKTIME") : (Long)map.get("UNLOCKTIME");
                if (!rowMap.containsKey(key)) {
                    timeGenList.add(key);
                    rowMap.put(key, map);
                    continue;
                }
                rowMapSecond.put(key, map);
            }
            Collections.sort(timeGenList);
            ArrayList<HashMap> list = new ArrayList<HashMap>();
            for (Long timeGen : timeGenList) {
                list.add((HashMap)rowMap.get(timeGen));
                if (!rowMapSecond.containsKey(timeGen)) continue;
                list.add((HashMap)rowMapSecond.get(timeGen));
            }
            this.removeScreenInvokeEvent(list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeScreenInvokeEvent(ArrayList<HashMap> list) {
        try {
            this.durationList = new ArrayList();
            int i = 1;
            Boolean b = false;
            for (HashMap map : list) {
                if (b.booleanValue()) {
                    HashMap cloneMap = (HashMap)map.clone();
                    cloneMap.put("STATUS", "NO");
                    this.durationList.add(cloneMap);
                } else {
                    this.durationList.add(map);
                }
                if (list.size() == i) continue;
                HashMap secondMap = list.get(i);
                if (map.get("LOCKTIME") != null && map.get("UNLOCKTIME") != null && secondMap.get("LOCKTIME") != null && secondMap.get("UNLOCKTIME") != null) {
                    Long fromTime = (Long)map.get("LOCKTIME");
                    Long toTime = (Long)map.get("UNLOCKTIME");
                    Long secondFirstTime = (Long)secondMap.get("LOCKTIME");
                    Long secondToTime = (Long)secondMap.get("UNLOCKTIME");
                    b = fromTime <= secondFirstTime && toTime >= secondToTime;
                } else {
                    b = false;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

