/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.useractivity;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.template.ComputerTableHandler;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformerAPI;
import com.adventnet.sym.adsm.auditing.server.transformers.UserLogonActivityTransformer;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class UserActivityUtil {
    private static UserActivityUtil userActivityUtil = null;
    String dateFormat = "MMM dd,yyyy hh:mm:ss a";
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    String spanString = "<span style=\"color: #FFF;font-family: Verdana,Arial,Helvetica,sans-serif;font-size: 11px;font-weight: normal;text-decoration: none;\">";
    String tableString = "<table class=\"technicianWrapper table table-striped\" bgcolor=\"#eff4ff\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\">";
    static ArrayList<Long> cvIDList = new ArrayList();
    String[] activityColumn = new String[]{"adap.AUDReports.description.Logon_Activity", "adap.AUDReports.description.Processs_Modification", "adap.AUDReports.description.other_Activity"};
    String[] lockColumn = new String[]{"adap.AUDReports.audit_report_name_Lock_Time", "adap.AUDReports.audit_report_name_Unlock_Time", "adap.AUDReports.audit_report_name_Duration"};
    String[] logonActivityColumn = new String[]{"adap.AUDReports.audit_report_name_Lock_Time", "adap.AUDReports.audit_report_name_Unlock_Time", "adap.AUDReports.audit_report_name_Duration"};
    String[] logonColumn = new String[]{"adap.AUDReports.audit_report_name_Total_Time", "adap.AUDReports.audit_report_name_Active_Time", "adap.AUDReports.audit_report_name_Idle_Time", "adap.AUDGPPolicyPathMapping.policy_path.Details"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserActivityUtil getInstance() {
        if (userActivityUtil != null) return userActivityUtil;
        Class<UserActivityUtil> clazz = UserActivityUtil.class;
        synchronized (UserActivityUtil.class) {
            userActivityUtil = new UserActivityUtil();
            UserActivityUtil.setCvIdList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userActivityUtil;
        }
    }

    public String getRowVal(ArrayList<ArrayList<HashMap>> list) {
        StringBuffer buff = null;
        try {
            if (!list.isEmpty()) {
                ArrayList<HashMap> rowList = list.get(0);
                for (HashMap firstRowMap : rowList) {
                    String val = firstRowMap.get("COLUMN_VALUE") != null ? firstRowMap.get("COLUMN_VALUE").toString() : "-";
                    buff = buff == null ? new StringBuffer() : buff.append(" - ");
                    buff.append(val);
                }
            } else {
                buff = new StringBuffer();
                buff.append("-");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public ArrayList<ArrayList<HashMap>> getUserActivityList(HashMap inputParams, String uvhPattern) throws Exception {
        Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", uvhPattern);
        ArrayList list = new ArrayList();
        HashMap<String, Object> addionalSQLPropsMap = new HashMap<String, Object>();
        addionalSQLPropsMap.put("startIndex", 1);
        addionalSQLPropsMap.put("noOfObjects", 1);
        addionalSQLPropsMap.put("sortOrder", "ASC");
        addionalSQLPropsMap.put("sortColumn", "RECORD_NUMBER");
        ArrayList columnList = this.getColumnList(cvId);
        String query = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, null, inputParams, addionalSQLPropsMap, 1);
        list = QueryUtil.getRows(query, columnList, inputParams, false);
        return list;
    }

    public ArrayList getColumnList(Long cvId) throws Exception {
        ArrayList columnList = null;
        try {
            ArrayList<String> columnNameList = new ArrayList<String>();
            columnNameList.add("CV_ID");
            columnNameList.add("BGCOLUMN");
            columnNameList.add("COLUMNALIAS");
            columnNameList.add("TRANSFORMER");
            columnNameList.add("COLUMN_CONF_ID");
            columnNameList.add("DATE_FORMAT");
            columnNameList.add("DISPLAYNAME");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return columnList;
    }

    public ArrayList<ArrayList<HashMap>> getRowList(HashMap inputParams, String uvhPattern) {
        ArrayList<ArrayList<HashMap>> list = new ArrayList();
        try {
            list = this.getUserActivityList(inputParams, uvhPattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public HashMap getInputParams(HashMap map, String source) {
        HashMap retMap = (HashMap)map.clone();
        try {
            String objectsSID = map.get("objectSIDStr").toString().toLowerCase();
            String[] sidList = objectsSID.split(",");
            if (sidList.length != 1) {
                ArrayList<String> domainNameList = new ArrayList<String>();
                domainNameList.add(map.get("domainDNSName").toString());
                domainNameList.add(map.get("domainFlatName").toString());
                ComputerTableHandler.getInstance();
                Row row = ComputerTableHandler.getComputerRow(source, domainNameList);
                StringBuffer buff = new StringBuffer();
                buff.append("'");
                buff.append(row.get("SID_STRING"));
                buff.append("'");
                retMap.put("objectSIDStr", buff.toString());
                buff = new StringBuffer();
                buff.append("'%{");
                buff.append(row.get("SID_STRING"));
                buff.append("}'");
                retMap.put("objectSID", buff.toString());
                buff = new StringBuffer();
                buff.append("'");
                buff.append(row.get("DNS_NAME"));
                buff.append("'");
                retMap.put("objectDNSName", buff.toString());
                buff = new StringBuffer();
                buff.append("'");
                buff.append(row.get("NAME"));
                buff.append("'");
                retMap.put("objectName", buff.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retMap;
    }

    public String getUIString(Long cvId, Object obj) {
        StringBuffer buff = new StringBuffer();
        try {
            if (cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:16014"))) {
                String[] columnKey = new String[]{"LOCKTIME", "UNLOCKTIME", "DURATION"};
                buff = this.getLogonActivity((ArrayList)obj, columnKey, this.lockColumn);
            } else if (cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:16007"))) {
                buff = this.getUserActivity((HashMap)obj);
            } else if (cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:16016"))) {
                String[] columnKey = new String[]{"TOTALHRS", "ACTIVETIME", "IDLETIME", "DETAILS"};
                buff = this.getLogonActivity((ArrayList)obj, columnKey, this.logonColumn);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public StringBuffer getUserActivity(HashMap map) {
        StringBuffer buff = new StringBuffer();
        try {
            String logonCount = (String)map.get("LOGONCOUNT");
            String processCount = (String)map.get("PROCESSCOUNT");
            String otherCount = (String)map.get("OTHERCOUNT");
            ArrayList firstRowList = (ArrayList)map.get("FIRSTROW");
            ArrayList lastRowList = (ArrayList)map.get("LASTROW");
            String firstRowVal = this.getRowVal(firstRowList);
            String lastRowVal = this.getRowVal(lastRowList);
            buff = buff.append("<tr><td colspan=\"2\">");
            buff = buff.append(this.tableString);
            buff = buff.append("<tbody><tr class=\"rowtable2\"><td colspan=\"3\" class=\"blacktxt1\">");
            buff = buff.append(firstRowVal);
            buff = buff.append("</td></tr>");
            buff = buff.append("<tr height=\"25\">");
            for (String key : this.activityColumn) {
                buff = buff.append("<TH style=\"width: 5%;\">");
                buff = buff.append(this.spanString);
                buff.append(RB.getString(key));
                buff.append("</span></TH>");
            }
            buff.append("</tr>");
            buff = buff.append("<tr class=\"rowtable1\">");
            buff = buff.append("<td>");
            buff = buff.append(logonCount);
            buff = buff.append("</td>");
            buff = buff.append("<td>");
            buff = buff.append(processCount);
            buff = buff.append("</td>");
            buff = buff.append("<td>");
            buff = buff.append(otherCount);
            buff = buff.append("</td></tr>");
            buff = buff.append("<tr class=\"rowtable2\"><td colspan=\"3\" class=\"blacktxt1\">");
            buff = buff.append(lastRowVal);
            buff = buff.append("</td></tr></tbody></table>");
            buff = buff.append("</td>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    public StringBuffer getLogonActivity(ArrayList<HashMap> list, String[] columnKey, String[] displayColumn) {
        StringBuffer buff = new StringBuffer();
        try {
            buff = buff.append("<tr><td colspan=\"2\">");
            buff.append(this.tableString);
            buff = buff.append("<tbody><tr height=\"25\">");
            for (String columnName : displayColumn) {
                buff.append("<TH style=\"width: 5%;\">");
                buff.append(this.spanString);
                buff.append(RB.getString(columnName));
                buff.append("</span></TH>");
            }
            buff.append("</tr>");
            int i = 1;
            for (HashMap rowMap : list) {
                String rowClass = i % 2 == 0 ? "rowtable1" : "rowtable2";
                buff.append("<tr class=\"" + rowClass + "\">");
                for (String key : columnKey) {
                    String val = "-";
                    if (rowMap.get(key) != null) {
                        val = key.equals("REMARKS") ? this.getRemarks((Integer)rowMap.get(key)) : rowMap.get(key);
                    }
                    buff.append("<td>");
                    buff.append((Object)val);
                    buff.append("</td>");
                }
                buff.append("</tr>");
                ++i;
            }
            buff.append("</tbody></table>");
            buff.append("</td>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    public String getDayString(Long val) {
        String durationTime = "-";
        try {
            durationTime = TimeUtil.getDuration(val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return durationTime;
    }

    public String getDateString(Long time) {
        String val = "";
        try {
            if (time != null) {
                val = CommonUtil.formatDate(time * 1000L, this.dateFormat);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public String getRemarks(Integer eventNumber) {
        String retVal = RB.getString("adap.AUDReports.audit_report_screan_savor_invoke_devoke");
        try {
            if (eventNumber == 4800 || eventNumber == 4801) {
                retVal = RB.getString("adap.AUDReports.audit_report_system_lock_unlock");
            } else if (eventNumber == 4778) {
                retVal = RB.getString("adap.AUDReports.audit_report_session_connect_disconnect");
            } else if (eventNumber == 4647) {
                retVal = RB.getString("adap.AUDReports.audit_report_shutdown_login");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public ArrayList<HashMap> getSubReportList(String userName, String source) {
        ArrayList<HashMap> rowList = new ArrayList<HashMap>();
        try {
            UserLogonActivityTransformer transformer = (UserLogonActivityTransformer)ColumnTransformerAPI.getInstance().getColumnTransformer(DBObjectUtil.getUVHValues("AUDColumnConfiguration", "AUDColumnConfiguration:column_conf_id:15039532"));
            HashMap paramsMap = UserActivityUtil.getInstance().getInputParams(UserLogonActivityTransformer.inputParams, source);
            paramsMap.put("USERNAMETEMP", userName);
            ArrayList<ArrayList<HashMap>> reportList = transformer.getReportList(source, paramsMap);
            rowList = transformer.getDurationList(reportList, paramsMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public String getLogonActivityDetails(String userName, String source) {
        StringBuffer buff = new StringBuffer();
        try {
            ArrayList<HashMap> rowList = this.getSubReportList(userName, source);
            String[] columnKey = new String[]{"LOCKTIME", "UNLOCKTIME", "DURATION"};
            buff.append("<table  border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">");
            buff.append(this.getLogonActivity(rowList, columnKey, this.logonActivityColumn));
            buff.append("</tr></table>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public static void setCvIdList() {
        try {
            cvIDList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:16020"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Boolean isSummaryReport(Long cvID) {
        Boolean b = false;
        try {
            if (!cvIDList.isEmpty() && cvIDList.contains(cvID)) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public ArrayList<HashMap> getExportRowsList(ArrayList<ArrayList<HashMap>> rowsList) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        try {
            String userName = "";
            String source = "";
            for (ArrayList<HashMap> rowList : rowsList) {
                HashMap rowMap = new HashMap();
                for (HashMap map : rowList) {
                    Object val = map.get("COLUMN_VALUE");
                    if (val != null && val.getClass().equals(ArrayList.class)) {
                        HashMap valMap = (HashMap)((ArrayList)val).get(0);
                        Set keys = valMap.keySet();
                        for (String key : keys) {
                            if (key.equalsIgnoreCase("DETAILS")) continue;
                            rowMap.put(key, valMap.get(key));
                        }
                        continue;
                    }
                    rowMap.put(map.get("COLUMNALIAS").toString(), val);
                    if (map.get("COLUMNALIAS").toString().equalsIgnoreCase("USERNAME")) {
                        userName = val.toString();
                        continue;
                    }
                    if (!map.get("COLUMNALIAS").toString().equalsIgnoreCase("SOURCE")) continue;
                    source = val.toString();
                }
                if (this.getSubReportList(userName, source).isEmpty()) continue;
                rowMap.put("SUBREPORT", this.getSubReportList(userName, source));
                list.add(rowMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public ArrayList<ArrayList<HashMap>> getTempList() {
        ArrayList<ArrayList<HashMap>> list = new ArrayList<ArrayList<HashMap>>();
        try {
            int z = 0;
            for (int j = 0; j <= 4; ++j) {
                ArrayList<String> copyRowList = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    copyRowList.add("temp" + z);
                    ++z;
                }
                list.add(copyRowList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public ArrayList<ArrayList> getSubReportList(HashMap valMap) {
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        try {
            Set keys = valMap.keySet();
            ArrayList<String> subList = new ArrayList<String>();
            for (String key : keys) {
                String val = "-";
                val = key.equalsIgnoreCase("REMARKS") ? this.getRemarks((Integer)valMap.get(key)) : valMap.get(key);
                subList.add(val);
            }
            list.add(subList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public ArrayList<ArrayList<HashMap>> getLogonDurationSubReport(ArrayList<ArrayList<HashMap>> reportsList, ArrayList<HashMap<String, Object>> columnList) {
        ArrayList<ArrayList<HashMap>> list = new ArrayList<ArrayList<HashMap>>();
        try {
            for (ArrayList<HashMap> subList : reportsList) {
                ArrayList<HashMap> subRowList = new ArrayList<HashMap>();
                for (HashMap columnMap : subList) {
                    Object mapVal = columnMap.get("COLUMN_VALUE");
                    if (mapVal instanceof ArrayList) {
                        HashMap subRowMap = (HashMap)((ArrayList)mapVal).get(0);
                        for (HashMap<String, Object> subColumnMap : columnList) {
                            HashMap cloneMap = (HashMap)subColumnMap.clone();
                            String key = cloneMap.get("COLUMNALIAS").toString();
                            Object columnVal = subRowMap.get(key);
                            cloneMap.put("COLUMN_VALUE", columnVal);
                            cloneMap.put("VISIBLE", true);
                            subRowList.add(cloneMap);
                        }
                        continue;
                    }
                    subRowList.add(columnMap);
                }
                list.add(subRowList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public String getRemark(String eventNumber) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(" [");
            if (eventNumber.equalsIgnoreCase("4800")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_screan_lock"));
            } else if (eventNumber.equalsIgnoreCase("4801")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_screan_unlock"));
            } else if (eventNumber.equalsIgnoreCase("4802") || eventNumber.equalsIgnoreCase("4804")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_screensaver_invoke"));
            } else if (eventNumber.equalsIgnoreCase("4803")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_screensaver_dismissed"));
            } else if (eventNumber.equalsIgnoreCase("4778")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_rd_connect"));
            } else if (eventNumber.equalsIgnoreCase("4779")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_rd_disconnect"));
            } else if (eventNumber.equalsIgnoreCase("4624")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_intractive_logon"));
            } else if (eventNumber.equalsIgnoreCase("4647")) {
                sb.append(RB.getString("adap.AUDReports.audit_report_wokstation_logoff"));
            }
            sb.append("]");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public ArrayList getCvIdList() {
        ArrayList<Long> cvIdList = new ArrayList<Long>();
        try {
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15051"));
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15053"));
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15054"));
            cvIdList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15055"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cvIdList;
    }
}

