/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Semaphore;

public class DelayBlockingQueue<E extends Delayed> {
    private final DelayQueue<E> delayQueue = new DelayQueue();
    private final Semaphore semaphore;
    private final Object syncObject;

    public DelayBlockingQueue(int capacity) {
        this.semaphore = new Semaphore(capacity, true);
        this.syncObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(E e) throws InterruptedException {
        this.semaphore.acquire();
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.delayQueue.contains(e)) {
                this.delayQueue.offer(e);
            } else {
                this.semaphore.release();
            }
        }
    }

    public void put(E o) {
        this.delayQueue.offer(o);
    }

    public boolean add(E o) {
        return this.delayQueue.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c) {
        int ret = 0;
        Object object = this.syncObject;
        synchronized (object) {
            ret = this.delayQueue.drainTo(c);
            int count = c.size();
            if (count > 0) {
                this.semaphore.release(count);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c, int maxElements) {
        int ret = 0;
        Object object = this.syncObject;
        synchronized (object) {
            ret = this.delayQueue.drainTo(c, maxElements);
        }
        int count = c.size();
        if (count > 0) {
            this.semaphore.release(count);
        }
        return ret;
    }

    public boolean contains(Object o) {
        Iterator<E> e = this.delayQueue.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.delayQueue.size();
    }

    public String toString() {
        return "DelayBlockingQueue [delayQueue=" + this.delayQueue.size() + ", available=" + this.semaphore + ", toString()=" + super.toString() + "]";
    }
}

