/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventDataUtil {
    private static Logger logger = Logger.getLogger("EventLogger");
    public static HashMap domainDetailsMap = null;
    private static EventDataUtil eventDataUtil = null;

    public static DataObject getMSDO(String msName, String domainName) throws Exception {
        Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria msCrit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)msName, 0);
        msCrit = domainCrit.and(msCrit);
        ArrayList<String> list = new ArrayList<String>();
        list.add("ADSMComputerGeneralDetails");
        list.add("AUDComputerEventRead");
        DataObject msDO = CommonUtil.getPersistence(new boolean[0]).get(list, msCrit);
        return msDO;
    }

    public static String getOSversion(String computerName, String domainName) throws Exception {
        String osVersion = "";
        try {
            Criteria criti = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)computerName, 0);
            criti = criti.and(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criti = criti.or(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)computerName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criti);
            Row dcRow = null;
            if (!dataObject.isEmpty()) {
                dcRow = dataObject.getFirstRow("ADSMComputerGeneralDetails");
            }
            osVersion = dcRow != null ? (String)dcRow.get("VERSION") : osVersion;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return osVersion;
    }

    public static void getComputerDetails(String domainName, String computerName) throws Exception {
        try {
            HashMap compMap = null;
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ADSMDCConfiguration"));
            Criteria crit1 = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"), (Object)3, 0);
            if (domainName != null) {
                crit1 = crit1.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            if (computerName != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)computerName, 0);
                crit1 = crit1.and(crit);
            }
            Join dcEventReadJoin = new Join("ADSMDCConfiguration", "AUDDCEventRead", new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            selectQuery.addJoin(dcEventReadJoin);
            Join scheduledTaskJoin = new Join("AUDDCEventRead", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            selectQuery.addJoin(scheduledTaskJoin);
            selectQuery.setCriteria(crit1);
            selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj1 = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator ite = dataObj1.getRows("ADSMDCConfiguration");
            while (ite.hasNext()) {
                Row dcRow = (Row)ite.next();
                if (domainDetailsMap == null) {
                    domainDetailsMap = new HashMap();
                }
                compMap = domainDetailsMap.get(dcRow.get("DOMAIN_NAME")) == null ? new HashMap() : (HashMap)domainDetailsMap.get(dcRow.get("DOMAIN_NAME"));
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("COMPUTER_ID", (Long)dcRow.get("DOMAIN_CONTROLLER_ID"));
                propMap.put("NAME", (String)dcRow.get("DOMAIN_CONTROLLER_NAME"));
                propMap.put("DOMAIN_NAME", (String)dcRow.get("DOMAIN_NAME"));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), dcRow.get("DOMAIN_CONTROLLER_ID"), 0);
                Row eventReadRow = dataObj1.getRow("AUDDCEventRead", crit);
                propMap.put("EVENT_READ", (Long)eventReadRow.get("EVENT_READ"));
                propMap.put("RECENT_EVENT_TIME", (Long)eventReadRow.get("RECENT_EVENT_TIME"));
                propMap.put("EVENT_FETCH_MODE", (Integer)eventReadRow.get("EVENT_FETCH_MODE"));
                propMap.put("VERSION", (String)eventReadRow.get("OS_VERSION"));
                propMap.put("CRITERIA_TABLE_NAME", "ADSMDCConfiguration");
                propMap.put("EVENT_TABLE_NAME", "AUDDCEventRead");
                propMap.put("EVENT_COLUMN_NAME", "DOMAIN_CONTROLLER_ID");
                propMap.put("CRITERIA_COLUMN_NAME", "DOMAIN_CONTROLLER_NAME");
                propMap.put("JOIN_COLUMN_NAME", "DOMAIN_CONTROLLER_ID");
                propMap.put("BASE_TABLE_NAME", "ADSMDCConfiguration");
                propMap.put("IS_FIM_ENABLED", (Integer)eventReadRow.get("IS_FIM_ENABLED"));
                compMap.put(dcRow.get("DOMAIN_CONTROLLER_NAME"), propMap);
                domainDetailsMap.put(dcRow.get("DOMAIN_NAME"), compMap);
            }
            SelectQueryImpl selectQuery1 = new SelectQueryImpl(Table.getTable((String)"AUDComputerEventRead"));
            Criteria crit2 = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"STATUS"), (Object)3, 0);
            if (domainName != null) {
                crit2 = crit2.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            if (computerName != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)computerName, 0);
                crit2 = crit2.and(crit);
            }
            Join compEventReadJoin = new Join("AUDComputerEventRead", "ADSMComputerGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            selectQuery1.addJoin(compEventReadJoin);
            selectQuery1.setCriteria(crit2);
            selectQuery1.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj2 = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery1);
            Iterator iter = dataObj2.getRows("ADSMComputerGeneralDetails");
            while (iter.hasNext()) {
                Row compRow = (Row)iter.next();
                if (domainDetailsMap == null) {
                    domainDetailsMap = new HashMap();
                }
                compMap = domainDetailsMap.get(compRow.get("DOMAIN_NAME")) == null ? new HashMap() : (HashMap)domainDetailsMap.get(compRow.get("DOMAIN_NAME"));
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("NAME", (String)compRow.get("NAME"));
                propMap.put("DOMAIN_NAME", (String)compRow.get("DOMAIN_NAME"));
                propMap.put("VERSION", (String)compRow.get("VERSION"));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), compRow.get("OBJECT_GUID"), 0);
                Row compEventRow = dataObj2.getRow("AUDComputerEventRead", crit);
                propMap.put("COMPUTER_ID", (Long)compEventRow.get("COMPUTER_ID"));
                propMap.put("OBJECT_GUID", (String)compEventRow.get("OBJECT_GUID"));
                propMap.put("RECENT_EVENT_TIME", (Long)compEventRow.get("RECENT_EVENT_TIME"));
                propMap.put("EVENT_READ", (Long)compEventRow.get("EVENT_READ"));
                propMap.put("EVENT_FETCH_MODE", (Integer)compEventRow.get("EVENT_FETCH_MODE"));
                crit = new Criteria(Column.getColumn((String)"AUDTerminalServerEventRead", (String)"OBJECT_GUID"), compEventRow.get("OBJECT_GUID"), 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTerminalServerEventRead", crit);
                if (!dataObj.isEmpty()) {
                    Row row = dataObj.getRow("AUDTerminalServerEventRead", crit);
                    propMap.put("TERMINAL_SERVER_EVENT_READ", row.get("EVENT_READ"));
                    propMap.put("TERMINAL_SERVER_RECENT_EVENT_TIME", row.get("RECENT_EVENT_TIME"));
                    propMap.put("TERMINAL_SERVER", 1);
                } else {
                    propMap.put("TERMINAL_SERVER", 0);
                }
                propMap.put("EVENT_TABLE_NAME", "AUDComputerEventRead");
                propMap.put("CRITERIA_TABLE_NAME", "AUDComputerEventRead");
                propMap.put("EVENT_COLUMN_NAME", "COMPUTER_ID");
                propMap.put("CRITERIA_COLUMN_NAME", "NAME");
                propMap.put("JOIN_COLUMN_NAME", "OBJECT_GUID");
                propMap.put("BASE_TABLE_NAME", "ADSMComputerGeneralDetails");
                propMap.put("MACHINE_TYPE", (Integer)compEventRow.get("MACHINE_TYPE"));
                propMap.put("IS_FIM_ENABLED", (Integer)compEventRow.get("IS_FIM_ENABLED"));
                compMap.put(compRow.get("NAME"), propMap);
                domainDetailsMap.put(compRow.get("DOMAIN_NAME"), compMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void updateTerminalServerTable(String domainName, String computerName, String objectGUID, boolean terminal) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDTerminalServerEventRead", (String)"OBJECT_GUID"), (Object)objectGUID, 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTerminalServerEventRead", criteria);
        if (!dataObj.isEmpty()) {
            if (terminal) return;
            CommonUtil.getPersistenceLite().delete(criteria);
            EventDataUtil.setTerminalServerConfigured(domainName, computerName);
            return;
        } else {
            if (!terminal) return;
            Row msRow = new Row("AUDTerminalServerEventRead");
            msRow.set("EVENT_READ", (Object)0L);
            msRow.set("TIME_READ", (Object)0);
            msRow.set("RECENT_EVENT_TIME", (Object)0);
            msRow.set("OBJECT_GUID", (Object)objectGUID);
            dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObj.addRow(msRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            EventDataUtil.setTerminalServerConfigured(domainName, computerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTerminalServerDetails(String domainName, String[] objectGUID) throws Exception {
        String query = "SELECT ADSMComputerGeneralDetails.NAME,ADSMComputerGeneralDetails.CANONICAL_NAME,AUDComputerEventRead.OBJECT_GUID,ADSMComputerGeneralDetails.VERSION FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails on ADSMComputerGeneralDetails.OBJECT_GUID = AUDComputerEventRead.OBJECT_GUID WHERE (AUDComputerEventRead.MACHINE_TYPE&16=16) AND ADSMComputerGeneralDetails.DOMAIN_NAME='" + domainName + "' AND ADSMComputerGeneralDetails.OPERATING_SYSTEM LIKE '%server%'";
        if (objectGUID != null) {
            query = query + "AND ADSMComputerGeneralDetails.OBJECT_GUID in ('";
            for (int i = 0; i < objectGUID.length; ++i) {
                query = query + objectGUID[i];
                if (i == objectGUID.length - 1) continue;
                query = query + "','";
            }
            query = query + "')";
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            block26: while (resultSet.next()) {
                double ver;
                String version = resultSet.getString("VERSION");
                if (version == null || (ver = new Double(version = version.substring(0, version.indexOf(40))).doubleValue()) < 6.0) continue;
                String computerName = resultSet.getString("NAME");
                String objectGuid = resultSet.getString("OBJECT_GUID");
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                String userName = (String)domainDetails.get("USER_NAME");
                String passwd = (String)domainDetails.get("PASSWORD");
                try {
                    ArrayList list;
                    String[] prop;
                    if (ver < 6.1) {
                        prop = new String[]{"id", "name"};
                        list = ADHandler.getWindowsDirectory(computerName, domainName, userName, passwd, prop, "select * from Win32_ServerFeature", null, 0, 0);
                        String li = list.toString();
                        if (li.toLowerCase().contains("gateway")) {
                            EventDataUtil.updateTerminalServerTable(domainName, computerName, objectGuid, true);
                            continue;
                        }
                        EventDataUtil.updateTerminalServerTable(domainName, computerName, objectGuid, false);
                        continue;
                    }
                    prop = new String[]{"Caption", "InstallState", "Name"};
                    list = ADHandler.getWindowsDirectory(computerName, domainName, userName, passwd, prop, "select * from Win32_OptionalFeature", null, 0, 0);
                    for (int i = 0; i < list.size(); ++i) {
                        Properties fea = (Properties)list.get(i);
                        String name = (String)fea.get("Name");
                        if (!name.equalsIgnoreCase("Gateway") || !name.equalsIgnoreCase("Gateway")) continue;
                        int in = (Integer)fea.get("InstallState");
                        if (in == 1) {
                            EventDataUtil.updateTerminalServerTable(domainName, computerName, objectGuid, true);
                            continue block26;
                        }
                        EventDataUtil.updateTerminalServerTable(domainName, computerName, objectGuid, false);
                        continue block26;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static HashMap getComputerProperties(String domainName, String computerName) throws Exception {
        HashMap propMap;
        HashMap compMap;
        logger.log(Level.FINE, "Now am in getComputerProperties");
        if (domainDetailsMap == null) {
            EventDataUtil.getComputerDetails(null, null);
        }
        HashMap hashMap = compMap = domainDetailsMap != null ? (HashMap)domainDetailsMap.get(domainName) : null;
        if (compMap == null) {
            EventDataUtil.getComputerDetails(domainName, null);
        }
        compMap = domainDetailsMap != null ? (HashMap)domainDetailsMap.get(domainName) : null;
        HashMap hashMap2 = propMap = compMap != null ? (HashMap)compMap.get(computerName) : null;
        if (propMap == null) {
            EventDataUtil.getComputerDetails(domainName, computerName);
        }
        compMap = domainDetailsMap != null ? (HashMap)domainDetailsMap.get(domainName) : null;
        propMap = compMap != null ? (HashMap)compMap.get(computerName) : null;
        return propMap;
    }

    public static void updateEventLogMessage(String message, String computerName, String domainName) {
        logger.log(Level.FINE, "Inside updateEventLogMessage");
        if (message == null) {
            message = "Success";
        }
        try {
            Integer eventFetchMode;
            HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
            if (message.equalsIgnoreCase("success") && (eventFetchMode = EventDataUtil.getEventFetchMode(computerName, domainName)) == 4) {
                RealTimeEventUtil.getInstance().changeDcFetchMode((Long)propMap.get("COMPUTER_ID"), 3);
                RealTimeEventUtil.getInstance().checkAndUpdate((Long)propMap.get("COMPUTER_ID"), 3);
                EventDataUtil.getComputerDetails(domainName, computerName);
            }
            logger.log(Level.FINE, "propMap in updateEventLogMessage is " + propMap);
            Criteria criteria = new Criteria(Column.getColumn((String)((String)propMap.get("CRITERIA_TABLE_NAME")), (String)((String)propMap.get("EVENT_COLUMN_NAME"))), (Object)((Long)propMap.get("COMPUTER_ID")), 0);
            DataObject dcDO = CommonUtil.getPersistence(new boolean[0]).get((String)propMap.get("CRITERIA_TABLE_NAME"), criteria);
            Iterator ie = dcDO.getRows((String)propMap.get("CRITERIA_TABLE_NAME"));
            logger.log(Level.FINE, "Message : " + message);
            if (ie.hasNext()) {
                Row dcRow = (Row)ie.next();
                dcRow.set("MESSAGE", (Object)message);
                dcDO.updateRow(dcRow);
            }
            logger.log(Level.FINE, "Going to update DCLog DO");
            CommonUtil.getPersistence(new boolean[0]).update(dcDO);
        }
        catch (DataAccessException dae) {
            logger.log(Level.SEVERE, "Exception while update event fetch message for domain controllers.");
            dae.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Long getRecordNumber(String computerName, String domainName) throws Exception {
        Long recordNumber = 0L;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        logger.log(Level.FINE, "propMap in getRecordNumber is " + propMap);
        recordNumber = (Long)propMap.get("EVENT_READ");
        logger.log(Level.INFO, "EVENT_READ -> " + recordNumber + " COMPUTER Name -> " + computerName);
        return recordNumber;
    }

    public static Long getEventTime(String computerName, String domainName) throws Exception {
        Long eventTime = 0L;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        logger.log(Level.FINE, "propMap in getRecordNumber is " + propMap);
        eventTime = (Long)propMap.get("RECENT_EVENT_TIME");
        logger.log(Level.INFO, "EVENT_READ -> " + eventTime + " COMPUTER Name -> " + computerName);
        return eventTime;
    }

    public static Integer getTerminalServerConfigured(String domainName, String computerName) throws Exception {
        Integer terminal = 0;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        terminal = (Integer)propMap.get("TERMINAL_SERVER");
        return terminal;
    }

    public static Integer getEventFetchMode(String computerName, String domainName) throws Exception {
        Integer eventFetchMode = 0;
        try {
            HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
            eventFetchMode = (Integer)propMap.get("EVENT_FETCH_MODE");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return eventFetchMode;
    }

    public static Integer isFIMEnabled(String computerName, String domainName) throws Exception {
        Integer isFIMEnabled = 0;
        try {
            HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
            isFIMEnabled = (Integer)propMap.get("IS_FIM_ENABLED");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isFIMEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTerminalServerConfigured(String domainName, String computerName) throws Exception {
        if (domainDetailsMap == null) {
            EventDataUtil.getComputerDetails(null, null);
        } else {
            HashMap hashMap = domainDetailsMap;
            synchronized (hashMap) {
                EventDataUtil.getComputerDetails(domainName, computerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFIMFlag(String domainName) throws Exception {
        logger.log(Level.INFO, "updatingFIM Flag in ComputerProperties");
        if (domainDetailsMap == null) {
            EventDataUtil.getComputerDetails(null, null);
        } else {
            HashMap hashMap = domainDetailsMap;
            synchronized (hashMap) {
                EventDataUtil.getComputerDetails(domainName, null);
            }
        }
    }

    public static String getComputerOsVersion(String computerName, String domainName) throws Exception {
        String osVersion = null;
        try {
            HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
            if (propMap != null) {
                osVersion = (String)propMap.get("VERSION");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return osVersion;
    }

    public static void setComputerOsVersion(String computerName, String domainName, String value) throws Exception {
        try {
            HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
            if (propMap != null) {
                propMap.put("VERSION", value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateRecordNumber(Hashtable dcEventCountTable) {
        try {
            Enumeration enumeration = dcEventCountTable.keys();
            while (enumeration.hasMoreElements()) {
                String domainName = (String)enumeration.nextElement();
                Hashtable domainHashtable = (Hashtable)dcEventCountTable.get(domainName);
                Enumeration dcEnumeration = domainHashtable.keys();
                while (dcEnumeration.hasMoreElements()) {
                    String dcName = (String)dcEnumeration.nextElement();
                    Hashtable timeRecordNumberMap = (Hashtable)domainHashtable.get(dcName);
                    EventDataUtil.updateRecordNumber((Long)timeRecordNumberMap.get("TIME_GENERATED"), (Long)timeRecordNumberMap.get("RECORD_NUMBER"), dcName, domainName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateRecordNumber(long recordNumber, String dcName, String domainName) throws DataAccessException {
        Long dcID = this.getDCID(dcName, domainName);
        Criteria dcIDCrit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcID, 0);
        DataObject dcObj = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", dcIDCrit);
        Row r = dcObj.getFirstRow("AUDDCEventRead");
        Long recL = recordNumber;
        r.set("EVENT_READ", (Object)recL);
        r.set("TIME_READ", (Object)System.currentTimeMillis());
        dcObj.updateRow(r);
        logger.log(Level.FINE, "Update Row Record Number " + r);
        CommonUtil.getPersistence(new boolean[0]).update(dcObj);
    }

    public static long getTerminalRecord(String domainName, String computerName) throws Exception {
        Long recordNumber = 0L;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        logger.log(Level.FINE, "propMap in getRecordNumber is " + propMap);
        recordNumber = (Long)propMap.get("TERMINAL_SERVER_EVENT_READ");
        logger.log(Level.FINE, "EVENT_READ -> " + recordNumber + " COMPUTER Name -> " + computerName);
        return recordNumber + 1L;
    }

    public static Long getTerminalTimeGenerated(String domainName, String computerName) throws Exception {
        Long eventTime = 0L;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        logger.log(Level.FINE, "propMap in getRecordNumber is " + propMap);
        eventTime = (Long)propMap.get("TERMINAL_SERVER_RECENT_EVENT_TIME");
        return eventTime;
    }

    public static void updateTerminalServerRecord(Hashtable retHash, String domainName, String computerName, String objectGUID) throws Exception {
        long timeGenerated = ((Integer)retHash.get("TimeWritten")).intValue();
        Long recordNumber = (Long)retHash.get("RecordNumber");
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        Long recentevent = (Long)propMap.get("TERMINAL_SERVER_RECENT_EVENT_TIME");
        Long recordRead = (Long)propMap.get("TERMINAL_SERVER_EVENT_READ");
        if (timeGenerated > recentevent || recordNumber > recordRead && timeGenerated == recentevent) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTerminalServerEventRead", (String)"OBJECT_GUID"), (Object)objectGUID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDTerminalServerEventRead", crit);
            Row row = dataObject.getRow("AUDTerminalServerEventRead", crit);
            row.set("EVENT_READ", (Object)recordNumber);
            row.set("TIME_READ", (Object)System.currentTimeMillis());
            row.set("RECENT_EVENT_TIME", (Object)timeGenerated);
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            propMap.put("TERMINAL_SERVER_RECENT_EVENT_TIME", timeGenerated);
            propMap.put("TERMINAL_SERVER_EVENT_READ", Long.valueOf(recordNumber));
        }
    }

    public static synchronized void updateRecordNumber(long timeGenerated, long recordNumber, String computerName, String domainName) throws Exception {
        boolean update = false;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        logger.log(Level.FINE, "For " + computerName + " --> propMap in updateRecordNumber is " + propMap);
        Long recentEventTime = (Long)propMap.get("RECENT_EVENT_TIME");
        if (recentEventTime == null) {
            update = true;
        } else if (timeGenerated == recentEventTime) {
            Long recordRead = (Long)propMap.get("EVENT_READ");
            if (recordNumber > recordRead) {
                update = true;
            }
        } else if (timeGenerated > recentEventTime) {
            update = true;
        }
        if (update) {
            logger.log(Level.FINE, "Updated the RecordNumber and EventFetchTime for .." + computerName);
            Criteria crit = new Criteria(Column.getColumn((String)((String)propMap.get("EVENT_TABLE_NAME")), (String)((String)propMap.get("EVENT_COLUMN_NAME"))), (Object)((Long)propMap.get("COMPUTER_ID")), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((String)propMap.get("EVENT_TABLE_NAME"), crit);
            Row row = dataObject.getFirstRow((String)propMap.get("EVENT_TABLE_NAME"));
            row.set("EVENT_READ", (Object)recordNumber);
            row.set("TIME_READ", (Object)System.currentTimeMillis());
            row.set("RECENT_EVENT_TIME", (Object)timeGenerated);
            dataObject.updateRow(row);
            logger.log(Level.FINE, "Update Row Record Number is " + row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            propMap.put("RECENT_EVENT_TIME", timeGenerated);
            propMap.put("EVENT_READ", recordNumber);
        }
    }

    private Long getDCID(String dcName, String domainName) throws DataAccessException {
        Long dcID = 0L;
        logger.log(Level.FINE, "Domain Name -> " + domainName);
        logger.log(Level.FINE, "Domain Controller Name -> " + dcName);
        Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria dcCrit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)dcName, 0);
        dcCrit = domainCrit.and(dcCrit);
        DataObject dcDO = CommonUtil.getPersistence(new boolean[0]).get("ADSMDCConfiguration", dcCrit);
        logger.log(Level.FINE, "ADSMDCConfiguration DO -> " + dcDO);
        if (!dcDO.isEmpty()) {
            dcID = (Long)dcDO.getFirstValue("ADSMDCConfiguration", "DOMAIN_CONTROLLER_ID");
        }
        return dcID;
    }

    public static Integer getMachineType(String domainName, String computerName) throws Exception {
        Integer machineType = 1;
        HashMap propMap = EventDataUtil.getComputerProperties(domainName, computerName);
        machineType = (Integer)propMap.get("MACHINE_TYPE");
        return machineType;
    }

    public static void removeDomainDetailsMap(String domainName) {
        try {
            if (null != domainDetailsMap && domainDetailsMap.containsKey(domainName)) {
                domainDetailsMap.remove(domainName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            EventDataUtil.getComputerDetails(null, null);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while getting details of all computers");
            ex.printStackTrace();
        }
    }
}

