/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.DCHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventSchedulerUtil {
    private static Logger logger = Logger.getLogger("ADMangLogger");
    private static Long scheduleId = 0L;
    private static final String EVENT_TASK_NAME = "EventUpdate";

    public static Long createScheduler(HashMap schedulerPropsMap) {
        boolean creationStatus = false;
        try {
            DataObject schDo = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row schRow = new Row("Schedule");
            schRow.set("SCHEDULE_NAME", schedulerPropsMap.get("SCHEDULE_NAME"));
            schRow.set("DESCRIPTION", schedulerPropsMap.get("DESCRIPTION"));
            schDo.addRow(schRow);
            String scheduleType = (String)schedulerPropsMap.get("SCHEDULE_TYPE");
            if (scheduleType.equalsIgnoreCase("hourly")) {
                schDo = EventSchedulerUtil.createPeriodicScheduler(schDo, schedulerPropsMap);
                schDo = CommonUtil.getPersistence(new boolean[0]).add(schDo);
                scheduleId = (Long)schRow.get("SCHEDULE_ID");
            } else {
                Row calendarRow = new Row("Calendar");
                calendarRow.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
                calendarRow.set("TIME_OF_DAY", schedulerPropsMap.get("TIME_PERIOD"));
                calendarRow.set("UNIT_OF_TIME", schedulerPropsMap.get("UNIT_OF_TIME"));
                if (scheduleType.equalsIgnoreCase("daily")) {
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
                } else if (scheduleType.equalsIgnoreCase("weekly")) {
                    calendarRow.set("DAY_OF_WEEK", schedulerPropsMap.get("DAY_OF_WEEK"));
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
                } else if (scheduleType.equalsIgnoreCase("monthly")) {
                    calendarRow.set("DATE_OF_MONTH", schedulerPropsMap.get("DATE_OF_MONTH"));
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
                }
                schDo.addRow(calendarRow);
                Row taskRow = new Row("Scheduled_Task");
                taskRow.set("ADMIN_STATUS", schedulerPropsMap.get("ADMIN_STATUS"));
                taskRow.set("AUDIT_FLAG", (Object)true);
                taskRow.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
                taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)schedulerPropsMap.get("EVENT_TASK_NAME")));
                taskRow.set("TRANSACTION_TIME", (Object)-1);
                schDo.addRow(taskRow);
                Row task_input_row = new Row("Task_Input");
                task_input_row.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
                task_input_row.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)schedulerPropsMap.get("EVENT_TASK_NAME")));
                Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)schDo, (Long)-1L, (boolean)false);
                task_input_row.set("SCHEDULE_TIME", (Object)new Timestamp(time));
                schDo.addRow(task_input_row);
                schDo = CommonUtil.getPersistence(new boolean[0]).add(schDo);
                scheduleId = (Long)schRow.get("SCHEDULE_ID");
            }
            creationStatus = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }

    public static DataObject createPeriodicScheduler(DataObject schDo, HashMap schedulerPropsMap) throws Exception {
        Iterator schIterator = schDo.getRows("Schedule");
        Row schRow = null;
        while (schIterator.hasNext()) {
            schRow = (Row)schIterator.next();
        }
        Row periodicRow = new Row("Periodic");
        periodicRow.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
        periodicRow.set("TIME_PERIOD", schedulerPropsMap.get("TIME_PERIOD"));
        periodicRow.set("UNIT_OF_TIME", schedulerPropsMap.get("UNIT_OF_TIME"));
        if (schedulerPropsMap.get("START_DATE") != null) {
            periodicRow.set("START_DATE", schedulerPropsMap.get("START_DATE"));
        }
        schDo.addRow(periodicRow);
        Row taskRow = new Row("Scheduled_Task");
        taskRow.set("ADMIN_STATUS", schedulerPropsMap.get("ADMIN_STATUS"));
        taskRow.set("AUDIT_FLAG", (Object)true);
        taskRow.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
        taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)schedulerPropsMap.get("EVENT_TASK_NAME")));
        taskRow.set("TRANSACTION_TIME", (Object)-1);
        if (schedulerPropsMap.get("SKIP_MISSED_SCHEDULE") != null) {
            taskRow.set("SKIP_MISSED_SCHEDULE", schedulerPropsMap.get("SKIP_MISSED_SCHEDULE"));
        }
        schDo.addRow(taskRow);
        Row task_input_row = new Row("Task_Input");
        task_input_row.set("SCHEDULE_ID", schRow.get("SCHEDULE_ID"));
        task_input_row.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)schedulerPropsMap.get("EVENT_TASK_NAME")));
        Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)schDo, (Long)-1L, (boolean)false);
        task_input_row.set("SCHEDULE_TIME", (Object)new Timestamp(time));
        schDo.addRow(task_input_row);
        return schDo;
    }

    public static void enableDisableScheduler(Long schedulerId, String status) throws Exception {
        try {
            logger.log(Level.INFO, status + " the scheduler id " + schedulerId);
            SchedulerUtil.enableDisableScheduler(schedulerId, status);
            if (!status.equalsIgnoreCase("Disable")) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Periodic", new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)schedulerId, 0));
                SchedulerUtil.updateTime(dataObject, schedulerId, System.currentTimeMillis());
                EventSchedulerUtil.fetchData(schedulerId);
            } else {
                RealTimeEventUtil.getInstance().stopRealTimeCollection(schedulerId, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventDataUtil.getComputerDetails(null, null);
    }

    public static String getDCSchedulerStatus(String dcName, String domainName) {
        String status = null;
        Long ret = 0L;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)dcName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDDCEventRead");
                ret = (Long)row.get("SCHEDULE_ID");
            }
            status = SchedulerUtil.getStatus(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static int getEnabledEventSchedulerCount() {
        int count = 0;
        try {
            Long taskId = SchedulerUtil.getTaskID(EVENT_TASK_NAME);
            String query = "select count(*) from auddceventread join scheduled_task on auddceventread.schedule_id = scheduled_task.schedule_id where scheduled_task.admin_status = 3";
            count = QueryUtil.getRowsCount(query);
            logger.log(Level.INFO, "Count of Enabled Schedulers :" + count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static boolean deleteDCEventSchedulers(String domainName) {
        boolean flag = false;
        try {
            Long[] schedulers = DCHandler.getDCEventSchedulers(domainName);
            Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)schedulers, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean deleteDCEventScheduler(Long dcID) {
        boolean flag = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", criteria);
            Row row = dataObject.getRow("AUDDCEventRead");
            Long scheduleId = (Long)row.get("SCHEDULE_ID");
            Criteria deleteCriteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistenceLite().delete(deleteCriteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Long createEventScheduler(Hashtable dcEventProps, int machineType) {
        Long scheduleId = 0L;
        try {
            String machineName = "";
            String domainName = (String)dcEventProps.get("domainName");
            int adminStatus = (Integer)dcEventProps.get("adminStatus");
            Long scheduleStartTime = (Long)dcEventProps.get("scheduleStartTime");
            String schedulerName = "_Events_Scheduler";
            String machineTypeString = "domain controller";
            if (machineType == 1) {
                machineName = (String)dcEventProps.get("dcName");
            } else {
                machineName = (String)dcEventProps.get("serverName");
                schedulerName = "_File_Audit_Scheduler";
                machineTypeString = "file server";
            }
            String timePeriod = (String)dcEventProps.get("timePeriod");
            HashMap<String, Object> schedulerPropsMap = new HashMap<String, Object>();
            schedulerPropsMap.put("SCHEDULE_NAME", domainName + "_" + machineName + schedulerName);
            schedulerPropsMap.put("DESCRIPTION", "Scheduler for getting events from " + machineTypeString + " " + machineName);
            schedulerPropsMap.put("SCHEDULE_TYPE", "hourly");
            if (timePeriod == null) {
                timePeriod = "120";
            }
            Long timePeriodLong = Long.parseLong(timePeriod);
            schedulerPropsMap.put("TIME_PERIOD", timePeriodLong);
            schedulerPropsMap.put("UNIT_OF_TIME", "Minutes");
            schedulerPropsMap.put("DATE_OF_MONTH", 0);
            schedulerPropsMap.put("DAY_OF_WEEK", 0);
            schedulerPropsMap.put("ADMIN_STATUS", adminStatus);
            schedulerPropsMap.put("START_DATE", new Timestamp(scheduleStartTime + timePeriodLong * 60L * 1000L));
            schedulerPropsMap.put("SKIP_MISSED_SCHEDULE", true);
            schedulerPropsMap.put("EVENT_TASK_NAME", EVENT_TASK_NAME);
            scheduleId = EventSchedulerUtil.createScheduler(schedulerPropsMap);
            logger.log(Level.INFO, "Created Scheduler for {0} {1} of domain {2}.", new Object[]{machineTypeString, machineName, domainName});
            logger.log(Level.INFO, "Schedule Id is {0} and Start Date is {1}", new Object[]{scheduleId, new Date(scheduleStartTime)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }

    public static void fetchData(Long scheduleId) {
        try {
            Criteria schedulecriteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject scheduleDataObject = CommonUtil.getPersistence(new boolean[0]).get("Schedule", schedulecriteria);
            Row scheduleRow = scheduleDataObject.getRow("Schedule");
            String scheduleName = (String)scheduleRow.get("SCHEDULE_NAME");
            if (scheduleName.endsWith("Events_Scheduler")) {
                DCHandler.runDCEventScheduler(scheduleId);
            } else if (scheduleName.endsWith("File_Audit_Scheduler")) {
                FileServerHandler.runEventScheduler(scheduleId);
            } else {
                MSHandler.fetchMSData(scheduleId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getEventSchedulers(int enabledOrDisabled) {
        ArrayList<Object> enabledEventSchedulers = new ArrayList<Object>();
        try {
            Long taskId = SchedulerUtil.getTaskID(EVENT_TASK_NAME);
            Criteria criteria = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"), (Object)enabledOrDisabled, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"TASK_ID"), (Object)taskId, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)"Events_Scheduler", 11));
            Table table1 = new Table("Schedule");
            SelectQueryImpl sq = new SelectQueryImpl(table1);
            sq.setCriteria(criteria);
            Join join = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            sq.addJoin(join);
            join = new Join("Schedule", "AUDDCEventRead", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            sq.addJoin(join);
            ArrayList<Column> colList = new ArrayList<Column>();
            colList.add(Column.getColumn((String)"Schedule", (String)"*"));
            colList.add(Column.getColumn((String)"Scheduled_Task", (String)"*"));
            sq.addSelectColumns(colList);
            SortColumn sortColumn = new SortColumn("AUDDCEventRead", "RECENT_EVENT_TIME", false);
            sq.addSortColumn(sortColumn);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator iterator = dataObject.getRows("Scheduled_Task");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                enabledEventSchedulers.add(row.get("SCHEDULE_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enabledEventSchedulers;
    }
}

