/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;

public class ExchangeCallerUserNameUtil {
    private static final String TABLE_USERMGMT = "AUDUserMgmt";
    private static final String TABLE_ACCOUNTCREATION = "AUDAccountCreation";
    private static final String TABLE_GROUPMGMT = "AUDGroupMgmt";
    private static final String TABLE_ADOAUDIT = "AUDADOAuditInfo";
    private static final ArrayList MONITORTABLES = new ArrayList<String>(Arrays.asList("AUDUserMgmt", "AUDAccountCreation", "AUDGroupMgmt", "AUDADOAuditInfo"));
    private static final String TABLE_EXCHANGESERVERS = "ADSMExchangeServerDetails";
    private static final String TABLE_COMPUTERGENERALDETAILS = "ADSMComputerGeneralDetails";
    private static final String TABLE_SYSTEMPARAMS = "SystemParams";
    private static final String COL_CALLERUSERNAME = "CALLER_USER_NAME";
    private static final String COL_SAMACCOUNTNAME = "SAM_ACCOUNT_NAME";
    private static final String COL_ACCOUNTNAME = "ACCOUNT_NAME";
    private static final String COL_CALLERUSERDOMAIN = "CALLER_USER_DOMAIN";
    private static final String COL_TIMEGENERATED = "TIME_GENERATED";
    private static final String COL_FORMATMESSAGE = "FORMAT_MESSAGE";
    private static final String COL_CALLERUSERSID = "CALLER_USER_SID";
    private static final String COL_CLIENTUSERNAME = "CLIENT_USER_NAME";
    private static final String COL_OBJECTNAMETEXT = "OBJECT_NAME_TEXT";
    private static final String COL_CLIENTDOMAIN = "CLIENT_DOMAIN";
    private static final String COL_NAME = "NAME";
    private static final String COL_SERIALNUMBER = "SERIAL_NUMBER";
    private static final String COL_DOMAINNAME = "DOMAIN_NAME";
    private static Hashtable<String, Hashtable<String, Object>> exchangeCache = new Hashtable();
    public static Hashtable<String, String> exToDomain = new Hashtable();
    private static HashMap<String, ReentrantLock> lockVariables = new HashMap();
    public static Hashtable<String, String> canoNameCache = new Hashtable();
    private static int diffTimeLimit = 20;
    private static int extraFetchTime = 120;
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static String[] notMonitorCmdLets = new String[]{"Get-MailboxStatistics", "Search-AdminAuditLog", "Search-MailboxAuditLog", "Set-ADServerSettings", "Get-Recipient"};
    private static String[] notMonitorAttributes = new String[]{"msExchMailboxAuditLastAdminAccess", "msExchMailboxAuditLastDelegateAccess", "msExchVersion", "msExchSafeSendersHash", "msExchHideFromAddressLists", "ShowInAddressBook"};
    public static int disableExchangeCallerUserNameUtil = 0;
    public static volatile ExchangeCallerUserNameUtil exchangeCallerUserNameUtil = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExchangeCallerUserNameUtil getInstance() {
        if (exchangeCallerUserNameUtil != null) return exchangeCallerUserNameUtil;
        Class<ExchangeCallerUserNameUtil> clazz = ExchangeCallerUserNameUtil.class;
        synchronized (ExchangeCallerUserNameUtil.class) {
            if (exchangeCallerUserNameUtil != null) return exchangeCallerUserNameUtil;
            exchangeCallerUserNameUtil = new ExchangeCallerUserNameUtil();
            try {
                Row r;
                Criteria c = new Criteria(Column.getColumn((String)TABLE_SYSTEMPARAMS, (String)"PARAM_NAME"), (Object)"disableExchangeCallerUserNameUtil", 0);
                DataObject exSysParams = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SYSTEMPARAMS, c);
                if (!exSysParams.isEmpty()) {
                    r = exSysParams.getFirstRow(TABLE_SYSTEMPARAMS);
                    disableExchangeCallerUserNameUtil = Integer.parseInt((String)r.get("PARAM_VALUE"));
                }
                c = new Criteria(Column.getColumn((String)TABLE_SYSTEMPARAMS, (String)"PARAM_NAME"), (Object)"exDiffTimeLimit", 0);
                exSysParams = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SYSTEMPARAMS, c);
                if (!exSysParams.isEmpty()) {
                    r = exSysParams.getFirstRow(TABLE_SYSTEMPARAMS);
                    diffTimeLimit = Integer.parseInt((String)r.get("PARAM_VALUE"));
                }
                c = new Criteria(Column.getColumn((String)TABLE_SYSTEMPARAMS, (String)"PARAM_NAME"), (Object)"exExtraFetchTime", 0);
                exSysParams = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SYSTEMPARAMS, c);
                if (exSysParams.isEmpty()) return exchangeCallerUserNameUtil;
                r = exSysParams.getFirstRow(TABLE_SYSTEMPARAMS);
                extraFetchTime = Integer.parseInt((String)r.get("PARAM_VALUE"));
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            return exchangeCallerUserNameUtil;
        }
    }

    public void updateExchangeInfoInEventRow(Row eventRow, Hashtable eventTbl) {
        try {
            String tableName = eventRow.getTableName();
            if (tableName.equals(TABLE_USERMGMT)) {
                int i;
                String attr = (String)eventRow.get("ATTRIBUTES_TEXT");
                if (attr != null) {
                    attr = attr.replaceAll("-", "");
                    for (i = 0; i < notMonitorAttributes.length; ++i) {
                        if (!attr.equalsIgnoreCase(notMonitorAttributes[i])) continue;
                        return;
                    }
                }
                if ((attr = (String)eventRow.get("USER_MGMT_TYPE")) != null) {
                    attr = attr.replaceAll("-", "");
                    for (i = 0; i < notMonitorAttributes.length; ++i) {
                        if (!attr.equalsIgnoreCase(notMonitorAttributes[i])) continue;
                        return;
                    }
                }
            }
            if (MONITORTABLES.contains(tableName) && disableExchangeCallerUserNameUtil == 0) {
                String column_AccountName;
                String column_CallerUserDomain;
                String column_SamAccountName;
                String column_CallerUserName;
                if (tableName.equals(TABLE_ADOAUDIT)) {
                    column_CallerUserName = COL_CLIENTUSERNAME;
                    column_SamAccountName = COL_OBJECTNAMETEXT;
                    column_CallerUserDomain = COL_CLIENTDOMAIN;
                    column_AccountName = COL_OBJECTNAMETEXT;
                } else {
                    column_CallerUserName = COL_CALLERUSERNAME;
                    column_SamAccountName = COL_SAMACCOUNTNAME;
                    column_CallerUserDomain = COL_CALLERUSERDOMAIN;
                    column_AccountName = COL_ACCOUNTNAME;
                }
                String callerUserName = (String)eventRow.get(column_CallerUserName);
                if (callerUserName.contains("$")) {
                    String domainName1;
                    String computerName = callerUserName.substring(0, callerUserName.length() - 1);
                    String userToFind = (String)eventRow.get(column_SamAccountName);
                    if (!tableName.equals(TABLE_ACCOUNTCREATION)) {
                        userToFind = (String)eventRow.get(column_AccountName);
                    }
                    if (!(domainName1 = ExchangeCallerUserNameUtil.validExchangeServer(computerName)).equals("false")) {
                        REPORT_LOGGER.log(Level.FINE, "In updateExchangeInfoInEventRow for : " + computerName + " : " + userToFind);
                        boolean tryAgain = true;
                        Boolean forceFromNative = false;
                        while (tryAgain) {
                            tryAgain = this.getExchangeCallerUserName(domainName1, computerName, (Long)eventRow.get(COL_TIMEGENERATED), forceFromNative);
                            ArrayList retList = (ArrayList)exchangeCache.get(computerName).get("cache");
                            Long currentDiff = new Long(diffTimeLimit);
                            for (Object temp : retList) {
                                String cmdletName;
                                String user;
                                Hashtable tempHash = (Hashtable)temp;
                                Long timeStamp = Long.parseLong((String)tempHash.get("when"), 10);
                                Long timeStampFromEvent = (Long)eventRow.get(COL_TIMEGENERATED);
                                Long timeDiff = Math.abs(timeStampFromEvent - timeStamp);
                                if (timeDiff >= currentDiff || !ExchangeCallerUserNameUtil.evaluateCmdletLog(user = (String)tempHash.get("user"), cmdletName = (String)tempHash.get("cmdlet"), userToFind, tableName, eventRow, eventTbl)) continue;
                                tryAgain = false;
                                currentDiff = timeDiff;
                                String fullName = (String)tempHash.get("who");
                                String[] fullNameParts = fullName.split("\\/");
                                eventRow.set(column_CallerUserName, (Object)fullNameParts[fullNameParts.length - 1]);
                                eventRow.set(column_CallerUserDomain, (Object)fullNameParts[0]);
                                eventRow.set(COL_CALLERUSERSID, (Object)((String)tempHash.get("whosid")));
                                String message = (String)eventRow.get(COL_FORMATMESSAGE);
                                message = message.replace(" by ", " by '" + (String)tempHash.get("who") + "' in server ");
                                eventRow.set(COL_FORMATMESSAGE, (Object)message);
                                break;
                            }
                            if (!tryAgain) continue;
                            forceFromNative = true;
                        }
                        callerUserName = (String)eventRow.get(column_CallerUserName);
                        if (callerUserName.contains("$")) {
                            REPORT_LOGGER.log(Level.INFO, "ExchangeCallerUserNameUtil :: Unable to find CallerUserName :: " + (String)eventRow.get(COL_FORMATMESSAGE) + " RecNo : " + eventRow.get("RECORD_NUMBER"));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String validExchangeServer(String computerName) {
        if (!exToDomain.containsKey(computerName)) {
            String domainName = "false";
            try {
                String localWinVer = System.getProperty("os.version");
                localWinVer = localWinVer.split("\\.")[0];
                int lWinVer = Integer.parseInt(localWinVer);
                if (lWinVer >= 6) {
                    Row r1;
                    String version;
                    Criteria c = new Criteria(Column.getColumn((String)TABLE_EXCHANGESERVERS, (String)COL_NAME), (Object)computerName, 0, false);
                    DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(TABLE_EXCHANGESERVERS, c);
                    if (!dataObj.isEmpty() && (version = (String)(r1 = dataObj.getFirstRow(TABLE_EXCHANGESERVERS)).get(COL_SERIALNUMBER)) != null) {
                        String vers = version.split("\\.")[0];
                        int no1 = Integer.parseInt(vers.replaceAll("\\D+", ""));
                        vers = version.split("\\.")[1];
                        vers = vers.split("\\(")[0];
                        int no2 = Integer.parseInt(vers.replaceAll("\\D+", ""));
                        if (no1 >= 14 && no2 >= 1 || no1 >= 15) {
                            Criteria c2 = new Criteria(Column.getColumn((String)TABLE_COMPUTERGENERALDETAILS, (String)COL_NAME), (Object)computerName, 0);
                            DataObject d2 = CommonUtil.getPersistence(new boolean[0]).get(TABLE_COMPUTERGENERALDETAILS, c2);
                            if (!d2.isEmpty()) {
                                Row r2 = d2.getFirstRow(TABLE_COMPUTERGENERALDETAILS);
                                domainName = (String)r2.get(COL_DOMAINNAME);
                            } else {
                                domainName = (String)r1.get(COL_DOMAINNAME);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            exToDomain.put(computerName, domainName);
        }
        return exToDomain.get(computerName);
    }

    private static boolean evaluateCmdletLog(String cmdlet, String cmdletName, String userToFind, String tableName, Row eventRow, Hashtable eventTbl) {
        String guid;
        String path;
        String name;
        String[] splitCanonical;
        boolean makeNative;
        String userToFindCanonical;
        Boolean guidExEvent;
        if (tableName.equals(TABLE_ADOAUDIT) && cmdletName.contains("Contact")) {
            if (cmdlet.contains("Name=" + userToFind)) {
                return true;
            }
            try {
                if (cmdlet.contains("Identity=" + eventRow.get("OBJECT_LOCATION_TEXT"))) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
        if (tableName.equals(TABLE_ACCOUNTCREATION) && cmdletName.contains("New-")) {
            return cmdlet.contains("SamAccountName=" + userToFind + ",") || cmdlet.contains("SamAccountName=" + userToFind + "}");
        }
        if (tableName.equals(TABLE_GROUPMGMT) && cmdletName.contains("Group")) {
            if (cmdlet.contains("SamAccountName=" + userToFind + ",") || cmdlet.contains("SamAccountName=" + userToFind + "}")) {
                return true;
            }
            if (cmdlet.contains("Name=" + userToFind + ",") || cmdlet.contains("Name=" + userToFind + "}")) {
                return true;
            }
            guidExEvent = cmdlet.contains("Identity=<GUID");
            if (!guidExEvent.booleanValue()) {
                userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromEventTbl(eventTbl, userToFind);
                if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                    return true;
                }
                if (!eventTbl.containsKey("Object DN")) {
                    userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromDB(eventRow, "ADSMGroupGeneralDetails", userToFind);
                    if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                        return true;
                    }
                    makeNative = false;
                    if (!userToFindCanonical.equals(userToFind)) {
                        splitCanonical = userToFindCanonical.split("/");
                        name = splitCanonical[splitCanonical.length - 1];
                        path = userToFind.replace(name, "");
                        if (cmdlet.contains("/" + name) || cmdlet.contains(path)) {
                            makeNative = true;
                        }
                    } else {
                        makeNative = true;
                    }
                    if (makeNative) {
                        userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromNative(eventRow, "group", userToFindCanonical);
                        if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                            return true;
                        }
                    }
                }
            } else {
                guid = ExchangeCallerUserNameUtil.getGUID(eventRow, "group", userToFind);
                if (cmdlet.contains("Identity=<GUID=" + guid + ">,") || cmdlet.contains("Identity=<GUID=" + guid + ">}") || cmdlet.contains("Identity=<GUID=" + guid.toLowerCase() + ">,") || cmdlet.contains("Identity=<GUID=" + guid.toLowerCase() + ">}")) {
                    return true;
                }
            }
        }
        if (tableName.equals(TABLE_USERMGMT)) {
            if (cmdlet.contains("SamAccountName=" + userToFind + ",") || cmdlet.contains("SamAccountName=" + userToFind + "}")) {
                return true;
            }
            if (cmdlet.contains("Name=" + userToFind + ",") || cmdlet.contains("Name=" + userToFind + "}")) {
                return true;
            }
            guidExEvent = cmdlet.contains("Identity=<GUID");
            if (!guidExEvent.booleanValue()) {
                userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromEventTbl(eventTbl, userToFind);
                if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                    return true;
                }
                if (!eventTbl.containsKey("Object DN")) {
                    userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromDB(eventRow, "ADSMUserGeneralDetails", userToFind);
                    if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                        return true;
                    }
                    makeNative = false;
                    if (!userToFindCanonical.equals(userToFind)) {
                        splitCanonical = userToFindCanonical.split("/");
                        name = splitCanonical[splitCanonical.length - 1];
                        path = userToFind.replace(name, "");
                        if (cmdlet.contains("/" + name) || cmdlet.contains(path)) {
                            makeNative = true;
                        }
                    } else {
                        makeNative = true;
                    }
                    if (makeNative) {
                        userToFindCanonical = ExchangeCallerUserNameUtil.getCanonicalNameFromNative(eventRow, "user", userToFindCanonical);
                        if (cmdlet.contains("Identity=" + userToFindCanonical + ",") || cmdlet.contains("Identity=" + userToFindCanonical + "}")) {
                            return true;
                        }
                    }
                }
            } else {
                guid = ExchangeCallerUserNameUtil.getGUID(eventRow, "user", userToFind);
                if (cmdlet.contains("Identity=<GUID=" + guid + ">,") || cmdlet.contains("Identity=<GUID=" + guid + ">}") || cmdlet.contains("Identity=<GUID=" + guid.toLowerCase() + ">,") || cmdlet.contains("Identity=<GUID=" + guid.toLowerCase() + ">}")) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getExchangeCallerUserName(String domainName, String computerName, Long fromTime, Boolean forceFromNative) {
        try {
            Hashtable<String, Object> computerCache;
            Long cacheTime;
            if (exchangeCache.containsKey(computerName) && !forceFromNative.booleanValue() && Math.abs((cacheTime = (Long)(computerCache = exchangeCache.get(computerName)).get("fromTime")) - fromTime) <= (long)extraFetchTime) {
                return cacheTime - fromTime < 0L || cacheTime - fromTime > (long)extraFetchTime;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReentrantLock lock = null;
        lock = ExchangeCallerUserNameUtil.getLockVariable(computerName);
        lock.lock();
        try {
            Hashtable<String, Object> computerCache;
            Long cacheTime;
            if (exchangeCache.containsKey(computerName) && (cacheTime = (Long)(computerCache = exchangeCache.get(computerName)).get("fromTime")) - fromTime == 0L) {
                lock.unlock();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList retList = new ArrayList();
        try {
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            sdfDate.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date d1 = new Date(fromTime * 1000L - (long)(extraFetchTime * 1000));
            String strDate = sdfDate.format(d1);
            Date d2 = new Date(fromTime * 1000L + (long)(extraFetchTime * 1000));
            String strDate2 = sdfDate.format(d2);
            String xmlQuery = "<QueryList><Query ><Select Path='MSExchange Management'>Event[EventData[";
            for (String cmdLet : notMonitorCmdLets) {
                xmlQuery = xmlQuery + "Data[1]!=\"" + cmdLet + "\" and ";
            }
            xmlQuery = xmlQuery.substring(0, xmlQuery.length() - 4);
            xmlQuery = xmlQuery + "]] and Event[System[(EventID=1) and TimeCreated[@SystemTime&gt;='" + strDate + "' and @SystemTime&lt;='" + strDate2 + "']]]</Select>" + "</Query>" + "</QueryList>";
            retList = ADHandler.getExchangeCallerUserName(domainName, computerName, xmlQuery);
            Hashtable<String, Serializable> computerCache = new Hashtable<String, Serializable>();
            computerCache.put("fromTime", fromTime);
            computerCache.put("cache", retList);
            exchangeCache.put(computerName, computerCache);
            REPORT_LOGGER.log(Level.FINE, "ExchangeCallerUserNameUtil :: Native Call :: " + exchangeCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        lock.unlock();
        return false;
    }

    private static String getCanonicalNameFromEventTbl(Hashtable eventTbl, String userToFind) {
        try {
            if (eventTbl.containsKey("Object DN")) {
                LdapName ldapName = new LdapName((String)eventTbl.get("Object DN"));
                Enumeration<String> enu = ldapName.getAll();
                userToFind = "";
                while (enu.hasMoreElements()) {
                    String ele = enu.nextElement();
                    if (ele.contains("DC=")) {
                        ele = ele.replace("DC=", "");
                        userToFind = "." + ele + userToFind;
                        continue;
                    }
                    ele = ele.substring(ele.indexOf("=") + 1, ele.length());
                    userToFind = userToFind + "/" + ele;
                }
                userToFind = userToFind.substring(1, userToFind.length());
                userToFind = userToFind.replaceAll("\\\\\\\\", "@###@");
                userToFind = userToFind.replaceAll("\\\\", "");
                userToFind = userToFind.replaceAll("@###@", "\\\\\\\\");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userToFind;
    }

    private static String getCanonicalNameFromDB(Row eventRow, String tableName, String userToFind) {
        String sidString = (String)eventRow.get("ACCOUNT_SID");
        sidString = sidString.replace("%{", "");
        String ret = canoNameCache.get(sidString = sidString.replace("}", ""));
        if (ret == null) {
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"SID_STRING"), (Object)sidString, 0);
            try {
                DataObject userDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
                if (!userDO.isEmpty()) {
                    Row r = userDO.getFirstRow(tableName);
                    userToFind = (String)r.get("CANONICAL_NAME");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            userToFind = ret;
        }
        return userToFind;
    }

    private static String getCanonicalNameFromNative(Row eventRow, String objClass, String userToFind) {
        try {
            String domainName = DomainDetailsAPI.getDomainName((String)eventRow.get("ACCOUNT_DOMAIN"));
            String sidString = (String)eventRow.get("ACCOUNT_SID");
            sidString = sidString.replace("%{", "");
            sidString = sidString.replace("}", "");
            String ret = canoNameCache.get(sidString);
            if (ret == null) {
                Row r = DirectoryObjectAPI.getInstance().getObjectRowFromAD(domainName, sidString, "SID_STRING", objClass);
                if (r != null) {
                    userToFind = (String)r.get("CANONICAL_NAME");
                    canoNameCache.put(sidString, userToFind);
                }
            } else {
                userToFind = ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userToFind;
    }

    private static String getGUID(Row eventRow, String objClass, String userToFind) {
        try {
            String domainName = DomainDetailsAPI.getDomainName((String)eventRow.get("ACCOUNT_DOMAIN"));
            String sidString = (String)eventRow.get("ACCOUNT_SID");
            sidString = sidString.replace("%{", "");
            sidString = sidString.replace("}", "");
            Row r = DirectoryObjectAPI.getInstance().getObjectRowFromDB(domainName, sidString, "SID_STRING", objClass);
            if (r == null) {
                r = DirectoryObjectAPI.getInstance().getObjectRowFromAD(domainName, sidString, "SID_STRING", objClass);
            }
            if (r != null) {
                userToFind = (String)r.get("OBJECT_GUID");
                userToFind = userToFind.replaceAll("\\{", "");
                userToFind = userToFind.replaceAll("}", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userToFind;
    }

    static synchronized ReentrantLock getLockVariable(String serverName) {
        ReentrantLock retLockVariable;
        String lockVariableName = ExchangeCallerUserNameUtil.getLockVariableName(serverName);
        if (lockVariables.containsKey(lockVariableName)) {
            retLockVariable = lockVariables.get(lockVariableName);
        } else {
            retLockVariable = new ReentrantLock();
            lockVariables.put(lockVariableName, retLockVariable);
        }
        return retLockVariable;
    }

    private static String getLockVariableName(String serverName) {
        String lockVariableName = "lock_" + serverName.replaceAll("[^a-zA-Z0-9]", "");
        return lockVariableName;
    }
}

