/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileAuditIpResolverUtil {
    private static final String TABLE_SHAREACCESSINFO = "AUDShareAccessInfoTables";
    private static final String TABLE_DOMAINCONFIG = "ADSMDomainConfiguration";
    private static final String TABLE_SYSTEMPARAMS = "SystemParams";
    private static final String COL_LOGONID = "LOGON_ID";
    private static final String COL_SOURCEIP = "SOURCE_IP";
    private static final String COL_TIMEGENERATED = "TIME_GENERATED";
    private static final String COL_DOMAINNAME = "DOMAIN_NAME";
    private static final String COL_SERVERNAME = "SERVER_NAME";
    private static final String COL_IPTABLENAME = "IP_TABLE_NAME";
    private static ArrayList<String> ipTableNamesCache = new ArrayList();
    private static Hashtable<String, LinkedHashMap<String, String>> ipResolverCache = new Hashtable();
    private static Hashtable<String, ReentrantLock> lockVariables = new Hashtable();
    private static Object cacheLock = new Object();
    private static Object dbUpdateLock = new Object();
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    public static volatile FileAuditIpResolverUtil fileAuditIpResolverUtil = null;
    public static int disableFileAuditIP = 0;
    private static int tableMaxRows = 300000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileAuditIpResolverUtil getInstance() {
        if (fileAuditIpResolverUtil != null) return fileAuditIpResolverUtil;
        Class<FileAuditIpResolverUtil> clazz = FileAuditIpResolverUtil.class;
        synchronized (FileAuditIpResolverUtil.class) {
            if (fileAuditIpResolverUtil != null) return fileAuditIpResolverUtil;
            fileAuditIpResolverUtil = new FileAuditIpResolverUtil();
            try {
                Criteria c = new Criteria(Column.getColumn((String)TABLE_SYSTEMPARAMS, (String)"PARAM_NAME"), (Object)"disableFileAuditIP", 0);
                DataObject exSysParams = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SYSTEMPARAMS, c);
                if (exSysParams.isEmpty()) return fileAuditIpResolverUtil;
                Row r = exSysParams.getFirstRow(TABLE_SYSTEMPARAMS);
                disableFileAuditIP = Integer.parseInt((String)r.get("PARAM_VALUE"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return fileAuditIpResolverUtil;
        }
    }

    public void insertOrUpdateIp(Hashtable<String, Object> eventTable) {
        String readDirection = (String)eventTable.get("ReadDirection");
        String domainName = (String)eventTable.get("DomainName");
        String serverName = (String)eventTable.get("DomainController");
        serverName = serverName.toLowerCase();
        int machineType = (Integer)eventTable.get("MachineType");
        if (((machineType & 4) == 4 || (machineType & 0x40) == 64) && readDirection != null && readDirection.equals("0") && disableFileAuditIP == 0) {
            String logonID = null;
            if (eventTable.containsKey("Subject Logon ID")) {
                logonID = (String)eventTable.get("Subject Logon ID");
            } else if (eventTable.containsKey("Logon ID")) {
                logonID = (String)eventTable.get("Logon ID");
            } else {
                return;
            }
            String sourceIp = (String)eventTable.get("Source Address");
            Integer time = (Integer)eventTable.get("TimeGenerated");
            Long timegen = time.longValue();
            this.updateIpResolverCache(domainName, serverName, logonID, sourceIp, timegen);
            this.insertOrUpdateIp(domainName, serverName, logonID, sourceIp, timegen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdateIp(String domainName, String serverName, String logonID, String sourceIp, Long timegen) {
        Object object = dbUpdateLock;
        synchronized (object) {
            try {
                String tableName = this.getipTableName(domainName, serverName);
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)COL_LOGONID), (Object)logonID, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
                if (dataObject.isEmpty()) {
                    Row r = new Row(tableName);
                    r.set(COL_LOGONID, (Object)logonID);
                    r.set(COL_SOURCEIP, (Object)sourceIp);
                    r.set(COL_TIMEGENERATED, (Object)timegen);
                    DataObject d = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    d.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(d);
                } else {
                    Row oldRow = dataObject.getFirstRow(tableName);
                    String oldIp = (String)oldRow.get(COL_SOURCEIP);
                    if (!oldIp.equals(sourceIp)) {
                        UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                        updateQuery.setCriteria(criteria);
                        updateQuery.setUpdateColumn(COL_SOURCEIP, (Object)sourceIp);
                        updateQuery.setUpdateColumn(COL_TIMEGENERATED, (Object)timegen);
                        CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
                    }
                }
            }
            catch (DataAccessException e) {
                reportLogger.log(Level.FINE, "Exception in FileAuditIPResolver :: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIpResolverCache(String domainName, String serverName, String logonID, String sourceIp, Long timegen) {
        try {
            String hashtableName = FileAuditIpResolverUtil.getCacheHashtableName(domainName, serverName);
            Object object = cacheLock;
            synchronized (object) {
                LinkedHashMap<String, String> tempHash = ipResolverCache.get(hashtableName);
                if (tempHash == null) {
                    int MAX_ENTRIES = 1000;
                    tempHash = new LinkedHashMap<String, String>(1001, 0.75f, true){

                        @Override
                        protected boolean removeEldestEntry(Map.Entry eldest) {
                            return this.size() > 1000;
                        }
                    };
                    ipResolverCache.put(hashtableName, tempHash);
                }
                tempHash.put(logonID, sourceIp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIpForLogonId(Row row, Hashtable<String, Object> eventTable) {
        String retIP = "--";
        try {
            String domainName = (String)row.get("DOMAIN");
            String serverName = (String)row.get("SOURCE");
            serverName = serverName.toLowerCase();
            String logonID = (String)row.get(COL_LOGONID);
            String hashtableName = FileAuditIpResolverUtil.getCacheHashtableName(domainName, serverName);
            String rDirection = (String)eventTable.get("ReadDirection");
            if (rDirection == null || rDirection.equals("1") || disableFileAuditIP != 0) {
                return "-";
            }
            Object object = cacheLock;
            synchronized (object) {
                LinkedHashMap<String, String> tempHash = ipResolverCache.get(hashtableName);
                if (tempHash != null) {
                    retIP = tempHash.get(logonID);
                }
                if (retIP == null) {
                    retIP = "--";
                }
            }
            if (retIP.equals("--")) {
                try {
                    String tableName = this.getipTableName(domainName, serverName);
                    Criteria c = new Criteria(Column.getColumn((String)tableName, (String)COL_LOGONID), (Object)logonID, 0);
                    DataObject d = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
                    if (!d.isEmpty()) {
                        Row r = d.getFirstRow(tableName);
                        retIP = (String)r.get(COL_SOURCEIP);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (retIP.equals("--")) {
                String[] tableNames = this.getUSipTableNames(domainName, serverName);
                for (int i = 0; i < tableNames.length; ++i) {
                    try {
                        String tableName = tableNames[i];
                        String query = "select * from " + tableName + " where " + COL_LOGONID + " = '" + logonID + "' order by " + COL_TIMEGENERATED + " desc";
                        ArrayList<String> list = QueryUtil.getRowsForCustomQuery(query, COL_SOURCEIP);
                        if (list.isEmpty()) continue;
                        retIP = list.get(0);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (retIP.equals("--")) {
                retIP = "-";
            }
            this.updateIpResolverCache(domainName, serverName, logonID, retIP, 123L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retIP;
    }

    public static void cleanShareAccessInfoTable() {
        try {
            ipTableNamesCache = new ArrayList();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(TABLE_DOMAINCONFIG, (Criteria)null);
            Iterator domains = dataObject.getRows(TABLE_DOMAINCONFIG);
            ArrayList<String> domainList = new ArrayList<String>();
            while (domains.hasNext()) {
                Row domainRow = (Row)domains.next();
                domainList.add((String)domainRow.get(COL_DOMAINNAME));
            }
            Long time = System.currentTimeMillis() / 1000L;
            time = time - 172800L;
            try {
                DataObject lifeDO = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SYSTEMPARAMS, new Criteria(Column.getColumn((String)TABLE_SYSTEMPARAMS, (String)"PARAM_NAME"), (Object)"FILEAUDIT_IPRESOLVER_LIFE", 0));
                if (!lifeDO.isEmpty()) {
                    String timeStringHrs = (String)lifeDO.getFirstRow(TABLE_SYSTEMPARAMS).get("PARAM_VALUE");
                    time = time + 172800L - (long)(Integer.parseInt(timeStringHrs) * 60 * 60);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataObject allTables = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SHAREACCESSINFO, (Criteria)null);
            if (!allTables.isEmpty()) {
                Iterator iter = allTables.getRows(TABLE_SHAREACCESSINFO);
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    String tableName = (String)r.get(COL_IPTABLENAME);
                    if (domainList.contains((String)r.get(COL_DOMAINNAME))) {
                        if (tableName.contains("__")) {
                            String timegenStr = tableName.split("__")[1];
                            Long timegen = Long.parseLong(timegenStr);
                            if (timegen >= time) continue;
                            try {
                                reportLogger.log(Level.INFO, "FileAuditIpResolver - Deleting table " + tableName);
                                Criteria c = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)tableName, 0);
                                CommonUtil.getPersistence(new boolean[0]).delete(c);
                                QueryUtil.executeSingleQuery("Drop table", "DROP TABLE " + tableName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!tableName.contains("iptable")) continue;
                        try {
                            Long maxValue = (Long)QueryUtil.getMaxValueOfColumn(COL_TIMEGENERATED, tableName);
                            Long nowTime = System.currentTimeMillis();
                            String modifiedTableName = tableName.replace("iptable", "ip");
                            String domainName1 = modifiedTableName.split("_")[1];
                            String domainName2 = domainName1.substring(0, 3);
                            modifiedTableName = modifiedTableName.replace(domainName1, domainName2);
                            String serverName1 = modifiedTableName.split("_")[2];
                            String serverName2 = serverName1.length() < 10 ? serverName1 : serverName1.substring(0, 10);
                            modifiedTableName = modifiedTableName.replace(serverName1, serverName2);
                            String newTableName = modifiedTableName + "__" + maxValue + "__" + nowTime;
                            reportLogger.log(Level.INFO, "FileAuditIpResolver :: Renaming table " + tableName + " to " + newTableName);
                            MoveRecreateTableHandler.getInstance().renameTable(tableName, newTableName);
                            Criteria c = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)tableName, 0);
                            UpdateQueryImpl updateQuery = new UpdateQueryImpl(TABLE_SHAREACCESSINFO);
                            updateQuery.setCriteria(c);
                            updateQuery.setUpdateColumn(COL_IPTABLENAME, (Object)newTableName);
                            CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
                            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)tableName, 0));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        reportLogger.log(Level.INFO, "FileAuditIpResolver - Deleting table " + tableName);
                        Criteria c = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)tableName, 0);
                        CommonUtil.getPersistence(new boolean[0]).delete(c);
                        QueryUtil.executeSingleQuery("Drop table", "DROP TABLE " + tableName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static synchronized ReentrantLock getLockVariable(String domainName, String serverName) {
        ReentrantLock retLockVariable;
        String lockVariableName = FileAuditIpResolverUtil.getLockVariableName(domainName, serverName);
        if (lockVariables.containsKey(lockVariableName)) {
            retLockVariable = lockVariables.get(lockVariableName);
        } else {
            retLockVariable = new ReentrantLock();
            lockVariables.put(lockVariableName, retLockVariable);
        }
        return retLockVariable;
    }

    private static String getLockVariableName(String domainName, String serverName) {
        String lockVariableName = "lock_" + domainName.replaceAll("[^a-zA-Z0-9]", "") + "_" + serverName.replaceAll("[^a-zA-Z0-9]", "");
        return lockVariableName;
    }

    private static String getCacheHashtableName(String domainName, String serverName) {
        String hashtableName = "temp_" + domainName.replaceAll("[^a-zA-Z0-9]", "") + "_" + serverName.replaceAll("[^a-zA-Z0-9]", "");
        return hashtableName;
    }

    private String getipTableName(String domainName, String serverName) throws Exception {
        String ipTableName = "ip_" + domainName.replaceAll("[^a-zA-Z0-9]", "").substring(0, 3) + "_" + serverName.replaceAll("[^a-zA-Z0-9]", "");
        if (ipTableNamesCache.contains(ipTableName = ipTableName.toLowerCase())) {
            return ipTableName;
        }
        ReentrantLock lock = FileAuditIpResolverUtil.getLockVariable(domainName, serverName);
        lock.lock();
        Criteria criteria = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_DOMAINNAME), (Object)domainName, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_SERVERNAME), (Object)serverName, 0));
        criteria = criteria.and(new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)"__", 13));
        criteria = criteria.and(new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)"iptable", 13));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SHAREACCESSINFO, criteria);
        try {
            if (dataObject.isEmpty()) {
                FileAuditIpResolverUtil.createIpTable(domainName, serverName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ipTableNamesCache = new ArrayList();
        criteria = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)"__", 13);
        dataObject = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SHAREACCESSINFO, criteria);
        if (!dataObject.isEmpty()) {
            Iterator iter = dataObject.getRows(TABLE_SHAREACCESSINFO);
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                ipTableNamesCache.add((String)r.get(COL_IPTABLENAME));
            }
        }
        lock.unlock();
        return ipTableName;
    }

    private String[] getUSipTableNames(String domainName, String serverName) {
        String[] tableNames = new String[]{};
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_DOMAINNAME), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_SERVERNAME), (Object)serverName, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)"__", 12));
            Table table1 = new Table(TABLE_SHAREACCESSINFO);
            SelectQueryImpl sq = new SelectQueryImpl(table1);
            sq.setCriteria(criteria);
            ArrayList<Column> colList = new ArrayList<Column>();
            colList.add(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)"*"));
            sq.addSelectColumns(colList);
            SortColumn sortColumn = new SortColumn(TABLE_SHAREACCESSINFO, COL_IPTABLENAME, true);
            sq.addSortColumn(sortColumn);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                Iterator iter = dataObject.getRows(TABLE_SHAREACCESSINFO);
                int c = 0;
                while (iter.hasNext()) {
                    iter.next();
                    ++c;
                }
                tableNames = new String[c];
                iter = dataObject.getRows(TABLE_SHAREACCESSINFO);
                for (int i = 0; i < c; ++i) {
                    Row r = (Row)iter.next();
                    tableNames[i] = (String)r.get(COL_IPTABLENAME);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableNames;
    }

    private static void createIpTable(String domainName, String serverName) throws Exception {
        String ipTableName = "ip_" + domainName.replaceAll("[^a-zA-Z0-9]", "").substring(0, 3) + "_" + serverName.replaceAll("[^a-zA-Z0-9]", "");
        ipTableName = ipTableName.toLowerCase();
        reportLogger.log(Level.INFO, "FileAuditIpResolver :: Creating table " + ipTableName);
        if (!MoveRecreateTableHandler.getInstance().createNewTable(ipTableName)) {
            String[] folderDetailscolumnNames = new String[]{COL_LOGONID, COL_SOURCEIP, COL_TIMEGENERATED};
            String[] columnDescription = new String[]{"Logon id ", "Client IP", "Event Generated Time"};
            String[] columnDataType = new String[]{"CHAR", "CHAR", "BIGINT"};
            int[] columnDataMaxLength = new int[]{50, 50, 0};
            Object[] columnDefaultValues = new Object[]{"-", "-", 0};
            TableDefinition tableDef = new TableDefinition();
            tableDef.setTableName(ipTableName);
            ColumnDefinition coldef = null;
            for (int i = 0; i < folderDetailscolumnNames.length; ++i) {
                coldef = new ColumnDefinition();
                coldef.setColumnName(folderDetailscolumnNames[i]);
                coldef.setDescription(columnDescription[i]);
                coldef.setDataType(columnDataType[i]);
                if (columnDataMaxLength[i] > 0) {
                    coldef.setMaxLength(columnDataMaxLength[i]);
                }
                coldef.setNullable(false);
                if (columnDefaultValues[i] != null) {
                    coldef.setDefaultValue(columnDefaultValues[i]);
                }
                tableDef.addColumnDefinition(coldef);
            }
            PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
            pkDef.setName(ipTableName + "_PK");
            pkDef.addColumnName(COL_LOGONID);
            pkDef.setTableName(ipTableName);
            tableDef.setPrimaryKey(pkDef);
            CommonUtil.getPersistence(new boolean[0]).createTable("adap", tableDef);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)ipTableName, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(TABLE_SHAREACCESSINFO, criteria);
        if (dataObject.isEmpty()) {
            Row r = new Row(TABLE_SHAREACCESSINFO);
            r.set(COL_DOMAINNAME, (Object)domainName);
            r.set(COL_SERVERNAME, (Object)serverName);
            r.set(COL_IPTABLENAME, (Object)ipTableName);
            DataObject d = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            d.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(d);
        }
    }

    public void tableCountCheck(String domainName, String serverName) {
        block7: {
            try {
                if (disableFileAuditIP != 0) {
                    return;
                }
                serverName = serverName.toLowerCase();
                String tableName = this.getipTableName(domainName, serverName);
                String countQuery = "select count(*) from " + tableName;
                int count = 0;
                try {
                    count = QueryUtil.getRowsCount(countQuery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (count <= tableMaxRows) break block7;
                Long maxValue = (Long)QueryUtil.getMaxValueOfColumn(COL_TIMEGENERATED, tableName);
                ReentrantLock lock = FileAuditIpResolverUtil.getLockVariable(domainName, serverName);
                lock.lock();
                try {
                    Long nowTime = System.currentTimeMillis();
                    String modifiedTableName = tableName.replace("iptable", "ip");
                    String domainName1 = modifiedTableName.split("_")[1];
                    String domainName2 = domainName1.substring(0, 3);
                    modifiedTableName = modifiedTableName.replace(domainName1, domainName2);
                    String serverName1 = modifiedTableName.split("_")[2];
                    String serverName2 = serverName1.length() < 10 ? serverName1 : serverName1.substring(0, 10);
                    modifiedTableName = modifiedTableName.replace(serverName1, serverName2);
                    String newTableName = modifiedTableName + "__" + maxValue + "__" + nowTime;
                    ipTableNamesCache.remove(tableName);
                    reportLogger.log(Level.INFO, "FileAuditIpResolver :: Renaming table " + tableName + " to " + newTableName);
                    MoveRecreateTableHandler.getInstance().renameTable(tableName, newTableName);
                    Criteria c = new Criteria(Column.getColumn((String)TABLE_SHAREACCESSINFO, (String)COL_IPTABLENAME), (Object)tableName, 0);
                    UpdateQueryImpl updateQuery = new UpdateQueryImpl(TABLE_SHAREACCESSINFO);
                    updateQuery.setCriteria(c);
                    updateQuery.setUpdateColumn(COL_IPTABLENAME, (Object)newTableName);
                    CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                lock.unlock();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getHostNameforIP(String ipAddress, Row row) {
        if (ipAddress == null || ipAddress.equals("-") || ipAddress.equals("---")) {
            return "-";
        }
        String hostName = "-";
        try {
            hostName = ipAddress.equals("127.0.0.1") || ipAddress.equals("::1") ? (String)row.get("SOURCE") : DNSResolver.getInstance().getHostName(ipAddress).get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostName;
    }
}

