/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaTableHandler {
    private static Pattern tableNamePattern = Pattern.compile("\\$\\{TABLE:([^\\}]*)\\}");

    public static void addMetaTableRow(String tableName, String newTableName, Statement statement) {
        try {
            String selectQuery = "SELECT MIN(TIME_GENERATED) AS START_TIME, MAX(TIME_GENERATED) AS END_TIME, MIN(UNIQUE_ID) AS START_INDEX, MAX(UNIQUE_ID) AS END_INDEX FROM " + newTableName;
            ResultSet resultSet = QueryUtil.executeQuery("Get Start End Values", statement, selectQuery);
            Long startTime = 0L;
            Long endTime = 0L;
            Long startIndex = 0L;
            Long endIndex = 0L;
            while (resultSet.next()) {
                startTime = resultSet.getLong("START_TIME");
                endTime = resultSet.getLong("END_TIME");
                startIndex = resultSet.getLong("START_INDEX");
                endIndex = resultSet.getLong("END_INDEX");
            }
            boolean b = false;
            if (newTableName != null && newTableName.contains("_0_")) {
                b = true;
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("AUDMetaTable");
            row.set("TABLE_NAME", (Object)tableName);
            row.set("START_TIME", (Object)startTime);
            row.set("END_TIME", (Object)endTime);
            row.set("START_INDEX", (Object)startIndex);
            row.set("END_INDEX", (Object)endIndex);
            row.set("LOOKUP_TABLENAME", (Object)newTableName);
            row.set("STATUS", (Object)"SUCCESS");
            row.set("IMPORT_TABLE", (Object)b);
            row.set("ACTIVE_TABLE", (Object)true);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> getTableList(String baseTableName, long time) {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add(baseTableName);
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)time, 6);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)time, 4));
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)baseTableName, 0));
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMetaTable", criteria);
            Iterator rowIterator = dataObject.getRows("AUDMetaTable");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                tableList.add((String)row.get("LOOKUP_TABLENAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTableNames(String constructedSQL, HashMap inputParamsMap) {
        Connection connection = null;
        DataSet dataSet = null;
        DataSet dataSet2 = null;
        RelationalAPI relAPI = RelationalAPI.getInstance();
        ArrayList<String[]> tableList = new ArrayList<String[]>();
        String[] tableNameList = null;
        try {
            connection = relAPI.getConnection();
            if (inputParamsMap != null && !inputParamsMap.isEmpty()) {
                String from = (String)inputParamsMap.get("FROM");
                String to = (String)inputParamsMap.get("TO");
                Matcher match = tableNamePattern.matcher(constructedSQL);
                String tableName = "";
                String tempTableName = null;
                while (match.find()) {
                    String matchStr = match.group();
                    tableName = matchStr.replace("${TABLE:", "");
                    tableName = tableName.replace("}", "");
                    if (tempTableName != null && tableName.equalsIgnoreCase(tempTableName)) continue;
                    tempTableName = tableName;
                    ArrayList<String> subTableList = new ArrayList<String>();
                    String compareTableName = "AUDMetaTable";
                    SelectQueryImpl stquery = new SelectQueryImpl(Table.getTable((String)compareTableName));
                    Criteria crit = new Criteria(Column.getColumn((String)compareTableName, (String)"TABLE_NAME"), (Object)tableName, 0);
                    crit = crit.or(new Criteria(Column.getColumn((String)compareTableName, (String)"TABLE_NAME"), (Object)(tableName + "_0"), 0));
                    crit = crit.and(new Criteria(Column.getColumn((String)compareTableName, (String)"ACTIVE_TABLE"), (Object)true, 0));
                    String compareTableName1 = "AUDBackUpMetaTable";
                    SelectQueryImpl stquery1 = new SelectQueryImpl(Table.getTable((String)compareTableName1));
                    Criteria crit1 = MetaTableHandler.getCriteria(compareTableName1, tableName, true);
                    if (from != null && !from.equals("") && to != null && !to.equals("")) {
                        String lookUpTableName;
                        crit = MetaTableHandler.getCriteria(crit, compareTableName, from, to);
                        crit1 = MetaTableHandler.getCriteria(crit1, compareTableName1, from, to);
                        stquery.setCriteria(crit);
                        stquery.addSelectColumn(Column.getColumn((String)compareTableName, (String)"TABLE_NAME"));
                        stquery.addSelectColumn(Column.getColumn((String)compareTableName, (String)"LOOKUP_TABLENAME"));
                        stquery.addSortColumn(new SortColumn(Column.getColumn((String)compareTableName, (String)"END_TIME"), false));
                        stquery1.setCriteria(crit1);
                        stquery1.addSelectColumn(Column.getColumn((String)compareTableName1, (String)"TABLE_NAME"));
                        stquery1.addSelectColumn(Column.getColumn((String)compareTableName1, (String)"LOOKUP_TABLENAME"));
                        stquery1.addSortColumn(new SortColumn(Column.getColumn((String)compareTableName1, (String)"END_TIME"), false));
                        dataSet = relAPI.executeQuery((Query)stquery, connection);
                        while (dataSet.next()) {
                            lookUpTableName = dataSet.getString("LOOKUP_TABLENAME");
                            subTableList.add(lookUpTableName);
                        }
                        dataSet2 = relAPI.executeQuery((Query)stquery1, connection);
                        while (dataSet2.next()) {
                            lookUpTableName = dataSet2.getString("LOOKUP_TABLENAME");
                            subTableList.add(lookUpTableName);
                        }
                    }
                    ArrayList<String> list = MetaTableHandler.getActiveTableList(tableName, subTableList);
                    int count = 0;
                    tableNameList = new String[list.size()];
                    Iterator<String> i$ = subTableList.iterator();
                    while (i$.hasNext()) {
                        String object;
                        tableNameList[count] = object = i$.next();
                        ++count;
                    }
                    tableList.add(tableNameList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (dataSet2 != null) {
                    dataSet2.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return tableList;
    }

    public static ArrayList<String> getActiveTableList(String tableName, ArrayList<String> list) {
        ArrayList<String> tableList = list;
        try {
            Row row;
            tableList.add(tableName);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)(tableName + "_0"), 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"ACTIVE_TABLE"), (Object)true, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMetaTable", crit);
            if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("AUDMetaTable")) != null) {
                tableList.add(tableName + "_0");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableList;
    }

    private static Criteria getCriteria(String compareTableName, String tableName, boolean isRegenerated) {
        return MetaTableHandler.getCriteria(compareTableName, new String[]{tableName}, isRegenerated);
    }

    private static Criteria getCriteria(String compareTableName, String[] tableName, boolean isRegenerated) {
        Criteria crit = new Criteria(Column.getColumn((String)compareTableName, (String)"TABLE_NAME"), (Object)tableName, 8);
        crit = crit.or(new Criteria(Column.getColumn((String)compareTableName, (String)"TABLE_NAME"), (Object)MetaTableHandler.convertTableNames(tableName), 8));
        crit = crit.and(new Criteria(Column.getColumn((String)compareTableName, (String)"IS_REGENERATE_DATA"), (Object)isRegenerated, 0));
        return crit;
    }

    private static String[] convertTableNames(String[] tableName) {
        String[] tableNames = new String[tableName.length];
        for (int i = 0; i < tableName.length; ++i) {
            tableNames[i] = tableName[i] + "_0";
        }
        return tableNames;
    }

    public static Criteria getCriteria(Criteria crit, String comparetableName, String from, String to) {
        try {
            Criteria criteria1 = new Criteria(Column.getColumn((String)comparetableName, (String)"START_TIME"), (Object)from, 4);
            criteria1 = criteria1.and(new Criteria(Column.getColumn((String)comparetableName, (String)"START_TIME"), (Object)to, 6));
            Criteria criteria2 = new Criteria(Column.getColumn((String)comparetableName, (String)"END_TIME"), (Object)from, 4);
            criteria2 = criteria2.and(new Criteria(Column.getColumn((String)comparetableName, (String)"END_TIME"), (Object)to, 6));
            Criteria criteria4 = new Criteria(Column.getColumn((String)comparetableName, (String)"START_TIME"), (Object)from, 6);
            criteria4 = criteria4.and(new Criteria(Column.getColumn((String)comparetableName, (String)"END_TIME"), (Object)from, 4));
            Criteria criteria5 = new Criteria(Column.getColumn((String)comparetableName, (String)"START_TIME"), (Object)to, 4);
            criteria5 = criteria5.and(new Criteria(Column.getColumn((String)comparetableName, (String)"END_TIME"), (Object)to, 6));
            Criteria criteria6 = criteria1.or(criteria2).or(criteria4).or(criteria5);
            crit = crit.and(criteria6);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    public static List<String> getMetaTableList(Integer days) {
        ArrayList<String> tableNameList = new ArrayList<String>();
        try {
            String[] metaTableList = new String[]{"AUDMetaTable", "AUDBackUpMetaTable"};
            Long timePeriod = days.longValue() * 86400L;
            Long fromTime = System.currentTimeMillis() / 1000L - timePeriod;
            for (String tableName : metaTableList) {
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)fromTime, 7);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)0, 5));
                if (tableName.equalsIgnoreCase("AUDBackUpMetaTable")) {
                    crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_REGENERATE_DATA"), (Object)true, 0));
                }
                selectQuery.setCriteria(crit);
                selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"TABLE_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"LOOKUP_TABLENAME"));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                    tableNameList.add(lookupTableName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableNameList;
    }

    public static DataObject getArchivedTableDetails(String fromVal, String toVal, ArrayList<String> tableNames) throws Exception {
        Criteria crit = MetaTableHandler.getCriteria("AUDBackUpMetaTable", tableNames.toArray(new String[tableNames.size()]), false);
        crit = MetaTableHandler.getCriteria(crit, "AUDBackUpMetaTable", fromVal, toVal);
        SelectQueryImpl stquery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
        stquery.setCriteria(crit);
        stquery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"END_TIME"), false));
        stquery.addSelectColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)stquery);
        return dataObject;
    }
}

