/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.adapter.SQLGenerator;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.mysql.tools.ConnectionUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MoveRecreateTableHandler {
    private static MoveRecreateTableHandler moveRecreateTableHandler = null;
    private static Logger logger = Logger.getLogger("ADMangLogger");
    private RelationalAPI relationalAPI = null;
    private static HashMap createTableCache = new HashMap();
    private static final HashMap<String, String[]> INDEXMAP = new HashMap();

    private MoveRecreateTableHandler() {
        createTableCache = new HashMap();
        this.relationalAPI = RelationalAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoveRecreateTableHandler getInstance() {
        if (moveRecreateTableHandler != null) return moveRecreateTableHandler;
        Class<MoveRecreateTableHandler> clazz = MoveRecreateTableHandler.class;
        synchronized (MoveRecreateTableHandler.class) {
            if (moveRecreateTableHandler != null) return moveRecreateTableHandler;
            moveRecreateTableHandler = new MoveRecreateTableHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return moveRecreateTableHandler;
        }
    }

    public Integer getRowCount(String tableName) {
        String query = "SELECT COUNT(UNIQUE_ID) FROM " + tableName;
        return QueryUtil.getRowsCount(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveRecreateTable(String tableName) {
        Connection connection = null;
        Statement statement = null;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            String createSyntax = null;
            createSyntax = this.getCreateTableSyntax(tableName, connection, statement, dbServerName);
            logger.log(Level.INFO, "Create table Syntax for [{0}] is [{1}]", new Object[]{tableName, createSyntax});
            if (createSyntax != null) {
                Long currentTime = System.currentTimeMillis();
                String newTableName = tableName + "_" + currentTime;
                String alterTableQuery = null;
                if (dbServerName.equalsIgnoreCase("mssql")) {
                    alterTableQuery = "EXEC SP_RENAME " + tableName + ", " + newTableName + ";EXEC SP_RENAME " + tableName + "_PK , " + newTableName + "_PK";
                } else if (dbServerName.equalsIgnoreCase("mysql")) {
                    alterTableQuery = "ALTER TABLE " + tableName + " RENAME " + newTableName;
                } else if (dbServerName.equalsIgnoreCase("postgres")) {
                    String renameIndex = this.renameIndexes(tableName, currentTime);
                    alterTableQuery = renameIndex + "ALTER TABLE " + tableName + " RENAME TO " + newTableName;
                }
                QueryUtil.executeUpdate("Renaming Table", statement, alterTableQuery);
                logger.log(Level.INFO, "After Rename table  [{0}] as [{1}]", new Object[]{tableName, newTableName});
                MetaTableHandler.addMetaTableRow(tableName, newTableName, statement);
                QueryUtil.executeUpdate("Recreating Table", statement, createSyntax);
                logger.log(Level.INFO, "Creating new  table [{0}]", new Object[]{tableName});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTable(String tableName) {
        boolean isCreated = false;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            String createTableSyntax = this.getPSQLCreateTableSyntax(tableName, CommonUtil.getDBServerName());
            if (createTableSyntax != null) {
                logger.log(Level.INFO, "Creating table {0}", new String[]{tableName});
                logger.log(Level.INFO, "Create table syntax {0}", new String[]{createTableSyntax});
                QueryUtil.executeUpdate("Creating table " + tableName, statement, createTableSyntax);
                isCreated = true;
            }
        }
        catch (Exception e) {
            isCreated = false;
            logger.log(Level.INFO, "Error in Creating table {0}", new String[]{tableName});
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return isCreated;
    }

    private String getCreateTableSyntax(String tableName, Connection connection, Statement statement, String dbServerName) throws Exception {
        String createSyntax = (String)createTableCache.get(tableName);
        if (createSyntax != null) {
            logger.log(Level.INFO, "Create Table Syntax Not Null");
            return createSyntax;
        }
        createSyntax = dbServerName.equalsIgnoreCase("mysql") ? this.getCreateTableSyntax(tableName, connection, statement) : this.getPSQLCreateTableSyntax(tableName, dbServerName);
        if (createSyntax != null) {
            createTableCache.put(tableName, createSyntax);
        }
        return createSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCreateTableSyntax(String tableName, Connection connection, Statement statement) {
        logger.log(Level.INFO, "Create Table Syntax is Null, getting from DB");
        String createSyntax = null;
        ResultSet resultSet = null;
        try {
            String sql = "SHOW CREATE TABLE " + tableName;
            resultSet = QueryUtil.executeQuery("Dropping and Re-Creating Tablet tables", statement, sql);
            while (resultSet.next()) {
                createSyntax = resultSet.getString(2);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exp) {
                resultSet = null;
            }
        }
        return createSyntax;
    }

    public String getPSQLCreateTableSyntax(String tableName, String dbServerName) {
        logger.log(Level.INFO, "Create Table Syntax is Null, getting from DB");
        String createTableSyntax = null;
        try {
            DBAdapter dbAdapter = ConnectionUtil.getDBAdapter(dbServerName);
            dbAdapter.setSQLGenerator((SQLGenerator)Class.forName(this.getSQLGeneratorName(dbServerName)).newInstance());
            TableDefinition tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName);
            if (tableDefinition != null) {
                createTableSyntax = dbAdapter.getSQLGenerator().getSQLForCreateTable(tableDefinition);
                logger.log(Level.INFO, "create table Syntax is " + createTableSyntax);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return createTableSyntax;
    }

    private String getSQLGeneratorName(String dbServerName) {
        String sqlGenName = "com.adventnet.db.adapter.postgres.PostgresSQLGenerator";
        if (dbServerName.equalsIgnoreCase("mssql")) {
            sqlGenName = "com.adventnet.db.adapter.mssql.MssqlSQLGenerator";
        } else if (dbServerName.equalsIgnoreCase("mysql")) {
            sqlGenName = "com.adventnet.sym.adsm.common.server.mysql.ADSMMysqlSQLGenerator";
        }
        return sqlGenName;
    }

    private String renameIndexes(String tableName, Long currentTime) throws Exception {
        String alterIndex = "ALTER INDEX " + tableName + "_PK RENAME TO " + tableName + "_" + currentTime + "_PK;";
        String[] indexes = INDEXMAP.get(tableName) != null ? INDEXMAP.get(tableName) : new String[]{};
        for (int i = 0; i < indexes.length; ++i) {
            alterIndex = alterIndex + "ALTER INDEX " + indexes[i] + " RENAME TO " + indexes[i] + "_" + currentTime + ";";
        }
        logger.log(Level.INFO, "alterIndex is " + alterIndex);
        return alterIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTable(String tableName, String newTableName) {
        Connection connection = null;
        Statement statement = null;
        boolean ret = false;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            String alterTableQuery = null;
            if (dbServerName.equalsIgnoreCase("mssql")) {
                alterTableQuery = "EXEC SP_RENAME " + tableName + " , " + newTableName;
                QueryUtil.executeUpdate("Renaming Table", statement, alterTableQuery);
                QueryUtil.executeUpdate("EXEC SP_RENAME " + tableName + "_PK , " + newTableName + "_PK");
            } else if (dbServerName.equalsIgnoreCase("mysql")) {
                alterTableQuery = "ALTER TABLE " + tableName + " RENAME " + newTableName;
                QueryUtil.executeUpdate("Renaming Table", statement, alterTableQuery);
            } else if (dbServerName.equalsIgnoreCase("postgres")) {
                String renameIndex = "ALTER INDEX " + tableName + "_PK RENAME TO " + newTableName + "_PK ; ";
                alterTableQuery = renameIndex + "ALTER TABLE " + tableName + " RENAME TO " + newTableName;
                QueryUtil.executeUpdate("Renaming Table", statement, alterTableQuery);
            }
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewTable(String tableName) {
        boolean isCreated = false;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            String createTableSyntax = null;
            createTableSyntax = this.getPSQLCreateTableSyntax(tableName, CommonUtil.getDBServerName());
            if (createTableSyntax != null) {
                logger.log(Level.INFO, "Creating table {0}", new String[]{tableName});
                logger.log(Level.INFO, "Create table syntax {0}", new String[]{createTableSyntax});
                QueryUtil.executeUpdate("Creating table " + tableName, statement, createTableSyntax);
                isCreated = true;
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists") || e.getMessage().contains("There is already an object named")) {
                isCreated = true;
                logger.log(Level.INFO, "IPTable Already exists {0}", new String[]{tableName});
            } else {
                isCreated = false;
                logger.log(Level.INFO, "Error in Creating table {0}", new String[]{tableName});
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return isCreated;
    }

    static {
        INDEXMAP.put("AUDLogonInfo", new String[]{"TIME_GENERATED_AUDLogonInfo", "RECORD_NUMBER_AUDLogonInfo", "USER_SID_AUDLogonInfo"});
        INDEXMAP.put("AUDLogonLogoffInfo", new String[]{"TIME_GNRTD_AUDLogonLogoffInfo", "USERNAME_AUDLogonLogoffInfo", "LOGON_TYPE_AUDLogonLogoffInfo", "SOURCE_AUDLogonLogoffInfo"});
        INDEXMAP.put("AUDAccountCreation", new String[]{"TIME_GENERATED_AUDAcntCrtn", "RECORD_NUMBER_AUDAcntCrtn", "ACCOUNT_SID_AUDAcntCrtn", "CALLER_USER_SID_AUDAcntCrtn"});
        INDEXMAP.put("AUDUserMgmt", new String[]{"TIME_GENERATED_AUDUserMgmt", "RECORD_NUMBER_AUDUserMgmt", "ACCOUNT_SID_AUDUserMgmt", "CALLER_USER_SID_AUDUserMgmt"});
        INDEXMAP.put("AUDGroupMgmt", new String[]{"TIME_GENERATED_AUDGroupMgmt", "RECORD_NUMBER_AUDGroupMgmt", "ACCOUNT_SID_AUDGroupMgmt", "CALLER_USER_SID_AUDGroupMgmt"});
        INDEXMAP.put("AUDComputerMgmt", new String[]{"TIME_GENERATED_AUDCompMgmt", "RECORD_NUMBER_AUDCompuMgmt", "ACCOUNT_SID_AUDCompuMgmt", "CALLER_USER_SID_AUDCompMgmt"});
        INDEXMAP.put("AUDPolicyChange", new String[]{"TIME_GENERATED_AUDPolicyCng", "RECORD_NUMBER_AUDPolicyCng", "CALLER_USER_SID_AUDPolicyCng"});
        INDEXMAP.put("AUDOUMgmt", new String[]{"TIME_GENERATED_AUDOUMgmt", "RECORD_NUMBER_AUDOUMgmt"});
        INDEXMAP.put("AUDGPOMgmt", new String[]{"TIME_GENERATED_AUDGPOMgmt", "RECORD_NUMBER_AUDGPOMgmt"});
        INDEXMAP.put("AUDFileAuditInfo", new String[]{"TIME_GENERATED_AUDFileAudit", "RECORD_NUMBER_AUDFileAudit", "ACCESS_TYPE_AUDFileAudit", "SOURCE_AUDFileAudit", "USERNAME_AUDFileAudit"});
        INDEXMAP.put("AUDComputerAuditInfo", new String[]{"TIME_GENERATED_AUDCompInfo", "RECORD_NUMBER_AUDCompInfo"});
        INDEXMAP.put("AUDNPSAuditInfo", new String[]{"TIME_GENERATED_AUDNPSAuditInf", "RECORD_NUMBER_AUDNPSAuditInfo"});
        INDEXMAP.put("AUDFileIntegrityMonitor", new String[]{"TIME_GENERATED_AUD_FIM", "RECORD_NUMBER_AUD_FIM", "ACCESS_TYPE_AUD_FIM", "SOURCE_AUD_FIM", "USERNAME_AUD_FIM"});
        INDEXMAP.put("AUDADOAuditInfo", new String[]{"TIME_GENERATED_AUDADOAuditinfo", "RECORD_NUMBER_AUDADOAuditinfo"});
        INDEXMAP.put("AUDDNSAuditInfo", new String[]{"TIME_GENERATED_AUDDNSAuditInfo", "RECORD_NUMBER_AUDDNSAuditInfo"});
        INDEXMAP.put("AUDADFSLogonLogoffInfo", new String[]{"TIME_GENERATED_AUDADFSLogonLogoffInfo", "USERNAME_AUDADFSLogonLogoffInfo", "RECORD_NUMBER_AUDADFSLogonLogoffInfo", "SOURCE_AUDADFSLogonLogoffInfo"});
        INDEXMAP.put("AUDLogonInfo_0", new String[]{"TIME_GENERATED_AUDLogonInfo_0", "RECORD_NUMBER_AUDLogonInfo_0", "USER_SID_AUDLogonInfo_0"});
        INDEXMAP.put("AUDLogonLogoffInfo_0", new String[]{"TIME_GNRTD_AUDLogonLogoffInfo_0", "USERNAME_AUDLogonLogoffInfo_0", "LOGON_TYPE_AUDLogonLogoffInfo_0", "SOURCE_AUDLogonLogoffInfo_0"});
        INDEXMAP.put("AUDAccountCreation_0", new String[]{"TIME_GENERATED_AUDAcCrtn_0", "RECORD_NUMBER_AUDAcCrtn_0", "ACCOUNT_SID_AUDAcCrtn_0", "CALLER_USER_SID_AUDAcCrtn_0"});
        INDEXMAP.put("AUDUserMgmt_0", new String[]{"TIME_GENERATED_AUDUserMgmt_0", "RECORD_NUMBER_AUDUserMgmt_0", "ACCOUNT_SID_AUDUserMgmt_0", "CALLER_USER_SID_AUDUserMgmt_0"});
        INDEXMAP.put("AUDGroupMgmt_0", new String[]{"TIME_GENERATED_AUDGroupMgmt_0", "RECORD_NUMBER_AUDGroupMgmt_0", "ACCOUNT_SID_AUDGroupMgmt_0", "CALLER_USER_SID_AUDGroupMgmt_0"});
        INDEXMAP.put("AUDComputerMgmt_0", new String[]{"TIME_GENERATED_AUDCompMgmt_0", "RECORD_NUMBER_AUDCompuMgmt_0", "ACCOUNT_SID_AUDCompuMgmt_0", "CALLER_USER_SID_AUDCompMgmt_0"});
        INDEXMAP.put("AUDPolicyChange_0", new String[]{"TIME_GENERATED_AUDPocyCng_0", "RECORD_NUMBER_AUDPoliCng_0", "CALLER_USER_SID_AUDPoliCng_0"});
        INDEXMAP.put("AUDOUMgmt_0", new String[]{"TIME_GENERATED_AUDOUMgmt_0", "RECORD_NUMBER_AUDOUMgmt_0"});
        INDEXMAP.put("AUDGPOMgmt_0", new String[]{"TIME_GENERATED_AUDGPOMgmt_0", "RECORD_NUMBER_AUDGPOMgmt_0"});
        INDEXMAP.put("AUDFileAuditInfo_0", new String[]{"TIME_GENERATED_AUDFileAudit_0", "RECORD_NUMBER_AUDFileAudit_0", "ACCESS_TYPE_AUDFileAudit_0", "SOURCE_AUDFileAudit_0", "USERNAME_AUDFileAudit_0"});
        INDEXMAP.put("AUDComputerAuditInfo_0", new String[]{"TIME_GENERATED_AUDCmInfo_0", "RECORD_NUMBER_AUDCmInfo_0"});
        INDEXMAP.put("AUDNPSAuditInfo_0", new String[]{"TIME_GENERATED_AUDNPSAudInf_0", "RECORD_NUMBER_AUDNPSAudInfo_0"});
        INDEXMAP.put("AUDFileIntegrityMonitor_0", new String[]{"TIME_GENERATED_AUD_FIM_0", "RECORD_NUMBER_AUD_FIM_0", "ACCESS_TYPE_AUD_FIM_0", "SOURCE_AUD_FIM_0", "USERNAME_AUD_FIM_0"});
        INDEXMAP.put("AUDADOAuditInfo_0", new String[]{"TIME_GENERATED_AUDADOAuditinfo_0", "RECORD_NUMBER_AUDADOAuditinfo_0"});
        INDEXMAP.put("AUDDNSAuditInfo_0", new String[]{"TIME_GENERATED_AUDDNSAuditInfo_0", "RECORD_NUMBER_AUDDNSAuditInfo_0"});
        INDEXMAP.put("AUDADFSLogonLogoffInfo_0", new String[]{"TIME_GENERATED_AUDADFSLogonLogoffInfo_0", "USERNAME_AUDADFSLogonLogoffInfo_0", "RECORD_NUMBER_AUDADFSLogonLogoffInfo_0", "SOURCE_AUDADFSLogonLogoffInfo_0"});
    }
}

