/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WindowsDirUtil {
    private static Logger logger = Logger.getLogger("EventLogger");

    public static Properties getWindowsDirectory(String dcName, Properties domainDetails) throws Exception {
        HashMap propMap = EventDataUtil.getComputerProperties(domainDetails.getProperty("DOMAIN_NAME"), dcName);
        Properties properties = null;
        try {
            properties = WindowsDirUtil.getWindowsDirFromDB(dcName, domainDetails.getProperty("DOMAIN_NAME"), propMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (properties == null || properties.getProperty("OSArchitecture") == null) {
            boolean isFetchModeAlreadySet = true;
            String fetchMode = "0";
            if (properties == null) {
                isFetchModeAlreadySet = false;
            } else {
                fetchMode = properties.getProperty("EventFetchMode");
            }
            String userName = null;
            String passwd = null;
            if (!domainDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("false")) {
                logger.log(Level.INFO, "Inside setting username details..");
                userName = (String)domainDetails.get("USER_NAME");
                passwd = (String)domainDetails.get("PASSWORD");
            }
            logger.log(Level.INFO, "Getting Windows Directory from Native for Domain Controller :" + dcName);
            String[] prop = new String[]{"Name", "WindowsDirectory", "Version", "OSArchitecture"};
            String domainName = domainDetails.getProperty("DOMAIN_NAME");
            logger.log(Level.FINE, "New invocation " + domainName);
            ArrayList list = ADHandler.getWindowsDirectory(dcName, domainName, userName, passwd, prop, "select * from Win32_OperatingSystem", null, 0, 0);
            if (list != null && list.size() > 0) {
                properties = (Properties)list.get(0);
            }
            if (!isFetchModeAlreadySet) {
                if (EventCollectionUtil.useLocalMessageDLL() || properties.getProperty("Version").startsWith("6.1")) {
                    properties.setProperty("EventFetchMode", "1");
                } else {
                    properties.setProperty("EventFetchMode", "0");
                }
                logger.log(Level.INFO, "Fetch Mode Set for the 1st time");
            } else {
                properties.setProperty("EventFetchMode", fetchMode);
            }
            properties.setProperty("IsFIMEnabled", "1");
            WindowsDirUtil.updateWindowsDir(dcName, domainDetails.getProperty("DOMAIN_NAME"), properties, propMap);
        }
        return properties;
    }

    public static Properties getWindowsDirFromDB(String dcName, String domainName, HashMap propMap) throws Exception {
        logger.log(Level.FINE, "propMap in getWindowsDirFromDB is " + propMap);
        Properties windowsProps = null;
        String baseTableName = (String)propMap.get("BASE_TABLE_NAME");
        String tableName = (String)propMap.get("EVENT_TABLE_NAME");
        String dcColumnName = (String)propMap.get("CRITERIA_COLUMN_NAME");
        String joinColumnName = (String)propMap.get("JOIN_COLUMN_NAME");
        Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)dcColumnName), (Object)dcName, 0);
        criteria = criteria.and(Column.getColumn((String)tableName, (String)"WINDOWS_DIR"), null, 1);
        Join join = new Join(baseTableName, tableName, new String[]{joinColumnName}, new String[]{joinColumnName}, 2);
        Table baseTable = Table.getTable((String)baseTableName);
        SelectQueryImpl query = new SelectQueryImpl(baseTable);
        query.addJoin(join);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Row row = null;
        if (dataObject.size(tableName) > 0) {
            row = dataObject.getRow(tableName);
        }
        if (row != null) {
            windowsProps = new Properties();
            windowsProps.setProperty("WindowsDirectory", (String)row.get("WINDOWS_DIR"));
            windowsProps.setProperty("Name", (String)row.get("OS_NAME"));
            windowsProps.setProperty("Version", (String)row.get("OS_VERSION"));
            windowsProps.setProperty("EventFetchMode", row.get("EVENT_FETCH_MODE").toString());
            windowsProps.setProperty("IsFIMEnabled", row.get("IS_FIM_ENABLED").toString());
            if ((String)row.get("OS_ARCHITECTURE") != null) {
                windowsProps.setProperty("OSArchitecture", (String)row.get("OS_ARCHITECTURE"));
            } else {
                logger.log(Level.WARNING, "Error while updating dc Windows Dir in DB");
            }
        }
        return windowsProps;
    }

    private static void updateWindowsDir(String dcName, String domainName, Properties properties, HashMap propMap) {
        try {
            String dcTable = (String)propMap.get("BASE_TABLE_NAME");
            String eventTable = (String)propMap.get("EVENT_TABLE_NAME");
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(dcTable);
            tableList.add(eventTable);
            Criteria criteria = new Criteria(Column.getColumn((String)dcTable, (String)((String)propMap.get("CRITERIA_COLUMN_NAME"))), (Object)dcName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            Row row = null;
            if (dataObject.size(eventTable) > 0) {
                row = dataObject.getRow(eventTable);
            }
            if (row != null) {
                row.set("OS_NAME", (Object)properties.getProperty("Name"));
                row.set("WINDOWS_DIR", (Object)properties.getProperty("WindowsDirectory"));
                row.set("OS_VERSION", (Object)properties.getProperty("Version"));
                Short eventFetchMode = 1;
                if (properties.getProperty("EventFetchMode").equals(0)) {
                    eventFetchMode = 0;
                }
                row.set("EVENT_FETCH_MODE", (Object)eventFetchMode);
                if (properties.getProperty("Version").startsWith("6.")) {
                    row.set("OS_ARCHITECTURE", (Object)properties.getProperty("OSArchitecture"));
                } else if (properties.getProperty("Name").contains("x64")) {
                    properties.setProperty("OSArchitecture", "64-bit");
                    row.set("OS_ARCHITECTURE", (Object)"64-bit");
                } else {
                    properties.setProperty("OSArchitecture", "32-bit");
                    row.set("OS_ARCHITECTURE", (Object)"32-bit");
                }
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while updating dc Windows Dir in DB");
            e.printStackTrace();
        }
    }

    public static String getLocalMachineArch() {
        String localmcarch = "32-bit";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"LOCAL_MC_ARCH", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            Row row = dataObject.getRow("SystemParams");
            localmcarch = (String)row.get("PARAM_VALUE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localmcarch;
    }

    public static String getLocalWindowsDir(Properties domainDetails) {
        String localWindowsDir = "";
        Properties properties = null;
        String osArch = null;
        String osName = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"LOCAL_WIN_DIR", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (dataObject.isEmpty()) {
                String userName = null;
                String passwd = null;
                logger.log(Level.INFO, "Getting Windows Directory for Local machine");
                String[] prop = new String[]{"Name", "WindowsDirectory", "Version", "OSArchitecture"};
                String domainName = domainDetails.getProperty("DOMAIN_NAME");
                ArrayList list = ADHandler.getWindowsDirectory("localhost", domainName, userName, passwd, prop, "select * from Win32_OperatingSystem", null, 0, 0);
                if (list != null && list.size() > 0) {
                    properties = (Properties)list.get(0);
                }
                logger.log(Level.INFO, "Local Windows Properties " + properties);
                localWindowsDir = properties.getProperty("WindowsDirectory");
                osArch = properties.getProperty("OSArchitecture");
                osName = properties.getProperty("Name");
                if (osArch != null && (osArch.contains("64") || osArch.contains("32"))) {
                    if (osArch.contains("64")) {
                        localWindowsDir = localWindowsDir.concat("\\syswow64");
                    } else if (osArch.contains("32")) {
                        localWindowsDir = localWindowsDir.concat("\\system32");
                    }
                } else {
                    localWindowsDir = osName.contains("x64") ? localWindowsDir.concat("\\syswow64") : localWindowsDir.concat("\\system32");
                }
                Row row = new Row("SystemParams");
                row.set("PARAM_NAME", (Object)"LOCAL_WIN_DIR");
                row.set("PARAM_VALUE", (Object)localWindowsDir);
                DataObject newDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                newDataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(newDataObject);
            } else {
                Row row = dataObject.getRow("SystemParams");
                localWindowsDir = (String)row.get("PARAM_VALUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Local windows Dir " + localWindowsDir);
        return localWindowsDir;
    }
}

