/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.auditing.server.gpo.PDCHandler;
import com.adventnet.sym.adsm.auditing.server.printAudit.PrintServerEnabled;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.export.AuditGPOCsvWriter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.ntfs.ExcludeFilesHandler;
import com.adventnet.sym.adsm.common.server.ntfs.PrintSystemAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.sun.jndi.ldap.LdapName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;

public final class ADHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger nativeLogger = Logger.getLogger("ADSMLogger");
    private static Logger admangLogger = Logger.getLogger("ADMangLogger");
    private static Logger delegLogger = Logger.getLogger("DelegLogger");
    private static Logger logger = Logger.getLogger(ADHandler.class.getName());
    private static final String LIBRARY_NAME = "ADSMSecurity";
    private static final String MANAGED_LIBRARY_NAME = "ADSMManaged";
    private static ADHandler handler = null;
    private static boolean dllLoaded = false;

    public static boolean isdebugLogLevel() {
        String loglevel = "";
        boolean isdebug = false;
        try {
            loglevel = ADSMPersUtil.getCurrentLogLevel();
            isdebug = loglevel.equalsIgnoreCase("DEBUG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isdebug;
    }

    public static void log(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        nativeLogger.log(l, message);
    }

    public static void admanglog(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        admangLogger.log(l, message);
    }

    public static void deleglog(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        delegLogger.log(l, message);
    }

    private static native ArrayList<HashMap<Object, Object>> GetLogFileNamesNative(String var0, String var1, String var2, String var3, String var4, String var5, boolean var6, NativeError var7);

    private static native void CopyLogFileNative(String var0, String var1, String var2, String var3, String var4, String var5, NativeError var6) throws Exception;

    public static native String GetOWAMetabasePath(String var0, Properties var1, ArrayList<String> var2, String var3, NativeError var4);

    public static native Properties GetOWALoggingInfo(String var0, Properties var1, ArrayList var2, NativeError var3);

    public static native void SetLogProperty(String var0, Properties var1, ArrayList var2, String var3, NativeError var4);

    public static native String GetErrorMessage(int var0);

    public static String getOWAMetabasePath(String serverDN, Properties credentialMap, ArrayList<String> attributes, String searchString, NativeError ne) {
        String metaBasePath = ADHandler.GetOWAMetabasePath(serverDN, credentialMap, attributes, searchString, ne);
        return metaBasePath;
    }

    public static Properties getOWALoggingInfo(String metabasePath, Properties credentialMap, ArrayList attributeList, NativeError ne) {
        Properties loggingInfo = ADHandler.GetOWALoggingInfo(metabasePath, credentialMap, attributeList, ne);
        return loggingInfo;
    }

    public static void setLogProperty(String metabasePath, Properties credentialMap, ArrayList attributeList, String value, NativeError ne) {
        ADHandler.SetLogProperty(metabasePath, credentialMap, attributeList, value, ne);
    }

    public static String getErrorMessage(int errorCode) {
        return ADHandler.GetErrorMessage(errorCode);
    }

    public static ArrayList<HashMap<Object, Object>> getLogFileNamesNative(String userName, String password, String domainName, String logDirectoryPath, String tempDirectoryPath, String searchPattern, boolean needFileDetails, NativeError ne) {
        ArrayList<HashMap<Object, Object>> logNames = ADHandler.GetLogFileNamesNative(userName, password, domainName, logDirectoryPath, tempDirectoryPath, searchPattern, needFileDetails, ne);
        return logNames;
    }

    public static void copyLogFileNative(String logFileName, String userName, String password, String domainName, String logDirectoryPath, String tempDirectoryPath, NativeError ne) throws Exception {
        ADHandler.CopyLogFileNative(logFileName, userName, password, domainName, logDirectoryPath, tempDirectoryPath, ne);
    }

    public static native String GetServiceStartupType(String var0, NativeError var1);

    public static native void SetServiceStartupType(String var0, boolean var1, NativeError var2);

    public static String getServiceStartupType(String serviceName) throws Exception {
        String type = null;
        try {
            NativeError errHdlr = new NativeError();
            type = ADHandler.GetServiceStartupType(serviceName, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    public static void setServiceStartupType(String serviceName, boolean type) throws Exception {
        try {
            NativeError errHdlr = new NativeError();
            ADHandler.SetServiceStartupType(serviceName, type, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static native ArrayList GetWindowsDirectory(String var0, String var1, String var2, String var3, String[] var4, String var5, Hashtable var6, int var7, int var8, String[][] var9, int[][] var10, NativeError var11);

    private static native Properties GetSharesForServer(Properties var0, NativeError var1, String var2, boolean var3);

    public static Properties getSharesForServer(String domainName, String serverName) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        String takeHiddenShares = ADSMPersUtil.getSyMParameter("TakeHiddenShares");
        Boolean hiddenShares = false;
        if (takeHiddenShares != null && "true".equals(takeHiddenShares)) {
            hiddenShares = true;
        }
        Properties shareList = ADHandler.GetSharesForServer(domainDetails, errHdlr, serverName, hiddenShares);
        if (errHdlr.getErrorMessage(domainName) != null) {
            ADHandler.handleError(errHdlr, domainName);
        } else {
            ADHandler.handleError(errHdlr, serverName);
        }
        return shareList;
    }

    private static native Properties GetPrinterNames(Properties var0, NativeError var1, String var2);

    public static Properties GetPrinterNames(String domainName, String serverName) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        Properties shareList = ADHandler.GetPrinterNames(domainDetails, errHdlr, serverName);
        if (errHdlr.getErrorMessage(domainName) != null) {
            shareList.put("errorCode", errHdlr.getErrorMessage(domainName));
        } else if (errHdlr.getErrorMessage(serverName) != null) {
            shareList.put("errorCode", errHdlr.getErrorMessage(serverName));
        } else if (errHdlr.getErrorMessage("\\\\" + serverName) != null) {
            shareList.put("errorCode", errHdlr.getErrorMessage("\\\\" + serverName));
        }
        return shareList;
    }

    public static native long GetOldestRecordNumber(long var0, String var2, Properties var3, boolean var4, NativeError var5);

    public static native boolean InstallAgent(String var0, String var1, String var2, String var3, String var4, String var5);

    public static native boolean UninstallAgent(String var0, String var1, String var2, String var3);

    public static native boolean StartService(String var0, String var1);

    public static native boolean StartServiceWithAuthentication(String var0, String var1, String var2, String var3);

    public static native long GetSystemRAMSizeInBytes();

    public static boolean uninstallAgent(String computerName, String userName, String password, String destDir) throws Exception {
        return ADHandler.UninstallAgent(computerName, userName, password, destDir);
    }

    public static boolean installAgent(String computerName, String userName, String password, String srcAgentDir, String destAgentDir, String destFolder) throws Exception {
        return ADHandler.InstallAgent(computerName, userName, password, srcAgentDir, destAgentDir, destFolder);
    }

    public static boolean startServiceWithAuthentication(String computerName, String serviceName, String userName, String password) throws Exception {
        return ADHandler.StartServiceWithAuthentication(computerName, serviceName, userName, password);
    }

    public static boolean startService(String computerName, String serviceName) throws Exception {
        return ADHandler.StartService(computerName, serviceName);
    }

    public static ArrayList getWindowsDirectory(String computerName, String domainName, String userName, String password, String[] prop, String wmiClass, Hashtable retHash, int machineType, int isGPO) throws Exception {
        NativeError errHdlr = new NativeError();
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        long x = System.currentTimeMillis();
        ArrayList winProp = ADHandler.GetWindowsDirectory(computerName, domainName, userName, password, prop, wmiClass, retHash, machineType, isGPO, excludeRules, excludeOpList, errHdlr);
        long y = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Time Taken by[" + computerName + "] WMI Mode----> " + (y - x) / 1000L + ".");
        nativeLogger.log(Level.INFO, "WMI ERROR -> " + errHdlr);
        ADHandler.handleError(errHdlr, computerName);
        return winProp;
    }

    public static long getOldestRecordNumber(long recordNumber, String dcName, Properties domainDetails, boolean isFirstFetch) throws Exception {
        NativeError errHdlr = new NativeError();
        long recNum = ADHandler.GetOldestRecordNumber(recordNumber, dcName, domainDetails, isFirstFetch, errHdlr);
        return recNum;
    }

    private static native void InitializeClassIDs();

    public static native void CleanupClassIDs();

    private static native long GetLocaleID(int var0, int var1, NativeError var2);

    private static native Properties GetPasswordPolicy(Properties var0, NativeError var1);

    private static native void GetGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetDisabledGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetUnusedGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetDomainLinkedGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetOULinkedGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetSiteLinkedGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetGPOBlockedInheritanceContainers(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetDisabledUserGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetDisabledComputerGPOs(Properties var0, ArrayList var1, NativeListener var2, NativeError var3);

    private static native void GetRecentlyCreatedGPOs(Properties var0, ArrayList var1, NativeListener var2, String var3, NativeError var4);

    private static native void GetRecentlyModifiedGPOs(Properties var0, ArrayList var1, NativeListener var2, String var3, NativeError var4);

    private static native Properties GetAccountLockOutPolicy(Properties var0, NativeError var1);

    private static native void GetValidDomains();

    public static native ArrayList GetDCName(String var0);

    public static native Properties GetDomainDetails(Properties var0, NativeError var1);

    public static native ArrayList GetMoreMembers(Properties var0, String var1, NativeError var2);

    private static native boolean CreateFolder(Properties var0, String var1, NativeError var2);

    private static native boolean CreateFolderAll(Properties var0, String var1, ArrayList var2, long var3, NativeError var5);

    private static native boolean MoveFolder(Properties var0, String var1, String var2, NativeError var3);

    private static native boolean SetFolderPermission(Properties var0, ArrayList var1, long var2, String var4, NativeError var5);

    private static native ArrayList GetMailBoxRights(Properties var0, String var1, NativeError var2);

    private static native Properties GetShareFolderInfo(Properties var0, String var1, String var2, NativeError var3);

    public static Properties getShareFolderInfo(String serverName, String shareName, String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = new Properties();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        properties = ADHandler.GetShareFolderInfo(domainDetails, serverName, shareName, errHdlr);
        if (errHdlr != null) {
            System.out.println("Share Props errHdlr : " + errHdlr);
        }
        return properties;
    }

    public static boolean createFolder(String domainName, Long loginId, String directoryPath) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        boolean ret = ADHandler.CreateFolder(domainDetails, directoryPath, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return ret;
    }

    public static NativeError createFolder(String domainName, Long loginId, String directoryPath, String trusteeSid, String trusteeDn, ArrayList acList, long inHeritFromParent) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        boolean isFolderCreated = ADHandler.CreateFolderAll(domainDetails, directoryPath, acList, inHeritFromParent, errHdlr);
        if (isFolderCreated) {
            ADHandler.SetFolderPermission(domainDetails, null, inHeritFromParent, directoryPath, errHdlr);
        }
        return errHdlr;
    }

    public static void createFileFolder(String domainName, Long loginId, String directoryPath, String trusteeSid, String trusteeDn) throws Exception {
        NativeError errHdlr = ADHandler.createFolder(domainName, loginId, directoryPath, trusteeSid, trusteeDn, new ArrayList(), 0x20000000L);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static boolean moveFolder(String domainName, Long loginId, String moveFrom, String moveTo) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        boolean ret = ADHandler.MoveFolder(domainDetails, moveFrom, moveTo, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return ret;
    }

    private static native void ShareFolder(Properties var0, String var1, String var2, String var3, ArrayList var4, NativeError var5);

    public static NativeError shareFolder(String domainName, Long loginId, String serverName, String shareName, String localPath, ArrayList aceList) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        ADHandler.ShareFolder(domainDetails, serverName, shareName, localPath, aceList, errHdlr);
        return errHdlr;
    }

    private static native void SetMailBoxPermission(Properties var0, ArrayList var1, String var2, NativeError var3);

    public static NativeError setMailBoxPermission(String domainName, Long loginId, ArrayList aceList, String adsPath) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        ADHandler.SetMailBoxPermission(domainDetails, aceList, adsPath, errHdlr);
        return errHdlr;
    }

    public static long getLocaleID(int primarylangId, int sublangId) throws Exception {
        NativeError errHdlr = new NativeError();
        System.out.println("ADHandler ADHandler ADHandler ADHandler ");
        return ADHandler.GetLocaleID(primarylangId, sublangId, errHdlr);
    }

    private static native Properties GetObjectProperties(Properties var0, String var1, ArrayList var2, NativeError var3);

    public static Properties getObjectProperties(String domainName, Long loginId, String objDN, ArrayList attributeList, String dcName) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.GetObjectProperties(DomainHandler.getConfiguredValues(domainName, loginId, dcName), CommonUtil.escapeDN(objDN), attributeList, errHdlr);
        if (errHdlr != null) {
            ADHandler.handleError(errHdlr, domainName);
        }
        return properties;
    }

    public static Properties getObjectProperties(String domainName, Long loginId, String objDN, ArrayList attributeList) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.GetObjectProperties(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(objDN), attributeList, errHdlr);
        if (errHdlr != null) {
            ADHandler.handleError(errHdlr, domainName);
        }
        return properties;
    }

    private static native Properties GetObjectFromGUID(Properties var0, String var1, ArrayList var2, NativeError var3);

    public static Properties getObjectFromGUID(String domainName, Long loginId, String guid, ArrayList attributeList, String dcName) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.GetObjectFromGUID(DomainHandler.getConfiguredValues(domainName, loginId, dcName), guid, attributeList, errHdlr);
        if (errHdlr != null) {
            ADHandler.handleError(errHdlr, domainName);
        }
        return properties;
    }

    public static void getValidDomains() throws Exception {
        ADHandler.GetValidDomains();
    }

    public static Properties getDomainDetails(String domainName, Long loginId) throws Exception {
        return DomainHandler.getConfiguredValues(domainName, loginId);
    }

    public static void searchSIDs(String domainName, Long loginId, String container, String searchString, NativeListener listener) {
        try {
            NativeError errHdlr = new NativeError();
            ADHandler.SearchSIDs(ADHandler.getDomainDetails(domainName, loginId), container, searchString, listener, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getUser(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) {
        try {
            NativeError errHdlr = new NativeError();
            ADHandler.GetUser(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, searchString, listener, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getObjects(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) throws Exception {
        ADHandler.getObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, searchString, listener);
    }

    public static void getObjects(Properties domainDetails, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetObjects(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, listener, errHdlr);
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList getObjectsWithOutListener(Properties domainDetails, String distinguishedName, ArrayList attributeList, String searchString) {
        ArrayList list = null;
        try {
            NativeError errHdlr = new NativeError();
            list = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static native ArrayList GetObjectsWithOutListenerWithSIDFromGC(Properties var0, ArrayList var1, String var2, NativeError var3);

    private static native ArrayList EnumerateProcessList(Properties var0, String var1, String var2, NativeError var3);

    public static ArrayList enumerateProcessList(Properties domainDetails, String userName, String server, NativeError errHdlr) throws Exception {
        Row r = DirectoryObjectAPI.getInstance().getObjectRowFromDB((String)domainDetails.get("DOMAIN_NAME"), userName, "SAM_ACCOUNT_NAME", "user");
        if (r == null) {
            return new ArrayList();
        }
        String sid = (String)r.get("SID_STRING");
        ArrayList result = ADHandler.EnumerateProcessList(domainDetails, sid, server, errHdlr);
        return result;
    }

    public static ArrayList getObjectsWithoutListenerWithSIDFromGC(String domainName, ArrayList attributeList, String sid) {
        ArrayList list = null;
        try {
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            NativeError errHdlr = new NativeError();
            String rootDomainNamingContext = domainDetails.getProperty("ROOT_DOMAIN_NAMING_CONTEXT");
            try {
                LdapName ldapName = new LdapName(rootDomainNamingContext);
                Enumeration<String> enu = ldapName.getAll();
                String dnsName = null;
                while (enu.hasMoreElements()) {
                    String ele = enu.nextElement();
                    String el = ele.substring(ele.indexOf("=") + 1);
                    if (dnsName == null) {
                        dnsName = el;
                        continue;
                    }
                    dnsName = el + "." + dnsName;
                }
                rootDomainNamingContext = dnsName;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            domainDetails.put("ROOT_DOMAIN_NAMING_CONTEXT", rootDomainNamingContext);
            list = ADHandler.GetObjectsWithOutListenerWithSIDFromGC(domainDetails, attributeList, sid, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getDomainObjectProps(String domainName, ArrayList attributeList, String searchString) {
        ArrayList list = null;
        try {
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            String distinguishedName = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            NativeError errHdlr = new NativeError();
            list = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getOUs(String domainName, Long loginId) {
        ArrayList list = new ArrayList();
        try {
            NativeError errHdlr = new NativeError();
            Properties p = ADHandler.getDomainDetails(domainName, loginId);
            list = ADHandler.GetOUs(p, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getCount(String domainName, Long loginId, String searchString) {
        int count = 0;
        try {
            NativeError errHdlr = new NativeError();
            Properties p = ADHandler.getDomainDetails(domainName, loginId);
            count = ADHandler.GetCount(p, searchString, errHdlr);
            if (errHdlr.getErrorMessage(domainName) != null) {
                count = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    private static native void GetUser(Properties var0, String var1, ArrayList var2, String var3, NativeListener var4, NativeError var5);

    private static native void GetObjects(Properties var0, String var1, ArrayList var2, String var3, NativeListener var4, NativeError var5);

    private static native ArrayList GetObjectsWithOutListener(Properties var0, String var1, ArrayList var2, String var3, NativeError var4);

    private static native void SearchSIDs(Properties var0, String var1, String var2, NativeListener var3, NativeError var4);

    private static native ArrayList GetOUs(Properties var0, NativeError var1);

    private static native int GetCount(Properties var0, String var1, NativeError var2);

    private static native void GetLogonHourReports(Properties var0, String var1, ArrayList var2, NativeListener var3, ArrayList var4, int var5, NativeError var6);

    private static native void GetLogonHourReports(Integer var0, Long var1, Properties var2, String var3, ArrayList var4, NativeListener var5, ArrayList var6, int var7, NativeError var8);

    private static native void GetRecentlyLoggedOnUsers(Properties var0, String var1, String var2, ArrayList var3, long var4, NativeListener var6, NativeError var7);

    private static native void GetRecentlyExpiredUsers(Properties var0, String var1, ArrayList var2, long var3, NativeListener var5, NativeError var6);

    private static native void GetAccountExpiredUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetSoonToExpireUsers(Properties var0, String var1, ArrayList var2, long var3, NativeListener var5, NativeError var6);

    private static native void GetDisabledAccounts(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetEnabledAccounts(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetDialInAccessAllowedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetDialInAccessDeniedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetLockedOutAccounts(Properties var0, String var1, ArrayList var2, NativeListener var3, long var4, NativeError var6);

    private static native void GetUsersWithMultiGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetInActiveUsers(Properties var0, String var1, String var2, long var3, ArrayList var5, NativeListener var6, NativeError var7);

    private static native void GetGroupBasedUsers(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetOMAEnabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetOWADisabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetOWAEnabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetAllGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetMailEnabledGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetPwdNeverExpireUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetNeverLoggedInUsers(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetForwardToBasedUsers(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetUsersWithoutDefaultStorageLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyDeletedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyModifiedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetRecentlyCreatedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetSoonToPasswordExpireUsers(Properties var0, String var1, long var2, long var4, ArrayList var6, NativeListener var7, NativeError var8);

    private static native void GetPasswordExpiredUsers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6);

    private static native void GetUsersWithScopeBasedGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, String var5, NativeError var6);

    private static native void GetUsersWithDistributionGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithSecurityGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithEmptyAttributes(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetManagerBasedUsers(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetUnManagedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetAccountNeverExpiredUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithScriptPath(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithoutScriptPath(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetPOP3DisabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetIMAP4DisabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithDefaultSendingLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithRestrictedSendingLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithDefaultReceivingLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithRestrictedReceivingLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithMessageRestrictions(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithoutMessageRestrictions(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithDefaultStorageLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersHideFromExchAddresslist(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithDefaultRecipLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUsersWithRestrictedRecipLimit(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetProxyAddressBasedUsers(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetProxyAddressBasedGroups(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetMailEnabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetMailBoxEnabledUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyBadLoginUsers(Properties var0, String var1, String var2, long var3, ArrayList var5, NativeListener var6, NativeError var7);

    private static native void GetRecentlyPwdChangedUsers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6);

    private static native void GetRecentlyPwdUnChangedUsers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6);

    private static native void GetPwdNotRequiredUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetCannotChangPwdUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetAllPrinters(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetScopeBasedGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, String var5, NativeError var6);

    private static native void GetDistributionGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetSecurityGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetEmptyGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetManagedGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUnManagedGroups(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native ArrayList GetTopBigGroups(Properties var0, String var1, int var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native void GetNestedGroups(Properties var0, ArrayList var1, NativeListener var2, String var3, NativeError var4);

    private static native ArrayList GetGroups(Properties var0, ArrayList var1, NativeError var2);

    private static native void GetInActiveObjects(Properties var0, String var1, String var2, long var3, ArrayList var5, NativeListener var6, NativeError var7);

    private static native void GetInActiveComputers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6);

    private static native void GetTrustedObjects(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetDisabledObjects(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetComputerObjects(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetDomainControllerObjects(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyModifiedComputers(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetOSBasedComputers(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, String var5, NativeError var6);

    private static native void GetManagedComputers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUnManagedComputers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetAllComputers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetAllOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetGPOLinkedOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetGPOBlockedInheritanceOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetEmptyOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetUserObjectsOU(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetComputerObjectsOU(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyCreatedOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetRecentlyModifiedOUs(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetFilesAndFolders(Properties var0, String var1, String var2, String var3, long var4, ArrayList var6, NativeListener var7, NativeError var8);

    private static native Hashtable GetFolderPermissions(String var0, Properties var1, NativeError var2);

    private static native void GetUsersWithFullControl(Properties var0, String var1, NativeListener var2, NativeError var3);

    private static native void GetObjectsWithPermission(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetObjectsWithFullPermission(Properties var0, String var1, ArrayList var2, NativeListener var3, String var4, NativeError var5);

    private static native void GetNonInheritableobjects(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetNonDistributionlist(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetDistributionlist(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native Properties GetPasswordPolicyReport(Properties var0, NativeError var1);

    private static native Properties GetAccountLockOutPolicyReport(Properties var0, NativeError var1);

    private static native void CreateMailBox2007(String var0, String var1, String var2, String var3, String var4);

    private static native void CreateMailEnabled2007(String var0, String var1, String var2, String var3, String var4);

    private static native String GetValidDcName(Properties var0, NativeError var1);

    private static native String GetHostName(String var0, NativeError var1);

    public static String getHostName(String ipAddress) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetHostName(ipAddress, errHdlr);
    }

    public static void createMailBox2007(String domainName, long loginId, String distinguishedName, String mailAlias, String homeMDB) throws Exception {
        try {
            if (!dllLoaded) {
                System.loadLibrary(MANAGED_LIBRARY_NAME);
                dllLoaded = true;
            }
            String dcName = ADHandler.getValidDcFQDN(domainName, loginId);
            System.out.println("Creating Exchange 2007 MailBox: username=" + distinguishedName + " && HomeMDB=:" + homeMDB + " && DC=:" + dcName);
            if (mailAlias.contains("@")) {
                mailAlias = mailAlias.replaceAll("@", "_");
            }
            if (dcName != null) {
                ADHandler.CreateMailBox2007(domainName, dcName, distinguishedName, mailAlias, CommonUtil.escapeDN(homeMDB));
            } else {
                System.out.println("Valid DC not Found.Not created 2007 mailBox ");
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("UnsatisfiedLinkError :ADSMManaged");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getValidDcName(Properties domainDetails) {
        String dcName = null;
        try {
            NativeError error = new NativeError();
            dcName = ADHandler.GetValidDcName(domainDetails, error);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcName;
    }

    public static String getValidDcFQDN(String domainName, long loginId) {
        String dcName = "";
        try {
            NativeError errHdlr = new NativeError();
            Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
            dcName = ADHandler.GetValidDcName(domainDetails, errHdlr);
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("dNSHostName");
            String searchString = "(&(objectCategory=computer)(objectClass=computer)(|(name=" + dcName + ")(dNSHostName=" + dcName + ")(cn=" + dcName + ")))";
            ArrayList result = ADHandler.getObjectsWithOutListener(domainDetails, (String)domainDetails.get("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
            if (result.size() > 0) {
                Properties dCDetails = (Properties)result.get(0);
                dcName = StrUtil.getString(dCDetails, "dNSHostName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcName;
    }

    public static void createMailEnabled2007(String domainName, long loginId, String distinguishedName, String alias, String externalEmail) throws Exception {
        try {
            if (!dllLoaded) {
                System.loadLibrary(MANAGED_LIBRARY_NAME);
                dllLoaded = true;
            }
            String dcName = ADHandler.getValidDcFQDN(domainName, loginId);
            System.out.println("Creating Exchange 2007 Mail User: username=" + distinguishedName + " && externalEmail=:" + externalEmail);
            if (alias.contains("@")) {
                alias = alias.replaceAll("@", "_");
            }
            if (dcName != null) {
                ADHandler.CreateMailEnabled2007(domainName, dcName, distinguishedName, alias, externalEmail);
            } else {
                System.out.println("Valid DC not Found.Not created 2007 mail User ");
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("UnsatisfiedLinkError :ADSMManaged");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleError(NativeError errHdlr, Object objectName) throws Exception {
        nativeLogger.log(Level.FINE, "NativeLogger ErrorHandler -> " + errHdlr);
        String errorSeverity = errHdlr.getSeverityLevel(objectName);
        if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
            nativeLogger.log(Level.FINE, "ObjectName -> " + objectName);
            String message = errHdlr.getErrorMessage(objectName);
            nativeLogger.log(Level.FINE, "Message -> " + message);
            if (message != null) {
                throw new Exception(message);
            }
        }
    }

    public static ArrayList getMailBoxRights(String domainName, Long loginId, String distinguishedName) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.GetMailBoxRights(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        ADHandler.handleError(errHdlr, distinguishedName);
        return list;
    }

    public static void getInActiveUsers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, time, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getPasswordExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetPasswordExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSoonToPasswordExpireUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime, long expiretime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetSoonToPasswordExpireUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, expiretime, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyCreatedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String createtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyCreatedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, createtime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyModifiedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String modifytime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyModifiedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, modifytime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithScopeBasedGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, String groupType, String groupScope) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithScopeBasedGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, groupType, groupScope, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithDistributionGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithDistributionGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithSecurityGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithSecurityGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList getMoreList(String domainName, Long loginId, String sid) throws Exception {
        NativeError err = new NativeError();
        return ADHandler.GetMoreMembers(ADHandler.getDomainDetails(domainName, loginId), sid, err);
    }

    public static void getUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithEmptyAttributes(String domainName, Long loginId, String distinguishedName, String searchString, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithEmptyAttributes(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), searchString, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDistributionList(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDistributionlist(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getNonDistributionList(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetNonDistributionlist(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyBadLoginUsers(String domainName, Long loginId, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, long maxpwdtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyBadLoginUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), dcName, maxpwdtime, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyPwdChangedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyPwdChangedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyPwdUnChangedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyPwdUnChangedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getPwdNotRequiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetPwdNotRequiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getCannotChangPwdUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetCannotChangPwdUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getAllPrinters(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAllPrinters(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getScopeBasedGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, String groupType, String groupScope) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetScopeBasedGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, groupType, groupScope, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDistributionGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDistributionGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSecurityGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetSecurityGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getEmptyGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetEmptyGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getManagedGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetManagedGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUnManagedGroups(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUnManagedGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList getTopBigGroups(String domainName, Long loginId, String distinguishedName, int jTopCount, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.GetTopBigGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), jTopCount, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return list;
    }

    public static void getNestedGroups(String domainName, Long loginId, ArrayList attrB, NativeListener listener, String userdN) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetNestedGroups(ADHandler.getDomainDetails(domainName, loginId), attrB, listener, userdN, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList getGroups(String domainName, Long loginId, ArrayList attrB) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.GetGroups(ADHandler.getDomainDetails(domainName, loginId), attrB, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return list;
    }

    public static void getInActiveComputers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attrB, NativeListener listener, long Time2) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveObjects(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, Time2, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getInActiveComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, long Time2) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), Time2, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDisabledComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getTrustedComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetTrustedObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getComputerObjects(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetComputerObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDomainControllerObjects(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDomainControllerObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyModifiedComputers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String modifytime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyModifiedComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, modifytime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getOSBasedComputers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String operatingSystem, String servicePack) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetOSBasedComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, operatingSystem, servicePack, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getManagedComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetManagedComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUnManagedComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUnManagedComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getAllComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAllComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getLogonHourReports(Integer reportId, Long generationId, String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, ArrayList checkList, int val) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetLogonHourReports(reportId, generationId, ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, checkList, val, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getLogonHourReports(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, ArrayList checkList, int val) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetLogonHourReports(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, checkList, val, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyLoggedOnUsers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyLoggedOnUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, attributeList, time, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getAccountExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAccountExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, time, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSoonToExpireUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetSoonToExpireUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, time, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDisabledAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getEnabledAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetEnabledAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDialInAccessAllowedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDialInAccessAllowedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDialInAccessDeniedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDialInAccessDeniedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getLockedOutAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, long acctLockPolicy, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetLockedOutAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, acctLockPolicy, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithMultiGroups(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithMultiGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUnManagedUsers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUnManagedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getManagerBasedUsers(String domainName, Long loginId, String distinguishedName, String GrpdName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetManagerBasedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), GrpdName, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getAllOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAllOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getGPOLinkedOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetGPOLinkedOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getGPOBlockedInheritanceOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetGPOBlockedInheritanceOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getEmptyOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetEmptyOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUserObjectsOU(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUserObjectsOU(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getComputerObjectsOU(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetComputerObjectsOU(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyCreatedOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, String creationTime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyCreatedOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, creationTime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyModifiedOUs(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, String modifyTime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyModifiedOUs(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, modifyTime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getFilesAndFolders(String domainName, String directoryPath, String directoryLocalPath, Long lastFileCreatedTime, long updateCount, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetFilesAndFolders(ADHandler.getDomainDetails(domainName, loginId), directoryPath, directoryLocalPath, lastFileCreatedTime.toString(), updateCount, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static Hashtable getFolderPermissions(String folderPath, String domainName) throws Exception {
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        NativeError errHdlr = new NativeError();
        Hashtable ht = ADHandler.GetFolderPermissions(folderPath, domainDetails, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return ht;
    }

    public static void getUsersWithFullControl(String domainName, Long loginId, String distinguishedName, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithFullControl(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getObjectsWithPermission(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetObjectsWithPermission(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, trustee, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getObjectsWithFullPermission(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetObjectsWithFullPermission(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, trustee, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getNonInheritableobjects(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetNonInheritableobjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static Properties getPasswordPolicyReport(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetPasswordPolicyReport(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
    }

    public static Properties getAccountLockOutPolicyReport(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetAccountLockOutPolicyReport(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
    }

    public static void getAccountNeverExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAccountNeverExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithScriptPath(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithScriptPath(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithoutScriptPath(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithoutScriptPath(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getPOP3DisabledUsers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetPOP3DisabledUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getIMAP4DisabledUsers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetIMAP4DisabledUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithDefaultSendingLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithDefaultSendingLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithRestrictedSendingLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithRestrictedSendingLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithDefaultReceivingLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithDefaultReceivingLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithRestrictedReceivingLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithRestrictedReceivingLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithMessageRestrictions(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithMessageRestrictions(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithoutMessageRestrictions(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithoutMessageRestrictions(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithDefaultStorageLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithDefaultStorageLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersHideFromExchAddresslist(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersHideFromExchAddresslist(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithDefaultRecipLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithDefaultRecipLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithRestrictedRecipLimit(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithRestrictedRecipLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getProxyAddressBasedUsers(String domainName, Long loginId, String distinguishedName, String emailType, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetProxyAddressBasedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), emailType, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getProxyAddressBasedGroups(String domainName, Long loginId, String distinguishedName, String emailType, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetProxyAddressBasedGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), emailType, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getMailEnabledUsers(Properties domainDetails, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetMailEnabledUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getMailBoxEnabledUsers(Properties domainDetails, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetMailBoxEnabledUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    private static native boolean CheckObjectExist(Properties var0, String var1, String var2, NativeError var3);

    private static native boolean CheckServerStatus(Properties var0, NativeError var1);

    private static native Object GetADObjects(Properties var0, String var1, NativeError var2);

    private static native Properties GetACLs(Properties var0, String var1, long var2, NativeError var4);

    private static native Properties GetUserObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetUserObjectForNTFormat(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetGroupObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetSharedFolderObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetPrinterObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetOUObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetContactObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetComputerObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetDomainDNSObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native Properties GetObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native long CreateObject(Properties var0, String var1, String var2, String var3, NativeError var4);

    private static native long AddContact(Properties var0, String var1, String var2, ArrayList var3, ArrayList var4, ArrayList var5, NativeError var6);

    private static native long AddUser(Properties var0, String var1, String var2, String var3, String var4, ArrayList var5, ArrayList var6, ArrayList var7, ArrayList var8, ArrayList var9, String var10, NativeError var11);

    private static native long SearchAndModifyUser(Properties var0, String var1, String var2, String var3, ArrayList var4, ArrayList var5, ArrayList var6, ArrayList var7, ArrayList var8, NativeError var9);

    private static native long SearchAndModifyContact(Properties var0, String var1, String var2, ArrayList var3, ArrayList var4, NativeError var5);

    private static native long ModifyUser(Properties var0, String var1, String var2, ArrayList var3, ArrayList var4, ArrayList var5, ArrayList var6, NativeListener var7, NativeError var8);

    private static native long ModifyContact(Properties var0, String var1, ArrayList var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native long ModifyInheritanceFlag(Properties var0, String var1, int var2, NativeError var3);

    private static native long ModifyUserFullName(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native long MoveObject(Properties var0, String var1, String var2, NativeError var3);

    private static native long UpdateUser(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native long UpdateContact(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native long UpdateComputer(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void DeleteUser(Properties var0, String var1, NativeError var2);

    private static native long SetPassword(Properties var0, String var1, String var2, NativeError var3);

    private static native long RestoreDefaultSecurityDescriptor(Properties var0, String var1, NativeError var2);

    private static native void SearchUser(Properties var0, String var1, NativeListener var2, NativeError var3);

    private static native boolean CheckUserMustChangePassword(Properties var0, String var1, NativeError var2);

    private static native boolean CheckCantChangePassword(Properties var0, String var1, NativeError var2);

    private static native boolean CheckPasswordNeverExpires(Properties var0, String var1, NativeError var2);

    private static native long AddGroup(Properties var0, String var1, String var2, ArrayList var3, ArrayList var4, NativeError var5);

    private static native long ModifyGroup(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native long DeleteGroup(Properties var0, String var1, NativeError var2);

    private static native void CreateMailBox(Properties var0, String var1, String var2, NativeError var3);

    private static native void SetTerminalServiceProps(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native void SetDialInProps(Properties var0, String var1, String var2, ArrayList var3, String var4, NativeError var5);

    private static native void GetObjectsWithSid(Properties var0, String var1, ArrayList var2, String var3, NativeListener var4, NativeError var5);

    public static void getObjectsWithSid(String domainName, String sid, String objectClass, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        ADHandler.GetObjectsWithSid(domainDetails, sid, attributeList, "(objectcategory=" + objectClass + ")", listener, errHdlr);
    }

    public static void getObjectsWithSid(String domainName, String sid, String[] objectClasses, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        String filter = "(|";
        if (objectClasses.length == 1) {
            filter = "(objectcategory=" + objectClasses[0] + ")";
        } else {
            for (String objectClass : objectClasses) {
                filter = filter + "(objectcategory=" + objectClass + ")";
            }
            filter = ")";
        }
        System.out.println("filter is :" + filter);
        ADHandler.GetObjectsWithSid(domainDetails, sid, attributeList, filter, listener, errHdlr);
    }

    public static boolean checkObjectExist(String domainName, Long loginId, String searchString, String searchScope) {
        NativeError errHdlr = new NativeError();
        boolean objectExists = false;
        try {
            objectExists = ADHandler.CheckObjectExist(ADHandler.getDomainDetails(domainName, loginId), searchString, CommonUtil.escapeDN(searchScope), errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectExists;
    }

    public static boolean checkServerStatus(String domainName, Long loginId) {
        NativeError errHdlr = new NativeError();
        boolean serverRunning = true;
        try {
            serverRunning = ADHandler.CheckServerStatus(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverRunning;
    }

    public static void deleteUser(String domainName, Long loginId, String dn) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.DeleteUser(ADHandler.getDomainDetails(domainName, loginId), dn, errHdlr);
        ADHandler.handleError(errHdlr, dn);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static long createObject(String domainName, Long loginId, String objectClass, String objectName, String container) throws Exception {
        NativeError errHdlr = new NativeError();
        long l = ADHandler.CreateObject(ADHandler.getDomainDetails(domainName, loginId), objectClass, objectName, container, errHdlr);
        String message = errHdlr.getErrorMessage(objectName);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return l;
    }

    public static NativeError addContact(String domainName, Long loginId, String containerName, String userName, ArrayList propList, ArrayList modifyList, ArrayList groupList) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.AddContact(ADHandler.getDomainDetails(domainName, loginId), containerName, userName, propList, modifyList, groupList, errHdlr);
        return errHdlr;
    }

    public static NativeError addUser(String domainName, Long loginId, String containerName, String userName, String samAccountName, String password, ArrayList propList, ArrayList modifyList, ArrayList tsList, ArrayList winNTAttributeList, ArrayList groupList, String homeMDB) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.AddUser(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(containerName), userName, samAccountName, password, propList, modifyList, tsList, winNTAttributeList, groupList, homeMDB, errHdlr);
        return errHdlr;
    }

    public static long modifyUser(String domainName, Long loginId, String sid, ArrayList propList, ArrayList modifyList, ArrayList attributeList, NativeListener listener) throws Exception {
        return ADHandler.modifyUser(domainName, loginId, sid, null, propList, modifyList, new ArrayList(), attributeList, listener);
    }

    public static long modifyUser(String domainName, Long loginId, String sid, String userName, ArrayList propList, ArrayList modifyList, ArrayList winNTAttributeList, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.ModifyUser(ADHandler.getDomainDetails(domainName, loginId), sid, userName, propList, modifyList, winNTAttributeList, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, sid);
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static long modifyContact(String domainName, Long loginId, String guid, ArrayList propList, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.ModifyContact(ADHandler.getDomainDetails(domainName, loginId), guid, propList, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, guid);
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static NativeError searchAndModifyUser(String domainName, Long loginId, String distinguishedName, String searchString, String password, ArrayList propList, ArrayList modifyList, ArrayList tsList, ArrayList winNTAttributeList, ArrayList groupList) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SearchAndModifyUser(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), searchString, password, propList, modifyList, tsList, winNTAttributeList, groupList, errHdlr);
        return errHdlr;
    }

    public static NativeError searchAndModifyContact(String domainName, Long loginId, String distinguishedName, String searchString, ArrayList propList, ArrayList groupList) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SearchAndModifyContact(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), searchString, propList, groupList, errHdlr);
        return errHdlr;
    }

    public static long modifyInheritanceFlag(String domainName, Long loginId, String sid, String userName, int inheritFlag) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.ModifyInheritanceFlag(ADHandler.getDomainDetails(domainName, loginId), userName, inheritFlag, errHdlr);
        ADHandler.handleError(errHdlr, sid);
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static boolean checkUserMustChangePassword(String domainName, Long loginId, String sid) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.CheckUserMustChangePassword(ADHandler.getDomainDetails(domainName, loginId), sid, errHdlr);
    }

    public static boolean checkCantChangePassword(String domainName, Long loginId, String userName) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.CheckCantChangePassword(ADHandler.getDomainDetails(domainName, loginId), userName, errHdlr);
    }

    public static boolean checkPasswordNeverExpires(String domainName, Long loginId, String sid) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.CheckPasswordNeverExpires(ADHandler.getDomainDetails(domainName, loginId), sid, errHdlr);
    }

    public static void moveObject(String domainName, Long loginId, String sourceDN, String destinationDN) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.MoveObject(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(sourceDN), CommonUtil.escapeDN(destinationDN), errHdlr);
        String message = errHdlr.getErrorMessage(CommonUtil.escapeDN(sourceDN));
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void setPassword(String domainName, Long loginId, String sid, String password) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SetPassword(ADHandler.getDomainDetails(domainName, loginId), sid, password, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void restoreDefaultSecurityDescriptor(String domainName, Long loginId, String sid) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.RestoreDefaultSecurityDescriptor(ADHandler.getDomainDetails(domainName, loginId), sid, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static NativeError addGroup(String domainName, Long loginId, String containerName, String userName, ArrayList propList, ArrayList groupList) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.AddGroup(ADHandler.getDomainDetails(domainName, loginId), containerName, userName, propList, groupList, errHdlr);
        String message = errHdlr.getErrorMessage(userName);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return errHdlr;
    }

    public static long modifyGroup(String domainName, Long loginId, String sid, ArrayList propList) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.ModifyGroup(ADHandler.getDomainDetails(domainName, loginId), sid, propList, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static void deleteGroup(String domainName, Long loginId, String dn) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.DeleteGroup(ADHandler.getDomainDetails(domainName, loginId), dn, errHdlr);
        ADHandler.handleError(errHdlr, dn);
    }

    public static long modifyUserFullName(String domainName, Long loginId, String userDN, String modifyValue, ArrayList attr) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        NativeListener listener = null;
        userDN = CommonUtil.escapeDN(userDN);
        val = ADHandler.ModifyUserFullName(ADHandler.getDomainDetails(domainName, loginId), userDN, CommonUtil.escapeString(modifyValue, new String[0]), attr, listener, errHdlr);
        String message = errHdlr.getErrorMessage(userDN);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static void createMailBox(String domainName, Long loginId, String sid, String mailBoxStore) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.CreateMailBox(ADHandler.getDomainDetails(domainName, loginId), sid, mailBoxStore, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void setTerminalServiceProps(String domainName, Long loginId, String userName, ArrayList prop) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SetTerminalServiceProps(ADHandler.getDomainDetails(domainName, loginId), userName, prop, errHdlr);
        String message = errHdlr.getErrorMessage(userName);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void setDialInProps(String domainName, Long loginId, String userName, String sid, ArrayList prop, String value) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SetDialInProps(ADHandler.getDomainDetails(domainName, loginId), userName, sid, prop, value, errHdlr);
        String message = errHdlr.getErrorMessage(userName);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
    }

    public static long updateUser(String domainName, Long loginId, String sid, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.UpdateUser(ADHandler.getDomainDetails(domainName, loginId), sid, attributeList, listener, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static long updateContact(String domainName, Long loginId, String guid, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.UpdateContact(ADHandler.getDomainDetails(domainName, loginId), guid, attributeList, listener, errHdlr);
        String message = errHdlr.getErrorMessage(guid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static long updateComputer(String domainName, Long loginId, String sid, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.UpdateComputer(ADHandler.getDomainDetails(domainName, loginId), sid, attributeList, listener, errHdlr);
        String message = errHdlr.getErrorMessage(sid);
        if (message != null) {
            throw new Exception(message);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static void searchUser(String domainName, Long loginId, String searchString, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SearchUser(ADHandler.getDomainDetails(domainName, loginId), searchString, listener, errHdlr);
    }

    public static Properties getUserObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Address");
        list.add("Account");
        list.add("Profile");
        list.add("Telephones");
        list.add("Organization");
        list.add("Groups");
        list.add("TerminalService");
        list.add("ExchangeServer");
        list.add("DialIn");
        list.add("Object");
        list.add("LogonHours");
        Properties p = ADHandler.GetUserObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
        try {
            Properties accountProps = (Properties)p.get("Account");
            String accountExpirationDate = accountProps.getProperty("accountExpirationDate");
            int index = accountExpirationDate.indexOf(" ");
            if (index > 0) {
                int year;
                String str = accountExpirationDate.substring(0, index);
                String yr = str.substring(str.lastIndexOf("/") + 1);
                if (str.contains("-")) {
                    yr = str.substring(str.lastIndexOf("-") + 1);
                }
                if ((year = Integer.parseInt(yr)) < 2005) {
                    accountProps.setProperty("accountExpirationDate", "Never");
                }
            } else if (accountExpirationDate.indexOf("/") != 0) {
                int year;
                String yr = accountExpirationDate.substring(accountExpirationDate.lastIndexOf("/") + 1);
                if (accountExpirationDate.contains("-")) {
                    yr = accountExpirationDate.substring(accountExpirationDate.lastIndexOf("-") + 1);
                }
                if ((year = Integer.parseInt(yr)) < 2005) {
                    accountProps.setProperty("accountExpirationDate", "Never");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static Properties getGroupObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Members");
        list.add("Object");
        list.add("Groups");
        list.add("ManagedBy");
        return ADHandler.GetGroupObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getSharedFolderObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Object");
        list.add("ManagedBy");
        return ADHandler.GetSharedFolderObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getPrinterObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Object");
        list.add("ManagedBy");
        return ADHandler.GetPrinterObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getComputerObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("OperatingSystem");
        list.add("Location");
        list.add("Groups");
        list.add("Object");
        list.add("ManagedBy");
        return ADHandler.GetComputerObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getOUObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Object");
        list.add("ManagedBy");
        return ADHandler.GetOUObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getContactObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Object");
        list.add("Address");
        list.add("Telephones");
        list.add("Organization");
        list.add("Groups");
        return ADHandler.GetContactObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Object");
        return ADHandler.GetObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    public static Properties getACLs(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties language = ADSMPersUtil.getLanguageSettings();
        String lcid = (String)language.get("lcid");
        System.out.println("Get ACLs called with lcid" + Long.parseLong(lcid));
        return ADHandler.GetACLs(ADHandler.getDomainDetails(domainName, loginId), guid, Long.parseLong(lcid), errHdlr);
    }

    public static Object getDomainObject(String domainName, Long loginId, String path) throws Exception {
        NativeError errHdlr = new NativeError();
        Object object = ADHandler.GetADObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(path), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return object;
    }

    public static Properties getDomainDNSObject(String domainName, Long loginId, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList<String> list = new ArrayList<String>();
        list.add("General");
        list.add("Object");
        list.add("ManagedBy");
        return ADHandler.GetDomainDNSObject(ADHandler.getDomainDetails(domainName, loginId), guid, list, errHdlr);
    }

    private static native Properties GetDisplaySpecifiers(Properties var0, long var1, NativeError var3);

    private static native ArrayList GetSchemaObjects(Properties var0, NativeError var1);

    private static native ArrayList GetSchemaObjectFromGuid(Properties var0, String var1, NativeError var2);

    private static native Properties GetPermissions(Properties var0, String var1, String var2, NativeError var3);

    private static native ArrayList DelegateTemplate(Properties var0, ArrayList var1, ArrayList var2, String var3, NativeError var4);

    private static native void GetSecurityPrincipals(Properties var0, NativeListener var1, NativeError var2);

    private static native void Search(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native Properties GetACLsFromDN(Properties var0, String var1, long var2, NativeError var4);

    private static native ArrayList SearchADObjects(Properties var0, String var1, String var2, NativeError var3);

    public static void getSecurityPrincipals(String domainName, Long loginId, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties p = ADHandler.getDomainDetails(domainName, loginId);
        ADHandler.GetSecurityPrincipals(p, listener, errHdlr);
    }

    public static void searchACE(String domainName, Long loginId, String adsPath, String trustee, ArrayList aceList, Properties dnSIDMap, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.Search(ADHandler.getDomainDetails(domainName, loginId), adsPath, trustee, aceList, listener, errHdlr);
    }

    public static void getGroupBasedUsers(String domainName, Long loginId, String distinguishedName, String GrpdName, ArrayList attrB, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetGroupBasedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), GrpdName, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getOMAEnabledUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetOMAEnabledUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getOWAEnabledUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetOWAEnabledUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getOWADisabledUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetOWADisabledUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getAllGroups(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAllGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getMailEnabledGroups(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetMailEnabledGroups(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getPwdNeverExpireUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetPwdNeverExpireUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getNeverLogonUsers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetNeverLoggedInUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getForwardToUsers(String domainName, Long loginId, String distinguishedName, String dnName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetForwardToBasedUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), dnName, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getUsersWithoutDefaultStorageLimit(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUsersWithoutDefaultStorageLimit(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyDeletedUsers(String domainName, Long loginId, ArrayList attributeList, NativeListener listener, String time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyDeletedUsers(ADHandler.getDomainDetails(domainName, loginId), time, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList delegateTemplate(String domainName, Long loginId, ArrayList aceList, ArrayList securityPrincipalList, String adsPath) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.DelegateTemplate(ADHandler.getDomainDetails(domainName, loginId), aceList, securityPrincipalList, CommonUtil.escapeDN(adsPath), errHdlr);
        String message = errHdlr.getErrorMessage(domainName);
        if (message != null) {
            throw new Exception(message);
        }
        return list;
    }

    public static Properties getDisplaySpecifiers(String domainName, Long loginId) throws Exception {
        String message;
        NativeError errHdlr = new NativeError();
        Properties language = ADSMPersUtil.getLanguageSettings();
        String lcid = (String)language.get("lcid");
        System.out.println("Get display called with lcid" + Long.parseLong(lcid));
        Properties p = ADHandler.GetDisplaySpecifiers(ADHandler.getDomainDetails(domainName, loginId), Long.parseLong(lcid), errHdlr);
        String errorSeverity = errHdlr.getSeverityLevel(domainName);
        if (errorSeverity != null && errorSeverity.equals("SEVERE") && (message = errHdlr.getErrorMessage(domainName)) != null) {
            throw new Exception(message);
        }
        return p;
    }

    public static ArrayList getSchemaObjects(String domainName, Long loginId) throws Exception {
        String message;
        NativeError errHdlr = new NativeError();
        Properties details = ADHandler.getDomainDetails(domainName, loginId);
        ArrayList l = ADHandler.GetSchemaObjects(details, errHdlr);
        String errorSeverity = errHdlr.getSeverityLevel(domainName);
        if (errorSeverity != null && errorSeverity.equals("SEVERE") && (message = errHdlr.getErrorMessage(domainName)) != null) {
            throw new Exception(message);
        }
        return l;
    }

    public static ArrayList getSchemaObjectFromGuid(String domainName, Long loginId, String query) throws Exception {
        String message;
        NativeError errHdlr = new NativeError();
        Properties details = ADHandler.getDomainDetails(domainName, loginId);
        ArrayList l = ADHandler.GetSchemaObjectFromGuid(details, query, errHdlr);
        String errorSeverity = errHdlr.getSeverityLevel(domainName);
        if (errorSeverity != null && errorSeverity.equals("SEVERE") && (message = errHdlr.getErrorMessage(domainName)) != null) {
            throw new Exception(message);
        }
        return l;
    }

    public static void getGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getDisabledGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getUnusedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUnusedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getDomainLinkedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDomainLinkedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getOULinkedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetOULinkedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getSiteLinkedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetSiteLinkedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getGPOBlockedInheritanceContainers(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetGPOBlockedInheritanceContainers(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getDisabledComputerGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledComputerGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getDisabledUserGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledUserGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, errHdlr);
    }

    public static void getRecentlyCreatedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener, String createtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyCreatedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, createtime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyModifiedGPOs(String domainName, Long loginId, ArrayList attributeList, NativeListener listener, String createtime) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyModifiedGPOs(ADHandler.getDomainDetails(domainName, loginId), attributeList, listener, createtime, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static Properties getPasswordPolicy(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetPasswordPolicy(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
    }

    public static Properties getAccountLockOutPolicy(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetAccountLockOutPolicy(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
    }

    public static Properties getPermissions(String domainName, Long loginId, String adsPath, String guid) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetPermissions(ADHandler.getDomainDetails(domainName, loginId), adsPath, guid, errHdlr);
    }

    public static Properties getACLsFromDN(String domainName, Long loginId, String distinguishedName) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties language = ADSMPersUtil.getLanguageSettings();
        String lcid = (String)language.get("lcid");
        System.out.println("Get ACLsFromDN called with lcid" + Long.parseLong(lcid));
        return ADHandler.GetACLsFromDN(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), Long.parseLong(lcid), errHdlr);
    }

    public static ArrayList searchADObjects(String domainName, Long loginId, String distinguishedName, String commonName) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.SearchADObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), commonName, errHdlr);
    }

    public static Properties getUserTerminalObjects(String domainName, Long loginId, String guid, ArrayList tsList) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetUserObject(ADHandler.getDomainDetails(domainName, loginId), guid, tsList, errHdlr);
    }

    public static native Hashtable GetEventData(Properties var0, String var1, long var2, long var4, int[] var6, String var7, int var8, String var9, Properties var10, String[][] var11, int[][] var12, NativeError var13);

    public static native boolean IsLocalDomain(String var0);

    public static native boolean IsTrustedDomain(String var0);

    public static boolean isTrustedDomain(String domainName) throws Exception {
        String domainDnsName = DomainDetailsAPI.getDomainDNSName(domainName);
        return ADHandler.IsTrustedDomain(domainDnsName);
    }

    public static native int GetEventCount(Properties var0, int var1, NativeError var2);

    public static native Hashtable GetPolicyStatus(Properties var0, String var1, String var2, String var3, NativeError var4, String var5, AuditGPOCsvWriter var6, String var7, String var8, String var9);

    public static native String GetAdvPolicyStatus(Properties var0, String var1, String var2, NativeError var3, Properties var4);

    public static native Hashtable GetSecurityDescriptorFromStringSD(Properties var0, String var1, NativeError var2);

    public static Hashtable getSecurityDescriptorFromStringSD(String domainName, String stringSD) throws Exception {
        NativeError errHdlr = new NativeError();
        Hashtable aceTable = ADHandler.GetSecurityDescriptorFromStringSD(ADHandler.getDomainDetails(domainName, 1L), stringSD, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return aceTable;
    }

    public static native ArrayList GetSACLForObject(Properties var0, String var1, NativeError var2);

    public static ArrayList getSACLForObject(String domainName, String distinguishedName) throws Exception {
        NativeError nativeError = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        ArrayList dcList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        String dcName = (String)dcList.get(0);
        String bindURL = distinguishedName = "LDAP://" + dcName + "/" + distinguishedName;
        ArrayList arrayList = ADHandler.GetSACLForObject(domainDetails, bindURL, nativeError);
        ADHandler.handleError(nativeError, domainName);
        return arrayList;
    }

    public static native void GetPrinterData(Properties var0, NativeError var1, String var2, PrintServerEnabled var3, Object[] var4);

    public static void getPrinterData(String domainName, boolean shutDown, String machineName, PrintServerEnabled listener, Object[] printerNameArray) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetPrinterData(ADHandler.getDomainDetails(domainName, 1L), errHdlr, machineName, listener, printerNameArray);
        if (errHdlr.getErrorMessage(machineName) != null) {
            PrintSystemAPI.updateStatusMessage(errHdlr.getErrorMessage(machineName), machineName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable getEventData(Properties domainDetails, String dcName, long recordNumber, long timeGenerated, int[] eventIDList, String windowsFolder, int machineType, String osVersion, Properties netAppDetails) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        long x = System.currentTimeMillis();
        Hashtable l = ADHandler.GetEventData(domainDetails, dcName, recordNumber, timeGenerated, eventIDList, windowsFolder, machineType, osVersion, netAppDetails, excludeRules, excludeOpList, ne);
        long y = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Time Taken by[" + dcName + "] Native Mode ----> " + (y - x) / 1000L + ".");
        if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072) {
            if (ne.getErrorMessage(domainName) != null) {
                l.put("ERROR_MESSAGE", ne.getErrorMessage(domainName));
                return l;
            } else {
                if (ne.getErrorMessage(dcName) == null) return l;
                l.put("ERROR_MESSAGE", ne.getErrorMessage(dcName));
                Hashtable error = ne.getError(dcName);
                l.put("ERROR_CODE", error.get("ERROR_CODE"));
            }
            return l;
        } else if (ne.getErrorMessage(domainName) != null) {
            ADHandler.handleError(ne, domainName);
            return l;
        } else {
            ADHandler.handleError(ne, dcName);
        }
        return l;
    }

    public static Hashtable getPolicyStatus(String domainName, String sectionName, String attribName, String gpoGUID, AuditGPOCsvWriter listener, String isLocalDomain) throws Exception {
        Long loginId = 1L;
        NativeError errHdlr = new NativeError();
        Hashtable pdcTable = (Hashtable)ADHandler.getPrimaryDC(domainName);
        String pdc = null;
        if (pdcTable == null || pdcTable.get("PDC_FLAT_NAME") == null) {
            String message = rb.getString("adap.GPOHandler.Not_able_to_find_PDC");
            throw new Exception(message);
        }
        pdc = (String)pdcTable.get("PDC_FLAT_NAME");
        pdc = pdc.replace("\\\\", "");
        pdc = pdc.trim();
        String advGPOReports = System.getProperty("server.dir");
        Hashtable ret = ADHandler.GetPolicyStatus(ADHandler.getDomainDetails(domainName, loginId), sectionName, attribName, gpoGUID, errHdlr, "DC", listener, isLocalDomain, advGPOReports, pdc);
        if (errHdlr.getErrorMessage(domainName) != null) {
            ret.put("Errors", errHdlr.getErrorMessage(domainName));
        }
        ADHandler.handleError(errHdlr, "PolicyStatus");
        return ret;
    }

    private static native ArrayList SetSACLForObject(Properties var0, ArrayList var1, ArrayList var2, String var3, NativeError var4);

    public static ArrayList setSAClForObject(String domainName, ArrayList shareDetails, ArrayList aceList, String machineName) throws Exception {
        String message;
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        ArrayList result = ADHandler.SetSACLForObject(domainDetails, shareDetails, aceList, machineName, errHdlr);
        String errorSeverity = errHdlr.getSeverityLevel(machineName);
        if (errorSeverity != null && errorSeverity.equals("SEVERE") && (message = errHdlr.getErrorMessage(machineName)) != null) {
            throw new Exception(message);
        }
        if (errorSeverity != null && errorSeverity.equals("WARNING")) {
            return result;
        }
        return null;
    }

    private static native ArrayList ApplySecurityFilterInGPO(Properties var0, ArrayList var1, ArrayList var2, String var3, String var4, NativeError var5);

    public static ArrayList applySecurityFilterInGPO(String domainName, ArrayList aceList, ArrayList securityPrincipalList, String gpoGuid, String pdc) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        ArrayList result = ADHandler.ApplySecurityFilterInGPO(domainDetails, aceList, securityPrincipalList, gpoGuid, pdc, errHdlr);
        try {
            String errorSeverity = errHdlr.getSeverityLevel(domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                String message = errHdlr.getErrorMessage(domainName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static native Hashtable CreateAndUpdateGpo(Properties var0, String var1, String var2, String var3, String var4, int var5, int var6, NativeError var7, String var8, AuditGPOCsvWriter var9, String var10, String var11);

    public static Hashtable createAndUpdateGpo(String domainName, String gpoGuid, String gpoName, String pdc, Integer machineType, Integer gpoFlags, String isLocalDomain) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        nativeLogger.log(Level.INFO, "machineType adHandler:" + machineType);
        nativeLogger.log(Level.INFO, "gpoFlags adHandler:" + gpoFlags);
        String advGPOReports = System.getProperty("server.dir");
        Hashtable<String, String> result = ADHandler.CreateAndUpdateGpo(domainDetails, gpoGuid, gpoName, domainName, pdc, machineType, gpoFlags, errHdlr, (machineType & 0x1000) == 4096 ? "WS" : "FS", AuditGPOCsvWriter.getInstance(), isLocalDomain, advGPOReports);
        nativeLogger.log(Level.INFO, "createAndUpdateGpo:Result list from Native:" + result);
        try {
            String errorSeverity;
            if (result == null) {
                result = new Hashtable<String, String>();
            }
            if ((errorSeverity = errHdlr.getSeverityLevel(domainName)) != null) {
                String message = errHdlr.getErrorMessage(domainName);
                if (message != null) {
                    result.put("MESSAGE", message);
                }
            } else {
                result.put("MESSAGE", "SUCCESS");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static native ArrayList ManageSystemACL(Properties var0, ArrayList var1, ArrayList var2, String var3, NativeError var4);

    public static ArrayList manageSystemACL(String domainName, Long loginId, ArrayList aceList, ArrayList securityPrincipalList, String adsPath) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.ManageSystemACL(ADHandler.getDomainDetails(domainName, loginId), aceList, securityPrincipalList, CommonUtil.escapeDN(adsPath), errHdlr);
        String message = errHdlr.getErrorMessage(domainName);
        if (message != null) {
            throw new Exception(message);
        }
        return list;
    }

    public static native Hashtable GetNetAppEventData(Properties var0, String var1, long var2, int[] var4, int var5, String var6, long var7, Properties var9, String[][] var10, int[][] var11, NativeError var12);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable getNetAppEventData(Properties domainDetails, String dcName, long recordNumber, int[] eventIDList, int machineType, String osVersion, long recentEventTime, Properties netAppDetails) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        Hashtable l = ADHandler.GetNetAppEventData(domainDetails, dcName, recordNumber, eventIDList, machineType, osVersion, recentEventTime, netAppDetails, excludeRules, excludeOpList, ne);
        if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072 || (machineType & 0x80000) == 524288) {
            if (ne.getErrorMessage(domainName) != null) {
                l.put("ERROR_MESSAGE", ne.getErrorMessage(domainName));
                return l;
            } else {
                if (ne.getErrorMessage(dcName) == null) return l;
                l.put("ERROR_MESSAGE", ne.getErrorMessage(dcName));
                Hashtable error = ne.getError(dcName);
                l.put("ERROR_CODE", error.get("ERROR_CODE"));
            }
            return l;
        } else if (ne.getErrorMessage(domainName) != null) {
            ADHandler.handleError(ne, domainName);
            return l;
        } else {
            ADHandler.handleError(ne, dcName);
        }
        return l;
    }

    public static native Hashtable Get2k8EventData(Properties var0, String var1, long var2, int[] var4, int var5, String var6, long var7, Properties var9, String[][] var10, int[][] var11, String var12, String var13, NativeError var14);

    public static Hashtable get2k8EventData(Properties domainDetails, String dcName, long recordNumber, int[] eventIDList, int machineType, String osVersion, long recentEventTime, Properties netAppDetails, String source) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        long evtTime = recentEventTime * 1000L + 1L;
        String evtQueryTime = TimeUtil.getEVTQueryEventTime(evtTime);
        long x = System.currentTimeMillis();
        Hashtable l = ADHandler.Get2k8EventData(domainDetails, dcName, recordNumber, eventIDList, machineType, osVersion, recentEventTime, netAppDetails, excludeRules, excludeOpList, evtQueryTime, source, ne);
        long y = System.currentTimeMillis();
        if (ne.getErrorMessage(domainName) != null) {
            ADHandler.handleError(ne, domainName);
        } else {
            ADHandler.handleError(ne, dcName);
        }
        nativeLogger.log(Level.INFO, "Time Taken by[" + dcName + "] EvtQuery mode ----> " + (y - x) / 1000L + ".");
        return l;
    }

    public static native ArrayList GetAdvancedGPOevt(Properties var0, String var1, String var2, String var3, String var4, NativeError var5);

    public static ArrayList getAdvancedGPOevt(Properties domainDetails, String dcName, String evtQueryGPO, String osVersion) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        long x = System.currentTimeMillis();
        ArrayList l = ADHandler.GetAdvancedGPOevt(domainDetails, dcName, evtQueryGPO, osVersion, "security", ne);
        long y = System.currentTimeMillis();
        if (ne.getErrorMessage(domainName) != null) {
            ADHandler.handleError(ne, domainName);
        } else {
            ADHandler.handleError(ne, dcName);
        }
        nativeLogger.log(Level.INFO, "Time Taken by[" + dcName + "] EvtQuery mode GPO----> " + (y - x) / 1000L + ".");
        return l;
    }

    public static native Object WatchGpoFilePath(Properties var0, NativeError var1);

    public static void watchGpoFilePath(String domainName) {
        try {
            String message = rb.getString("adap.common.text.status_msg.success");
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
            rowDataMap.put("DOMAIN_NAME", domainName);
            rowDataMap.put("MESSAGE", message);
            rowDataMap.put("STATUS", true);
            NativeError errHdlr = new NativeError();
            String pdcName = PDCHandler.getInstance().getPDCName(domainName, true);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L, pdcName);
            GPOManagementListener.getInstance().updateGPOFileWatcherDetails(rowDataMap);
            ADHandler.WatchGpoFilePath(domainDetails, errHdlr);
            String errorSeverity = errHdlr.getSeverityLevel(domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                message = errHdlr.getErrorMessage(domainName);
                if (message != null) {
                    rowDataMap.put("MESSAGE", message);
                    rowDataMap.put("STATUS", false);
                }
                GPOManagementListener.getInstance().updateGPOFileWatcherDetails(rowDataMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static native Object GenerateGpoReport(Properties var0, String var1, String var2, NativeError var3);

    public static native Object GenerateGpoReportOtherDomain(String var0, Properties var1, NativeError var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object generateGpoReport(String domainName, String gpoName, String dirPath) throws Exception {
        Hashtable<String, Object> result;
        block18: {
            result = null;
            try {
                PDCHandler.getInstance();
                if (!PDCHandler.isGPMCInstalled().booleanValue()) break block18;
                NativeError errHdlr = new NativeError();
                String pdcName = PDCHandler.getInstance().getPDCName(domainName, true);
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L, pdcName);
                String flatName = (String)domainDetails.get("DOMAIN_FLAT_NAME");
                String message = "";
                boolean isLocalDomain = true;
                if (flatName != null) {
                    isLocalDomain = ADHandler.IsLocalDomain(flatName);
                    if (isLocalDomain) {
                        result = (Hashtable)ADHandler.GenerateGpoReport(domainDetails, gpoName, dirPath, errHdlr);
                        message = errHdlr.getErrorMessage(domainName);
                    } else {
                        message = "80070005";
                    }
                } else {
                    result = (Hashtable<String, Object>)ADHandler.GenerateGpoReport(domainDetails, gpoName, dirPath, errHdlr);
                    message = errHdlr.getErrorMessage(domainName);
                }
                boolean fl = false;
                if (message != null && (message.toLowerCase().contains("80070005") || message.toLowerCase().contains("8007200f") || message.toLowerCase().contains("8007052e"))) {
                    String isAuthenticated = (String)domainDetails.get("IS_AUTHENTICATION_REQUIRED");
                    if (isAuthenticated.equalsIgnoreCase("false") && !isLocalDomain) {
                        result = (Hashtable)ADHandler.GenerateGpoReport(domainDetails, gpoName, dirPath, errHdlr);
                        message = errHdlr.getErrorMessage(domainName);
                    } else {
                        String dir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "GPODetails" + File.separator;
                        String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS").format(new Date());
                        String textFile = dir + gpoName + timeStamp + ".txt";
                        String domainDnsName = (String)domainDetails.get("DOMAIN_DNS_NAME");
                        String advGPOReports = "\"" + System.getProperty("server.dir") + File.separator + "lib" + File.separator + "native" + File.separator + "AdvGPOReports.exe\" generate \"" + textFile + "\" " + domainDnsName + " " + pdcName + " " + gpoName + " \"" + dirPath + "\" " + domainName;
                        result = (Hashtable)ADHandler.GenerateGpoReportOtherDomain(advGPOReports, domainDetails, errHdlr);
                        FileReader ff = null;
                        BufferedReader bb = null;
                        try {
                            ff = new FileReader(textFile);
                            bb = new BufferedReader(ff);
                            String s = bb.readLine();
                            String[] ss = s.split("##");
                            if (ss[0].toLowerCase().contains("error")) {
                                nativeLogger.log(Level.INFO, "AdvGpoReports.Exe: " + ss[0]);
                            } else {
                                result = new Hashtable<String, Object>();
                                result.put("DOMAIN_NAME", ss[0]);
                                result.put("GPO_TARGET_PATH", ss[1]);
                                result.put("VER_FILE_NAME", ss[2]);
                                result.put("GPO_VERSION", Integer.parseInt(ss[3]));
                                result.put("IS_HTML_GENERATED", ss[4]);
                                if (ss[4].equalsIgnoreCase("False")) {
                                    nativeLogger.log(Level.INFO, "AdvGpoReports.Exe: " + ss[5]);
                                }
                                fl = true;
                                nativeLogger.log(Level.INFO, "Gpos collected using AdvGPOReports.exe");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            bb.close();
                            ff.close();
                            File file = new File(textFile);
                            file.delete();
                        }
                    }
                }
                if (!fl) {
                    ADHandler.handleError(errHdlr, domainName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return result;
    }

    private static native Object GetPrimaryDC(Properties var0, NativeError var1);

    public static Object getPrimaryDC(String domainName) {
        Object result = null;
        try {
            NativeError errHdlr = new NativeError();
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            result = ADHandler.GetPrimaryDC(domainDetails, errHdlr);
            ADHandler.handleError(errHdlr, domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static native boolean IsGpmcInstalled(NativeError var0);

    public static boolean isGpmcInstalled() {
        Boolean b = false;
        try {
            NativeError errHdlr = new NativeError();
            b = ADHandler.IsGpmcInstalled(errHdlr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static native Hashtable GetEventFromCollector(Properties var0, String var1, long var2, int[] var4, int var5, String var6, long var7, String var9, Properties var10, String[][] var11, int[][] var12, NativeError var13);

    public static Hashtable getEventFromCollector(Properties domainDetails, String dcName, long recordNumber, int[] eventIDList, int machineType, String winVersion, long recentEventTime, String systemDir, Properties netAppDetails) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        Hashtable l = ADHandler.GetEventFromCollector(domainDetails, dcName, recordNumber, eventIDList, machineType, winVersion, recentEventTime, systemDir, netAppDetails, excludeRules, excludeOpList, ne);
        if (ne.getErrorMessage(domainName) != null) {
            l.put("ERROR_MESSAGE", ne.getErrorMessage(domainName));
        } else if (ne.getErrorMessage(dcName) != null) {
            l.put("ERROR_MESSAGE", ne.getErrorMessage(dcName));
        }
        return l;
    }

    public static native Properties SearchGpo(Properties var0, String var1, String var2, ArrayList var3, NativeError var4);

    public static Properties searchGpo(String domainName, String gpoName, String pdc, ArrayList attrList) throws Exception {
        Properties result = null;
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        NativeError errHdlr = new NativeError();
        result = ADHandler.SearchGpo(domainDetails, gpoName, pdc, attrList, errHdlr);
        nativeLogger.log(Level.INFO, "result SearchGpo" + result);
        ADHandler.handleError(errHdlr, domainName);
        return result;
    }

    private static native boolean IsFileExists(Properties var0, String var1, NativeError var2);

    public static boolean isFileExits(String domainName, Long loginId, String filePath) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.IsFileExists(ADHandler.getDomainDetails(domainName, loginId), filePath, errHdlr);
    }

    private static native String GetFileCreatedTime(Properties var0, String var1, NativeError var2);

    public static String getFileCreatedTime(String domainName, Long loginId, String filePath) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetFileCreatedTime(ADHandler.getDomainDetails(domainName, loginId), filePath, errHdlr);
    }

    public static ArrayList getOwaEnabled(Properties domainDetails, String userName, String workstationName, NativeError errHdlr) {
        ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList("cn", "name", "distinguishedName", "protocolSettings", "objectGUID", "msExchOmaAdminWirelessEnable", "mailNickName"));
        String searchString = "(&(objectCategory=person)(objectClass=user)(sAMAccountName=" + userName + "))";
        ArrayList testResult = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN((String)domainDetails.get("DEFAULT_NAMING_CONTEXT")), attributeList, searchString, errHdlr);
        ArrayList<String> resultMap = new ArrayList<String>();
        if (testResult.size() > 0) {
            Properties test = (Properties)testResult.get(0);
            if (test.containsKey("protocolSettings")) {
                ArrayList protocols = (ArrayList)test.get("protocolSettings");
                if (!protocols.contains("HTTP\u00a70\u00a71\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7") && !protocols.contains("OWA\u00a70")) {
                    resultMap.add("Enabled");
                }
            } else if (test.containsKey("mailNickName")) {
                resultMap.add("Enabled");
            }
        }
        return resultMap;
    }

    public static ArrayList getActiveSyncDevices(Properties domainDetails, String userName, String workstationName, NativeError errHdlr) {
        Properties test;
        ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList("cn", "name", "distinguishedName", "protocolSettings", "objectGUID", "msExchOmaAdminWirelessEnable"));
        String searchString = "(&(objectCategory=person)(objectClass=user)(sAMAccountName=" + userName + "))";
        ArrayList testResult = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN((String)domainDetails.get("DEFAULT_NAMING_CONTEXT")), attributeList, searchString, errHdlr);
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        if (!(testResult.size() <= 0 || (test = (Properties)testResult.get(0)).containsKey("msExchOmaAdminWirelessEnable") && ((ArrayList)test.get("msExchOmaAdminWirelessEnable")).contains("4"))) {
            searchString = "(objectclass=msexchactivesyncdevice)";
            try {
                Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow((String)domainDetails.get("DOMAIN_NAME"), userName, "SAM_ACCOUNT_NAME", "user");
                if (objectRow != null) {
                    String base_dn = (String)objectRow.get("DISTINGUISHED_NAME");
                    attributeList = new ArrayList<String>(Arrays.asList("msExchDeviceFriendlyName", "msExchDeviceID"));
                    ArrayList result = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN(base_dn), attributeList, searchString, errHdlr);
                    if (result != null) {
                        for (int i = 0; i < result.size(); ++i) {
                            Properties resultMap = new Properties();
                            Properties device = (Properties)result.get(i);
                            if (device.containsKey("msExchDeviceFriendlyName")) {
                                resultMap.put("Device Name", device.get("msExchDeviceFriendlyName"));
                            }
                            if (device.containsKey("msExchDeviceID")) {
                                resultMap.put("Device ID", device.get("msExchDeviceID"));
                            }
                            resultList.add(resultMap);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public static native ArrayList GetServices(Properties var0, String var1, String var2, NativeError var3, int var4);

    public static native ArrayList GetScheduleName(Properties var0, String var1, String var2, NativeError var3);

    public static native ArrayList GetNetworkMapDrive(Properties var0, String var1, String var2, NativeError var3);

    public static native ArrayList GetLogonSession(Properties var0, String var1, String var2, NativeError var3);

    public static HashMap getComponentList(String domainName, String userName, String workstationName, String analyzeName) throws Exception {
        int component = 0;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        NativeError errHdlr = new NativeError();
        ArrayList result = null;
        if (analyzeName.equalsIgnoreCase("service")) {
            result = ADHandler.GetServices(domainDetails, userName, workstationName, errHdlr, 1);
            component = 0;
        } else if (analyzeName.equalsIgnoreCase("service2")) {
            result = ADHandler.GetServices(domainDetails, userName, workstationName, errHdlr, 2);
            component = 0;
        } else if (analyzeName.equalsIgnoreCase("service3")) {
            result = ADHandler.GetServices(domainDetails, userName, workstationName, errHdlr, 3);
            component = 0;
        } else if (analyzeName.equalsIgnoreCase("schedule")) {
            result = ADHandler.GetScheduleName(domainDetails, userName, workstationName, errHdlr);
            component = 1;
        } else if (analyzeName.equalsIgnoreCase("networkMap")) {
            result = ADHandler.GetNetworkMapDrive(domainDetails, userName, workstationName, errHdlr);
            component = 2;
        } else if (analyzeName.equalsIgnoreCase("logonSession")) {
            result = ADHandler.GetLogonSession(domainDetails, userName, workstationName, errHdlr);
            component = 3;
        } else if (analyzeName.equalsIgnoreCase("owa")) {
            result = ADHandler.getOwaEnabled(domainDetails, userName, workstationName, errHdlr);
            component = 5;
        } else if (analyzeName.equalsIgnoreCase("activeSync")) {
            result = ADHandler.getActiveSyncDevices(domainDetails, userName, workstationName, errHdlr);
            component = 6;
        } else if (analyzeName.equalsIgnoreCase("processList")) {
            result = ADHandler.enumerateProcessList(domainDetails, userName, workstationName, errHdlr);
            component = 7;
        } else {
            AccountLockoutUtil.getInstance();
            String wmiQuery = AccountLockoutUtil.getWMIQuery(domainName, userName);
            String domainUserName = null;
            String password = null;
            if (!domainDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("false")) {
                domainUserName = (String)domainDetails.get("USER_NAME");
                password = (String)domainDetails.get("PASSWORD");
            }
            String[] properties = new String[]{"Caption", "RunAsUser"};
            result = ADHandler.GetWindowsDirectory(workstationName, domainName, domainUserName, password, properties, wmiQuery, null, 0, 0, null, null, errHdlr);
            component = 4;
        }
        resultMap.put("result", result);
        resultMap.put("component", component);
        if (errHdlr.getErrorMessage(domainName) != null) {
            resultMap.put("errorMessage", errHdlr.getErrorMessage(domainName));
        } else if (errHdlr.getErrorMessage(workstationName) != null) {
            resultMap.put("errorMessage", errHdlr.getErrorMessage(workstationName));
        }
        return resultMap;
    }

    public static native Hashtable GetLockoutEventData(Properties var0, String var1, long var2, long var4, int[] var6, String var7, int var8, String var9, String[][] var10, int[][] var11, NativeError var12);

    public static HashMap getLockoutEventData(Properties domainDetails, String dcName, long fromTimeGenerated, long toTimeGenerated, int[] eventIDList, int machineType, String osVersion) throws Exception {
        NativeError nativeError = new NativeError();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        long x = System.currentTimeMillis();
        Hashtable table = ADHandler.GetLockoutEventData(domainDetails, dcName, fromTimeGenerated, toTimeGenerated, eventIDList, "C:\\Windows\\System32\\", machineType, osVersion, new String[0][], new int[0][], nativeError);
        resultMap.put("result", table);
        long y = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Time Taken by[" + dcName + "] Native Mode ----> " + (y - x) / 1000L + ".");
        if (nativeError.getErrorMessage(domainName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(domainName));
        } else if (nativeError.getErrorMessage(dcName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(dcName));
        }
        return resultMap;
    }

    private static native Hashtable GetEMCAuditSettings(Properties var0, String var1, NativeError var2);

    public static HashMap<String, Object> getEMCAuditSettings(String domainName, String cifsServer) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            NativeError nativeError = new NativeError();
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            Hashtable result = ADHandler.GetEMCAuditSettings(domainDetails, cifsServer, nativeError);
            resultMap.put("result", result);
            if (nativeError.getErrorMessage(domainName) != null) {
                resultMap.put("errorMessage", nativeError.getErrorMessage(domainName));
            } else if (nativeError.getErrorMessage(cifsServer) != null) {
                resultMap.put("errorMessage", nativeError.getErrorMessage(cifsServer));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultMap;
    }

    public static native ArrayList SearchFile(Properties var0, String var1, String var2, String var3, long var4, NativeError var6);

    public static ArrayList searchFile(String uncName, String fileName, String extension, Long timeGenerated, String domainName) throws Exception {
        ArrayList result = null;
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        NativeError errHdlr = new NativeError();
        result = ADHandler.SearchFile(domainDetails, uncName, fileName, extension, timeGenerated, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return result;
    }

    public static native Hashtable GetArchiveEventData2k8(Properties var0, String var1, int[] var2, int var3, String var4, String[][] var5, int[][] var6, String var7, NativeError var8);

    public static native Hashtable GetArchiveEventData2k3(Properties var0, String var1, int[] var2, int var3, String var4, String[][] var5, int[][] var6, String var7, NativeError var8);

    public static HashMap getArchiveEventLog(String domainName, String machineName, int[] eventIDList, String filePath) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Properties netappProp = new Properties();
        NativeError nativeError = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, 0);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        Hashtable table = new Hashtable();
        long x = System.currentTimeMillis();
        String localWinVer = System.getProperty("os.version");
        table = localWinVer.startsWith("6.") ? ADHandler.GetArchiveEventData2k8(domainDetails, machineName, eventIDList, 65536, "2k8r2", excludeRules, excludeOpList, filePath, nativeError) : ADHandler.GetArchiveEventData2k3(domainDetails, machineName, eventIDList, 65536, "2k3", excludeRules, excludeOpList, filePath, nativeError);
        resultMap.put("result", table);
        long y = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Time Taken by[" + machineName + "] Native Mode ----> " + (y - x) / 1000L + ".");
        if (nativeError.getErrorMessage(domainName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(domainName));
        } else if (nativeError.getErrorMessage(machineName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(machineName));
        }
        return resultMap;
    }

    public static native ArrayList GetArchiveFiles(Properties var0, String var1, String var2, boolean var3, NativeError var4);

    public static HashMap getArchiveFiles(String domainName, String machineName, String filePath, boolean permCheck) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        NativeError nativeError = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        ArrayList list = new ArrayList();
        long x = System.currentTimeMillis();
        list = ADHandler.GetArchiveFiles(domainDetails, machineName, filePath, permCheck, nativeError);
        resultMap.put("result", list);
        long y = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Time Taken by[" + machineName + "] Native Mode ----> " + (y - x) / 1000L + ".");
        if (nativeError.getErrorMessage(domainName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(domainName));
        } else if (nativeError.getErrorMessage(machineName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(machineName));
        }
        return resultMap;
    }

    public static native Hashtable Watch2k8EventLog(Properties var0, String var1, long var2, int[] var4, int var5, String var6, long var7, Properties var9, String[][] var10, int[][] var11, String var12, long var13, NativeError var15);

    public static HashMap watch2k8EventLog(Properties domainDetails, String computerName, long recordNumber, int[] eventIDList, int machineType, String osVersion, long recentEventTime, long uniqueId) throws Exception {
        NativeError nativeError = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        HashMap filter = ExcludeFilesHandler.getInstance().constructExcludeString(domainName, machineType);
        String[][] excludeRules = (String[][])filter.get("excludeMap");
        int[][] excludeOpList = (int[][])filter.get("excludeOperators");
        long evtTime = recentEventTime * 1000L + 1L;
        String evtQueryTime = TimeUtil.getEVTQueryEventTime(evtTime);
        long x = System.currentTimeMillis();
        nativeLogger.log(Level.INFO, "Start Time [" + computerName + "] Real Time in ADHandler ----> " + x + ".");
        Hashtable table = ADHandler.Watch2k8EventLog(domainDetails, computerName, recordNumber, eventIDList, machineType, osVersion, recentEventTime, null, excludeRules, excludeOpList, evtQueryTime, uniqueId, nativeError);
        long y = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", table);
        if (nativeError.getErrorMessage(domainName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(domainName));
        } else if (nativeError.getErrorMessage(computerName) != null) {
            resultMap.put("errorMessage", nativeError.getErrorMessage(computerName));
        }
        nativeLogger.log(Level.INFO, "End Time [" + computerName + "] Real Time in ADHandler ----> " + y + ".");
        nativeLogger.log(Level.INFO, "Time Taken by[" + computerName + "] Real Time in ADHandler ----> " + (y - x) / 1000L + ".");
        return resultMap;
    }

    public static native Hashtable FindDC(Properties var0, NativeError var1, ArrayList var2);

    public static Hashtable findDC(String domainname, ArrayList list) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainname, 1L);
        Hashtable map = new Hashtable();
        map = ADHandler.FindDC(domainDetails, errHdlr, list);
        String error = "";
        if (errHdlr.getErrorMessage(domainname) != null) {
            error = errHdlr.getErrorMessage(domainname);
        } else if (errHdlr.getErrorMessage(list.get(list.size() - 1)) != null) {
            error = errHdlr.getErrorMessage(list.get(list.size() - 1));
        }
        map.put("errorfromdc", error);
        return map;
    }

    public static native Hashtable RSOPPrintHandler(Properties var0, String var1, NativeError var2, int var3);

    public static Hashtable rsopPrintHandler(String domainname, String dcName, int pingID) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainname, 1L);
        Hashtable map = new Hashtable();
        map = ADHandler.RSOPPrintHandler(domainDetails, dcName, errHdlr, pingID);
        String error = "";
        if (errHdlr.getErrorMessage(domainname) != null) {
            error = errHdlr.getErrorMessage(domainname);
        } else if (errHdlr.getErrorMessage(dcName) != null) {
            error = errHdlr.getErrorMessage(dcName);
        }
        map.put("error", error);
        return map;
    }

    public static native ArrayList GetExchangeCallerUserName(Properties var0, NativeError var1, String var2, String var3);

    public static ArrayList getExchangeCallerUserName(String domainName, String computerName, String xmlQuery) {
        ArrayList retList = new ArrayList();
        try {
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            NativeError errHdlr = new NativeError();
            retList = ADHandler.GetExchangeCallerUserName(domainDetails, errHdlr, computerName, xmlQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retList;
    }

    private static native boolean AuthenticateUser(String var0, String var1, String var2, String var3, String var4, String var5);

    public static synchronized boolean authenticateUser(Properties domainDetails, String domainName, String loginName, String password, String isSSL) throws Exception {
        boolean result = false;
        logger.log(Level.INFO, "authenticateUser invoked");
        String serverName = ADHandler.getValidDcName(domainDetails);
        String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
        if (serverName != null) {
            result = ADHandler.AuthenticateUser(serverName, domainName, loginName, password, isSSL, defaultNamingContext);
        } else {
            domainDetails.put("USER_DISTINGUISHED_NAME", loginName);
            domainDetails.put("USER_NAME", loginName);
            domainDetails.put("PASSWORD", password);
            NativeError errHdlr = new NativeError();
            serverName = ADHandler.GetValidDcName(domainDetails, errHdlr);
            if (serverName == null && domainDetails.get("DOMAIN_CONTROLLER_LIST") != null) {
                ArrayList dcList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
                serverName = (String)dcList.get(0);
            }
            if (serverName != null) {
                result = ADHandler.AuthenticateUser(serverName, domainName, loginName, password, isSSL, defaultNamingContext);
            } else {
                throw new LoginException(errHdlr.getErrorMessage(domainName));
            }
        }
        return result;
    }

    public static native void CopyNetAppEvtFiles(Properties var0, String var1, long var2, int[] var4, int var5, String var6, long var7, Properties var9, String var10, Integer var11, NativeError var12);

    public static void copyNetAppEvtFiles(Properties domainDetails, String dcName, long recordNumber, int[] eventIDList, int machineType, String osVersion, long recentEventTime, Properties netAppDetails, String objectGuid, Integer count) throws Exception {
        NativeError ne = new NativeError();
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        ADHandler.CopyNetAppEvtFiles(domainDetails, dcName, recordNumber, eventIDList, machineType, osVersion, recentEventTime, netAppDetails, objectGuid, count, ne);
    }

    public static native String DeleteGPO(String var0, String var1, String var2, String var3, String var4, Properties var5, NativeError var6, String var7);

    public static boolean deleteGPO(String isLocalDomain, String domainName, String gpoDsPath, String gpoDcDsPath, String gpoGuid, String pdc) throws Exception {
        String advGPOReports;
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
        String res = ADHandler.DeleteGPO(isLocalDomain, gpoDsPath, gpoDcDsPath, gpoGuid, pdc, domainDetails, errHdlr, advGPOReports = System.getProperty("server.dir"));
        return res.equals("Success");
    }

    public static native Hashtable AddOrRemoveGroupMembers(Properties var0, String var1, ArrayList var2, int var3, NativeError var4);

    public static ArrayList addOrRemoveMembers(Properties domainDetails, String grpName, ArrayList memList, int action, int res) {
        ArrayList result = new ArrayList();
        NativeError errHdlr = new NativeError();
        Hashtable memberMap = ADHandler.AddOrRemoveGroupMembers(domainDetails, grpName, memList, action, errHdlr);
        if (memberMap != null && !memberMap.isEmpty()) {
            result = res == 1 ? (ArrayList)memberMap.get("AddedMembers") : (ArrayList)memberMap.get("RemovedMembers");
        }
        return result;
    }

    static {
        try {
            System.out.println("Thread.....");
            System.loadLibrary(LIBRARY_NAME);
            System.out.println("Calling Initialize classIDs from java in Static Block..");
            System.out.println("Build Number : " + CommonUtil.getBuildNumber());
            ADHandler.InitializeClassIDs();
        }
        catch (Exception e) {
            System.out.println("Exception.....");
            e.printStackTrace();
        }
    }
}

