/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateQueue;
import java.util.Hashtable;

public class DBQueue {
    private Hashtable queues = new Hashtable();
    private Hashtable generationIdQueueMap = new Hashtable();
    private static DBQueue instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBQueue getInstance() {
        if (instance != null) return instance;
        Class<DBQueue> clazz = DBQueue.class;
        synchronized (DBQueue.class) {
            if (instance != null) return instance;
            instance = new DBQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DBQueue() {
    }

    public void registerForUpdation(String tableName, Long generationId, Hashtable prop) {
        ObjectUpdateQueue queue = null;
        if (this.queues.get(tableName) == null) {
            queue = new ObjectUpdateQueue();
            this.queues.put(tableName, queue);
        } else {
            queue = (ObjectUpdateQueue)this.queues.get(tableName);
        }
        queue.setProps(generationId, prop);
        if (this.generationIdQueueMap.get(generationId) == null) {
            this.generationIdQueueMap.put(generationId, queue);
        }
    }

    public void deRegister(Long generationId) {
        this.generationIdQueueMap.remove(generationId);
    }

    public void add(Long generationId, String guid, Hashtable singleRowMap, Hashtable multiRowMap) {
        ObjectUpdateQueue queue = (ObjectUpdateQueue)this.generationIdQueueMap.get(generationId);
        queue.addToQueue(generationId, guid, singleRowMap, multiRowMap);
    }

    public void checkForNextUpdate(Long generationId) {
        ObjectUpdateQueue queue = (ObjectUpdateQueue)this.generationIdQueueMap.get(generationId);
        queue.checkForNextUpdate();
    }

    public boolean isCompleted(Long generationId) {
        ObjectUpdateQueue queue = (ObjectUpdateQueue)this.generationIdQueueMap.get(generationId);
        return queue.isCompleted(generationId);
    }
}

