/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DCHandler {
    private static Logger logger = Logger.getLogger(DCHandler.class.getName());

    public static HashMap getDCDOs(String domainName, Properties dconList) {
        HashMap<String, Row> dcDOMap = new HashMap<String, Row>();
        try {
            Row dcRow = new Row(DomainHandler.tableDCName);
            dcRow.set("DOMAIN_NAME", (Object)domainName);
            dcRow.set("DOMAIN_CONTROLLER_NAME", (Object)dconList.getProperty("DOMAIN_CONTROLLER_NAME"));
            dcRow.set("PRIORITY_ID", dconList.get("PRIORITY_ID"));
            dcRow.set("MESSAGE", (Object)dconList.getProperty("MESSAGE"));
            dcDOMap.put("dcRow", dcRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcDOMap;
    }

    public static DataObject addDCSchedulers(DataObject domainDO, Properties dcScheduleTimeMap, String domainName) throws DataAccessException {
        Long scheduleStartTime = System.currentTimeMillis();
        Row domainRow = domainDO.getRow(DomainHandler.tableName);
        DataObject eventSchedulerDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        int enabledSchedulers = EventSchedulerUtil.getEnabledEventSchedulerCount();
        Iterator iterator = domainDO.getRows(DomainHandler.tableDCName);
        while (iterator.hasNext()) {
            Row dcRow = (Row)iterator.next();
            String domainControllers = LicenseUtil.getLicenseProperty("DomainController", "NumberOfDomainControllers");
            int adminStatus = 4;
            Integer domainControllersInt = Integer.parseInt(domainControllers);
            if (enabledSchedulers < domainControllersInt) {
                ++enabledSchedulers;
                adminStatus = 3;
            }
            String dcName = (String)dcRow.get("DOMAIN_CONTROLLER_NAME");
            logger.log(Level.FINE, "The Properties are Domain : {0}, dcName : {1}, adminStatus : {2}, scheduleStartTime : {4}, timePeriod : {5}", new Object[]{domainName, dcName, adminStatus, scheduleStartTime, dcScheduleTimeMap});
            Hashtable<String, Object> dcEventProps = new Hashtable<String, Object>();
            dcEventProps.put("domainName", domainName);
            dcEventProps.put("dcName", dcName);
            dcEventProps.put("adminStatus", adminStatus);
            dcEventProps.put("scheduleStartTime", scheduleStartTime);
            dcEventProps.put("timePeriod", dcScheduleTimeMap.getProperty(dcName));
            Long scheduleId = EventSchedulerUtil.createEventScheduler(dcEventProps, 1);
            scheduleStartTime = scheduleStartTime + 300000L;
            Row dcEventRow = new Row(DomainHandler.tableEventDCRead);
            Integer fetchMode = 1;
            try {
                fetchMode = DCHandler.getEventFetchMode(domainName, dcName, scheduleId, dcEventRow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dcEventRow.set("DOMAIN_CONTROLLER_ID", dcRow.get("DOMAIN_CONTROLLER_ID"));
            dcEventRow.set("EVENT_READ", (Object)0);
            dcEventRow.set("TIME_READ", (Object)0);
            dcEventRow.set("EVENT_FETCH_MODE", (Object)fetchMode);
            dcEventRow.set("SCHEDULE_ID", (Object)scheduleId);
            eventSchedulerDO.addRow(dcEventRow);
        }
        CommonUtil.getPersistence(new boolean[0]).add(eventSchedulerDO);
        return eventSchedulerDO;
    }

    public static Long[] getDCEventSchedulers(String domainName) {
        Long[] schedulers = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add(DomainHandler.tableName);
            tablesList.add(DomainHandler.tableDCName);
            tablesList.add(DomainHandler.tableEventDCRead);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
            int size = dataObject.size(DomainHandler.tableEventDCRead);
            schedulers = new Long[size];
            int i = 0;
            Iterator iterator = dataObject.getRows(DomainHandler.tableEventDCRead);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                schedulers[i] = (Long)row.get("SCHEDULE_ID");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schedulers;
    }

    public static DataObject getDCEventSchedulerDO(Long dcId) {
        DataObject dcDataObj = null;
        try {
            Table domainConfigTable = Table.getTable((String)DomainHandler.tableDCName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(domainConfigTable);
            Criteria criteria = new Criteria(Column.getColumn((String)DomainHandler.tableDCName, (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
            selectQuery.setCriteria(criteria);
            Join dcEventJoin = new Join(DomainHandler.tableDCName, DomainHandler.tableEventDCRead, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 1);
            Join dcEventPropsJoin = new Join(DomainHandler.tableDCName, DomainHandler.tableEventDCProps, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 1);
            Join dcScheduleJoin = new Join(DomainHandler.tableEventDCRead, "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join scheduleTaskJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join dcPeriodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            selectQuery.addJoin(dcEventJoin);
            selectQuery.addJoin(dcEventPropsJoin);
            selectQuery.addJoin(dcScheduleJoin);
            selectQuery.addJoin(scheduleTaskJoin);
            selectQuery.addJoin(dcPeriodicJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)DomainHandler.tableDCName, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)DomainHandler.tableEventDCRead, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)DomainHandler.tableEventDCProps, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"*"));
            dcDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcDataObj;
    }

    public static ArrayList<String> getDomainControllerList(String domainName) {
        ArrayList<String> domainControllerList = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)DomainHandler.tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableDCName, criteria);
            Iterator rowIterator = dataObject.getRows(DomainHandler.tableDCName);
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                String domainControllerName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                if (domainControllerName.indexOf(".") > 0) {
                    int index = domainControllerName.indexOf(".");
                    domainControllerName = domainControllerName.substring(0, index);
                }
                domainControllerList.add(domainControllerName.toLowerCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainControllerList;
    }

    public static void runDCEventScheduler(Long scheduleId) {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AUDDCEventRead");
            tableList.add("ADSMDCConfiguration");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            Row row = dataObject.getRow("ADSMDCConfiguration");
            String domainName = (String)row.get("DOMAIN_NAME");
            String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
            EventDataHandler.getInstance().fillEventData(domainName, dcName, scheduleId, 1, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Integer getEventFetchMode(String domainName, String dcName, Long scheduleId, Row dcEventRow) {
        Integer fetchMode = 1;
        try {
            String localWinVer = System.getProperty("os.version");
            if (localWinVer != null && localWinVer.startsWith("6.")) {
                Properties prop;
                ArrayList list;
                String version;
                Properties domainProp = ADHandler.getDomainDetails(domainName, 1L);
                ArrayList<String> attributeList = new ArrayList<String>();
                attributeList.add("operatingSystemVersion");
                StringBuffer buff = new StringBuffer();
                buff.append("(&(objectCategory=computer)(objectClass=computer)(|(name=");
                buff.append(dcName);
                buff.append(")(dNSHostName=");
                buff.append(dcName);
                buff.append(")(cn=");
                buff.append(dcName);
                buff.append(")))");
                ArrayList result = ADHandler.getObjectsWithOutListener(domainProp, domainProp.get("DEFAULT_NAMING_CONTEXT").toString(), attributeList, buff.toString());
                if (null != result && !result.isEmpty() && null != (version = (String)(list = (ArrayList)(prop = (Properties)result.get(0)).get("operatingSystemVersion")).get(0)) && version.startsWith("6.")) {
                    dcEventRow.set("OS_VERSION", (Object)version);
                    fetchMode = 3;
                    RealTimeEventUtil.getInstance().updateTaskInput(scheduleId, 3);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fetchMode;
    }

    public static boolean isEventFetchChange(Long dcId, Integer fetchMode) {
        boolean b = true;
        try {
            DataObject dataObj = DCHandler.getDCEventSchedulerDO(dcId);
            Row row = dataObj.getRow(DomainHandler.tableEventDCRead);
            if (row != null) {
                int oldFetchMode = (Integer)row.get("EVENT_FETCH_MODE");
                if (2 >= oldFetchMode) {
                    oldFetchMode = 1;
                }
                if (oldFetchMode == fetchMode) {
                    b = false;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }
}

