/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;

public class DomainAction {
    public static Properties addDomainGeneralDetails(String domainName) {
        String objectSID = "";
        String objectGUID = "";
        try {
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("objectSID");
            attributeList.add("objectGUID");
            attributeList.add("distinguishedName");
            attributeList.add("canonicalName");
            ArrayList domainPropsList = ADHandler.getDomainObjectProps(domainName, attributeList, "(objectClass=domainDNS)");
            Row row = new Row("ADSMDomainGeneralDetails");
            if (domainPropsList != null && !domainPropsList.isEmpty()) {
                ArrayList canonList;
                ArrayList dnList;
                ArrayList guidList;
                Properties properties = (Properties)domainPropsList.get(0);
                ArrayList sidList = (ArrayList)properties.get("objectSID");
                if (sidList != null && !sidList.isEmpty()) {
                    objectSID = (String)sidList.get(0);
                    row.set("SID_STRING", (Object)objectSID);
                }
                if ((guidList = (ArrayList)properties.get("objectGUID")) != null && !guidList.isEmpty()) {
                    objectGUID = (String)guidList.get(0);
                    row.set("OBJECT_GUID", (Object)objectGUID);
                }
                if ((dnList = (ArrayList)properties.get("distinguishedName")) != null && !dnList.isEmpty()) {
                    row.set("DISTINGUISHED_NAME", dnList.get(0));
                }
                if ((canonList = (ArrayList)properties.get("canonicalName")) != null && !canonList.isEmpty()) {
                    row.set("CANONICAL_NAME", canonList.get(0));
                }
                row.set("NAME", (Object)domainName);
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties domainProps = new Properties();
        domainProps.setProperty("SID_STRING", objectSID);
        domainProps.setProperty("OBJECT_GUID", objectGUID);
        domainProps.setProperty("DOMAIN_NAME", domainName);
        return domainProps;
    }

    public static Properties getDomainGeneralDetails(String domainName) {
        Properties domainProps = new Properties();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", criteria);
            if (dataObject.size("ADSMDomainGeneralDetails") > 0) {
                Row row = dataObject.getRow("ADSMDomainGeneralDetails");
                domainProps.setProperty("DOMAIN_NAME", domainName);
                domainProps.setProperty("SID_STRING", (String)row.get("SID_STRING"));
                domainProps.setProperty("OBJECT_GUID", (String)row.get("OBJECT_GUID"));
            } else {
                domainProps = DomainAction.addDomainGeneralDetails(domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainProps;
    }

    public static void deleteDomainDatas(String domainName) {
        try {
            EventSchedulerUtil.deleteDCEventSchedulers(domainName);
            Criteria deleteFileAuditSchedulers = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)domainName, 10);
            deleteFileAuditSchedulers = deleteFileAuditSchedulers.and(new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)"File_Audit_Scheduler", 11));
            CommonUtil.getPersistenceLite().delete(deleteFileAuditSchedulers);
            MSHandler.deleteMSTasks(domainName);
            AuditMonitorHandler.getInstance().deleteDomainBasedMonitors(domainName);
            Column column = Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(column, (Object)domainName, 0);
            if (com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)"ManageEngine Log360")) {
                CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            } else {
                CommonUtil.getPersistenceLite().delete(criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

