/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class DomainDetailsAPI {
    private static Hashtable domainNameVsDNSDomainName = null;
    private static Hashtable domainNameVsFlatDomainName = null;
    private static Hashtable defaultNamingContextVsFlatDomainName = null;
    private static Hashtable defaultNamingContextVsDomainName = null;
    private static Hashtable domainNameVsRDNC = null;
    private static Hashtable domainNameVsDNSServers = null;

    public static void resetValues() {
        domainNameVsDNSDomainName = null;
        domainNameVsFlatDomainName = null;
        defaultNamingContextVsFlatDomainName = null;
        defaultNamingContextVsDomainName = null;
        domainNameVsRDNC = null;
        domainNameVsDNSServers = null;
    }

    public static String getDomainDNSName(String domainName) {
        String domainDNSName = null;
        try {
            if (domainNameVsDNSDomainName == null) {
                domainNameVsDNSDomainName = new Hashtable();
            }
            if (domainNameVsDNSDomainName.get(domainName) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainNameVsDNSDomainName.put(r.get("DOMAIN_NAME"), r.get("DOMAIN_DNS_NAME"));
                }
            }
            domainDNSName = (String)domainNameVsDNSDomainName.get(domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainDNSName;
    }

    public static String getDomainFlatName(String domainName, boolean escapeForQuery) {
        String domainFlatName = null;
        try {
            if (domainNameVsFlatDomainName == null) {
                domainNameVsFlatDomainName = new Hashtable();
            }
            if (domainNameVsFlatDomainName.get(domainName) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainNameVsFlatDomainName.put(r.get("DOMAIN_NAME"), r.get("DOMAIN_FLAT_NAME"));
                }
            }
            domainFlatName = (String)domainNameVsFlatDomainName.get(domainName);
            if (escapeForQuery && domainFlatName != null) {
                domainFlatName = EscapeUtil.escSplCharsAsSQL(domainFlatName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainFlatName;
    }

    public static String getDnFlatName(String defaultNamingContext) {
        String domainFlatName = null;
        try {
            if (defaultNamingContextVsFlatDomainName == null) {
                defaultNamingContextVsFlatDomainName = new Hashtable();
            }
            if (defaultNamingContextVsFlatDomainName.get(defaultNamingContext) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DEFAULT_NAMING_CONTEXT"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    defaultNamingContextVsFlatDomainName.put(r.get("DEFAULT_NAMING_CONTEXT"), r.get("DOMAIN_FLAT_NAME"));
                }
            }
            domainFlatName = (String)defaultNamingContextVsFlatDomainName.get(defaultNamingContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainFlatName;
    }

    public static String getDNCDomainName(String defaultNamingContext) {
        String domainName = null;
        try {
            if (defaultNamingContextVsDomainName == null) {
                defaultNamingContextVsDomainName = new Hashtable();
            }
            if (defaultNamingContextVsDomainName.get(defaultNamingContext) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DEFAULT_NAMING_CONTEXT"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    defaultNamingContextVsDomainName.put(r.get("DEFAULT_NAMING_CONTEXT"), r.get("DOMAIN_NAME"));
                }
            }
            domainName = (String)defaultNamingContextVsDomainName.get(defaultNamingContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainName;
    }

    public static String getDomainObjectGuid(String domainName) {
        String guid = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", crit);
            Row r = dataObject.getFirstRow("ADSMDomainGeneralDetails");
            guid = (String)r.get("OBJECT_GUID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guid;
    }

    public static String getDomainName(String defaultNamingContext) {
        String domainName = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DEFAULT_NAMING_CONTEXT"), (Object)defaultNamingContext, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DNS_NAME"), (Object)defaultNamingContext, 0));
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_FLAT_NAME"), (Object)defaultNamingContext, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
            domainName = (String)r.get("DOMAIN_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static String getDomainDNSZone(String domainName) {
        return "DC=DomainDNSZones," + DomainDetailsAPI.getDefaultNamingContext(domainName);
    }

    public static String getForestDNSZone(String domainName) {
        return "DC=ForestDNSZones," + DomainDetailsAPI.getRootDomainNamingContext(domainName);
    }

    public static String getDefaultNamingContext(String domainName) {
        String defaultNamingContext = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
            defaultNamingContext = (String)r.get("DEFAULT_NAMING_CONTEXT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultNamingContext;
    }

    public static String getSchemaNamingContext(String domainName) {
        String schemaNamingContext = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
            schemaNamingContext = (String)r.get("SCHEMA_NAMING_CONTEXT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schemaNamingContext;
    }

    public static String getConfigurationNamingContext(String domainName) {
        String schemaNamingContext = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
            schemaNamingContext = (String)r.get("CONFIGURATION_NAMING_CONTEXT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schemaNamingContext;
    }

    public static boolean isDomainPrivileged(String domainName) throws Exception {
        boolean status = false;
        String msg = null;
        String defaultDomain = null;
        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableName, new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
        Iterator ite = obj.getRows(DomainHandler.tableName);
        while (ite.hasNext()) {
            Row r = (Row)ite.next();
            defaultDomain = (String)r.get("IS_DEFAULT_DOMAIN");
            if (!defaultDomain.equals("true") || !(msg = (String)r.get("MESSAGE")).equals("Success")) continue;
            status = true;
            break;
        }
        return status;
    }

    public static String getDefaultDomainName() throws Exception {
        String defaultDomainName = "";
        Object msg = null;
        String defaultDomain = null;
        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableName, new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)"", 1));
        Iterator ite = obj.getRows(DomainHandler.tableName);
        while (ite.hasNext()) {
            Row r = (Row)ite.next();
            defaultDomain = (String)r.get("IS_DEFAULT_DOMAIN");
            if (!defaultDomain.equals("true")) continue;
            defaultDomainName = (String)r.get("DOMAIN_NAME");
        }
        return defaultDomainName;
    }

    public static String getRootDomainNamingContext(String domainName) {
        String rootDNC = null;
        try {
            if (domainNameVsRDNC == null) {
                domainNameVsRDNC = new Hashtable();
            }
            if (domainNameVsRDNC.get(domainName) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"ROOT_DOMAIN_NAMING_CONTEXT"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainNameVsRDNC.put(r.get("DOMAIN_NAME"), r.get("ROOT_DOMAIN_NAMING_CONTEXT"));
                }
            }
            rootDNC = (String)domainNameVsRDNC.get(domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rootDNC;
    }

    public static ArrayList<String> getDNSServers(String domainName) {
        ArrayList dnsServersList = new ArrayList();
        try {
            if (domainNameVsDNSServers == null) {
                domainNameVsDNSServers = new Hashtable();
            }
            if (domainNameVsDNSServers.get(domainName) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                crit.and(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"DomainController", 2);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", crit);
                Iterator it = obj.getRows("ADSMComputerGeneralDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    dnsServersList.add(r.get("NAME").toString());
                }
                domainNameVsDNSServers.put(domainName, dnsServersList);
            }
            dnsServersList = (ArrayList)domainNameVsDNSServers.get(domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dnsServersList;
    }

    public static ArrayList<String> getConfiguredDomainList() {
        ArrayList<String> domainList = new ArrayList<String>();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", (Row)null);
            Iterator rowIterator = dataObject.getRows("ADSMDomainConfiguration");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                domainList.add((String)row.get("DOMAIN_NAME"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static String getContext(String domainName, String contextType) {
        if (contextType.equalsIgnoreCase("${defaultNamingContext}")) {
            return DomainDetailsAPI.getDefaultNamingContext(domainName);
        }
        if (contextType.equalsIgnoreCase("${schemaNamingContext}")) {
            return DomainDetailsAPI.getSchemaNamingContext(domainName);
        }
        if (contextType.equalsIgnoreCase("${configurationNamingContext}")) {
            return DomainDetailsAPI.getConfigurationNamingContext(domainName);
        }
        if (contextType.equalsIgnoreCase("${domainDNSZones}")) {
            return DomainDetailsAPI.getDomainDNSZone(domainName);
        }
        if (contextType.equalsIgnoreCase("${forestDNSZones}")) {
            return DomainDetailsAPI.getForestDNSZone(domainName);
        }
        if (contextType.equalsIgnoreCase("${RDNC}")) {
            return DomainDetailsAPI.getRootDomainNamingContext(domainName);
        }
        return null;
    }
}

