/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.auditing.server.compliance.TemplateTableHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventController;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.auditing.server.gpo.PDCHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DCHandler;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DomainHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String tableName = "ADSMDomainConfiguration";
    public static String tableDCName = "ADSMDCConfiguration";
    public static String tableEventDCRead = "AUDDCEventRead";
    public static String tableEventDCProps = "AUDDCEventLogProps";
    public static String tableComputerEventRead = "AUDComputerEventRead";
    public static String tableGeneralDetails = "ADSMComputerGeneralDetails";
    private static Object syncObj = new Object();
    private static Logger logger = Logger.getLogger(DomainHandler.class.getName());

    public static void addDomain(String domainName, ArrayList domainControllerName) {
        logger.log(Level.INFO, " Add Domains called from Native..... " + domainName + " and the DC : " + domainControllerName);
        if (domainName == null || domainControllerName == null) {
            return;
        }
        Properties p = new Properties();
        p.put("DOMAIN_NAME", domainName);
        p.put("DOMAIN_CONTROLLER_LIST", domainControllerName);
        p.put("IS_AUTHENTICATION_REQUIRED", "false");
        if (DomainHandler.getSelectedDomain(1L).size() > 0) {
            p.put("IS_DEFAULT_DOMAIN", "false");
        } else {
            p.put("IS_DEFAULT_DOMAIN", "true");
        }
        try {
            DomainHandler.addDomain(p, false, true, new boolean[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean addDomainDetails(Properties domainDetails, boolean ... flags) throws Exception {
        boolean status = true;
        DomainHandler.addDomain(domainDetails, true, false, flags);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkNoOfDomains() throws Exception {
        Object object = syncObj;
        synchronized (object) {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", (Row)null);
            ArrayList domainList = CommonUtil.getList(dataObject, new String[]{"DOMAIN_NAME"}, "ADSMDomainConfiguration");
            String noOfDomains = LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains");
            String type = LicenseUtil.getLicenseType();
            int no = 2;
            try {
                no = Integer.parseInt(noOfDomains);
            }
            catch (Exception ex) {
                no = 2;
                ex.printStackTrace();
            }
            if (domainList.size() >= no) {
                throw new Exception(rb.handleGetObject("adap.DomainHandler.License_is_applied_to_only_these_domains", new String[]{Integer.toString(no)}));
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void addDomain(Properties domainDetails, boolean contextValues, boolean fromNative, boolean ... flags) throws Exception {
        if (!DomainHandler.checkNoOfDomains()) {
            throw new Exception("Exception occured");
        }
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        boolean caseSensitivity = false;
        Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
        Criteria crit = new Criteria(col, (Object)domainName, 0, caseSensitivity);
        Criteria criter = crit.or(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainName, 0, caseSensitivity));
        Criteria criteria = criter.or(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, caseSensitivity));
        DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
        if (!dataObj.isEmpty()) throw new Exception(rb.getString("adap.DomainHandler.Domain_Already_Exists"));
        if (!DomainHandler.addUpdateDomains(domainDetails = DomainHandler.getDomainDetails(domainDetails, contextValues), dataObj = CommonUtil.getPersistence(flags).constructDataObject(), "add", fromNative, flags)) throw new Exception(rb.getString("adap.DomainHandler.Problem_while_Adding_DomainDetails"));
        DomainProcess.getInstance().process(Long.valueOf(System.currentTimeMillis()).toString(), domainName, 1L, "add", null);
        try {
            TemplateTableHandler.createAll(domainName);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        MSHandler.synchronizeNow("to Sync added Domain Details", false);
    }

    public static boolean updateDomainDetails(Properties domainDetails, boolean ... flags) throws Exception {
        boolean status = true;
        ArrayList<String> tblList = new ArrayList<String>();
        tblList.add(tableDCName);
        tblList.add(tableEventDCRead);
        domainDetails = DomainHandler.getDomainDetails(domainDetails, true);
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
        Criteria criteria = new Criteria(col, (Object)domainName, 0);
        DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
        Criteria dcCriteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
        DataObject dcDataObj = CommonUtil.getPersistence(flags).get(tblList, dcCriteria);
        logger.log(Level.INFO, "dcDataObj -> " + dcDataObj);
        dcDataObj.deleteRows(tableDCName, dcCriteria);
        dataObj.deleteRows("AUDAuditPolicy", criteria);
        CommonUtil.getPersistence(flags).update(dcDataObj);
        status = DomainHandler.addUpdateDomains(domainDetails, dataObj, "update", false, flags);
        return status;
    }

    private static boolean addUpdateDomains(Properties domainDetails, DataObject dataObj, String operation, boolean fromNative, boolean ... flags) throws Exception {
        boolean status = true;
        ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        logger.log(Level.FINE, "dcDetails -> " + dcDetails);
        try {
            Row row = new Row(tableName);
            Properties dcScheduleTimeMap = new Properties();
            for (int j = 0; j < dcDetails.size(); ++j) {
                Properties dconList = (Properties)dcDetails.get(j);
                HashMap dcDOMap = DCHandler.getDCDOs(domainName, dconList);
                Row dcRow = (Row)dcDOMap.get("dcRow");
                Long priorityId = (Long)dconList.get("PRIORITY_ID");
                if (priorityId == 1L) {
                    domainDetails.put("DOMAIN_CONTROLLER_ID", dcRow.get("DOMAIN_CONTROLLER_ID"));
                    CommonUtil.updateRow(row, domainDetails);
                }
                dataObj.addRow(dcRow);
                String timePeriod = "120";
                if (dconList.getProperty("TIME_PERIOD") != null) {
                    timePeriod = dconList.getProperty("TIME_PERIOD");
                }
                dcScheduleTimeMap.setProperty(dconList.getProperty("DOMAIN_CONTROLLER_NAME"), timePeriod);
            }
            dataObj.addRow(row);
            CommonUtil.getPersistence(flags).update(dataObj);
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
            rowDataMap.put("DOMAIN_NAME", domainName);
            rowDataMap.put("MESSAGE", "Success");
            rowDataMap.put("STATUS", true);
            GPOManagementListener.getInstance().updateGPOFileWatcherDetails(rowDataMap);
            PDCHandler.getInstance().startNativeThread(domainName);
            DCHandler.addDCSchedulers(dataObj, dcScheduleTimeMap, domainName);
            if (!fromNative) {
                PolicyHandler ph = new PolicyHandler();
                PolicyHandler.addAuditPolicy(domainName);
                PolicyHandler.addDCEventLogToDB(domainName);
            }
            ObjectAttributeHandler.getInstance().resetValues();
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static boolean addDomainControllers(Properties domainDetails) throws Exception {
        boolean flag = true;
        boolean existingDcCheck = false;
        String existingDcMessage = "";
        try {
            ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
            String domainName = domainDetails.getProperty("DOMAIN_NAME");
            Long maxPriorityId = DomainHandler.getMaxPriorityId(domainName);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Properties dcScheduleTimeMap = new Properties();
            String domainDns = "." + domainDetails.getProperty("DOMAIN_DNS_NAME").toString();
            String dcNameWithDns = "";
            DataObject dcDataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDCConfiguration", (Criteria)null);
            String existingDc = "";
            for (Object object : dcDetails) {
                Properties dconList = (Properties)object;
                String dcDetailsString = dconList.get("DOMAIN_CONTROLLER_NAME").toString();
                if (dcDetailsString.contains(domainDns)) {
                    int domainDnsLength = domainDns.length();
                    dcNameWithDns = dcDetailsString.substring(0, dcDetailsString.length() - domainDnsLength);
                } else {
                    dcNameWithDns = dcDetailsString + domainDns;
                }
                Criteria c1 = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)dcDetailsString, 0, false);
                Criteria c2 = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)dcNameWithDns, 0, false);
                Criteria c = c1.or(c2);
                Iterator it = dcDataObject.getRows("ADSMDCConfiguration", c);
                if (it.hasNext()) {
                    Row s = (Row)it.next();
                    existingDc = existingDc.equals("") ? s.get(1).toString() : existingDc + "," + s.get(1).toString();
                    existingDcCheck = true;
                    continue;
                }
                maxPriorityId = maxPriorityId + 1L;
                dconList.put("PRIORITY_ID", maxPriorityId);
                HashMap dcDOMap = DCHandler.getDCDOs(domainName, dconList);
                dataObject.addRow((Row)dcDOMap.get("dcRow"));
                String timePeriod = "120";
                if (dconList.getProperty("TIME_PERIOD") != null) {
                    timePeriod = dconList.getProperty("TIME_PERIOD");
                }
                dcScheduleTimeMap.setProperty(dconList.getProperty("DOMAIN_CONTROLLER_NAME"), timePeriod);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            MSHandler.synchronizeNow("to Sync added DomainControllers Details", false);
            DCHandler.addDCSchedulers(dataObject, dcScheduleTimeMap, domainName);
            RealTimeEventUtil.getInstance();
            RealTimeEventUtil.startEventFetchAddedDC(dataObject);
            existingDcMessage = rb.handleGetObject("adap.DomainHandler.For_domain_the_domain_controllers_are_already_added", new String[]{domainDetails.getProperty("DOMAIN_NAME").toString(), existingDc});
        }
        catch (DataAccessException e) {
            String message = e.getMessage();
            if (message.contains("Duplicate entry")) {
                List errList = e.getErrRows();
                String errDomainControllers = "";
                String errDomainName = "";
                for (int i = 0; i < errList.size(); ++i) {
                    Row erRow = (Row)errList.get(i);
                    if (!errDomainControllers.equals("")) {
                        errDomainControllers = errDomainControllers + ", ";
                    }
                    errDomainControllers = errDomainControllers + erRow.get("DOMAIN_CONTROLLER_NAME");
                    errDomainName = erRow.get("DOMAIN_NAME").toString();
                }
                message = rb.handleGetObject("adap.DomainHandler.For_domain_the_domain_controllers_are_already_added", new String[]{errDomainName, errDomainControllers});
            }
            throw new Exception(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        if (existingDcCheck) {
            throw new Exception(existingDcMessage);
        }
        return flag;
    }

    public static Long getMaxPriorityId(String domainName) {
        Long maxPriorityId = 0L;
        try {
            Table dcTable = Table.getTable((String)tableDCName);
            SelectQueryImpl query = new SelectQueryImpl(dcTable);
            Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableDCName, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableDCName);
                maxPriorityId = (Long)row.get("PRIORITY_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxPriorityId;
    }

    public static boolean updateCredentials(Properties domainDetails) {
        boolean flag = false;
        try {
            ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
            String domainName = (String)domainDetails.remove("DOMAIN_NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject domainDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row row = domainDO.getRow(tableName);
            if (row != null) {
                CommonUtil.updateRow(row, domainDetails);
                domainDO.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(domainDO);
                flag = true;
            }
            MSHandler.synchronizeNow("to Sync updated Domain Credentials", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static Properties getDomainDetails(Properties domainDetails, boolean contextValues) throws Exception {
        NativeError nativeError = new NativeError();
        String userName = "";
        String userDNName = (String)domainDetails.get("USER_DISTINGUISHED_NAME");
        String userDomain = (String)domainDetails.get("DOMAIN_NAME");
        if (userDNName != null) {
            int pos;
            if (userDNName.contains("@")) {
                pos = userDNName.indexOf(64);
                userName = userDNName.substring(0, pos);
                userDomain = userDNName.substring(pos + 1, userDNName.length());
                domainDetails.put("USER_NAME", userName);
            } else if (userDNName.contains("\\")) {
                pos = userDNName.indexOf(92);
                userDomain = userDNName.substring(0, pos);
                userName = userDNName.substring(pos + 1, userDNName.length());
                userDNName = userDomain + "\\" + userName;
                domainDetails.put("USER_NAME", userName);
            } else {
                domainDetails.put("USER_NAME", userDNName);
            }
        }
        domainDetails.put("USER_DOMAIN_NAME", userDomain);
        Properties details = ADHandler.GetDomainDetails(domainDetails, nativeError);
        domainDetails.putAll((Map<?, ?>)details);
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        Hashtable domainError = nativeError.getError(domainName);
        ArrayList<Properties> dcs = new ArrayList<Properties>();
        ArrayList dcEvt = new ArrayList();
        if (domainError != null) {
            String mess = (String)domainError.get("ERROR_SEVERITY");
            String level = (String)domainError.get("ERROR_MESSAGE");
            if (mess.equals("SEVERE") && contextValues) {
                String errorCode = (String)domainError.get("ERROR_CODE");
                if (errorCode.equalsIgnoreCase("8007203a")) {
                    level = level + rb.handleGetObject("adap.DomainHandler.8007203a_error_code_text", new String[]{domainName});
                }
                throw new Exception(level);
            }
            domainDetails.put("MESSAGE", level);
        } else {
            domainDetails.put("MESSAGE", "Success");
        }
        ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
        HashMap dcPropMap = (HashMap)domainDetails.remove("DC_PROP_MAP");
        if (dcPropMap == null) {
            dcPropMap = new HashMap();
        }
        int priorityId = 1;
        for (int i = 0; i < dcDetails.size(); ++i) {
            String domainControllerName = (String)dcDetails.get(i);
            Hashtable error = nativeError.getError(domainControllerName);
            Properties p = (Properties)dcPropMap.get(domainControllerName);
            if (p == null) {
                p = new Properties();
                p.setProperty("DOMAIN_CONTROLLER_NAME", domainControllerName);
            }
            if (error != null) {
                p.put("MESSAGE", error.get("ERROR_MESSAGE"));
                p.put("PRIORITY_ID", (Object)(dcDetails.size() - i + (priorityId - 1)));
            } else {
                p.put("PRIORITY_ID", (Object)priorityId);
                ++priorityId;
            }
            dcs.add(p);
        }
        domainDetails.put("DOMAIN_CONTROLLER_LIST", dcs);
        String passWord = (String)domainDetails.get("PASSWORD");
        if (passWord != null) {
            domainDetails.put("PASSWORD", passWord);
        }
        domainDetails.remove("USER_DOMAIN_NAME");
        return domainDetails;
    }

    public static void updateDomain(String domainName, Long loginId, String[] selectedUpdates) throws Exception {
        Hashtable props = new Hashtable();
        ArrayList<String> updates = new ArrayList<String>();
        for (int j = 0; j < selectedUpdates.length; ++j) {
            updates.add(selectedUpdates[j]);
        }
        props.put("actionList", updates);
        DomainProcess.getInstance().process(Long.valueOf(System.currentTimeMillis()).toString(), domainName, loginId, "update", props);
    }

    public static void updateDomainDatas(String domainName, Long loginId, String[] selectedUpdates) {
        try {
            logger.log(Level.INFO, "Checking ADServer Status...");
            String message = "Success";
            if (ADHandler.checkServerStatus(domainName, loginId)) {
                ArrayList<String> updates = new ArrayList<String>();
                for (int j = 0; j < selectedUpdates.length; ++j) {
                    updates.add(selectedUpdates[j]);
                }
                Object column = null;
                Object criteria = null;
                for (int i = 0; i < updates.size(); ++i) {
                    String update = (String)updates.get(i);
                }
            } else {
                logger.log(Level.INFO, "ADServer Not Running...Updates quits");
                message = rb.getString("adap.DomainHandler.Unable_to_contact_AD_Server");
            }
            try {
                Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)1, 0));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
                if (!dataObject.isEmpty()) {
                    Iterator it = dataObject.getRows(tableDCName, criteria);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        r.set("MESSAGE", (Object)message);
                        dataObject.updateRow(r);
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void scheduleUpdate(String domainName) {
        try {
            logger.log(Level.INFO, "Populating table .............");
            DomainProcess.getInstance().process(Long.valueOf(System.currentTimeMillis()).toString(), domainName, 1L, "scheduleUpdate", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean populateTable(String sidTableName, String domainName) {
        try {
            logger.log(Level.INFO, "Populating table .............");
            DomainProcess.getInstance().process(Long.valueOf(System.currentTimeMillis()).toString(), domainName, 1L, "add", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteDomain(String domainName) throws Exception {
        boolean status = true;
        Object object = syncObj;
        synchronized (object) {
            String key = Long.valueOf(System.currentTimeMillis()).toString();
            TemplateTableHandler.deleteAll(domainName);
            DomainProcess.getInstance().set(key, domainName, "delete");
            RealTimeEventUtil.getInstance().stopRealTimeDeletedDomain(DCHandler.getDCEventSchedulers(domainName));
            DomainAction.deleteDomainDatas(domainName);
            DomainProcess.getInstance().finished(key, domainName);
            AlertAPI.getInstance().deleteGPOAlertProfile(domainName);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow(tableName);
                domainName = (String)r.get("DOMAIN_NAME");
                DomainHandler.setDefaultDomain(domainName, new boolean[0]);
            }
            EventDataUtil.removeDomainDetailsMap(domainName);
            MSHandler.synchronizeNow("to Sync deleted deleteDomain", false);
        }
        return status;
    }

    public static synchronized boolean startDomainDiscovery() {
        return DomainHandler.startDomainDiscovery(false);
    }

    public static synchronized boolean startDomainDiscovery(boolean forceFully) {
        boolean status = false;
        try {
            Column col = Column.getColumn((String)"ADSMSchedulerStatus", (String)"SCHEDULER_NAME");
            Criteria criteria = new Criteria(col, (Object)"DomainDiscovery", 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSchedulerStatus", criteria);
            if (dataObj.isEmpty()) {
                Row row = new Row("ADSMSchedulerStatus");
                row.set("SCHEDULER_NAME", (Object)"DomainDiscovery");
                row.set("STATUS", (Object)"false");
                dataObj.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                new Thread(new GetDomains()).start();
                status = true;
            } else {
                Row row = dataObj.getRow("ADSMSchedulerStatus");
                String stat = (String)row.get("STATUS");
                if (stat.equals("false")) {
                    if (forceFully) {
                        new Thread(new GetDomains()).start();
                    }
                    status = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static ArrayList getRestrictedConfiguredList(Long loginID) {
        Table baseTable = Table.getTable((String)tableName);
        Table joinTable = Table.getTable((String)tableDCName);
        ArrayList<Properties> ret = new ArrayList<Properties>();
        try {
            Object logonUserProps = null;
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)1L, 0);
            Criteria criter = null;
            if (loginID.equals(1L)) {
                criter = LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1") ? crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0)) : crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1));
            }
            sq.setCriteria(criter);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                Properties p = new Properties();
                p.put("DOMAIN_NAME", domainName);
                String uName = (String)r.get("USER_DISTINGUISHED_NAME");
                if (uName == null || uName.equals("")) {
                    uName = "-";
                }
                p.put("DEFAULT_NAMING_CONTEXT", r.get("DEFAULT_NAMING_CONTEXT"));
                p.put("USER_DISTINGUISHED_NAME", uName);
                p.put("IS_DEFAULT_DOMAIN", (String)r.get("IS_DEFAULT_DOMAIN"));
                p.put("MESSAGE", (String)r.get("MESSAGE"));
                p.put("DOMAIN_DNS_NAME", (String)r.get("DOMAIN_DNS_NAME"));
                p.put("DOMAIN_FLAT_NAME", (String)r.get("DOMAIN_FLAT_NAME"));
                Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
                Iterator ite = dcDataObj.getRows(tableDCName, criteria);
                ArrayList<Properties> dcs = new ArrayList<Properties>();
                while (ite.hasNext()) {
                    Row rw = (Row)ite.next();
                    Properties pr = new Properties();
                    String dcName = (String)rw.get("DOMAIN_CONTROLLER_NAME");
                    String msg = (String)rw.get("MESSAGE");
                    if (msg == null) {
                        pr.put("MESSAGE", "null");
                    } else {
                        pr.put("MESSAGE", msg);
                    }
                    pr.put("DCS", dcName);
                    dcs.add(pr);
                }
                p.put("DOMAINCONTROLLERS", dcs);
                ite = dcDataObj.getRows(tableDCName, crit);
                while (ite.hasNext()) {
                    Row dcr = (Row)ite.next();
                    p.put("DOMAIN_CONTROLLER_NAME", (String)dcr.get("DOMAIN_CONTROLLER_NAME"));
                }
                ret.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean getDomainOption(String domainName) {
        Table baseTable = Table.getTable((String)tableName);
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dbobj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = dbobj.getRows(tableName);
            Row r = null;
            if (it.hasNext()) {
                r = (Row)it.next();
            }
            boolean ret = (Boolean)r.get("LOG_ON_TO_OPTION");
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setDomainOption(String domainName, boolean value) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject d = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Row r = d.getRow(tableName);
            r.set("LOG_ON_TO_OPTION", (Object)value);
            d.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getFullConfiguredList(Long loginId, boolean defaultSortEnabled, String delegatedDomain) {
        return DomainHandler.getDomainConfig(defaultSortEnabled, true, delegatedDomain);
    }

    public static ArrayList getConfiguredList(Long loginId, boolean defaultSortEnabled) {
        return DomainHandler.getDomainConfig(defaultSortEnabled, false, null);
    }

    public static ArrayList getConfiguredList(Long loginId, boolean defaultSortEnabled, String delegatedDomain) {
        return DomainHandler.getDomainConfig(defaultSortEnabled, false, delegatedDomain);
    }

    public static ArrayList getDomainConfig(boolean defaultSortEnabled, boolean getDCList, String delegatedDomain) {
        Table baseTable = Table.getTable((String)tableName);
        Table joinTable = Table.getTable((String)tableDCName);
        ArrayList<Properties> ret = new ArrayList<Properties>();
        try {
            Criteria crit;
            Object logonUserProps = null;
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(join);
            Criteria domainCrit = crit = new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)1L, 0);
            if (!(delegatedDomain == null || delegatedDomain.equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) || delegatedDomain.equalsIgnoreCase("adap.common.text.All_Domains") || delegatedDomain.equalsIgnoreCase("All Domains"))) {
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)delegatedDomain.split(","), 8));
            }
            if (defaultSortEnabled) {
                SortColumn sortColumn = new SortColumn(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), false);
                sq.addSortColumn(sortColumn);
            }
            sq.setCriteria(domainCrit);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                Properties p = new Properties();
                p.put("DOMAIN_NAME", domainName);
                String uName = (String)r.get("USER_DISTINGUISHED_NAME");
                if (uName == null || uName.equals("")) {
                    uName = "-";
                }
                p.put("DEFAULT_NAMING_CONTEXT", r.get("DEFAULT_NAMING_CONTEXT"));
                p.put("USER_DISTINGUISHED_NAME", uName);
                p.put("IS_DEFAULT_DOMAIN", (String)r.get("IS_DEFAULT_DOMAIN"));
                p.put("IS_AUTHENTICATION_REQUIRED", (String)r.get("IS_AUTHENTICATION_REQUIRED"));
                p.put("MESSAGE", (String)r.get("MESSAGE"));
                p.put("DOMAIN_DNS_NAME", (String)r.get("DOMAIN_DNS_NAME"));
                p.put("DOMAIN_FLAT_NAME", (String)r.get("DOMAIN_FLAT_NAME"));
                if (getDCList) {
                    DomainHandler.getDCconfig(domainName, p, crit);
                }
                ret.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "RET -> " + ret);
        return ret;
    }

    public static void getDCconfig(String domainName, Properties p, Criteria crit) {
        ArrayList<Properties> dcs = new ArrayList<Properties>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
            Iterator ite = dcDataObj.getRows(tableDCName, criteria);
            while (ite.hasNext()) {
                Row scheduledTaskRow;
                Row rw = (Row)ite.next();
                Long dcId = (Long)rw.get("DOMAIN_CONTROLLER_ID");
                DataObject dcEventSchedulerDO = DCHandler.getDCEventSchedulerDO(dcId);
                Properties pr = new Properties();
                String dcName = (String)rw.get("DOMAIN_CONTROLLER_NAME");
                String msg = (String)rw.get("MESSAGE");
                if (msg == null) {
                    pr.put("MESSAGE", "null");
                } else {
                    pr.put("MESSAGE", msg);
                }
                pr.put("DCS", dcName);
                pr.put("DC_ID", dcId);
                Row row = dcEventSchedulerDO.getRow(tableEventDCRead);
                Row eventPropsRow = dcEventSchedulerDO.getRow(tableEventDCProps);
                Properties eventDCProps = null;
                if (eventPropsRow != null) {
                    eventDCProps = new Properties();
                    eventDCProps.put("FILE_SIZE", eventPropsRow.get("FILE_SIZE"));
                    eventDCProps.put("MAX_FILE_SIZE", eventPropsRow.get("MAX_FILE_SIZE"));
                    eventDCProps.put("NO_OF_RECORDS", eventPropsRow.get("NO_OF_RECORDS"));
                    eventDCProps.put("OVERWRITE_OUTDATED", eventPropsRow.get("OVERWRITE_OUTDATED"));
                    eventDCProps.put("NAME", eventPropsRow.get("NAME"));
                    eventDCProps.put("OVERWRITE_POLICY", eventPropsRow.get("OVERWRITE_POLICY"));
                    eventDCProps.put("LOG_FILE_NAME", eventPropsRow.get("LOG_FILE_NAME"));
                    pr.put("iseventDCProps", "true");
                    pr.put("eventDCProps", eventDCProps);
                } else {
                    eventDCProps = new Properties();
                    pr.put("iseventDCProps", "false");
                    pr.put("eventDCProps", eventDCProps);
                }
                if (row != null) {
                    pr.put("TIME_READ", row.get("TIME_READ"));
                    pr.put("RECENT_EVENT_TIME", row.get("RECENT_EVENT_TIME"));
                    pr.put("EVENT_FETCH_MODE", row.get("EVENT_FETCH_MODE"));
                } else {
                    pr.put("TIME_READ", new Long(0L));
                    pr.put("RECENT_EVENT_TIME", new Long(0L));
                    pr.put("EVENT_FETCH_MODE", new Integer(1));
                }
                String osVersion = EventDataUtil.getComputerOsVersion(dcName, domainName);
                if (osVersion == null || osVersion.equals("")) {
                    osVersion = EventDataUtil.getOSversion(dcName, domainName);
                }
                if (osVersion != null && !osVersion.equals("")) {
                    pr.put("OS_VERSION", osVersion);
                }
                pr.put("SYSTEM_OS_VERSION", System.getProperty("os.version"));
                Row scheduleRow = dcEventSchedulerDO.getRow("Schedule");
                if (scheduleRow != null) {
                    pr.put("SCHEDULE_NAME", scheduleRow.get("SCHEDULE_NAME"));
                    pr.put("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                }
                if ((scheduledTaskRow = dcEventSchedulerDO.getRow("Scheduled_Task")) != null) {
                    pr.put("ADMIN_STATUS", scheduledTaskRow.get("ADMIN_STATUS"));
                } else {
                    pr.put("ADMIN_STATUS", new Integer(0));
                }
                Row periodicRow = dcEventSchedulerDO.getRow("Periodic");
                if (periodicRow != null) {
                    String unitOfTime = (String)periodicRow.get("UNIT_OF_TIME");
                    Long timePeriod = (Long)periodicRow.get("TIME_PERIOD");
                    String timePeriodText = "";
                    if (unitOfTime.equalsIgnoreCase("Hours")) {
                        timePeriodText = rb.handleGetObject("adap.DomainHandler.Every_timePeriod_hours", new String[]{timePeriod.toString()});
                        timePeriod = timePeriod * 60L;
                    } else if (unitOfTime.equalsIgnoreCase("Minutes")) {
                        Long hourPeriod = timePeriod / 60L;
                        if (hourPeriod == 0L) {
                            timePeriodText = rb.handleGetObject("adap.DomainHandler.Every_timePeriod_minutes", new String[]{timePeriod.toString()});
                        } else {
                            Long minutePeriod = timePeriod % 60L;
                            timePeriodText = rb.handleGetObject("adap.DomainHandler.Every_hourPeriod_hours", new String[]{hourPeriod.toString()});
                            if (minutePeriod != 0L) {
                                timePeriodText = timePeriodText + rb.handleGetObject("adap.DomainHandler._and_minutePeriod_minutes", new String[]{minutePeriod.toString()});
                            }
                        }
                    }
                    pr.put("TIME_PERIOD_TEXT", timePeriodText);
                    pr.put("TIME_PERIOD", timePeriod);
                } else {
                    pr.put("TIME_PERIOD_TEXT", "-");
                    pr.put("TIME_PERIOD", new Long(0L));
                }
                if ((Integer)pr.get("ADMIN_STATUS") == 3) {
                    pr.put("IS_ENABLED", (Object)true);
                } else {
                    pr.put("IS_ENABLED", (Object)false);
                }
                if ((Integer)pr.get("EVENT_FETCH_MODE") == 3) {
                    pr.put("IS_REALTIME", (Object)true);
                } else {
                    pr.put("IS_REALTIME", (Object)false);
                }
                dcs.add(pr);
            }
            p.put("DOMAINCONTROLLERS", dcs);
            if (dcDataObj != null && !dcDataObj.isEmpty()) {
                ite = dcDataObj.getRows(tableDCName, crit);
                while (ite.hasNext()) {
                    Row dcr = (Row)ite.next();
                    p.put("DOMAIN_CONTROLLER_NAME", (String)dcr.get("DOMAIN_CONTROLLER_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getConfiguredList(Long loginID) {
        return DomainHandler.getConfiguredList(loginID, false, null);
    }

    public static boolean deleteDomainController(Long dcId) {
        boolean status = false;
        try {
            EventSchedulerUtil.deleteDCEventScheduler(dcId);
            Criteria deleteCriteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
            DataObject domainControllerDO = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, deleteCriteria);
            Row domConRow = domainControllerDO.getRow(tableDCName);
            String domainName = (String)domConRow.get("DOMAIN_NAME");
            RealTimeEventController.getInstance().stop(dcId, true);
            if (com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)"ManageEngine Log360")) {
                CommonUtil.getPersistence(new boolean[0]).delete(deleteCriteria);
                MSHandler.synchronizeNow("to Sync deleted DomainController Details", false);
            } else {
                CommonUtil.getPersistenceLite().delete(deleteCriteria);
            }
            Table dcTable = Table.getTable((String)tableDCName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(dcTable);
            Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), true));
            selectQuery.setRange(new Range(1, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)tableDCName, (String)"*"));
            selectQuery.setCriteria(criteria);
            DataObject dcDO = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!dcDO.isEmpty()) {
                Row dcRow = dcDO.getRow(tableDCName);
                Long priorityId = (Long)dcRow.get("PRIORITY_ID");
                Long domainContId = (Long)dcRow.get("DOMAIN_CONTROLLER_ID");
                if (priorityId > 1L) {
                    dcRow.set("PRIORITY_ID", (Object)1L);
                    dcDO.updateRow(dcRow);
                    CommonUtil.getPersistence(new boolean[0]).update(dcDO);
                    Criteria domainCriteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    DataObject domainDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, domainCriteria);
                    Row domainRow = domainDO.getRow(tableName);
                    domainRow.set("DOMAIN_CONTROLLER_ID", (Object)domainContId);
                    domainDO.updateRow(domainRow);
                    CommonUtil.getPersistence(new boolean[0]).update(domainDO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static ArrayList getForestDomains(String rootDomainNamingContext, Long loginID) {
        ArrayList forestDomains = new ArrayList();
        try {
            String[] props;
            Object logonUserProps = null;
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"ROOT_DOMAIN_NAMING_CONTEXT"), (Object)rootDomainNamingContext, 0);
            if (LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0));
            }
            query.setCriteria(criteria);
            for (String string : props = new String[]{"DOMAIN_NAME", "DOMAIN_DNS_NAME", "DOMAIN_FLAT_NAME", "DEFAULT_NAMING_CONTEXT", "ROOT_DOMAIN_NAMING_CONTEXT"}) {
                query.addSelectColumn(Column.getColumn((String)tableName, (String)string));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                forestDomains = CommonUtil.getList(dataObj, props, tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forestDomains;
    }

    public static Hashtable getDomainsAndOUs(Long loginId) throws Exception {
        Hashtable<String, Cloneable> domains = new Hashtable<String, Cloneable>();
        Hashtable<Object, String> dnDomainNameMap = new Hashtable<Object, String>();
        try {
            Criteria criteria = null;
            Object logonUserProps = null;
            if (loginId.equals(1L)) {
                criteria = LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1") ? new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0) : new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Iterator it = dataObj.getRows(tableName);
            ArrayList<Properties> domainList = new ArrayList<Properties>();
            while (it.hasNext()) {
                Properties domainProp = new Properties();
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                domainProp.put("DOMAIN_NAME", domainName);
                domainProp.put("DEFAULT_NAMING_CONTEXT", r.get("DEFAULT_NAMING_CONTEXT"));
                domainProp.put("IS_DEFAULT_DOMAIN", r.get("IS_DEFAULT_DOMAIN"));
                domainProp.put("DOMAIN_FLAT_NAME", r.get("DOMAIN_FLAT_NAME"));
                dnDomainNameMap.put(r.get("DEFAULT_NAMING_CONTEXT"), domainName);
                ArrayList<Properties> ouList = new ArrayList<Properties>();
                Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
                query.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"*"));
                query.setCriteria(c);
                query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"), true));
                DataObject ouObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                Iterator ouIterations = ouObj.getRows("ADSMOUDetails");
                while (ouIterations.hasNext()) {
                    Properties ouProp = new Properties();
                    Row ou = (Row)ouIterations.next();
                    ouProp.put("DISTINGUISHED_NAME", ou.get("DISTINGUISHED_NAME"));
                    ouProp.put("OU_NAME", ou.get("NAME"));
                    ouList.add(ouProp);
                    dnDomainNameMap.put(ou.get("DISTINGUISHED_NAME"), domainName);
                }
                domainProp.put("ouList", ouList);
                domainList.add(domainProp);
            }
            domains.put("domainList", domainList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        domains.put("dnDomainNameMap", dnDomainNameMap);
        return domains;
    }

    public static HashMap<String, ArrayList<String>> getConfiguredDomainsList() {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        ArrayList<String> domainNameList = new ArrayList<String>();
        ArrayList<String> domainFlatNameList = new ArrayList<String>();
        ArrayList<String> domainDnsNameList = new ArrayList<String>();
        Table table = Table.getTable((String)tableName);
        SelectQueryImpl selectQuery = new SelectQueryImpl(table);
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), null, 1);
        criteria = LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1") ? criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0)) : criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1));
        selectQuery.setCriteria(criteria);
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), false));
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    domainFlatNameList.add((String)row.get("DOMAIN_FLAT_NAME"));
                    domainDnsNameList.add((String)row.get("DOMAIN_DNS_NAME"));
                    domainNameList.add((String)row.get("DOMAIN_NAME"));
                }
                map.put("DomainNameList", domainNameList);
                map.put("DomainFlatNameList", domainFlatNameList);
                map.put("domainDnsNameList", domainDnsNameList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Hashtable getConfiguredDomains() throws Exception {
        Hashtable<String, Properties> domains = new Hashtable<String, Properties>();
        try {
            Criteria criteria = null;
            criteria = LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1") ? new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0) : new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                List columnNames = r.getColumns();
                for (int i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (r.get(columnName) == null) continue;
                    p.put(columnName, r.get(columnName));
                }
                String encryptedPassword = (String)p.get("PASSWORD");
                if (encryptedPassword != null) {
                    p.put("PASSWORD", encryptedPassword);
                }
                String distinguishedName = (String)p.get("DEFAULT_NAMING_CONTEXT");
                domains.put(distinguishedName, p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return domains;
    }

    public static Properties getConfiguredValues(String domainName, Long loginId, String domainControllerName) throws Exception {
        Properties p = new Properties();
        try {
            p = DomainHandler.getConfiguredValues(domainName, loginId);
            ArrayList domainControllerList = (ArrayList)p.get("DOMAIN_CONTROLLER_LIST");
            ArrayList<String> newdomainControllerList = new ArrayList<String>();
            if (!domainControllerList.isEmpty() && domainControllerName != null) {
                newdomainControllerList.add(domainControllerName);
                for (Object object : domainControllerList) {
                    newdomainControllerList.add((String)object);
                }
                p.put("DOMAIN_CONTROLLER_LIST", newdomainControllerList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static Properties getConfiguredValues(String domainName, Long loginId) throws Exception {
        Properties p = new Properties();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)tableDCName, (String)"*"));
            Join join = new Join(tableName, tableDCName, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            query.addJoin(join);
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), true));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            Iterator iter = dataObj.getRows(tableDCName);
            ArrayList<String> al = new ArrayList<String>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                al.add(dcName);
            }
            p.put("DOMAIN_CONTROLLER_LIST", al);
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                int pos;
                if (userDNName.contains("@")) {
                    pos = userDNName.indexOf(64);
                } else if (userDNName.contains("\\")) {
                    pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            p.put("USER_DOMAIN_NAME", userDomain);
            boolean isAdminUser = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static Properties getUnAuthenticatedDomainDetails(String domainName, String columnName) throws Exception {
        Properties p = new Properties();
        try {
            Column col = Column.getColumn((String)tableName, (String)columnName);
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            Column colu = Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME");
            Criteria crit = new Criteria(colu, p.get("DOMAIN_NAME"), 0);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, crit);
            Iterator iter = dcDataObj.getRows(tableDCName, crit);
            ArrayList<String> al = new ArrayList<String>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                al.add(dcName);
            }
            p.put("DOMAIN_CONTROLLER_LIST", al);
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                if (userDNName.contains("@")) {
                    int pos = userDNName.indexOf(64);
                    userDomain = userDNName.substring(pos + 1, userDNName.length());
                } else if (userDNName.contains("\\")) {
                    int pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            p.put("USER_DOMAIN_NAME", userDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static Properties getConfiguredValuesForModify(String domainName) throws Exception {
        Properties p = new Properties();
        try {
            Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            Column colu = Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME");
            Criteria crit = new Criteria(colu, (Object)domainName, 0);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, crit);
            Iterator iter = dcDataObj.getRows(tableDCName, crit);
            ArrayList<String> al = new ArrayList<String>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                al.add(dcName);
            }
            p.put("DOMAIN_CONTROLLER_LIST", al);
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                if (userDNName.contains("@")) {
                    int pos = userDNName.indexOf(64);
                    userDomain = userDNName.substring(pos + 1, userDNName.length());
                } else if (userDNName.contains("\\")) {
                    int pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            p.put("USER_DOMAIN_NAME", userDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static boolean setDefaultDomain(String domainName, boolean ... flags) throws Exception {
        try {
            Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
            Row r = dataObj.getRow(tableName);
            r.set("IS_DEFAULT_DOMAIN", (Object)"true");
            dataObj.updateRow(r);
            CommonUtil.getPersistence(flags).update(dataObj);
            DomainHandler.updateOtherDomainDefaultStatus(domainName, "false", flags);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkDefaultDomain(String domainName, String defaultStatus) throws Exception {
        boolean status = false;
        DataObject dataObj = DomainHandler.getDefaultDomainDO(domainName);
        if (defaultStatus.equals("true") && !dataObj.isEmpty()) {
            status = true;
        } else if (defaultStatus.equals("false") && dataObj.isEmpty()) {
            throw new Exception("Atleast one Domain should be selected as default.");
        }
        return status;
    }

    public static void updateOtherDomainDefaultStatus(String domainName, String status, boolean ... flags) {
        try {
            DataObject dataObj = DomainHandler.getDefaultDomainDO(domainName);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                r.set("IS_DEFAULT_DOMAIN", (Object)status);
                dataObj.updateRow(r);
            }
            CommonUtil.getPersistence(flags).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DataObject getDefaultDomainDO(String domainName) {
        DataObject dataObj = null;
        try {
            Table table = Table.getTable((String)tableName);
            Column col1 = Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN");
            Criteria criteria = new Criteria(col1, (Object)"true", 0);
            Column domainCol = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria domainCriteria = new Criteria(domainCol, (Object)domainName, 1);
            Criteria res = criteria.and(domainCriteria);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.setCriteria(res);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    private static String getString(Properties p, String key) {
        return StrUtil.getString(p, key);
    }

    public static ArrayList getGroupList(Long loginId, String defaultNamingContext, ArrayList attributeList) {
        ArrayList list = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DEFAULT_NAMING_CONTEXT"), (Object)defaultNamingContext, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
            String domainName = (String)r.get("DOMAIN_NAME");
            list = ADHandler.getGroups(domainName, loginId, attributeList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties getSelectedDomain(Long loginId) {
        Properties p = new Properties();
        Table baseTable = Table.getTable((String)tableName);
        Table joinTable = Table.getTable((String)tableDCName);
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)1L, 0);
            Criteria criter = null;
            boolean isAdminUser = true;
            if (isAdminUser && loginId.equals(1L)) {
                criter = new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0);
            }
            sq.setCriteria(criter);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow(tableName);
                String domainName = (String)r.get("DOMAIN_NAME");
                p.put("DOMAIN_NAME", domainName);
                p.put("DOMAIN_DNS_NAME", (String)r.get("DOMAIN_DNS_NAME"));
                p.put("DOMAIN_FLAT_NAME", (String)r.get("DOMAIN_FLAT_NAME"));
                p.put("DEFAULT_NAMING_CONTEXT", (String)r.get("DEFAULT_NAMING_CONTEXT"));
                p.put("ROOT_DOMAIN_NAMING_CONTEXT", (String)r.get("ROOT_DOMAIN_NAMING_CONTEXT"));
                p.put("IS_DEFAULT_DOMAIN", (String)r.get("IS_DEFAULT_DOMAIN"));
                Criteria criteria = crit.and(new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
                Row dcR = dcDataObj.getRow(tableDCName);
                p.put("DOMAIN_CONTROLLER_NAME", dcR.get("DOMAIN_CONTROLLER_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getDomainList() {
        ArrayList domainList = new ArrayList();
        try {
            Criteria criter = null;
            criter = LicenseUtil.getLicenseType().equals("F") || LicenseUtil.getLicenseProperty("Domains", "NumberOfDomains").equals("1") ? new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0) : new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", criter);
            domainList = CommonUtil.getList(dataObject, new String[]{"DOMAIN_NAME"}, "ADSMDomainConfiguration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static String getObjectGuid(String domainName) {
        String objectGuid = "";
        try {
            String generalDetailsTable = "ADSMDomainGeneralDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)generalDetailsTable, (String)"NAME"), (Object)domainName, 0, false);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(generalDetailsTable, criteria);
            Row row = dataObject.getRow(generalDetailsTable);
            objectGuid = (String)row.get("OBJECT_GUID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectGuid;
    }

    public static JSONObject getDomainDetails(String domainName) {
        JSONObject domainDetails = new JSONObject();
        try {
            DataObject dataObj = DomainHandler.getDomainDetailsDO(domainName);
            if (dataObj != null && !dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow(tableName);
                List columns = row.getColumns();
                for (String col : columns) {
                    domainDetails.put(col, row.get(col));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainDetails;
    }

    public static DataObject getDomainDetailsDO(String domainName) {
        DataObject dataObj = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObj;
    }

    public static Properties getDNSName(String objectGuid) {
        Properties p = new Properties();
        try {
            Criteria c = new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(tableGeneralDetails);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, c);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow(tableGeneralDetails);
                p.put("NAME", (String)row.get("NAME"));
                p.put("DNS_NAME", (String)row.get("DNS_NAME"));
                p.put("DOMAIN_NAME", (String)row.get("DOMAIN_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getComputerId(String hostName) {
        return DomainHandler.getComputerId(hostName, null);
    }

    public static ArrayList getComputerId(String hostName, String domainName) {
        DataObject dataObj = DomainHandler.getComputerDetails(hostName, domainName);
        return DomainHandler.getComputerIdFromDO(dataObj);
    }

    public static ArrayList getComputerId(ArrayList<String> list, String domainName) {
        DataObject dataObj = DomainHandler.getComputerDetails(list, domainName);
        return DomainHandler.getComputerIdFromDO(dataObj);
    }

    public static ArrayList getComputerIdFromDO(DataObject dataObj) {
        ArrayList<Long> id = new ArrayList<Long>();
        try {
            Iterator itr = dataObj.getRows(tableComputerEventRead);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                id.add((Long)row.get("COMPUTER_ID"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return id;
    }

    public static DataObject getLocalComputerDetails(ArrayList<?> computerID, int isInherited) {
        DataObject dataObj = null;
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(tableGeneralDetails);
            tableList.add(tableComputerEventRead);
            Criteria criteria = new Criteria(Column.getColumn((String)tableComputerEventRead, (String)"COMPUTER_ID"), (Object)computerID.toArray(), 8);
            criteria.and(new Criteria(Column.getColumn((String)tableComputerEventRead, (String)"ISINHERITED"), (Object)isInherited, 0));
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static DataObject getComputerDetails(ArrayList<String> list, String domainName) {
        DataObject dataObj = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"NAME"), (Object)list.toArray(), 8);
            if (domainName != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(tableGeneralDetails);
            tableList.add(tableComputerEventRead);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static DataObject getComputerDetails(String hostName, String domainName) {
        DataObject dataObj = null;
        Table genDetailsTable = Table.getTable((String)tableGeneralDetails);
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"NAME"), (Object)hostName, 0);
            criteria = criteria.or(new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"DNS_NAME"), (Object)hostName, 0));
            if (domainName != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableGeneralDetails, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(tableGeneralDetails);
            tableList.add(tableComputerEventRead);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static Properties getDNSNameForDC(Long scheduleId) {
        Properties p = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableEventDCRead, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(tableDCName);
            tableList.add(tableEventDCRead);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableDCName);
                p.put("DOMAIN_CONTROLLER_NAME", (String)row.get("DOMAIN_CONTROLLER_NAME"));
                p.put("DOMAIN_NAME", (String)row.get("DOMAIN_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getDCNames(String domainName) {
        ArrayList<String> dcNameList = new ArrayList<String>();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableDCName));
            selQuery.addSelectColumn(Column.getColumn((String)tableDCName, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            selQuery.setCriteria(criteria);
            SortColumn srtCol = new SortColumn(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), true);
            selQuery.addSortColumn(srtCol);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (dcDataObj.isEmpty()) {
                return dcNameList;
            }
            Iterator ite = dcDataObj.getRows(tableDCName);
            while (ite.hasNext()) {
                Row rw = (Row)ite.next();
                dcNameList.add((String)rw.get("DOMAIN_CONTROLLER_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcNameList;
    }

    static class GetDomains
    implements Runnable {
        GetDomains() {
        }

        @Override
        public void run() {
            try {
                ADHandler.getValidDomains();
                Column col = Column.getColumn((String)"ADSMSchedulerStatus", (String)"SCHEDULER_NAME");
                Criteria criteria = new Criteria(col, (Object)"DomainDiscovery", 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSchedulerStatus", criteria);
                Row row = new Row("ADSMSchedulerStatus");
                row.set("SCHEDULER_NAME", (Object)"DomainDiscovery");
                row.set("STATUS", (Object)"true");
                if (dataObj.isEmpty()) {
                    dataObj.addRow(row);
                    CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                } else {
                    dataObj.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class UpdateDomainDatas
    implements Runnable {
        String domainName = null;
        String[] selectedUpdates = null;
        Long loginId = null;

        public UpdateDomainDatas(String s, Long loginId, String[] selectedUpdates) {
            this.domainName = s;
            this.selectedUpdates = selectedUpdates;
            this.loginId = loginId;
        }

        @Override
        public void run() {
            try {
                DomainHandler.updateDomainDatas(this.domainName, this.loginId, this.selectedUpdates);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

