/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventCollectorHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String tableComputerName = "ADSMComputerGeneralDetails";
    public static String tableMSName = "AUDComputerEventRead";
    private static Logger logger = Logger.getLogger(EventCollectorHandler.class.getName());

    public static void deleteEvntCollectorDetails(String[] objectGuid) throws Exception {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getCollectorDetails(Properties msProps) {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), msProps.get("OBJECT_GUID"), 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDEvntCollectorDetails");
                msProps.put("TIME_READ", (Long)row.get("TIME_READ"));
                msProps.put("EVENT_READ", (Long)row.get("EVENT_READ"));
                msProps.put("RECENT_EVENT_TIME", (Long)row.get("RECENT_EVENT_TIME"));
                String msg = (String)row.get("MESSAGE");
                if (msg == null) {
                    msg = "-";
                }
                msProps.put("MESSAGE", msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addCollectorDetails(String objectGuid) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", criteria);
            Row row = null;
            if (nfObj.isEmpty()) {
                row = new Row("AUDEvntCollectorDetails");
                row.set("OBJECT_GUID", (Object)objectGuid);
                row.set("MESSAGE", (Object)rb.getString("adap.common.text.status_msg.yet_to_fetch_event_data"));
                nfObj.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(nfObj);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void updateRecordNumber(Hashtable eventData) {
        try {
            HashMap propMap = EventDataUtil.getComputerProperties((String)eventData.get("DomainName"), (String)eventData.get("DomainController"));
            logger.log(Level.FINE, " propMap is:" + propMap);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)((String)propMap.get("OBJECT_GUID")), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", crit);
            Row row = dataObject.getFirstRow("AUDEvntCollectorDetails");
            Long recNumber = (Long)row.get("EVENT_READ");
            if ((Long)eventData.get("RecordNumber") > recNumber) {
                row.set("EVENT_READ", (Object)((Long)eventData.get("RecordNumber")));
            }
            row.set("TIME_READ", (Object)System.currentTimeMillis());
            Long timeWritten = (Long)row.get("RECENT_EVENT_TIME");
            if ((Integer)eventData.get("TimeWritten") > timeWritten.intValue()) {
                row.set("RECENT_EVENT_TIME", (Object)((Integer)eventData.get("TimeWritten")).longValue());
            }
            dataObject.updateRow(row);
            logger.log(Level.FINE, "Update Row Record Number is " + row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static Long getRecordNumber(String objectGuid) {
        Long recNumber = 1L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", crit);
            Row row = dataObject.getFirstRow("AUDEvntCollectorDetails");
            recNumber = (Long)row.get("EVENT_READ");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return recNumber;
    }

    public static void resetRecordNumber(String objectGuid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", crit);
            Row row = dataObject.getFirstRow("AUDEvntCollectorDetails");
            row.set("EVENT_READ", (Object)1L);
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void updateStatus(String objectGuid, String message) {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", criteria2);
            Row row = dataObj.getRow("AUDEvntCollectorDetails");
            logger.log(Level.INFO, "Existing Message is " + row.get("MESSAGE"));
            row.set("MESSAGE", (Object)message);
            dataObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void getCollectorDetailsEmber(HashMap<String, Object> msProps) {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDEvntCollectorDetails", (String)"OBJECT_GUID"), msProps.get("OBJECT_GUID"), 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDEvntCollectorDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDEvntCollectorDetails");
                msProps.put("TIME_READ", (Long)row.get("TIME_READ"));
                msProps.put("EVENT_READ", (Long)row.get("EVENT_READ"));
                msProps.put("RECENT_EVENT_TIME", (Long)row.get("RECENT_EVENT_TIME"));
                String msg = (String)row.get("MESSAGE");
                if (msg == null) {
                    msg = "-";
                }
                msProps.put("MESSAGE", msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

