/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InheritedHostHandler {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static final String HOSTDETAILS_API = "GET_HOST_LICENSE_DETAILS";
    private static final String CONVERT_HOST_API = "CONVERT_HOST_AND_INHERITEDHOST";

    public static void checkAndDeleteInheritedHost(String hostName, String domainName, Integer machineType, String source_product) throws Exception {
        if (source_product == null) {
            out.info("WARNING : Request processed based on Old Eventlog request  checkAndDeleteInheritedHost");
            ArrayList ids = DomainHandler.getComputerId(hostName, domainName);
            MSHandler.updateMemberServers(domainName, "Delete", ids, null, machineType, true);
        } else if (InheritedHostHandler.validateInheritedHost(hostName, domainName, source_product)) {
            ArrayList ids = DomainHandler.getComputerId(hostName, domainName);
            MSHandler.updateMemberServers(domainName, "Delete", ids, null, machineType, true);
        } else {
            out.info("Target Host not found or Source Product Not matching for host : " + hostName + "  source_product : " + source_product);
        }
    }

    public static boolean validateInheritedHost(String hostName, String domainName, String source_product) throws DataAccessException {
        DataObject dobj = DomainHandler.getComputerDetails(hostName, domainName);
        if (dobj != null && !dobj.isEmpty() && dobj.containsTable("AUDComputerEventRead")) {
            Row audEvntRow = dobj.getFirstRow("AUDComputerEventRead");
            String old_seqNumber = (String)audEvntRow.get("SOURCE_PRODUCT");
            Integer isInherited = (Integer)audEvntRow.get("ISINHERITED");
            if (isInherited == 1 && (old_seqNumber == null || source_product != null && source_product.equals(old_seqNumber))) {
                return true;
            }
        }
        return false;
    }

    public static boolean addOrConvertInheritedHost(String domainName, String hostName, Integer machineType, String source_product, boolean isOriginLicensed, boolean status) throws Exception {
        DataObject dobj = DomainHandler.getComputerDetails(hostName, domainName);
        Row audEvntRow = null;
        ArrayList computerID = DomainHandler.getComputerIdFromDO(dobj);
        if (dobj != null && !dobj.isEmpty() && dobj.containsTable("AUDComputerEventRead")) {
            audEvntRow = dobj.getFirstRow("AUDComputerEventRead");
        }
        if (source_product == null) {
            out.info("WARNING : Request processed based on Old Eventlog request  addOrConvertInheritedHost");
            MSHandler.addMemberServers(domainName, machineType, (Boolean)true, hostName, source_product, true);
            return true;
        }
        Integer totalCount = MSHandler.getLicenseCount(machineType);
        Integer enabledSchedulers = ServerConfigAPI.getConfiguredServerCount(new int[]{machineType});
        boolean isLicensed = "R".equals(LicenseManager.getLicenseCode());
        if (audEvntRow != null) {
            Integer isalrdyInherited = (Integer)audEvntRow.get("ISINHERITED");
            if (isalrdyInherited == 1) {
                out.fine("Scenario 1 - Changing Product sequence number");
                InheritedHostHandler.updateNewSequenceNumber(source_product, dobj);
            } else if (isOriginLicensed && !isLicensed) {
                out.fine("Scenario 2 - Converting as synced device");
                InheritedHostHandler.convertToInheritedHost(computerID, domainName, source_product);
            } else if (!isOriginLicensed && isLicensed || !isOriginLicensed && !isLicensed || isOriginLicensed && isLicensed) {
                out.fine("Scenario 3 - converting as local device");
                InheritedHostHandler.switchHostAndInheritedHost(domainName, hostName, source_product, machineType, "TRUE", status);
                InheritedHostHandler.convertToLocalHost(computerID, domainName, source_product);
            }
        } else if (!isOriginLicensed && isLicensed) {
            if (totalCount > enabledSchedulers && InheritedHostHandler.switchHostAndInheritedHost(domainName, hostName, source_product, machineType, "TRUE", status)) {
                out.fine("Scenario 4 - adding as local device");
                InheritedHostHandler.handleAddOrUpdateServers(domainName, machineType, hostName, ProductUniqueSeqGenerator.getCurrentSeqNumber(), false);
            } else {
                out.fine("Scenario 5 - adding as synced device");
                out.info("Licensed Host Count Exceeded or unable to Contact Source product, going to add as inherited Device");
                InheritedHostHandler.handleAddOrUpdateServers(domainName, machineType, hostName, source_product, true);
            }
        } else if (InheritedHostHandler.switchHostAndInheritedHost(domainName, hostName, source_product, machineType, "FALSE", status)) {
            out.fine("Scenario 6 - adding as synced device");
            InheritedHostHandler.handleAddOrUpdateServers(domainName, machineType, hostName, source_product, true);
        } else {
            out.fine("Scenario 7 - adding as local device");
            InheritedHostHandler.handleAddOrUpdateServers(domainName, machineType, hostName, ProductUniqueSeqGenerator.getCurrentSeqNumber(), false);
        }
        return true;
    }

    private static void handleAddOrUpdateServers(String domainName, Integer machineType, String deviceName, String source_product, boolean isSynced) throws Exception {
        if (machineType == 16 || machineType == 4096) {
            ArrayList guidList = new ArrayList();
            HashMap<String, String> computerMap = new HashMap<String, String>();
            computerMap.put("OBJECT_GUID", MSHandler.getComputerGuid(deviceName, domainName));
            guidList.add(computerMap);
            MSHandler.addORUpdateServers(domainName, guidList, "no", (int)machineType, source_product, isSynced);
        } else {
            out.info("Unknown device Type : " + machineType);
        }
    }

    public static String convertToInheritedHost(ArrayList<?> msIDs, String domainName, String sourceProduct) throws Exception {
        return MSHandler.updateMemberServers(domainName, "CONVERTTOINHERITEDHOST", msIDs, null, sourceProduct, null, new boolean[0]);
    }

    public static String convertToLocalHost(ArrayList<?> msIDs, String domainName, String sourceProduct) throws Exception {
        return MSHandler.updateMemberServers(domainName, "CONVERTTOLOCALHOST", msIDs, null, sourceProduct, null, new boolean[0]);
    }

    public static void updateNewSequenceNumber(String newSeqNumber, DataObject dobj) throws DataAccessException {
        boolean status = false;
        Row row = dobj.getFirstRow("AUDComputerEventRead");
        String oldSeqNumber = (String)row.get("SOURCE_PRODUCT");
        if (oldSeqNumber == null) {
            status = true;
            row.set("SOURCE_PRODUCT", (Object)oldSeqNumber);
        } else if (newSeqNumber != null && !newSeqNumber.equals(oldSeqNumber)) {
            status = true;
            row.set("SOURCE_PRODUCT", (Object)newSeqNumber);
        }
        if (status) {
            dobj.updateRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[]{true}).update(dobj);
        }
    }

    public static boolean switchHostAndInheritedHost(String domainName, String hostName, String source_product, Integer machineType, String isInherited, boolean status) throws Exception {
        try {
            Properties params = new Properties();
            if (domainName == null || hostName == null) {
                out.info("Unable to process request hostname or domain name becomes null  : " + hostName + " , " + domainName);
                return false;
            }
            Object parentProduct = InheritedHostHandler.getParentProductSeqNumber();
            params.setProperty("DOMAIN_NAME", domainName);
            params.setProperty("HOST_NAME", hostName);
            params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
            params.setProperty("DESTINATION_SEQUENCE_NUMBER", source_product);
            params.setProperty("CHANGETO_INHERITED", isInherited);
            params.setProperty("MACHINE_TYPE", machineType.toString());
            int count = ServerConfigAPI.getConfiguredInheritedHostCount(new int[]{machineType}, source_product);
            params.setProperty("CURRENT_ENABLED_COUNT", "" + count);
            params.setProperty("CURRENT_LICENSED_COUNT", "" + MSHandler.getLicenseCount(machineType));
            params.setProperty("ADD_REQUEST_INITIATED_BY", source_product);
            params.setProperty("DEVICE_STATUS", status ? "true" : "false");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
            DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
            RestAPI api = new RestAPI();
            api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)CONVERT_HOST_API), params);
            JSONObject responseResult = api.getResponseJSON();
            out.fine("responseResult in ADAP: " + responseResult);
            if (responseResult.has("sSTATUS") && responseResult.getString("sSTATUS").equalsIgnoreCase("SUCCESS")) {
                return true;
            }
            out.info("Failed to Update Details in remote server for host  : " + hostName + " responseResult : " + responseResult + " details : " + responseResult);
            return false;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    private static Object getParentProductSeqNumber() throws DataAccessException {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSProductParams", (String)"PARAM_NAME"), (Object)"PARENT_APP_SEQNO", 0);
        DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductParams", crit);
        if (!dobj.isEmpty()) {
            return dobj.getFirstValue("ADSProductParams", "PARAM_VALUE");
        }
        return null;
    }

    public static JSONArray collectAllSequenceNumber(DataObject dobj) throws DataAccessException {
        JSONArray seqIDList = new JSONArray();
        Iterator itr = dobj.getRows("ADSProductDetails");
        while (itr.hasNext()) {
            seqIDList.put(((Row)itr.next()).get("SEQUENCE_ID"));
        }
        return seqIDList;
    }

    public static JSONObject checkISValidAction(Row computerDetails, String sourceProduct, int enableCount, Integer myType) throws JSONException {
        boolean status = false;
        JSONObject responseResult = null;
        JSONObject resultObj = new JSONObject();
        try {
            Properties params = new Properties();
            params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
            params.setProperty("DESTINATION_SEQUENCE_NUMBER", sourceProduct);
            params.setProperty("ENABLED_HOST_COUNT", "" + enableCount);
            if (computerDetails != null) {
                if (computerDetails.get("NAME") != null) {
                    params.setProperty("HOST_NAME", (String)computerDetails.get("NAME"));
                }
                if (computerDetails.get("DOMAIN_NAME") != null) {
                    params.setProperty("DOMAIN_NAME", (String)computerDetails.get("DOMAIN_NAME"));
                }
            }
            Object parentProduct = InheritedHostHandler.getParentProductSeqNumber();
            Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
            DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
            if (!dobj.isEmpty()) {
                RestAPI api = new RestAPI();
                api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)HOSTDETAILS_API), params);
                responseResult = api.getResponseJSON();
            }
            status = InheritedHostHandler.loadResultObject(sourceProduct, responseResult, resultObj, enableCount, myType);
        }
        catch (Exception exp) {
            resultObj.put("eMESSAGE", (Object)"Unable to Connect to remote Machine");
        }
        if (!status) {
            resultObj.put("STATUS", false);
        } else {
            resultObj.put("STATUS", true);
        }
        return resultObj;
    }

    private static boolean loadResultObject(String sourceProduct, JSONObject responseResult, JSONObject resultObj, int inheritedHostCount, Integer mType) throws JSONException {
        boolean status = false;
        if (responseResult != null) {
            if (responseResult.has("IS_VALID")) {
                if (!responseResult.getBoolean("IS_VALID")) {
                    resultObj.put("eMESSAGE", (Object)"adap.MSHandler.inheritedhost.status.message.request.rejected");
                } else {
                    status = true;
                    resultObj.put("sMESSAGE", (Object)"SUCCESS");
                }
            } else if (responseResult.has("IS_LICENSE_EXPIRED")) {
                resultObj.put("eMESSAGE", (Object)"adap.MSHandler.inheritedhost.status.message.license.expired");
            } else if (responseResult.has("HOST_COUNT") || responseResult.has("WORKSTATION_COUNT")) {
                int count = 0;
                if (mType == 16) {
                    if (responseResult.has("HOST_COUNT")) {
                        count = responseResult.getInt("HOST_COUNT");
                    }
                } else if (responseResult.has("WORKSTATION_COUNT")) {
                    count = responseResult.getInt("WORKSTATION_COUNT");
                } else if (responseResult.has("HOST_COUNT")) {
                    inheritedHostCount += ServerConfigAPI.getConfiguredInheritedHostCount(new int[]{16}, sourceProduct);
                    count = responseResult.getInt("HOST_COUNT");
                }
                if (inheritedHostCount < count) {
                    status = true;
                    resultObj.put("sMESSAGE", (Object)"SUCCESS");
                } else {
                    resultObj.put("eMESSAGE", (Object)"adap.MSHandler.inheritedhost.status.message.license.limit");
                }
            } else {
                resultObj.put("eMESSAGE", (Object)"adap.MSHandler.inheritedhost.status.message.component.down");
            }
        } else {
            resultObj.put("eMESSAGE", (Object)"adap.MSHandler.inheritedhost.status.message.component.down");
        }
        return status;
    }

    public static boolean publishLicenseStatus() {
        boolean result;
        block4: {
            result = true;
            if (!CommonUtil.isProductIntegrated((String)"ManageEngine Log360")) {
                return false;
            }
            try {
                Object parentProduct = InheritedHostHandler.getParentProductSeqNumber();
                Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
                DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
                if (!dobj.isEmpty()) {
                    Properties params = new Properties();
                    params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
                    params.setProperty("LICENSE_CODE", LicenseManager.getLicenseCode());
                    RestAPI api = new RestAPI();
                    api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)"UPDATE_HOST_LICENSE_STATUS"), params);
                }
            }
            catch (Exception exp) {
                String message = exp.getMessage();
                if (!"00000002".equals(message) && !"00000011".equals(message)) break block4;
                result = false;
            }
        }
        return result;
    }
}

