/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.eventcollection.FetchMsEventData;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.util.WindowsDirUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.EventCollectorHandler;
import com.adventnet.sym.adsm.common.server.InheritedHostHandler;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.manageengine.ads.fw.dbsync.DBSynchronizer;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class MSHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String tableComputerName = "ADSMComputerGeneralDetails";
    public static String tableMSName = "AUDComputerEventRead";
    public static final String ME_LOG360 = "ManageEngine Log360";
    private static Logger logger = Logger.getLogger(MSHandler.class.getName());
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();
    public static HashMap<Long, String> instanceVsGUIDMap = new HashMap();
    private static ExecutorService synchronizer = null;

    public static void addMemberServers(String domainName, Integer machineType, Boolean isNeedADRefresh, boolean ... flag) throws Exception {
        MSHandler.addMemberServers(domainName, machineType, isNeedADRefresh, null, null, flag);
    }

    public static void addMemberServers(String domainName, Integer machineType, Boolean isNeedADRefresh, String hostName, String source_Product, boolean ... flag) throws Exception {
        try {
            logger.log(Level.INFO, " Add MemberServers..... " + domainName);
            if (isNeedADRefresh.booleanValue()) {
                Criteria criteria = new Criteria(Column.getColumn((String)tableComputerName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
                if (dataObject.isEmpty()) {
                    ArrayList reportIds = new ArrayList();
                    Hashtable<String, Integer> reportTable = new Hashtable<String, Integer>();
                    reportTable.put("report_id", 210);
                    reportIds.add(reportTable);
                    ObjectUpdateHandler.runDailyReport(domainName, 1L, reportIds);
                }
            }
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext(domainName);
            Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:4");
            if (machineType == 4096) {
                cvId = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:895");
            }
            boolean isInherited = false;
            if (flag.length > 0 && flag[0]) {
                isInherited = true;
            }
            Integer addCount = MSHandler.getLicenseCount(machineType);
            logger.log(Level.INFO, "License Count:" + addCount + "for MachineType:" + machineType);
            ArrayList list = null;
            if (hostName == null) {
                logger.log(Level.INFO, "Getting Computer details from DirectoryObjectAPI");
                list = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "computer", null, -1, 0, cvId, 0L);
            } else {
                logger.log(Level.INFO, "Getting  Computer details from given List");
                list = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "computer", hostName, -1, 0, cvId, 0L);
            }
            if (list.size() > 0 && (addCount > 0 || isInherited)) {
                ArrayList addedList = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    addedList.add(list.get(i));
                    if (i == addCount - 1) break;
                }
                if (machineType == 16) {
                    String message = MSHandler.addORUpdateServers(domainName, addedList, "no", 16, source_Product, isInherited);
                } else {
                    String message = MSHandler.addORUpdateServers(domainName, addedList, "no", 4096, source_Product, isInherited);
                }
                logger.log(Level.INFO, "Successfully configured Member Server in domain " + domainName);
                EventDataUtil.getComputerDetails(null, null);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception while configuring Member Server in domain " + domainName);
            ex.printStackTrace();
        }
    }

    public static String addORUpdateServers(String domainName, ArrayList list, String userSelection, int mType, boolean ... flag) {
        return MSHandler.addORUpdateServers(domainName, list, userSelection, mType, null, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addORUpdateServers(String domainName, ArrayList list, String userSelection, int mType, String source_Product, boolean ... flag) {
        logger.log(Level.INFO, "MachineType from Client is " + mType);
        String message = "";
        Boolean disabledAdd = false;
        message = mType == 16 ? rb.getString("adap.MSHandler.Successfully_configured_the_Member_Servers") : (mType == 1024 ? rb.getString("adap.MSHandler.Successfully_configured_the_Event_Collectors") : rb.getString("adap.MSHandler.Successfully_configured_the_work_stations"));
        String msg = null;
        String gpoStatus = "";
        Integer count = 0;
        int isInherited = 0;
        if (flag.length > 0 && flag[0]) {
            isInherited = 1;
        }
        try {
            int enabledSchedulers;
            Long scheduleId = DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3484");
            Long timePeriod = 120L;
            String threadPoolName = "MemberServerThreadPool";
            if (mType == 4096) {
                threadPoolName = "WorkStationThreadPool";
                timePeriod = 360L;
                scheduleId = DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3483");
            }
            Long poolId = null;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ThreadPool"));
            Criteria threadCriteria = new Criteria(Column.getColumn((String)"ThreadPool", (String)"THREADPOOL_NAME"), (Object)threadPoolName, 0);
            query.setCriteria(threadCriteria);
            query.addSelectColumn(Column.getColumn((String)"ThreadPool", (String)"*"));
            DataObject poolObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!poolObj.isEmpty()) {
                Row row = poolObj.getRow("ThreadPool");
                poolId = (Long)row.get("THREADPOOL_ID");
            }
            if (mType == 4096) {
                enabledSchedulers = ServerConfigAPI.getConfiguredServerCount(new int[]{mType});
            } else {
                int enabledMSs;
                enabledSchedulers = enabledMSs = ServerConfigAPI.getConfiguredServerCount(new int[]{16});
                if (16 == (mType & 0x10)) {
                    enabledSchedulers += ServerConfigAPI.getPrintServerCount();
                    enabledSchedulers -= ServerConfigAPI.getPrintMemberServerCount(16);
                }
            }
            Integer totalCount = MSHandler.getLicenseCount(new Integer(mType));
            int availableCount = totalCount - enabledSchedulers;
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String[] objectGuids = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                HashMap computerMap = (HashMap)list.get(i);
                objectGuids[i] = (String)computerMap.get("OBJECT_GUID");
            }
            Criteria guidCriteria = new Criteria(Column.getColumn((String)tableMSName, (String)"OBJECT_GUID"), (Object)objectGuids, 8);
            DataObject existingServersDO = CommonUtil.getPersistence(new boolean[0]).get(tableMSName, guidCriteria);
            Long scheduleStartTime = System.currentTimeMillis();
            boolean isUpdatePresent = false;
            for (int size = 0; size < list.size(); ++size) {
                HashMap computerMap = (HashMap)list.get(size);
                String guid = (String)computerMap.get("OBJECT_GUID");
                Criteria criteria = new Criteria(Column.getColumn((String)tableMSName, (String)"OBJECT_GUID"), (Object)guid, 0);
                Row msRow = existingServersDO.getRow(tableMSName, criteria);
                boolean isUpdate = false;
                if (msRow == null) {
                    if (16 == (mType & 0x10)) {
                        availableCount = ServerConfigAPI.isConfiguredPrintServer(guid) ? (availableCount <= 0 ? (availableCount = 1) : ++availableCount) : availableCount;
                    }
                    msRow = new Row(tableMSName);
                    isUpdate = false;
                    msRow.set("MACHINE_TYPE", (Object)mType);
                    if (mType == 1024) {
                        msRow.set("MACHINE_TYPE", (Object)mType);
                    } else if (availableCount <= 0 && isInherited == 0) {
                        msRow.set("MACHINE_TYPE", (Object)(mType * 2));
                        disabledAdd = true;
                        msg = totalCount > 0 ? (mType == 16 ? rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_Member_Servers", new String[]{Integer.toString(totalCount)}) : rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_work_stations", new String[]{Integer.toString(totalCount)})) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                    }
                    if (count > 50) {
                        scheduleStartTime = scheduleStartTime + 60000L;
                        count = 0;
                    }
                    msRow.set("SCHEDULE_ID", (Object)scheduleId);
                    Row taskInputRow = MSHandler.addTaskInstanceID(scheduleId, scheduleStartTime, poolId);
                    if (disabledAdd.booleanValue()) {
                        taskInputRow.set("ADMIN_STATUS", (Object)4);
                    }
                    dataObj.addRow(taskInputRow);
                    msRow.set("INSTANCE_ID", taskInputRow.get("INSTANCE_ID"));
                    msRow.set("TIME_PERIOD", (Object)timePeriod);
                    msRow.set("UNIT_OF_TIME", (Object)"Minutes");
                    msRow.set("MESSAGE", (Object)rb.getString("adap.common.text.status_msg.yet_to_fetch_event_data"));
                    msRow.set("EVENT_FETCH_MODE", (Object)2);
                    msRow.set("ISINHERITED", (Object)isInherited);
                    if (isInherited == 1) {
                        msRow.set("SOURCE_PRODUCT", (Object)source_Product);
                    } else {
                        --availableCount;
                        msRow.set("SOURCE_PRODUCT", (Object)ProductUniqueSeqGenerator.getCurrentSeqNumber());
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                } else {
                    int machineType = (Integer)msRow.get("MACHINE_TYPE");
                    if ((machineType & mType) != mType && (machineType & mType * 2) != mType * 2) {
                        if (mType == 1024) {
                            if (((machineType |= mType) & 8) == 8 || (machineType & 0x80) == 128) {
                                EventSchedulerUtil.enableDisableScheduler((Long)msRow.get("SCHEDULE_ID"), "Enable");
                            }
                            if ((machineType & 0x20) == 32) {
                                MSHandler.updateAdminStatus((Long)msRow.get("INSTANCE_ID"), 3);
                            }
                            msRow.set("MACHINE_TYPE", (Object)machineType);
                        } else {
                            if (16 == (mType & 0x10)) {
                                int n = ServerConfigAPI.isConfiguredPrintServer(guid) ? (availableCount <= 0 ? (availableCount = 1) : ++availableCount) : (availableCount = availableCount);
                            }
                            if (availableCount > 0) {
                                if (((machineType |= mType) & 8) == 8 || (machineType & 0x80) == 128) {
                                    EventSchedulerUtil.enableDisableScheduler((Long)msRow.get("SCHEDULE_ID"), "Enable");
                                }
                                if ((machineType & 0x800) == 2048) {
                                    MSHandler.updateAdminStatus((Long)msRow.get("INSTANCE_ID"), 3);
                                }
                            } else {
                                machineType |= mType * 2;
                                msg = totalCount > 0 ? (mType == 16 ? rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_Member_Servers", new String[]{Integer.toString(totalCount)}) : rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_work_stations", new String[]{Integer.toString(totalCount)})) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                            }
                            msRow.set("MACHINE_TYPE", (Object)machineType);
                            --availableCount;
                        }
                    }
                    isUpdate = true;
                }
                msRow.set("OBJECT_GUID", (Object)guid);
                if (isUpdate) {
                    existingServersDO.updateRow(msRow);
                    isUpdatePresent = true;
                } else {
                    dataObj.addRow(msRow);
                }
                if ((mType & 0x400) != 1024) continue;
                EventCollectorHandler.addCollectorDetails(guid);
            }
            logger.log(Level.FINE, "list is " + dataObj);
            logger.log(Level.FINE, "existingServersDO is " + existingServersDO);
            CommonUtil.getPersistence(flag).add(dataObj);
            if ((mType & 0x10) == 16 || (mType & 0x20) == 32) {
                class TerminalServer
                extends Thread {
                    String[] objectGUID;
                    String domainName;

                    public TerminalServer(String domain, String[] guid) {
                        super("TerminalGatewayServerUpdate");
                        this.objectGUID = guid;
                        this.domainName = domain;
                    }

                    @Override
                    public void run() {
                        try {
                            EventDataUtil.updateTerminalServerDetails(this.domainName, this.objectGUID);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                new TerminalServer(domainName, objectGuids).start();
            }
            if (isUpdatePresent) {
                CommonUtil.getPersistence(flag).update(existingServersDO);
            }
            if (userSelection != null) {
                if (userSelection.equalsIgnoreCase("yes")) {
                    if (objectGuids.length > 0) {
                        gpoStatus = GpoHandler.createGpoAndApplySecurityFilter(domainName, null, objectGuids, mType);
                        if (gpoStatus.equalsIgnoreCase("Configuring audit policy for remote domain is currently not supported")) {
                            if (mType == 16) {
                                message = rb.getString("adap.MSHandler.Successfully_configured_the_Member_Server");
                                message = message + " " + rb.getString("adap.common.text.and") + " " + rb.getString("adap.MSHandler.Configuring_MS_audit_policy_for_remote_domain_is_currently_not_supported");
                            } else {
                                message = rb.getString("adap.MSHandler.Successfully_configured_the_work_station");
                                message = message + " " + rb.getString("adap.common.text.and") + " " + rb.getString("adap.MSHandler.Configuring_WS_audit_policy_for_remote_domain_is_currently_not_supported");
                            }
                        } else {
                            message = mType == 16 ? rb.getString("adap.MSHandler.Successfully_configured_the_Member_Server") : rb.getString("adap.MSHandler.Successfully_configured_the_work_station");
                            message = message + " " + rb.getString("adap.common.text.and") + " " + gpoStatus;
                        }
                    }
                } else {
                    message = mType == 16 ? rb.getString("adap.MSHandler.Successfully_configured_the_Member_Servers") : (mType == 1024 ? rb.getString("adap.MSHandler.Successfully_configured_the_Event_Collectors") : rb.getString("adap.MSHandler.Successfully_configured_the_work_stations"));
                }
            }
            if (msg != null) {
                message = msg;
            }
            MSHandler.synchronizeNow("to Sync added Host Details", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = mType == 16 || mType == 1024 ? rb.getString("adap.ConfigureComputerAction.Error_While_Adding_Member_Servers") : rb.getString("adap.ConfigureComputerAction.Error_While_Adding_work_stations");
        }
        finally {
            try {
                EventDataUtil.getComputerDetails(null, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return message;
    }

    public static int getInheritedHostcount() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableMSName));
            query.addSelectColumn(Column.getColumn((String)tableMSName, (String)"ISINHERITED"));
            query.setCriteria(new Criteria(Column.getColumn((String)tableMSName, (String)"ISINHERITED"), (Object)new Integer(1), 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (obj.isEmpty()) {
                return 0;
            }
            return obj.size(tableMSName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 0;
        }
    }

    public static String updateMemberServers(String domainName, String action, ArrayList<?> msIDs, String timePeriodText, Integer mType, boolean ... flag) throws Exception {
        return MSHandler.updateMemberServers(domainName, action, msIDs, timePeriodText, null, mType, flag);
    }

    public static String updateMemberServers(String domainName, String action, ArrayList<?> msIDs, String timePeriodText, String source_product, Integer mType, boolean ... flag) throws Exception {
        String message = null;
        boolean deleteInherited = false;
        if (flag.length > 0 && flag[0]) {
            deleteInherited = true;
        }
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add(tableComputerName);
        tableList.add(tableMSName);
        Criteria criteria = new Criteria(Column.getColumn((String)tableMSName, (String)"COMPUTER_ID"), (Object)msIDs.toArray(new Long[msIDs.size()]), 8);
        Criteria adapHost = new Criteria(Column.getColumn((String)tableMSName, (String)"ISINHERITED"), (Object)new Integer(0), 0);
        Criteria elaHost = new Criteria(Column.getColumn((String)tableMSName, (String)"ISINHERITED"), (Object)new Integer(1), 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria.and(adapHost));
        if (!dataObj.isEmpty()) {
            message = MSHandler.updateMemberServers(dataObj, domainName, action, msIDs, timePeriodText, source_product, mType, false);
        }
        if (!(dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria.and(elaHost))).isEmpty()) {
            if (action.equalsIgnoreCase("Delete") && !deleteInherited) {
                return rb.getString("adap.MSHandler.inherited.host.delete.error.message");
            }
            message = MSHandler.updateMemberServers(dataObj, domainName, action, msIDs, timePeriodText, source_product, mType, true);
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String updateMemberServers(DataObject dataObj, String domainName, String action, ArrayList<?> msIDs, String timePeriodText, String source_product, Integer mType, boolean flag) throws Exception {
        String message;
        block35: {
            Iterator iter;
            int deletedCount;
            ArrayList<String> evntCollectors;
            ArrayList<String> deletedTask;
            ArrayList<String> deletedRow;
            ArrayList<String> objectGuids;
            block37: {
                int tempCount;
                int enableCount;
                int licenseCount;
                block32: {
                    block38: {
                        block36: {
                            block34: {
                                block31: {
                                    block33: {
                                        message = null;
                                        if (!action.equalsIgnoreCase("Enable")) break block31;
                                        licenseCount = MSHandler.getLicenseCount(mType);
                                        enableCount = 0;
                                        tempCount = licenseCount;
                                        if (flag) break block32;
                                        if (mType != 4096 || flag) break block33;
                                        enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{mType});
                                        break block32;
                                    }
                                    enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{16});
                                    if (16 != (mType & 0x10)) break block32;
                                    enableCount += ServerConfigAPI.getPrintServerCount();
                                    enableCount -= ServerConfigAPI.getPrintMemberServerCount(16);
                                    break block32;
                                }
                                if (!action.equalsIgnoreCase("Disable")) break block34;
                                Iterator iter2 = dataObj.getRows("AUDComputerEventRead");
                                while (iter2.hasNext()) {
                                    Row row = (Row)iter2.next();
                                    int machineType = (Integer)row.get("MACHINE_TYPE");
                                    machineType |= mType * 2;
                                    row.set("MACHINE_TYPE", (Object)(machineType &= ~mType.intValue()));
                                    if ((machineType & 8) == 8 || (machineType & 0x80) == 128) {
                                        EventSchedulerUtil.enableDisableScheduler((Long)row.get("SCHEDULE_ID"), "Disable");
                                    }
                                    dataObj.updateRow(row);
                                    if ((machineType & 4) == 4 || (machineType & 8) == 8 || (machineType & 0x40) == 64 || (machineType & 0x80) == 128 || (machineType & 0x10) == 16 || (machineType & 0x400) == 1024) continue;
                                    MSHandler.updateAdminStatus((Long)row.get("INSTANCE_ID"), 4);
                                }
                                CommonUtil.getPersistence(flag).update(dataObj);
                                message = rb.getString("adap.MSHandler.Successfully_Disabled");
                                break block35;
                            }
                            if (!action.equalsIgnoreCase("Delete")) break block36;
                            objectGuids = new ArrayList<String>();
                            deletedRow = new ArrayList<String>();
                            deletedTask = new ArrayList<String>();
                            evntCollectors = new ArrayList<String>();
                            deletedCount = 0;
                            iter = dataObj.getRows("AUDComputerEventRead");
                            break block37;
                        }
                        if (!action.equalsIgnoreCase("timePeriodChange")) break block38;
                        Long timePeriod = Long.parseLong(timePeriodText);
                        ArrayList<Long> scheduleIdList = new ArrayList<Long>();
                        Iterator iter3 = dataObj.getRows("AUDComputerEventRead");
                        while (iter3.hasNext()) {
                            Row row = (Row)iter3.next();
                            row.set("TIME_PERIOD", (Object)timePeriod);
                            dataObj.updateRow(row);
                            int machineType = (Integer)row.get("MACHINE_TYPE");
                            if ((machineType & 4) != 4 && (machineType & 8) != 8 && (machineType & 0x40) != 64 && (machineType & 0x80) != 128) continue;
                            scheduleIdList.add((Long)row.get("SCHEDULE_ID"));
                        }
                        CommonUtil.getPersistence(flag).update(dataObj);
                        if (scheduleIdList.size() > 0) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("TIME_PERIOD", timePeriod);
                            map.put("UNIT_OF_TIME", "Minutes");
                            map.put("SCHEDULE_ID", scheduleIdList.toArray(new Long[scheduleIdList.size()]));
                            SchedulerUtil.updatePeriodicScheduler(map);
                        }
                        message = rb.getString("adap.MSHandler.Successfully_Changed_the_Event_Fetch");
                        break block35;
                    }
                    if (action.equalsIgnoreCase("CONVERTTOINHERITEDHOST")) {
                        Iterator iter4 = dataObj.getRows("AUDComputerEventRead");
                        while (iter4.hasNext()) {
                            Row row = (Row)iter4.next();
                            int machineType = (Integer)row.get("MACHINE_TYPE");
                            row.set("SOURCE_PRODUCT", (Object)source_product);
                            row.set("ISINHERITED", (Object)1);
                            dataObj.updateRow(row);
                            MSHandler.checkAndEnableServer(dataObj, row, machineType);
                        }
                        CommonUtil.getPersistence(flag).update(dataObj);
                        message = rb.getString("adap.MSHandler.Successfully_enabled");
                        break block35;
                    } else if (action.equalsIgnoreCase("CONVERTTOLOCALHOST")) {
                        Iterator iter5 = dataObj.getRows("AUDComputerEventRead");
                        for (int enableCount2 = ServerConfigAPI.getConfiguredServerCount(new int[]{16}); iter5.hasNext() && enableCount2 > 0; --enableCount2) {
                            Row row = (Row)iter5.next();
                            row.set("SOURCE_PRODUCT", (Object)ProductUniqueSeqGenerator.getCurrentSeqNumber());
                            row.set("ISINHERITED", (Object)0);
                            dataObj.updateRow(row);
                        }
                        CommonUtil.getPersistence(flag).update(dataObj);
                        message = rb.getString("adap.MSHandler.Successfully_enabled");
                    }
                    break block35;
                }
                for (int i = 0; i < msIDs.size(); ++i) {
                    boolean isvalid;
                    Row enableRow;
                    block30: {
                        Criteria enableCrit = new Criteria(new Column(tableMSName, "COMPUTER_ID"), msIDs.get(i), 0);
                        enableRow = dataObj.getRow(tableMSName, enableCrit);
                        isvalid = false;
                        if (enableRow == null) continue;
                        if (flag) {
                            enableCrit = new Criteria(new Column(tableMSName, "OBJECT_GUID"), enableRow.get("OBJECT_GUID"), 0);
                            Row generalDetails = dataObj.getRow(tableComputerName, enableCrit);
                            String sourceProduct = (String)enableRow.get("SOURCE_PRODUCT");
                            enableCount = ServerConfigAPI.getConfiguredInheritedHostCount(new int[]{mType}, sourceProduct);
                            JSONObject result = null;
                            if (sourceProduct == null) {
                                logger.info("WARNING : Request processed based on Old Eventlog request  updateMemberServers");
                                result = new JSONObject();
                                result.put("STATUS", true);
                            } else {
                                result = InheritedHostHandler.checkISValidAction(generalDetails, sourceProduct, enableCount, mType);
                            }
                            if (result.has("STATUS") && result.getBoolean("STATUS")) {
                                isvalid = true;
                                break block30;
                            } else {
                                if (!result.has("eMESSAGE")) continue;
                                message = result.getString("eMESSAGE");
                                continue;
                            }
                        }
                        boolean bl = isvalid = tempCount > enableCount;
                    }
                    if (16 == (mType & 0x10) && !flag) {
                        int n = enableCount = ServerConfigAPI.isEnabledPrintServer(msIDs.get(i)) && enableCount > 0 ? --enableCount : enableCount;
                    }
                    if (mType == 1024) {
                        int machineType = (Integer)enableRow.get("MACHINE_TYPE");
                        machineType |= mType.intValue();
                        enableRow.set("MACHINE_TYPE", (Object)(machineType &= ~(mType * 2)));
                        dataObj.updateRow(enableRow);
                        message = rb.getString("adap.MSHandler.Successfully_enabled");
                        MSHandler.updateAdminStatus((Long)enableRow.get("INSTANCE_ID"), 3);
                        if ((machineType & 8) != 8 && (machineType & 0x80) != 128) continue;
                        EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
                        continue;
                    }
                    if (isvalid) {
                        message = MSHandler.checkAndEnableServer(dataObj, enableRow, mType);
                        if (!flag) {
                            --tempCount;
                            continue;
                        }
                        CommonUtil.getPersistence(flag).update(dataObj);
                        continue;
                    }
                    if (licenseCount > 0) {
                        if (mType == 16) {
                            message = rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_Member_Servers", new String[]{Integer.toString(licenseCount)});
                            continue;
                        }
                        message = rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_work_stations", new String[]{Integer.toString(licenseCount)});
                        continue;
                    }
                    message = rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                }
                if (!flag) {
                    CommonUtil.getPersistence(flag).update(dataObj);
                }
                break block35;
            }
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                int machineType = (Integer)row.get("MACHINE_TYPE");
                machineType &= ~mType.intValue();
                row.set("MACHINE_TYPE", (Object)(machineType &= ~(mType * 2)));
                boolean isUpdate = false;
                if ((machineType & 4) == 4 || (machineType & 8) == 8 || (machineType & 0x40) == 64 || (machineType & 0x80) == 128) {
                    logger.log(Level.INFO, "The server is configured as Cluster Node /File server");
                    dataObj.updateRow(row);
                    isUpdate = true;
                } else {
                    if (mType.equals(16) && ((machineType & 0x400) == 1024 || (machineType & 0x800) == 2048)) {
                        dataObj.updateRow(row);
                        isUpdate = true;
                    } else if (mType.equals(1024) && ((machineType & 0x10) == 16 || (machineType & 0x20) == 32)) {
                        dataObj.updateRow(row);
                        isUpdate = true;
                    }
                    if (!isUpdate) {
                        deletedRow.add((String)row.get("OBJECT_GUID"));
                        objectGuids.add((String)row.get("OBJECT_GUID"));
                        deletedTask.add(Long.toString((Long)row.get("INSTANCE_ID")));
                        instanceVsGUIDMap.put((Long)row.get("INSTANCE_ID"), (String)row.get("OBJECT_GUID"));
                    }
                }
                evntCollectors.add((String)row.get("OBJECT_GUID"));
                if (++deletedCount < 100) continue;
                MSHandler.removeTaskInstanceID(deletedTask, new boolean[0]);
                deletedTask.clear();
                deletedCount = 0;
            }
            CommonUtil.getPersistence(flag).update(dataObj);
            MSHandler.removeTaskInstanceID(deletedTask, flag);
            if (deletedRow != null && !deletedRow.isEmpty() && deletedRow.size() > 0 && mType.equals(1024)) {
                EventCollectorHandler.deleteEvntCollectorDetails(evntCollectors.toArray(new String[deletedRow.size()]));
            }
            message = rb.getString("adap.MSHandler.Successfully_deleted");
            String gpoName = "";
            gpoName = mType == 4096 ? GpoHandler.gpoForWs : GpoHandler.gpoForFs;
            GpoHandler.removeSecurityFilter(domainName, gpoName, objectGuids.toArray(new String[objectGuids.size()]));
        }
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    private static String checkAndEnableServer(DataObject dataObj, Row enableRow, int mType) throws Exception {
        String message = null;
        int machineType = (Integer)enableRow.get("MACHINE_TYPE");
        machineType |= mType;
        enableRow.set("MACHINE_TYPE", (Object)(machineType &= ~(mType * 2)));
        dataObj.updateRow(enableRow);
        message = rb.getString("adap.MSHandler.Successfully_enabled");
        MSHandler.updateAdminStatus((Long)enableRow.get("INSTANCE_ID"), 3);
        if ((machineType & 8) == 8 || (machineType & 0x80) == 128) {
            EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
        }
        return message;
    }

    public static void updateAdminStatus(Long instanceId, int adminStatus) throws Exception {
        Criteria eCrit = new Criteria(new Column("Task_Input", "INSTANCE_ID"), (Object)instanceId, 0);
        DataObject eDo = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", eCrit);
        Row eRow = eDo.getRow("Task_Input", eCrit);
        eRow.set("ADMIN_STATUS", (Object)adminStatus);
        eDo.updateRow(eRow);
        CommonUtil.getPersistence(new boolean[0]).update(eDo);
    }

    public static void fetchMSData(Long instanceId) throws Exception {
        Criteria criteria = new Criteria(new Column("AUDComputerEventRead", "INSTANCE_ID"), (Object)instanceId, 0);
        ArrayList<String> list = new ArrayList<String>();
        list.add("ADSMComputerGeneralDetails");
        list.add("AUDComputerEventRead");
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(list, criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("ADSMComputerGeneralDetails");
            Row eventRow = dataObject.getRow("AUDComputerEventRead");
            String domainName = (String)row.get("DOMAIN_NAME");
            String computerName = (String)row.get("NAME");
            String osVersion = (String)row.get("VERSION");
            String objectGuid = (String)row.get("OBJECT_GUID");
            Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
            Integer eventFetchMode = (Integer)eventRow.get("EVENT_FETCH_MODE");
            Properties props = new Properties();
            props.put("TIME_PERIOD", eventRow.get("TIME_PERIOD"));
            props.put("TIME_READ", eventRow.get("TIME_READ"));
            props.put("OBJECT_GUID", objectGuid);
            if ((machineType & 0x400) == 1024 && (machineType & 4) != 4) {
                EventCollectorHandler.getCollectorDetails(props);
                logger.log(Level.INFO, "props after event collector" + props);
            }
            if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024 || (machineType & 0x1000) == 4096) {
                logger.log(Level.INFO, "Going to fetch the event for the machine " + computerName);
                if (System.currentTimeMillis() - (Long)props.get("TIME_PERIOD") * 60L * 1000L > (Long)props.get("TIME_READ")) {
                    Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                    if (EventDataHandler.getInstance().dcStatusP == null) {
                        EventDataHandler.getInstance().dcStatusP = new Hashtable();
                        logger.log(Level.INFO, "Initializing for DC -> " + computerName);
                        EventDataHandler.getInstance().dcStatusP.put(computerName, 1);
                    } else if (EventDataHandler.getInstance().dcStatusP.get(computerName) == null) {
                        EventDataHandler.getInstance().dcStatusP.put(computerName, 1);
                    } else {
                        Integer state = EventDataHandler.getInstance().dcStatusP.get(computerName);
                        if (state == 1) {
                            logger.log(Level.INFO, "Event fetching is already on for " + computerName);
                            throw new Exception(rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{computerName}));
                        }
                    }
                    EventDataHandler.getInstance().dcStatusP.put(computerName, 1);
                    try {
                        Long recordNumber = EventDataUtil.getRecordNumber(computerName, domainName);
                        Long timeGenerated = EventDataUtil.getEventTime(computerName, domainName);
                        boolean isLocalDll = EventCollectionUtil.useLocalMessageDLL();
                        EventDataUtil.updateEventLogMessage("Event collection scheduled", computerName, domainName);
                        logger.log(Level.INFO, "OS Version:" + osVersion);
                        logger.log(Level.INFO, "Event FetchMode:" + eventFetchMode);
                        logger.log(Level.INFO, "LocalDll:" + isLocalDll);
                        Integer isFIMEnabled = EventDataUtil.isFIMEnabled(computerName, domainName);
                        if (isFIMEnabled == 1 && FILE_INTEGRITY_MANAGER.isFIMEnabledInDomain(domainName) && FILE_INTEGRITY_MANAGER.isFIMEnabledForMachineType(domainName, machineType)) {
                            machineType = machineType + 16384;
                            logger.log(Level.INFO, "FIM Enabled for:" + computerName);
                        }
                        if (osVersion == null || osVersion.equals("")) {
                            osVersion = DirectoryObjectAPI.getInstance().getObjectOsVersion(domainName, objectGuid, computerName, "computer");
                        }
                        if (osVersion != null && !osVersion.startsWith("5.0") && eventFetchMode != null && eventFetchMode == 1 && isLocalDll) {
                            FetchMsEventData fetchEventData = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, null, machineType, osVersion, objectGuid, isLocalDll, 1);
                            logger.log(Level.INFO, "Native mode with local dll");
                            fetchEventData.fetchEventData();
                        } else if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0") && eventFetchMode == 2 && isLocalDll) {
                            FetchMsEventData fetchEventData = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, null, machineType, osVersion, objectGuid, isLocalDll, 2);
                            logger.log(Level.INFO, "evt query with local dll");
                            fetchEventData.fetchEventData();
                        } else if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0") && isLocalDll) {
                            FetchMsEventData fetchEventData = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, null, machineType, osVersion, objectGuid, isLocalDll, 1);
                            logger.log(Level.INFO, "native mode for os version 6 and above with local dll");
                            fetchEventData.fetchEventData();
                        } else {
                            Properties windowsProps = WindowsDirUtil.getWindowsDirectory(computerName, domainDetails);
                            osVersion = windowsProps.getProperty("Version");
                            eventFetchMode = Integer.parseInt(windowsProps.getProperty("EventFetchMode"));
                            if (osVersion.startsWith("5.0")) {
                                isLocalDll = false;
                            }
                            if (osVersion.startsWith("6.0") && !isLocalDll) {
                                FetchMsEventData fetchEventDataWmi = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, windowsProps, machineType, osVersion, objectGuid, isLocalDll, 0);
                                fetchEventDataWmi.fetchEventDataWMI();
                                logger.log(Level.INFO, "going to wmi for osversion 6.0");
                            } else if (osVersion.startsWith("6.") && eventFetchMode == 0) {
                                FetchMsEventData fetchEventDataWmi = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, windowsProps, machineType, osVersion, objectGuid, isLocalDll, 0);
                                fetchEventDataWmi.fetchEventDataWMI();
                                logger.log(Level.INFO, "wmi without local dll");
                            } else if (osVersion.startsWith("6.") && eventFetchMode == 2) {
                                FetchMsEventData fetchEventData = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, windowsProps, machineType, osVersion, objectGuid, isLocalDll, 2);
                                logger.log(Level.INFO, "evt query without local dll");
                                fetchEventData.fetchEventData();
                            } else {
                                logger.log(Level.INFO, "Going to Native:" + computerName);
                                FetchMsEventData fetchEventData = new FetchMsEventData(domainDetails, computerName, (long)recordNumber, timeGenerated, windowsProps, machineType, osVersion, objectGuid, isLocalDll, 1);
                                logger.log(Level.INFO, "all conditions unsatisfied. Therefore going to native");
                                fetchEventData.fetchEventData();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() != null) {
                            logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{computerName, ex.getMessage()});
                        } else {
                            ex.printStackTrace();
                        }
                        if ((machineType & 0x1000) != 4096) {
                            EventErrorAlert.sendMail((String)domainDetails.get("DOMAIN_NAME"), computerName, ex.getMessage(), machineType);
                        }
                        EventDataHandler.getInstance().dcStatusP.put(computerName, 0);
                        EventDataUtil.updateEventLogMessage(ex.getMessage(), computerName, domainName);
                        throw new Exception(ex);
                    }
                }
            }
        }
    }

    public static Integer getLicenseCount(Integer machineType) throws Exception {
        String licenseType = LicenseUtil.getLicenseType();
        String licensedServers = "0";
        try {
            if ((machineType & 4) == 4 || (machineType & 0x40) == 64) {
                licensedServers = LicenseUtil.getLicenseProperty("FileServer", "NumberOfFileServers");
            } else if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024) {
                licensedServers = LicenseUtil.getLicenseProperty("MemberServer", "NumberOfMemberServers");
            } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072 || (machineType & 0x80000) == 524288) {
                licensedServers = LicenseUtil.getLicenseProperty("CIFSServer", "NumberOfCIFSServers");
                if (licensedServers != null && licensedServers.equals("0") && ((machineType & 0x20000) == 131072 || (machineType & 0x100) == 256 || (machineType & 0x80000) == 524288)) {
                    licensedServers = null;
                }
            } else if ((machineType & 0x1000) == 4096) {
                licensedServers = LicenseUtil.getLicenseProperty("WorkStation", "NumberOfWorkStations");
            }
        }
        catch (NullPointerException ex) {
            licensedServers = null;
        }
        if (licenseType != null && (licenseType.equals("R") || licenseType.equals("T")) && licensedServers == null) {
            boolean status = MSHandler.getTimeDifference(machineType);
            if (status) {
                if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024) {
                    licensedServers = "10";
                } else if ((machineType & 4) == 4 || (machineType & 0x40) == 64) {
                    licensedServers = "2";
                } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072 || (machineType & 0x80000) == 524288) {
                    licensedServers = "1";
                } else if ((machineType & 0x1000) == 4096) {
                    licensedServers = "100";
                }
            } else {
                licensedServers = "0";
            }
        } else if (licenseType != null && licenseType.equals("F") && (machineType & 0x1000) != 4096) {
            licensedServers = "0";
        }
        Integer totalCount = Integer.parseInt(licensedServers);
        return totalCount;
    }

    private static boolean getTimeDifference(Integer machineType) {
        boolean status = false;
        Long currentTime = System.currentTimeMillis();
        Long startingTime = 0L;
        Criteria criteria = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"SystemParams"));
            if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024) {
                criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"MemberServerAdded", 0);
            } else if ((machineType & 4) == 4 || (machineType & 0x40) == 64) {
                criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"FileServerAdded", 0);
            } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072 || (machineType & 0x80000) == 524288) {
                criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"CIFSServerAdded", 0);
            } else if ((machineType & 0x1000) == 4096) {
                criteria = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"WorkStationAdded", 0);
            }
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"SystemParams", (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow("SystemParams");
                startingTime = Long.parseLong((String)row.get("PARAM_VALUE"));
                Long timeDiff = currentTime / 1000L - startingTime;
                if (timeDiff < 2592000L) {
                    status = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    private static void setSelectedColumn(SelectQuery query, String[] tableName, String[] columnName) throws Exception {
        for (int i = 0; i < tableName.length; ++i) {
            query.addSelectColumn(Column.getColumn((String)tableName[i], (String)columnName[i]));
        }
    }

    public static int[] getMachineTypes(String selectedTile, String action) {
        int[] machineTypes = new int[]{};
        if (selectedTile.equalsIgnoreCase("listofMS")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{16} : (action.equalsIgnoreCase("Disable") ? new int[]{32} : new int[]{16, 32});
        } else if (selectedTile.equalsIgnoreCase("listofEC")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{1024} : (action.equalsIgnoreCase("Disable") ? new int[]{2048} : new int[]{1024, 2048});
        } else if (selectedTile.equalsIgnoreCase("listofWS")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{4096} : (action.equalsIgnoreCase("Disable") ? new int[]{8192} : new int[]{4096, 8192});
        }
        return machineTypes;
    }

    public static void removeTaskInstanceID(Long instanceID, boolean ... flag) throws Exception {
        logger.log(Level.INFO, "Before Removing INSTANCE_ID :: " + instanceID);
        ArrayList<String> deletedTask = new ArrayList<String>();
        deletedTask.add(Long.toString(instanceID));
        MSHandler.removeTaskInstanceID(deletedTask, flag);
    }

    private static void removeTaskInstanceID(ArrayList deletedTask, boolean ... flag) throws Exception {
        Criteria taskCrit = new Criteria(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID"), (Object)deletedTask.toArray(new String[deletedTask.size()]), 8);
        CommonUtil.getPersistence(flag).delete(taskCrit);
        MSHandler.synchronizeNow("to Sync deleted Host Details", false);
    }

    public static Row addTaskInstanceID(Long scheduleId, Long scheduleStartTime, Long poolId) throws Exception {
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", (Object)scheduleId);
        taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID("MSEventUpdate"));
        taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(scheduleStartTime));
        taskInputRow.set("POOL_ID", (Object)poolId);
        return taskInputRow;
    }

    public static void deleteMSTasks(String domainName) {
        try {
            String[] schduleNames = new String[]{"Work_Station_Events_Scheduler", "Member_Server_Events_Scheduler"};
            Criteria deleteMSSchedulers = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schduleNames, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", deleteMSSchedulers);
            ArrayList<Long> deletedSchedule = new ArrayList<Long>();
            Iterator iterator = dataObj.getRows("Schedule");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
            }
            logger.log(Level.INFO, "MS & WS ScheduleIDs" + deletedSchedule);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"SCHEDULE_ID"), (Object)deletedSchedule.toArray(new Long[deletedSchedule.size()]), 8));
            Join join = new Join("ADSMComputerGeneralDetails", "AUDComputerEventRead", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Table baseTable = Table.getTable((String)"ADSMComputerGeneralDetails");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addJoin(join);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDComputerEventRead", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            ArrayList<String> deletedTask = new ArrayList<String>();
            int deletedCount = 0;
            if (dataObject.size("AUDComputerEventRead") > 0) {
                Iterator iterator2 = dataObject.getRows("AUDComputerEventRead");
                while (iterator2.hasNext()) {
                    Row row = (Row)iterator2.next();
                    deletedTask.add(Long.toString((Long)row.get("INSTANCE_ID")));
                    instanceVsGUIDMap.put((Long)row.get("INSTANCE_ID"), (String)row.get("OBJECT_GUID"));
                    if (++deletedCount < 100) continue;
                    MSHandler.removeTaskInstanceID(deletedTask, new boolean[0]);
                    deletedTask.clear();
                    deletedCount = 0;
                }
                MSHandler.removeTaskInstanceID(deletedTask, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isMemberServer(String hostName) {
        boolean memberServer = false;
        boolean caseSensitivity = false;
        try {
            Criteria crit1 = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)hostName, 0);
            Criteria crit2 = crit1.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)hostName, 0));
            Criteria crit3 = crit2.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OPERATING_SYSTEM"), (Object)"Windows Server*", 2, caseSensitivity));
            Criteria criteria = crit3.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"WorkStation or Server", 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            if (!dataObject.isEmpty()) {
                memberServer = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memberServer;
    }

    public static Integer getMachineType(String hostName, String domainName) {
        boolean caseSensitivity = false;
        try {
            String operatingSystem;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)hostName, 0);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)hostName, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 2, caseSensitivity));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"WorkStation or Server", 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            if (!dataObject.isEmpty() && (operatingSystem = (String)dataObject.getFirstValue("ADSMComputerGeneralDetails", "OPERATING_SYSTEM")) != null) {
                if (operatingSystem.toUpperCase().contains("WINDOWS SERVER")) {
                    return 16;
                }
                return 4096;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isMemberServer(String hostName, String domainName) {
        boolean memberServer = false;
        boolean caseSensitivity = false;
        try {
            Criteria crit1 = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)hostName, 0);
            Criteria crit2 = crit1.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)hostName, 0));
            Criteria crit3 = crit2.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OPERATING_SYSTEM"), (Object)"Windows Server*", 2, caseSensitivity));
            Criteria crit4 = crit3.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 2, caseSensitivity));
            Criteria criteria = crit4.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"WorkStation or Server", 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            if (!dataObject.isEmpty()) {
                memberServer = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memberServer;
    }

    public static String getDomainNamefromHost(String hostName) {
        String domainName = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)hostName, 0);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)hostName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                domainName = (String)row.get("DOMAIN_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static int checkAndUpdateServers(int count, int machineType, String reqSource_seqNumber) throws Exception {
        int requestedMachines = 0;
        Criteria selectedHost = new Criteria(Column.getColumn((String)tableMSName, (String)"SOURCE_PRODUCT"), (Object)reqSource_seqNumber, 0);
        selectedHost.and(new Criteria(Column.getColumn((String)tableMSName, (String)"ISINHERITED"), (Object)new Integer(1), 0));
        DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get(tableMSName, selectedHost);
        if (dobj.size(tableMSName) > count) {
            ArrayList<Long> computerList = new ArrayList<Long>();
            requestedMachines = dobj.size(tableMSName) - count;
            Iterator itr = dobj.getRows(tableMSName);
            for (int index = 0; index < requestedMachines && itr.hasNext(); ++index) {
                Row row = (Row)itr.next();
                computerList.add((Long)row.get("COMPUTER_ID"));
            }
            MSHandler.updateMemberServers(null, "Disable", computerList, null, null, machineType, true);
        }
        return requestedMachines;
    }

    public static String getComputerGuid(String computerName, String domainName) {
        String objectGuid = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableComputerName, (String)"NAME"), (Object)computerName, 0, false);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableComputerName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableComputerName, criteria);
            Row row = dataObject.getRow(tableComputerName);
            objectGuid = (String)row.get("OBJECT_GUID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectGuid;
    }

    public static synchronized void synchronizeNow(String message, boolean isDirectCall) {
        try {
            if (com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)ME_LOG360)) {
                logger.log(Level.INFO, "Calling Synchronize , " + message);
                if (synchronizer == null) {
                    synchronizer = Executors.newFixedThreadPool(1);
                }
                synchronizer.execute(new Runnable(){

                    @Override
                    public void run() {
                        DBSynchronizer.syncWithSubscribers();
                    }
                });
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

