/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.start.MemoryConfg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MySqlConfg {
    private static Logger nativeLogger = Logger.getLogger("ADSMLogger");

    public static void log(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        nativeLogger.log(l, message);
        System.out.println("MySqlConfg: " + message);
    }

    private static boolean isEveryThingOk(File file) {
        if (!file.exists()) {
            System.out.println("The File: " + file + " " + "does not exist");
            return false;
        }
        if (!file.isFile()) {
            System.out.println(String.valueOf(file) + " : " + "is not a file");
            return false;
        }
        if (!file.canRead()) {
            System.out.println("The File: " + file + " " + "does not have read permission");
            return false;
        }
        if (!file.canWrite()) {
            System.out.println("The File: " + file + " " + "does not have write permission");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setMemConfg(String fileLoc, long ramSize) {
        Long query_cache;
        boolean ret = false;
        float size = Long.valueOf(ramSize).floatValue();
        Long innodb_buffer_pool = new Float((double)size * 0.2).longValue();
        if (innodb_buffer_pool > 350L) {
            innodb_buffer_pool = 350L;
        }
        if ((query_cache = Long.valueOf(new Float((double)size * 0.05).longValue())) > 50L) {
            query_cache = 50L;
        }
        String innodb_buffer_pool_size = "innodb_buffer_pool_size = " + innodb_buffer_pool.toString() + "M";
        String query_cache_size = "query_cache_size = " + query_cache.toString() + "M";
        System.out.println("innodb_buffer_pool_size: " + innodb_buffer_pool_size);
        System.out.println("query_cache_size: " + query_cache_size);
        String oldConfFileStr = fileLoc + File.separator + "conf" + File.separator + "my.ini";
        String newConfFileStr = fileLoc + File.separator + "conf" + File.separator + "new_my.ini";
        System.out.println("oldConfFile String: " + oldConfFileStr);
        System.out.println("newConfFile String: " + newConfFileStr);
        File oldConfFile = new File(oldConfFileStr);
        File newConfFile = new File(newConfFileStr);
        FileReader inputFileReader = null;
        OutputStreamWriter outFileWriter = null;
        if (MySqlConfg.isEveryThingOk(oldConfFile)) {
            try {
                inputFileReader = new FileReader(oldConfFile);
                outFileWriter = new FileWriter(newConfFile);
                if (MySqlConfg.isEveryThingOk(newConfFile)) {
                    BufferedReader bfre = new BufferedReader(inputFileReader);
                    String Inline = null;
                    String wholefile = "";
                    while ((Inline = bfre.readLine()) != null) {
                        if (Inline.contains("innodb_buffer_pool_size")) {
                            Inline = innodb_buffer_pool_size;
                        } else if (Inline.contains("query_cache_size")) {
                            Inline = query_cache_size;
                        }
                        wholefile = wholefile + Inline + "\r\n";
                    }
                    inputFileReader.close();
                    outFileWriter.write(wholefile);
                    outFileWriter.close();
                    boolean status = oldConfFile.renameTo(new File(fileLoc + File.separator + "conf" + File.separator + "old_my.ini"));
                    if (status && (status = newConfFile.renameTo(new File(fileLoc + File.separator + "conf" + File.separator + "my.ini")))) {
                        ret = true;
                    }
                    if (!status) {
                        System.out.println("Err renaming file");
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Exception:");
                ex.printStackTrace();
            }
            finally {
                try {
                    if (inputFileReader != null) {
                        inputFileReader.close();
                    }
                    if (outFileWriter != null) {
                        outFileWriter.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("Please give Installation directory as a command line argument");
                System.exit(0);
            }
            String fileLoc = args[0];
            System.out.println("Installation Directory: " + fileLoc);
            long availSize = MemoryConfg.getSystemRamSizeinMB();
            System.out.println("Total RAM Size: " + availSize + " MB");
            if (availSize != 0L) {
                if (MySqlConfg.setMemConfg(fileLoc, availSize)) {
                    System.out.println("Sucessfuly sets mysql memory confgs");
                } else {
                    System.out.println("Failed sets mysql memory confgs");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

