/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class NativeError {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private Hashtable errors = null;

    public Hashtable getErrors() {
        return this.errors;
    }

    public Hashtable getError(Object key) {
        System.out.println("The key on error is : " + key + " t error e" + this.errors);
        if (this.errors != null) {
            ArrayList errorList = (ArrayList)this.errors.get(key);
            if (errorList != null) {
                return (Hashtable)errorList.get(0);
            }
            return null;
        }
        return null;
    }

    public String getSeverityLevel(Object key) {
        ArrayList errorList;
        String s = null;
        if (this.errors != null && (errorList = (ArrayList)this.errors.get(key)) != null && !errorList.isEmpty()) {
            Hashtable h = (Hashtable)errorList.get(0);
            s = (String)h.get("ERROR_SEVERITY");
        }
        return s;
    }

    public String getErrorMessage(Object key) {
        if (this.errors != null) {
            ArrayList errorList = (ArrayList)this.errors.get(key);
            StringBuilder stringBuilder = new StringBuilder();
            if (errorList != null && !errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    String message = rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                    if (message.indexOf(".") != -1) {
                        message = message.substring(0, message.lastIndexOf("."));
                    }
                    String s = message;
                    if (hashtable.get("ERROR_CODE") != null) {
                        s = s + " - " + rb.getString("adap.NativeError.Error_Code") + ":" + (String)hashtable.get("ERROR_CODE") + " ";
                    }
                    stringBuilder.append(s);
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public ArrayList<Hashtable> getErrorList(Object key) {
        ArrayList errorList = new ArrayList();
        if (this.errors != null) {
            errorList = (ArrayList)this.errors.get(key);
        }
        return errorList;
    }

    public void setErrorList(Object key, String errorSeverity, Object errorCode, Object errorMessage) {
        ArrayList errorList;
        if (this.errors == null) {
            this.errors = new Hashtable();
        }
        if ((errorList = (ArrayList)this.errors.get(key)) == null) {
            errorList = new ArrayList();
        }
        Hashtable<String, Object> errorTable = new Hashtable<String, Object>();
        errorTable.put("ERROR_SEVERITY", errorSeverity);
        if (errorCode != null) {
            errorTable.put("ERROR_CODE", errorCode);
        }
        errorTable.put("ERROR_MESSAGE", rb.getString((String)errorMessage));
        errorList.add(errorTable);
        System.out.println("setting error lists : " + errorTable + " for the key : " + key);
        this.errors.put(key, errorList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.errors != null) {
            Enumeration enumeration = this.errors.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                ArrayList list = (ArrayList)this.errors.get(key);
                builder.append("key is " + key);
                builder.append("error values = ");
                if (list == null || list.isEmpty()) continue;
                for (Hashtable hashtable : list) {
                    builder.append("{");
                    builder.append("ERROR_SEVERITY : " + hashtable.get("ERROR_SEVERITY"));
                    builder.append("ERROR_CODE : " + hashtable.get("ERROR_CODE"));
                    builder.append("ERROR_MESSAGE : " + rb.getString((String)hashtable.get("ERROR_MESSAGE")));
                    builder.append("}, ");
                }
            }
            return builder.toString();
        }
        return rb.getString("adap.NativeError.Error_Object_is__null");
    }
}

