/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.AdvancedGpoHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.export.AuditGPOCsvWriter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolicyHandler {
    public static final String GPO_DDC_GUID = "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
    public static final String GPO_DD_GUID = "{31B2F340-016D-11D2-945F-00C04FB984F9}";
    private static Logger logger = Logger.getLogger("EventLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String polTblName = "AUDAuditPolicy";
    public static String dcEventLogPropsTbl = "AUDDCEventLogProps";
    public static String dcConfigTbl = "ADSMDCConfiguration";
    public static String domainConfigTbl = "ADSMDomainConfiguration";

    public static void addAuditPolicy(String domainName, String gpoGUID) {
        logger.log(Level.INFO, "In getStatus().." + domainName);
        try {
            HashMap queueMap = new HashMap();
            String domainDNSName = DomainDetailsAPI.getDomainDNSName(domainName);
            logger.log(Level.INFO, "In getStatus() DNS.." + domainDNSName);
            Hashtable policyStatusObject = ADHandler.getPolicyStatus(domainName, "Event Audit", "GET", gpoGUID, AuditGPOCsvWriter.getInstance(), "true");
            String re = (String)policyStatusObject.get("policyStatusKey");
            String policyString = (String)policyStatusObject.get("AdvpolicyStatusKey");
            if (re == null || "".equals(re)) {
                logger.log(Level.SEVERE, "Return policy string from native is empty!");
                return;
            }
            logger.log(Level.INFO, "Return -> " + re);
            String[] att = re.split("%");
            logger.log(Level.FINE, "att -> " + att);
            logger.log(Level.FINE, "att length -> " + att.length);
            Criteria domainCrit = new Criteria(Column.getColumn((String)polTblName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria crit = domainCrit.and(new Criteria(Column.getColumn((String)polTblName, (String)"GPO_GUID"), (Object)gpoGUID, 0));
            DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(polTblName, crit);
            if (!polDO.isEmpty()) {
                polDO.deleteRows(polTblName, crit);
            }
            for (int i = 0; i < att.length; ++i) {
                Row row = new Row(polTblName);
                row.set("DOMAIN_NAME", (Object)domainName);
                String[] s = att[i].split("=");
                row.set("ATTRIB_NAME", (Object)s[0]);
                row.set("ATTRIB_VALUE", (Object)s[1]);
                row.set("GPO_GUID", (Object)gpoGUID);
                logger.log(Level.FINE, "Policy Row -> " + row);
                polDO.addRow(row);
            }
            AdvancedGpoHandler.constructAdvancedPolicyEntries(policyString, gpoGUID, domainName, "DC");
            if (policyString == null || "".equals(policyString)) {
                logger.log(Level.SEVERE, "Return Advanced Policy policy string from native is empty!");
                return;
            }
            CommonUtil.getPersistence(new boolean[0]).update(polDO);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error while adding policy status -> ");
            ex.printStackTrace();
        }
    }

    public boolean getAuditPolicy(String domainName, String gpoGUID, boolean refresh) throws DataAccessException {
        boolean r = false;
        Properties polProp = new Properties();
        Criteria criteria = new Criteria(Column.getColumn((String)polTblName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)polTblName, (String)"GPO_GUID"), (Object)gpoGUID, 0));
        DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(polTblName, criteria);
        if (polDO.isEmpty() && refresh) {
            PolicyHandler.addAuditPolicy(domainName, gpoGUID);
            polDO = CommonUtil.getPersistence(new boolean[0]).get(polTblName, criteria);
        }
        Iterator ie = polDO.getRows(polTblName);
        while (ie.hasNext()) {
            Row rw = (Row)ie.next();
            polProp.put(rw.get("ATTRIB_NAME"), rw.get("ATTRIB_VALUE"));
        }
        String audLogonEvt = (String)polProp.get("AuditLogonEvents");
        if (gpoGUID.equalsIgnoreCase(GPO_DD_GUID)) {
            if (audLogonEvt != null && audLogonEvt.equals("3")) {
                r = true;
            }
        } else if (gpoGUID.equalsIgnoreCase(GPO_DDC_GUID)) {
            String audAcctMgt = (String)polProp.get("AuditAccountManage");
            String audAcctLogon = (String)polProp.get("AuditAccountLogon");
            String audDSAccess = (String)polProp.get("AuditDSAccess");
            if (audAcctMgt == null || audAcctLogon == null || audDSAccess == null || audLogonEvt == null) {
                return false;
            }
            if (audAcctMgt.equals("3") && audAcctLogon.equals("3") && audLogonEvt.equals("3") && (audDSAccess.equals("3") || audDSAccess.equals("1"))) {
                r = true;
            }
            if (!r) {
                r = AdvancedGpoHandler.getAuditPolicy(domainName, gpoGUID, "DC");
            }
        }
        return r;
    }

    public boolean getDefaultAuditPolicy(String gpoGUID, boolean refresh) throws Exception {
        boolean r = false;
        Hashtable domainsConfigured = DomainHandler.getConfiguredDomains();
        Enumeration e = domainsConfigured.keys();
        while (e.hasMoreElements()) {
            String dn = (String)e.nextElement();
            Properties domProp = (Properties)domainsConfigured.get(dn);
            String isDefault = (String)domProp.get("IS_DEFAULT_DOMAIN");
            String domainName = domProp.getProperty("DOMAIN_NAME");
            if (!isDefault.equals("true")) continue;
            r = this.getAuditPolicy(domainName, gpoGUID, refresh);
        }
        return r;
    }

    public void writeAuditPolicy(String domainName, String gpoGUID) throws Exception {
        try {
            String domainFlatName = DomainDetailsAPI.getDomainFlatName(domainName, false);
            logger.log(Level.INFO, "DomainFlat Name -> " + domainFlatName);
            if (domainFlatName == null) {
                String msg = rb.getString("adap.PolicyHandler.Domain_Flat_name_returns_empty");
                logger.log(Level.SEVERE, msg);
                throw new Exception(msg);
            }
            if (!this.getAuditPolicy(domainName, gpoGUID, true)) {
                if (ADHandler.IsLocalDomain(domainFlatName)) {
                    logger.log(Level.INFO, "Going to write audit policy..");
                    ADHandler.getPolicyStatus(domainName, "Event Audit", "PUT", gpoGUID, AuditGPOCsvWriter.getInstance(), "true");
                } else {
                    logger.log(Level.INFO, "Going to write audit policy..");
                    ADHandler.getPolicyStatus(domainName, "Event Audit", "PUT", gpoGUID, AuditGPOCsvWriter.getInstance(), "false");
                }
            } else {
                logger.log(Level.INFO, "Domain policy already configured for " + domainName);
            }
            logger.log(Level.FINE, "Call has returned..");
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public static ArrayList getWindowsEventLogProps(String domainName) throws Exception {
        ArrayList<Properties> dcEventDetails = new ArrayList<Properties>();
        Properties eventLogProps = null;
        Properties domainProps = DomainHandler.getConfiguredValues(domainName, 1L);
        int noOfDCs = ((ArrayList)domainProps.get("DOMAIN_CONTROLLER_LIST")).size();
        for (int i = 0; i < noOfDCs; ++i) {
            String wmiClass;
            String[] prop;
            String password;
            String userName;
            String dcName = (String)((ArrayList)domainProps.get("DOMAIN_CONTROLLER_LIST")).get(i);
            ArrayList list = ADHandler.getWindowsDirectory(dcName, domainName, userName = (String)domainProps.get("USER_NAME"), password = (String)domainProps.get("PASSWORD"), prop = new String[]{"FileSize", "MaxfileSize", "Name", "NumberOfRecords", "OverwriteOutdated", "OverwritePolicy", "LogFileName"}, wmiClass = "select * from Win32_NTEventlogFile where LogFileName = 'Security'", null, 0, 0);
            if (list == null || list.size() <= 0) continue;
            eventLogProps = (Properties)list.get(0);
            eventLogProps.put("DCNAME", dcName);
            dcEventDetails.add(eventLogProps);
        }
        logger.log(Level.FINE, "dcEventDetails -> " + dcEventDetails);
        return dcEventDetails;
    }

    public static void addDCEventLogToDB(String domainName) {
        try {
            ArrayList dcEventLogProps = PolicyHandler.getWindowsEventLogProps(domainName);
            DataObject dcEventPropsDO = CommonUtil.getPersistence(new boolean[0]).get(dcEventLogPropsTbl, (Criteria)null);
            logger.log(Level.FINE, "dcEventPropsDO -> " + dcEventPropsDO);
            Criteria domainCriteria = new Criteria(Column.getColumn((String)dcConfigTbl, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject domainDO = CommonUtil.getPersistence(new boolean[0]).get(dcConfigTbl, domainCriteria);
            Iterator it = domainDO.getRows(dcConfigTbl);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long dcID = (Long)r.get("DOMAIN_CONTROLLER_ID");
                logger.log(Level.FINE, "dcID -> " + dcID);
                Criteria dcCrit = new Criteria(Column.getColumn((String)dcEventLogPropsTbl, (String)"DOMAIN_CONTROLLER_ID"), (Object)dcID, 0);
                dcEventPropsDO.deleteRows(dcEventLogPropsTbl, dcCrit);
            }
            logger.log(Level.FINE, "dcEventPropsDO -> " + dcEventPropsDO);
            CommonUtil.getPersistence(new boolean[0]).update(dcEventPropsDO);
            PolicyHandler.addDCEventLogPropsDO(domainName, dcEventLogProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDCEventLogPropsDO(String domainName, ArrayList dcEventLogProps) throws Exception {
        int size = dcEventLogProps.size();
        DataObject dcEvntDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        for (int i = 0; i < size; ++i) {
            Row row = new Row(dcEventLogPropsTbl);
            Hashtable dcProps = (Hashtable)dcEventLogProps.get(i);
            String dcName = (String)dcProps.get("DCNAME");
            long dcID = PolicyHandler.getDCID(dcName);
            row.set("DOMAIN_CONTROLLER_ID", (Object)dcID);
            row.set("FILE_SIZE", (Object)Long.parseLong((String)dcProps.get("FileSize")));
            row.set("MAX_FILE_SIZE", (Object)((Integer)dcProps.get("MaxfileSize")).longValue());
            row.set("NAME", dcProps.get("Name"));
            row.set("NO_OF_RECORDS", (Object)((Integer)dcProps.get("NumberOfRecords")).longValue());
            row.set("OVERWRITE_OUTDATED", (Object)((Integer)dcProps.get("OverwriteOutdated")).longValue());
            row.set("OVERWRITE_POLICY", dcProps.get("OverwritePolicy"));
            row.set("LOG_FILE_NAME", dcProps.get("LogFileName"));
            dcEvntDO.addRow(row);
        }
        logger.log(Level.FINE, "dcEvntDO -> " + dcEvntDO);
        CommonUtil.getPersistence(new boolean[0]).add(dcEvntDO);
    }

    private static Long getDCID(String dcName) throws Exception {
        long dcID = 0L;
        String dcTbl = "ADSMDCConfiguration";
        ArrayList<String> tbls = new ArrayList<String>();
        tbls.add(dcTbl);
        Criteria criteria = new Criteria(Column.getColumn((String)dcTbl, (String)"DOMAIN_CONTROLLER_NAME"), (Object)dcName, 0);
        DataObject dcDO = CommonUtil.getPersistence(new boolean[0]).get(tbls, criteria);
        Iterator it = dcDO.getRows(dcTbl);
        while (it.hasNext()) {
            Row r = (Row)it.next();
            dcID = (Long)r.get("DOMAIN_CONTROLLER_ID");
        }
        return dcID;
    }

    public static void addAuditPolicy(String domainName) throws Exception {
        String[] gpoGUIDs = new String[]{GPO_DDC_GUID, GPO_DD_GUID};
        for (int len = 0; len < gpoGUIDs.length; ++len) {
            PolicyHandler.addAuditPolicy(domainName, gpoGUIDs[len]);
        }
        PolicyHandler.addDCEventLogToDB(domainName);
    }
}

