/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.accountLockout.IISHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditPolicyHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.objects.DHCPUtil;
import com.adventnet.sym.adsm.common.server.objects.GroupHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSUpdateUtil;
import com.adventnet.sym.adsm.common.server.schema.SchemaUpdate;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GraphUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessObject {
    private static Logger logger = Logger.getLogger(ProcessObject.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private String domainName = null;
    private Hashtable hash = null;

    public ProcessObject(String str) {
        this.domainName = str;
        this.hash = new Hashtable();
    }

    public ArrayList getCurrentActions() {
        ArrayList<String> list = new ArrayList<String>();
        logger.log(Level.INFO, " Properties in the Process Object for the domain " + this.domainName + " is : " + this.hash);
        Enumeration e = this.hash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Hashtable stat = (Hashtable)this.hash.get(key);
            String action = (String)stat.get("action");
            String isCompleted = (String)stat.get("isCompleted");
            if (!isCompleted.equalsIgnoreCase("false")) continue;
            list.add(action);
        }
        return list;
    }

    public void set(String key, String action) {
        Hashtable<String, String> status = new Hashtable<String, String>();
        status.put("action", action);
        status.put("isCompleted", "false");
        this.hash.put(key, status);
    }

    public void finished(String key) {
        Hashtable stat = (Hashtable)this.hash.get(key);
        stat.put("isCompleted", "true");
    }

    public void startProcess(String key, Long loginId, String action, Hashtable props) {
        Hashtable<String, String> status = new Hashtable<String, String>();
        status.put("action", action);
        status.put("isCompleted", "false");
        this.hash.put(key, status);
        Action thr = new Action(key, action, loginId, props);
    }

    public void addDomainDatas(String domainName, Long loginId) {
        Properties domainProperties = DomainAction.addDomainGeneralDetails(domainName);
        domainProperties.setProperty("DOMAIN_NAME", domainName);
        String domainSID = domainProperties.getProperty("SID_STRING");
        String[] groupSIDs = new String[]{"S-1-5-32-544", domainSID + "-" + "512"};
        try {
            PolicyHandler.addAuditPolicy(domainName);
            Properties properties = DomainHandler.getConfiguredValues(domainName, 1L);
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            String rootDomainNamingContext = properties.getProperty("ROOT_DOMAIN_NAMING_CONTEXT");
            if (defaultNamingContext.equalsIgnoreCase(rootDomainNamingContext)) {
                groupSIDs = new String[]{"S-1-5-32-544", domainSID + "-" + "512", domainSID + "-" + "518", domainSID + "-" + "519"};
            }
            GroupHandler.updateGroups(domainName, groupSIDs);
            AuditDelegationHandler delegationHandler = new AuditDelegationHandler(domainName);
            delegationHandler.addDelegationEntries();
            delegationHandler.updateDelegationStatus();
            ProcessObject.updateExchangeServerDetails(domainName);
            logger.log(Level.INFO, "Started Fetching Data ----------------------");
            EventDataHandler.getInstance().fillEventData(domainName);
            logger.log(Level.INFO, "Finished Fetching Data ----------------------");
            Thread.sleep(20000L);
            logger.log(Level.INFO, "Stared File Watcher Thread ----------------------");
            GPOManagementListener.getInstance().startFileWatcherThread(domainName);
            logger.log(Level.INFO, "Started Generating Home Charts----------------------");
            Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.schedule.DefaultGraphGenerator");
            GraphGenerator generator = (GraphGenerator)classToInvoke.newInstance();
            LinkedHashMap<Long, HashMap> graphMap = GraphUtil.getHomeGraphList();
            Set<Long> graphIDSet = graphMap.keySet();
            for (Long graphOptId : graphIDSet) {
                HashMap detailsMap = graphMap.get(graphOptId);
                Long firstGraphDuration = (Long)detailsMap.get("FIRST_GRAPH_DURATION");
                generator.generateHighCharts(graphOptId, domainName, firstGraphDuration, new ArrayList<HashMap<String, Object>>());
                Long secondGraphDuration = (Long)detailsMap.get("SECOND_GRAPH_DURATION");
                generator.generateHighCharts(graphOptId, domainName, secondGraphDuration, new ArrayList<HashMap<String, Object>>());
            }
            logger.log(Level.INFO, "After Finishing Generating Home Charts----------------------");
            logger.log(Level.INFO, "Started Fetching Objects ----------------------");
            ObjectUpdateHandler.runDailyReport(domainName, loginId);
            logger.log(Level.INFO, "After Fetching Objects ----------------------");
            logger.log(Level.INFO, "Started to configure Member Servers.....Now am in ProcessObject.java");
            MSHandler.addMemberServers(domainName, (Integer)16, (Boolean)true, new boolean[0]);
            MSHandler.addMemberServers(domainName, (Integer)4096, (Boolean)true, new boolean[0]);
            logger.log(Level.INFO, "Finished to configure Member Servers....");
            DHCPUtil.getInstance().updateDHCPServers(domainName);
            DNSUpdateUtil.getDNSZoneObjects(domainName);
            DNSUpdateUtil.getDNSNodeObjects(domainName);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ProcessObject: Error while fetching event data!");
            ex.printStackTrace();
        }
    }

    public void scheduleUpdate(String domainName, Long loginId) {
    }

    public void updateDomainDatas(String domainName, Long loginId, Hashtable props) {
        block27: {
            try {
                String message = rb.getString("adap.DomainAction.Success");
                String tableDCName = DomainHandler.tableDCName;
                if (ADHandler.checkServerStatus(domainName, loginId)) {
                    ArrayList updates = (ArrayList)props.get("actionList");
                    Object column = null;
                    Object criteria = null;
                    for (int i = 0; i < updates.size(); ++i) {
                        String update = (String)updates.get(i);
                        Integer reportId = null;
                        if (update.equalsIgnoreCase("OU")) {
                            reportId = 701;
                        } else if (update.equalsIgnoreCase("Group")) {
                            reportId = 109;
                        } else if (update.equalsIgnoreCase("Users")) {
                            reportId = 15;
                        } else if (update.equalsIgnoreCase("Computers")) {
                            reportId = 210;
                        } else if (update.equalsIgnoreCase("Contacts")) {
                            reportId = 901;
                        } else if (update.equalsIgnoreCase("Add Policy")) {
                            PolicyHandler.addAuditPolicy(domainName);
                            AuditDelegationHandler delegationHandler = new AuditDelegationHandler(domainName);
                            delegationHandler.updateDelegationStatus();
                            GpoHandler.checkGPOExist(domainName, 4);
                            GpoHandler.checkGPOExist(domainName, 4096);
                            GpoHandler.checkAuditPolicy(domainName, 4);
                            GpoHandler.checkAuditPolicy(domainName, 4096);
                            AuditPolicyHandler.checkGPOGroupStatus(domainName, 4);
                            AuditPolicyHandler.checkGPOGroupStatus(domainName, 4096);
                        } else if (update.equalsIgnoreCase("GPO")) {
                            reportId = 503;
                        } else if (update.equalsIgnoreCase("objectsAttributes")) {
                            new SchemaUpdate(domainName).start();
                            DHCPUtil.getInstance().updateDHCPServers(domainName);
                        } else if (update.equalsIgnoreCase("Share")) {
                            ArrayList list = ServerConfigAPI.getConfiguredServers(domainName, new HashMap(), null, null, null, new int[]{4}, 0);
                            for (HashMap prop : list) {
                                String computerName = (String)prop.get("COMPUTER_NAME");
                                FileSystemAPI.getInstance().getSharesForServer(domainName, computerName, "true");
                            }
                        }
                        ArrayList reportIds = new ArrayList();
                        if (reportId != null) {
                            Hashtable<String, Integer> reportTable = new Hashtable<String, Integer>();
                            reportTable.put("report_id", reportId);
                            reportIds.add(reportTable);
                        }
                        ObjectUpdateHandler.runDailyReport(domainName, 1L, reportIds);
                    }
                    break block27;
                }
                message = rb.getString("adap.DomainHandler.Unable_to_contact_AD_Server");
                try {
                    Criteria criteria = new Criteria(Column.getColumn((String)tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)1, 0));
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
                    if (!dataObject.isEmpty()) {
                        Iterator it = dataObject.getRows(tableDCName, criteria);
                        while (it.hasNext()) {
                            Row r = (Row)it.next();
                            r.set("MESSAGE", (Object)message);
                            dataObject.updateRow(r);
                        }
                        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateExchangeServerDetails(String domainName) {
        try {
            ExchangeCallerUserNameUtil.exToDomain.clear();
            Properties domainDetails1 = ADHandler.getDomainDetails(domainName, 1L);
            ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList("cn", "serialNumber", "name", "canonicalName", "distinguishedName", "legacyExchangeDN", "objectGUID", "msExchCurrentServerRoles"));
            String searchString = "objectClass=msExchExchangeServer";
            ArrayList testresult = ADHandler.getObjectsWithOutListener(domainDetails1, (String)domainDetails1.get("CONFIGURATION_NAMING_CONTEXT"), attributeList, searchString);
            if (testresult != null && testresult.size() > 0) {
                Criteria delc = new Criteria(Column.getColumn((String)"ADSMExchangeServerDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(delc);
            }
            for (Object obj : testresult) {
                Hashtable exserver = (Hashtable)obj;
                try {
                    Properties loggingProps;
                    Row r = new Row("ADSMExchangeServerDetails");
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("NAME", ((ArrayList)exserver.get("name")).get(0));
                    if (exserver.get("serialNumber") == null || exserver.get("legacyExchangeDN") == null) continue;
                    r.set("LEGACY_EXCHANGE_DN", ((ArrayList)exserver.get("legacyExchangeDN")).get(0));
                    r.set("SERIAL_NUMBER", ((ArrayList)exserver.get("serialNumber")).get(0));
                    r.set("DISTINGUISHED_NAME", ((ArrayList)exserver.get("distinguishedName")).get(0));
                    r.set("SERVER_ROLE", ((ArrayList)exserver.get("msExchCurrentServerRoles")).get(0));
                    DataObject d = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    d.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(d);
                    Criteria crit = new Criteria(Column.getColumn((String)"IISServer", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"IISServer", (String)"SERVER_NAME"), (Object)((String)r.get("NAME")), 0));
                    d = CommonUtil.getPersistence(new boolean[0]).get("IISServer", crit);
                    if (d.isEmpty() || (loggingProps = IISHandler.getIISDetails((String)r.get("NAME"), domainName, true)).containsKey("errorMessage")) continue;
                    IISHandler.AddorUpdateIISRow(loggingProps, domainName, (String)r.get("NAME"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFileServers(String domainName) {
        logger.log(Level.INFO, "Discovering File Servers from ftDFs Objects for domain {0}", new Object[]{domainName});
        ArrayList<String> fileServerList = FileServerHandler.discoverFileServers(domainName);
        if (fileServerList.isEmpty()) {
            logger.log(Level.INFO, "Finished getting File Servers from ftDFs Objects for domain {0}. Not able to find any File Server", new Object[]{domainName});
        } else {
            logger.log(Level.INFO, "Finished getting File Servers from ftDFs Objects for domain {0}. The list of file servers : {1}", new Object[]{domainName, fileServerList});
            ArrayList<String> toBeAddedFileServerList = new ArrayList<String>();
            for (String serverName : fileServerList) {
                if (serverName.contains(".")) {
                    int index = serverName.indexOf(".");
                    serverName = serverName.substring(0, index);
                }
                toBeAddedFileServerList.add(serverName);
            }
            if (!toBeAddedFileServerList.isEmpty()) {
                try {
                    FileServerHandler.addFileServers(domainName, toBeAddedFileServerList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class Action
    extends Thread {
        private String action = null;
        private String key = null;
        private Long loginId = null;
        private Hashtable props = null;

        public Action(String k, String ac, Long l, Hashtable p) {
            this.key = k;
            this.loginId = l;
            this.action = ac;
            this.props = p;
            this.start();
        }

        @Override
        public void run() {
            if (this.action.equalsIgnoreCase("add")) {
                ProcessObject.this.addDomainDatas(ProcessObject.this.domainName, this.loginId);
            } else if (this.action.equalsIgnoreCase("update")) {
                ProcessObject.this.updateDomainDatas(ProcessObject.this.domainName, this.loginId, this.props);
            } else if (this.action.equalsIgnoreCase("scheduleUpdate")) {
                ProcessObject.this.scheduleUpdate(ProcessObject.this.domainName, this.loginId);
            } else if (this.action.equalsIgnoreCase("delete")) {
                DomainAction.deleteDomainDatas(ProcessObject.this.domainName);
            } else if (this.action.equalsIgnoreCase("home")) {
                ObjectUpdateHandler.runSelectedReport(ProcessObject.this.domainName, this.loginId, this.props);
            }
            Hashtable status = (Hashtable)ProcessObject.this.hash.get(this.key);
            status.put("isCompleted", "true");
        }
    }
}

