/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.util.PersistenceUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ScheduleHandler {
    public static boolean isCrashOccuredOnPreviousStart() {
        boolean ret = false;
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String dirStr = productHome + File.separator + "bin";
        File dirName = new File(dirStr);
        FilenameFilter filter = null;
        String fileFilter = "hs_err_pid";
        if ("hs_err_pid" != null) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("hs_err_pid");
                }
            };
        }
        String[] children = dirName.list(filter);
        for (int i = 0; i < children.length; ++i) {
            String filename = children[i];
            File file = new File(dirStr + File.separatorChar + filename);
            if (!file.isFile()) continue;
            long modTime = file.lastModified();
            String modTimeStr = new Date(modTime).toString();
            long curTime = System.currentTimeMillis();
            String curTimeStr = new Date(curTime).toString();
            if (curTime - modTime >= 40000L) continue;
            ret = true;
            System.out.println("HS Error Pid log found Crashed ....");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSchedulerStatus() {
        block28: {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("Schedule_Audit"));
            Column col = new Column("Schedule_Audit", "TASK_INPUT_ID");
            sq.addSelectColumn(col);
            sq.addSelectColumn(new Column("Schedule_Audit", "SCHEDULE_ID"));
            sq.setCriteria(new Criteria(new Column("Schedule_Audit", "TASK_EXECUTION_STATUS"), (Object)"PROCESSING", 0, false));
            Connection c = null;
            DataSet ds = null;
            RelationalAPI r = RelationalAPI.getInstance();
            ArrayList<Long> taskInputIDs = new ArrayList<Long>();
            try {
                c = r.getConnection();
                ds = r.executeQuery((Query)sq, c);
                while (ds.next()) {
                    Long taskInputID = (Long)ds.getValue("TASK_INPUT_ID");
                    taskInputIDs.add(taskInputID);
                }
            }
            catch (Exception Ex) {
                Ex.printStackTrace();
            }
            finally {
                if (ds != null) {
                    try {
                        ds.close();
                    }
                    catch (Exception Ex) {}
                }
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Exception Ex) {}
                }
            }
            System.out.println("taskInputIDs: " + taskInputIDs);
            try {
                long[] taskIds = new long[taskInputIDs.size()];
                for (int i = 0; i < taskIds.length; ++i) {
                    taskIds[i] = (Long)taskInputIDs.get(i);
                }
                DataObject taskInputsDO = DataAccess.get((String)"Task_Input", (Criteria)new Criteria(new Column("Task_Input", "INSTANCE_ID"), (Object)taskIds, 8));
                System.out.println("taskInputRows: " + taskInputsDO);
                if (taskInputsDO.isEmpty()) break block28;
                Iterator iterator = taskInputsDO.getRows("Task_Input", (Criteria)null);
                while (iterator.hasNext()) {
                    Row taskRow = (Row)iterator.next();
                    Long taskInputID = (Long)taskRow.get("INSTANCE_ID");
                    Long scheduleID = (Long)taskRow.get("SCHEDULE_ID");
                    Long nextScheduleTime = new Long(((Timestamp)taskRow.get("SCHEDULE_TIME")).getTime());
                    String nextScheduleTimeStr = ((Timestamp)taskRow.get("SCHEDULE_TIME")).toString();
                    System.out.println("nextScheduleTime String :" + nextScheduleTimeStr);
                    DataObject schedule = PersistenceUtil.getSchedule((Long)scheduleID, (boolean)true);
                    try {
                        while (nextScheduleTime < System.currentTimeMillis()) {
                            nextScheduleTime = ScheduleUtil.calculateNextScheduleTime((DataObject)schedule, (Long)nextScheduleTime, (boolean)true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.out.println("updating nextScheduleTimeStr: " + new Timestamp(nextScheduleTime).toString());
                    UpdateQueryImpl uq = new UpdateQueryImpl("Task_Input");
                    uq.setUpdateColumn("SCHEDULE_TIME", (Object)new Timestamp(nextScheduleTime));
                    uq.setCriteria(new Criteria(new Column("Task_Input", "INSTANCE_ID"), (Object)taskInputID, 0));
                    DataAccess.update((UpdateQuery)uq);
                    System.out.println("updating current schedule status to skipped");
                    uq = new UpdateQueryImpl("Schedule_Audit");
                    uq.setUpdateColumn("TASK_EXECUTION_STATUS", (Object)"SKIPPED");
                    uq.setCriteria(new Criteria(new Column("Schedule_Audit", "TASK_INPUT_ID"), (Object)taskInputID, 0).and(new Criteria(new Column("Schedule_Audit", "TASK_EXECUTION_STATUS"), (Object)"PROCESSING", 0, false)));
                    DataAccess.update((UpdateQuery)uq);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

