/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.ADMPResolver;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADSMPersUtil {
    private static Logger logger = Logger.getLogger(ADSMPersUtil.class.getName());
    public static String webFile = "conf\\web.xml";
    static Element rootElement = null;
    static String fileName = null;

    private ADSMPersUtil() {
    }

    public static String getSyMParameter(String paramKey) {
        try {
            Column col = Column.getColumn((String)"SystemParams", (String)"PARAM_NAME");
            Criteria criteria = new Criteria(col, (Object)paramKey, 0);
            DataObject sharefolderDO = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (sharefolderDO.isEmpty()) {
                return null;
            }
            Row sfrow = sharefolderDO.getFirstRow("SystemParams");
            String paramValue = (String)sfrow.get("PARAM_VALUE");
            return paramValue;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while retrieving Parameter:" + paramKey + " from DB.", ex);
            return null;
        }
    }

    public static void updateSyMParameter(String paramName, String paramValue) throws Exception {
        Column col = Column.getColumn((String)"SystemParams", (String)"PARAM_NAME");
        Criteria criteria = new Criteria(col, (Object)paramName, 0);
        DataObject symParamDO = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
        if (symParamDO.isEmpty()) {
            Row symParamRow = new Row("SystemParams");
            symParamRow.set("PARAM_NAME", (Object)paramName);
            symParamRow.set("PARAM_VALUE", (Object)paramValue);
            symParamDO.addRow(symParamRow);
            CommonUtil.getPersistence(new boolean[0]).add(symParamDO);
            logger.log(Level.INFO, "Parameter added in DB:- param name: " + paramName + "  param value: " + paramValue);
        } else {
            Row symParamRow = symParamDO.getFirstRow("SystemParams");
            symParamRow.set("PARAM_VALUE", (Object)paramValue);
            symParamDO.updateRow(symParamRow);
            CommonUtil.getPersistence(new boolean[0]).update(symParamDO);
            logger.log(Level.INFO, "Parameter updated in DB:- param name: " + paramName + "  param value: " + paramValue);
        }
    }

    public static Row getUserAccountSettings(Long userAccId) throws Exception {
        try {
            String tableName = "UserSettings";
            Column col = Column.getColumn((String)tableName, (String)"USER_ACCOUNT_ID");
            Criteria criteria = new Criteria(col, (Object)userAccId, 0);
            DataObject settingsDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row userAccRow = null;
            if (!settingsDO.isEmpty()) {
                userAccRow = settingsDO.getRow(tableName);
            }
            return userAccRow;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while retrieving user settings for user account id: " + userAccId, ex);
            throw new Exception("Exception while retrieving user settings");
        }
    }

    public static String getServiceName(String loginName) throws Exception {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("AaaLogin");
            tables.add("AaaUser");
            tables.add("AaaAccount");
            tables.add("AaaService");
            SelectQuery query = QueryConstructor.get(tables, (Criteria)new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(query);
            String serviceName = (String)dataObject.getFirstValue("AaaService", "NAME");
            return serviceName;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while getting serviceName for loginName: " + loginName, e);
            throw new Exception("Exception while getting serviceName");
        }
    }

    public static Row addOrUpdateUserAccountSettings(Row userAccRow) throws Exception {
        try {
            String tableName = "UserSettings";
            Column col = Column.getColumn((String)tableName, (String)"USER_ACCOUNT_ID");
            Criteria criteria = new Criteria(col, userAccRow.get("USER_ACCOUNT_ID"), 0);
            DataObject settingsDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (settingsDO.isEmpty()) {
                settingsDO.addRow(userAccRow);
                CommonUtil.getPersistence(new boolean[0]).add(settingsDO);
                logger.log(Level.FINEST, "Adding User Account Settings: " + userAccRow);
            } else {
                settingsDO.updateRow(userAccRow);
                settingsDO = CommonUtil.getPersistence(new boolean[0]).update(settingsDO);
                userAccRow = settingsDO.getRow(tableName);
                logger.log(Level.FINER, "Updating User Account Settings: " + userAccRow);
            }
            return userAccRow;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while add/update user account settings: " + userAccRow, ex);
            throw new Exception("Exception while add/update user account settings");
        }
    }

    public static boolean checkSSL() throws Exception {
        boolean isEnable = false;
        String ssl = null;
        try {
            ssl = ADSMPersUtil.getSyMParameter("SSL");
            if (ssl == null) {
                ssl = "false";
                ADSMPersUtil.updateSyMParameter("SSL", ssl);
            }
            if (ssl.equalsIgnoreCase("true")) {
                isEnable = true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while checking ssl. ", ex);
            throw ex;
        }
        return isEnable;
    }

    public static void enableSSLPort(int port) throws Exception {
        try {
            System.out.println("enabling SSLPort:" + port);
            ADSMPersUtil.addSecurity("..\\conf\\Server.xml", port);
            ADSMPersUtil.addconfidential("..\\" + webFile, "CONFIDENTIAL", "..\\conf\\web.dtd");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while enableSSLPort to: " + port, ex);
            throw ex;
        }
    }

    public static void disableSSLPort() throws Exception {
        try {
            System.out.println("disabling SSLPort:");
            ADSMPersUtil.removeSecurity("..\\conf\\Server.xml");
            ADSMPersUtil.addconfidential("..\\" + webFile, "NONE", "..\\conf\\web.dtd");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while disableSSLPort: " + ex);
            throw ex;
        }
    }

    private static void addSecurity(String filePath, int sslport) {
        try {
            logger.log(Level.INFO, "addSecurity starts");
            String fileName = filePath;
            Element rootElement = null;
            boolean check = false;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            File logFile = new File(filePath);
            Document document = factory.newDocumentBuilder().parse(logFile);
            rootElement = document.getDocumentElement();
            logger.log(Level.INFO, " RootElementName:" + rootElement.getTagName());
            NodeList nlist = rootElement.getElementsByTagName("Service");
            System.out.println("changing redirectPort");
            for (int j = 0; j < nlist.getLength(); ++j) {
                Node nl = nlist.item(j);
                NodeList clist = ((Element)nl).getElementsByTagName("Connector");
                for (int k = 0; k < clist.getLength(); ++k) {
                    Node cl = clist.item(k);
                    String nodeName = ((Element)cl).getAttribute("name");
                    System.out.println("changing redirectPort nodeName:" + nodeName);
                    if (nodeName == null || !nodeName.equalsIgnoreCase("WebServer")) continue;
                    System.out.println("changed redirectPort:");
                    ((Element)cl).setAttribute("redirectPort", String.valueOf(sslport));
                    check = true;
                }
            }
            NodeList childNodelist = rootElement.getChildNodes();
            int childNodelistLength = childNodelist.getLength();
            logger.log(Level.INFO, "ChildNodelist \t     :" + childNodelist);
            logger.log(Level.INFO, "ChildNodelist length  :" + childNodelistLength);
            for (int i = 0; i < childNodelistLength; ++i) {
                Node childNode = childNodelist.item(i);
                String childNodeName = childNode.getNodeName();
                logger.log(Level.INFO, "ChildNodeName  :" + childNodeName);
                if (!childNodeName.equalsIgnoreCase("Service")) continue;
                logger.log(Level.INFO, "Appending the Node...");
                childNode.normalize();
                Element Connection2 = document.createElement("Connector");
                Connection2.setAttribute("port", String.valueOf(sslport));
                Connection2.setAttribute("name", "SSL");
                Connection2.setAttribute("maxThreads", "150");
                Connection2.setAttribute("minSpareThreads", "25");
                Connection2.setAttribute("maxSpareThreads", "75");
                Connection2.setAttribute("enableLookups", "true");
                Connection2.setAttribute("disableUploadTimeout", "true");
                Connection2.setAttribute("acceptCount", "100");
                Connection2.setAttribute("debug", "0");
                Connection2.setAttribute("scheme", "https");
                Connection2.setAttribute("secure", "true");
                Connection2.setAttribute("clientAuth", "false");
                Connection2.setAttribute("sslProtocol", "TLS");
                Connection2.setAttribute("keystoreFile", "./conf/server.keystore");
                Connection2.setAttribute("keystorePass", "adventnet");
                Connection2.setAttribute("SSLEnabled", "true");
                Connection2.setAttribute("connectionTimeout", "-1");
                childNode.appendChild(Connection2);
                check = true;
                logger.log(Level.INFO, "Appending Node Finished...");
            }
            if (check) {
                ADSMPersUtil.writeToFile2(rootElement, fileName);
            }
            logger.log(Level.INFO, "addSecurity finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addconfidential(String filePath, String Security, String webPath) {
        try {
            logger.log(Level.INFO, "addconfidential starts");
            String fileName = filePath;
            Element rootElement = null;
            File logFile = new File(filePath);
            boolean check = false;
            logger.log(Level.INFO, "logFileName:   " + logFile.getName());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ADMPResolver(webPath));
            Document document = builder.parse(logFile);
            rootElement = document.getDocumentElement();
            logger.log(Level.INFO, " RootElementName:" + rootElement.getTagName());
            NodeList childNodelist = rootElement.getElementsByTagName("transport-guarantee");
            int childNodelistlength = childNodelist.getLength();
            logger.log(Level.INFO, "ChildNodelist \t:" + childNodelist);
            logger.log(Level.INFO, "ChildNodelist length  :" + childNodelistlength);
            for (int i = 0; i < childNodelistlength; ++i) {
                Node childNode = childNodelist.item(i);
                String childNodeName = childNode.getNodeName();
                logger.log(Level.INFO, "ChildNodeName    :" + childNodeName);
                if (!childNodeName.equalsIgnoreCase("transport-guarantee")) continue;
                NodeList subChildNodelist = childNode.getChildNodes();
                int subChildNodelistlength = subChildNodelist.getLength();
                logger.log(Level.INFO, "subChildNodelist \t:" + subChildNodelist);
                logger.log(Level.INFO, "subChildNodelist length  :" + subChildNodelistlength);
                for (int j = 0; j < subChildNodelistlength; ++j) {
                    Node subChildNode = subChildNodelist.item(j);
                    String subChildNodeName = subChildNode.getNodeName();
                    String subChildNodeValue = subChildNode.getNodeValue();
                    logger.log(Level.INFO, "subChildNodeName    :" + subChildNodeName);
                    logger.log(Level.INFO, "subChildNodeValue   :" + subChildNodeValue);
                    if (Security.equalsIgnoreCase("CONFIDENTIAL") && subChildNodeValue.equalsIgnoreCase("NONE")) {
                        logger.log(Level.INFO, "Changing The Node value to CONFIDENTIAL...");
                        subChildNode.setNodeValue("CONFIDENTIAL");
                        check = true;
                        continue;
                    }
                    if (!Security.equalsIgnoreCase("NONE") || !subChildNodeValue.equalsIgnoreCase("CONFIDENTIAL")) continue;
                    logger.log(Level.INFO, "Changing The Node value to NONE...");
                    subChildNode.setNodeValue("NONE");
                    check = true;
                }
            }
            if (check) {
                ADSMPersUtil.writeToFile2(rootElement, fileName);
            }
            logger.log(Level.INFO, "addconfidential finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeSecurity(String filePath) {
        try {
            logger.log(Level.INFO, "removeSecurity starts");
            String fileName = filePath;
            Element rootElement = null;
            boolean check = false;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            File logFile = new File(filePath);
            Document document = factory.newDocumentBuilder().parse(logFile);
            rootElement = document.getDocumentElement();
            logger.log(Level.INFO, " Element Name:" + rootElement.getTagName());
            NodeList childNodelist = rootElement.getChildNodes();
            int childNodelistlength = childNodelist.getLength();
            logger.log(Level.INFO, "ChildNodelist \t:" + childNodelist);
            logger.log(Level.INFO, "ChildNodelist length  :" + childNodelistlength);
            for (int i = 0; i < childNodelistlength; ++i) {
                Node childNode = childNodelist.item(i);
                String childNodeName = childNode.getNodeName();
                logger.log(Level.INFO, "ChildNodeName    :" + childNodeName);
                if (!childNodeName.equalsIgnoreCase("Service")) continue;
                NodeList subChildNodelist = ((Element)childNode).getElementsByTagName("Connector");
                int subChildNodelistlength = subChildNodelist.getLength();
                logger.log(Level.INFO, "SubChildNodelist \t:" + subChildNodelist);
                logger.log(Level.INFO, "SubChildNodelist length  :" + subChildNodelistlength);
                for (int j = 0; j < subChildNodelistlength; ++j) {
                    Node subChildNode = subChildNodelist.item(j);
                    logger.log(Level.INFO, "SubChildNodeName    :" + subChildNode.getNodeName());
                    String subChildNodeValue = ((Element)subChildNode).getAttribute("name");
                    logger.log(Level.INFO, "SubChildNodeValue  :" + subChildNodeValue);
                    if (subChildNodeValue.equalsIgnoreCase("SSL")) {
                        logger.log(Level.INFO, "yes Getting SSL:");
                        Node reSubChildNode = childNode.removeChild(subChildNode);
                        logger.log(Level.INFO, "Removed NodeName :" + reSubChildNode.getNodeName());
                        check = true;
                        continue;
                    }
                    logger.log(Level.INFO, "No SSl:");
                }
            }
            if (check) {
                ADSMPersUtil.writeToFile2(rootElement, fileName);
            }
            logger.log(Level.INFO, "removeSecurity finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile2(Element rootElement, String fileName) {
        try {
            logger.log(Level.INFO, "writeToFile2 starts");
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer trans = fac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(rootElement);
            FileWriter writer = new FileWriter(new File(fileName));
            StreamResult streamResult = new StreamResult(writer);
            trans.transform(domSource, streamResult);
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            logger.log(Level.INFO, "writeToFile2 Finished");
        }
        catch (Exception ex) {
            System.err.println("Exception while writing file " + ex);
            ex.printStackTrace();
        }
    }

    public static void addconfidential() {
        ADSMPersUtil.addconfidential(webFile, "CONFIDENTIAL", "conf\\web.dtd");
    }

    public static String getCurrentLogLevel() throws Exception {
        String level = null;
        try {
            level = ADSMPersUtil.getSyMParameter("LogLevel");
            if (level == null) {
                level = "NORMAL";
                ADSMPersUtil.updateSyMParameter("LogLevel", level);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while getting current log level. ", ex);
            throw ex;
        }
        return level;
    }

    public static Properties getLanguageList() throws Exception {
        Properties language = new Properties();
        String label = null;
        String value = null;
        ArrayList<String> labelList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        try {
            logger.log(Level.INFO, "getting language list");
            DataObject languageDo = CommonUtil.getPersistence(new boolean[0]).get("ADSMLanguageList", (Row)null);
            Iterator iterator = languageDo.getRows("ADSMLanguageList");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                label = (String)row.get("Language_Label");
                labelList.add(label);
                value = (String)row.get("Language_Value");
                valueList.add(value);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "caught exception while retrieving language list:");
            ex.printStackTrace();
        }
        language.put("label", labelList);
        language.put("value", valueList);
        return language;
    }

    public static Properties getLanguageSettings() throws Exception {
        Properties langSettings = new Properties();
        try {
            logger.log(Level.INFO, "getting language settings");
            DataObject DO = CommonUtil.getPersistence(new boolean[0]).get("ADSMLanguageSettings", (Row)null);
            if (!DO.isEmpty()) {
                Row row = DO.getRow("ADSMLanguageSettings");
                String language = (String)row.get("Language_Country");
                String lcid = ((Long)row.get("LocaleID")).toString();
                langSettings.put("language", language);
                langSettings.put("lcid", lcid);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "caught exception while retrieving language settings:");
            ex.printStackTrace();
        }
        return langSettings;
    }

    public static void changeLogLevel(String level) throws Exception {
        if (level == null) {
            return;
        }
        try {
            logger.log(Level.INFO, "Starts setting the LogLevel");
            ADSMPersUtil.setLogLevel(level);
            logger.log(Level.INFO, "Finished setting the LogLevel");
            logger.log(Level.INFO, "Starts updating the LogLevel in DB");
            String dblevel = ADSMPersUtil.getSyMParameter("LogLevel");
            if (dblevel == null || !dblevel.equalsIgnoreCase(level)) {
                ADSMPersUtil.updateSyMParameter("LogLevel", level);
            } else {
                logger.log(Level.INFO, "Both DB Loglevel and input Loglevel are same");
            }
            logger.log(Level.INFO, "Finished updating the LogLevel in DB");
            logger.log(Level.INFO, "Starts setting the FileLogLevel");
            ADSMPersUtil.setFileLogLevel(level);
            logger.log(Level.INFO, "Finished setting the FileLogLevel");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while changing log level to: " + level, ex);
            throw ex;
        }
    }

    private static void setLogLevel(String level) {
        logger.log(Level.INFO, "Input loglevel string: " + level);
        if (level == null) {
            return;
        }
        if (level.equalsIgnoreCase("NORMAL")) {
            level = "INFO";
        } else if (level.equalsIgnoreCase("DEBUG")) {
            level = "ALL";
        }
        String changedLoggers = "";
        ArrayList<String> loggerNames = new ArrayList<String>();
        loggerNames.add("ADSMLogger");
        loggerNames.add("ADMangLogger");
        loggerNames.add("DelegLogger");
        logger.log(Level.INFO, "LoggerNames are: " + loggerNames);
        if (loggerNames != null && level != null) {
            Level l = Level.parse(level);
            int lsize = loggerNames.size();
            for (int j = 0; j < lsize; ++j) {
                String loggerName = (String)loggerNames.get(j);
                try {
                    Logger log = Logger.getLogger(loggerName);
                    logger.log(Level.INFO, "loggerobjectName:" + log.getName() + "    loggerobjectLevel:" + log.getLevel().getName());
                    logger.log(Level.INFO, "Level to be set:" + l.getName());
                    log.setLevel(l);
                    logger.log(Level.INFO, "Level after set:" + log.getLevel().getName());
                    continue;
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }

    public static void changeLanguageSettings(String language) throws Exception {
        if (language == null || language.equalsIgnoreCase("System_Default")) {
            logger.log(Level.INFO, "changing languagesettings with default lcid");
            long defaultlcid = ADSMPersUtil.getSystemDefaultLocaleID();
            ADSMPersUtil.setlocaleid("System_Default", defaultlcid);
        } else {
            try {
                logger.log(Level.INFO, "changing languagesettings with configured lcid: " + language);
                if (language.contains("-")) {
                    int pos = language.indexOf(45);
                    String lang = language.substring(0, pos);
                    String reg = language.substring(pos + 1, language.length());
                    logger.log(Level.INFO, "language settings are lang: " + lang + "reg" + reg);
                    String langid = ADSMPersUtil.getlanguageid("ADSMPrimaryLanguageList", lang);
                    String regid = ADSMPersUtil.getlanguageid("ADSMSubLanguageList", reg);
                    logger.log(Level.INFO, "language settings ids are : " + langid + "reg" + regid);
                    logger.log(Level.INFO, "converting language settings ids to integer: " + Integer.parseInt(langid, 16) + "reg" + Integer.parseInt(regid, 16));
                    long lcid = ADHandler.getLocaleID(Integer.parseInt(langid, 16), Integer.parseInt(regid, 16));
                    logger.log(Level.INFO, "the lcid is : " + lcid);
                    ADSMPersUtil.setlocaleid(language, lcid);
                } else {
                    String langregid = ADSMPersUtil.getlanguageid("ADSMPrimaryLanguageList", language);
                    logger.log(Level.INFO, "language settings ids are : " + langregid);
                    logger.log(Level.INFO, "converting language settings ids to integer: " + Integer.parseInt(langregid, 16));
                    long langreglcid = ADHandler.getLocaleID(Integer.parseInt(langregid, 16), 1);
                    logger.log(Level.INFO, "the lcid is : " + langreglcid);
                    ADSMPersUtil.setlocaleid(language, langreglcid);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "caught exception while changing language settings: " + language, ex);
                ex.printStackTrace();
            }
        }
    }

    private static void setFileLogLevel(String level) {
        logger.log(Level.INFO, "Input loglevel string: " + level);
        if (level == null) {
            return;
        }
        if (level.equalsIgnoreCase("NORMAL")) {
            level = "INFO";
        } else if (level.equalsIgnoreCase("DEBUG")) {
            level = "ALL";
        }
        String loggerFile = "..\\conf\\logging.xml";
        ADSMPersUtil.getFileElement(loggerFile);
        ADSMPersUtil.setFileElement(level);
    }

    public static long getSystemDefaultLocaleID() {
        long lcid = 0L;
        try {
            lcid = ADHandler.getLocaleID(0, 0);
            logger.log(Level.INFO, "the system default lcid is : " + lcid);
            return lcid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return lcid;
        }
    }

    public static void setlocaleid(String key, long value) {
        try {
            logger.log(Level.INFO, "starts updating the language in db");
            Criteria criteria = null;
            DataObject dataobj = CommonUtil.getPersistence(new boolean[0]).get("ADSMLanguageSettings", criteria);
            if (!dataobj.isEmpty()) {
                logger.log(Level.INFO, "the table adsmlanguagesettings is not empty");
                Criteria crit = null;
                dataobj.deleteRows("ADSMLanguageSettings", crit);
                CommonUtil.getPersistence(new boolean[0]).update(dataobj);
            }
            Row r = new Row("ADSMLanguageSettings");
            r.set("Language_Country", (Object)key);
            r.set("LocaleID", (Object)value);
            dataobj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataobj);
            logger.log(Level.INFO, "starts updating the language in db22");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getlanguageid(String tablename, String key) {
        String paramvalue = null;
        try {
            Column col = Column.getColumn((String)tablename, (String)"language");
            Criteria criteria = new Criteria(col, (Object)key, 0);
            DataObject sharefolderdo = CommonUtil.getPersistence(new boolean[0]).get(tablename, criteria);
            if (sharefolderdo.isEmpty()) {
                return null;
            }
            Row sfrow = sharefolderdo.getFirstRow(tablename);
            paramvalue = (String)sfrow.get("id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paramvalue;
    }

    private static void getFileElement(String filePath) {
        logger.log(Level.INFO, "getFileElement starts");
        try {
            fileName = filePath;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            File logFile = new File(filePath);
            Document document = factory.newDocumentBuilder().parse(logFile);
            rootElement = document.getDocumentElement();
            logger.log(Level.INFO, " Element Name:" + rootElement.getTagName());
        }
        catch (Exception e) {
            System.out.println(" Error reading/parsing file " + filePath);
        }
        logger.log(Level.INFO, "getFileElement finished");
    }

    private static void setFileElement(String level) {
        String[] loggerNames = new String[]{"ADSMLogger", "ADMangLogger", "DelegLogger"};
        boolean result = false;
        logger.log(Level.INFO, "setFileElement starts with level" + level + "for loggerNames" + loggerNames[0] + loggerNames[1] + loggerNames[2]);
        NodeList ndlist = rootElement.getElementsByTagName("Logger");
        logger.log(Level.INFO, "NodeList \t:" + ndlist);
        logger.log(Level.INFO, "NodeList length  :" + ndlist.getLength());
        for (int k = 0; k < ndlist.getLength(); ++k) {
            Node nd = ndlist.item(k);
            logger.log(Level.INFO, "NodeName    :" + nd.getNodeName());
            String loggerName = ((Element)nd).getAttribute("loggername");
            logger.log(Level.INFO, "loggerName  :" + loggerName);
            String loggerLevel = ((Element)nd).getAttribute("logger_level");
            logger.log(Level.INFO, "loggerLevel :" + loggerLevel);
            for (int i = 0; i < loggerNames.length; ++i) {
                if (!loggerName.equalsIgnoreCase(loggerNames[i])) continue;
                logger.log(Level.INFO, "LoggerName Matched:");
                ((Element)nd).setAttribute("logger_level", level);
                logger.log(Level.INFO, "AfterSet loggerLevel  :" + ((Element)nd).getAttribute("logger_level"));
                result = true;
            }
        }
        logger.log(Level.INFO, "setFileElements finished");
        if (result) {
            ADSMPersUtil.writeToFile();
        }
    }

    private static void writeToFile() {
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer trans = fac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(rootElement);
            FileWriter writer = new FileWriter(new File(fileName));
            StreamResult streamResult = new StreamResult(writer);
            trans.transform(domSource, streamResult);
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            System.err.println("Exception while writing file " + ex);
            ex.printStackTrace();
        }
    }
}

