/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.rss.db.DBAdaptor;
import com.adventnet.rss.db.DBPersistence;
import com.adventnet.rss.reader.FeedLoginParams;
import com.adventnet.rss.reader.FeedURL;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.JSONUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class AdminHandler {
    private static Logger logger = Logger.getLogger(AdminHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("\\$\\{CATEGORY_ID:([^\\}]*)\\}");

    public static Properties getAddOnRow(String productName) {
        Properties p = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"FEED_LOGIN_PARAMS", (String)"PRODUCT_NAME"), (Object)productName, 0);
            DataObject obj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("FEED_LOGIN_PARAMS", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("FEED_LOGIN_PARAMS");
                while (it.hasNext()) {
                    p = new Properties();
                    Row r = (Row)it.next();
                    p.put("HOST", r.get("HOST"));
                    p.put("PORT", (Integer)r.get("PORT"));
                    p.put("USERNAME", r.get("USERNAME"));
                    p.put("PASSWORD", r.get("PASSWORD"));
                    p.put("PROTOCOL", r.get("PROTOCOL"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static String deleteAddOnRow(String pdtName) {
        String message = rb.getString("adap.AdminHandler.Successfully_Deleted");
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"FEED_LOGIN_PARAMS", (String)"PRODUCT_NAME"), (Object)pdtName, 0);
            com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistenceLite().delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addProductDetails(String productName, Properties prop) {
        logger.log(Level.INFO, "now am in addproductdetails");
        boolean status = false;
        Connection conn = null;
        try {
            FeedLoginParams feedLogin = new FeedLoginParams();
            long feedLoginID = feedLogin.getFeedLoginId();
            String host = prop.getProperty("HOST");
            Integer po = (Integer)prop.get("PORT");
            int port = po;
            String userName = prop.getProperty("USERNAME");
            String password = prop.getProperty("PASSWORD");
            long proxyID = 0L;
            String protocol = (String)prop.get("PROTOCOL");
            String loginURL = protocol + "://" + host + ":" + port + "/HomePage.do";
            feedLogin.setProductName(productName);
            feedLogin.setRemoteHost(host);
            feedLogin.setRemotePort(port);
            feedLogin.setProtocol(protocol);
            feedLogin.setUserName(userName);
            feedLogin.setPassword(password);
            feedLogin.setContextPath("/");
            feedLogin.setActionClass("/j_security_check");
            feedLogin.setLabelUser("j_username");
            feedLogin.setLabelPass("j_password");
            feedLogin.setProxyID(proxyID);
            feedLogin.setLoginUrl(loginURL);
            conn = RelationalAPI.getInstance().getConnection();
            DBAdaptor dbadapt = new DBAdaptor(conn);
            DBPersistence dbpers = new DBPersistence(dbadapt);
            String feedUrlStr = protocol + "://" + host + ":" + port + "/servlet/RssFeedCreator";
            FeedURL feedUrl = new FeedURL();
            feedUrl.setFeedLoginID(feedLoginID);
            feedUrl.setFeedUrl(feedUrlStr);
            feedUrl.setFeedName(productName);
            logger.log(Level.INFO, "Fed All the Service Desk Details.");
            FeedLoginParams params = (FeedLoginParams)dbpers.getRowObject("FEED_LOGIN_PARAMS", "PRODUCT_NAME", productName);
            logger.log(Level.INFO, "dbpers : " + dbpers);
            if (productName.equals("ADManagerPlus")) {
                prop.put("PRODUCT_ID", CommonUtil.getProductId((String)"ManageEngine ADManager Plus"));
                JumpToHandler.updateSettings((JSONObject)JSONUtil.getJSONObject((Properties)prop));
                status = true;
            }
            if (status) {
                if (params != null) {
                    feedLogin.setFeedLoginID(params.getFeedLoginId());
                    dbpers.updateFeedLoginParams(feedLogin);
                    feedUrl.setFeedLoginID(params.getFeedLoginId());
                    dbpers.updateFeedUrl(feedUrl);
                } else {
                    dbpers.addFeedLoginParams(feedLogin);
                    feedUrl.setFeedLoginID(feedLogin.getFeedLoginId());
                    dbpers.addFeedUrl(feedUrl);
                }
                logger.log(Level.INFO, "status is " + status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkServerStatus(Properties p) {
        System.out.println("Alert.. Now am in checkServerStatus");
        boolean status = false;
        BufferedInputStream is = null;
        HttpURLConnection connection = null;
        ByteArrayOutputStream bos = null;
        String hostName = (String)p.get("HOST");
        int portNo = (Integer)p.get("PORT");
        try {
            String url = "http://" + hostName + ":" + portNo + "/servlets/ADSMServerStatusServlet";
            connection = AdminHandler.openConnection(url);
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            connection.setRequestMethod("GET");
            is = new BufferedInputStream(connection.getInputStream());
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int length = -1;
            if (is.available() > 0) {
                String resultString;
                while ((length = is.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, length);
                }
                byte[] result = bos.toByteArray();
                if (result.length > 0 && (resultString = new String(result)).equals("ServiceDeskServerRunning")) {
                    status = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return status;
    }

    public static HttpURLConnection openConnection(String urlStr) throws Exception {
        URL urlObj = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    public static String getADMPURL() {
        String admpUrl = "html/promotion/admp.html?LinkID=104";
        Properties p = AdminHandler.getAddOnRow("ADManagerPlus");
        if (p != null && !p.isEmpty()) {
            String hostName = (String)p.get("HOST");
            int portNo = (Integer)p.get("PORT");
            String protocol = (String)p.get("PROTOCOL");
            admpUrl = protocol + "://" + hostName + ":" + portNo;
        }
        logger.log(Level.FINE, "admpUrl is " + admpUrl);
        return admpUrl;
    }

    public static LinkedHashMap<String, ArrayList> getLeftTreeDetails(String tileId, AdventNetResourceBundle rb, ArrayList userActions) throws Exception {
        Long tabId = DBObjectUtil.getUVHValues("ADAPTotalTabs", tileId);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TAB_ID"), (Object)tabId, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"ACTION_ID"), (Object)userActions.toArray(), 8));
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDLeftTreeComponents"));
        query.setCriteria(crit);
        query.addSelectColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PRIORITY_ID"), true));
        DataObject dObj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        LinkedHashMap<String, ArrayList> tilesTables = new LinkedHashMap<String, ArrayList>();
        Iterator iterator = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)0L, 0));
        while (iterator.hasNext()) {
            Row parentRow = (Row)iterator.next();
            tilesTables.put(rb.getString((String)parentRow.get("TILE_DISPLAY_NAME")), AdminHandler.getDetailsList(dObj, (Long)parentRow.get("TILE_ID"), rb));
        }
        return tilesTables;
    }

    private static ArrayList getDetailsList(DataObject dObj, Long parentId, AdventNetResourceBundle rb) throws Exception {
        ArrayList<Properties> detailsList = new ArrayList<Properties>();
        Iterator iter = dObj.getRows("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"PARENT_ID"), (Object)parentId, 0));
        while (iter.hasNext()) {
            Row detailsRow = (Row)iter.next();
            Properties detailProps = new Properties();
            detailProps.setProperty("displayName", rb.getString((String)detailsRow.get("TILE_DISPLAY_NAME")));
            detailProps.setProperty("img", detailsRow.get("TILE_IMAGE") != null ? (String)detailsRow.get("TILE_IMAGE") : "");
            String url = AdminHandler.categoryIdReplaceInURL((String)detailsRow.get("TILE_URL"));
            detailProps.setProperty("url", url);
            detailProps.setProperty("heading", detailsRow.get("TILE_HEADING") != null ? rb.getString((String)detailsRow.get("TILE_HEADING")) : "");
            detailProps.setProperty("desc", detailsRow.get("TILE_DESC") != null ? rb.getString((String)detailsRow.get("TILE_DESC")) : "");
            detailProps.setProperty("id", rb.getString((String)detailsRow.get("TILE_NAME")));
            detailProps.setProperty("ACTION_ID", Long.toString((Long)detailsRow.get("ACTION_ID")));
            detailsList.add(detailProps);
        }
        return detailsList;
    }

    public static String categoryIdReplaceInURL(String url) throws Exception {
        if (url != null) {
            Matcher match = CATEGORY_PATTERN.matcher(url);
            while (match.find()) {
                String matchStr = match.group();
                Long categoryId = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:" + matchStr.replace("${", "").replace("}", "").toLowerCase());
                url = url.replace(matchStr, Long.toString(categoryId));
            }
        } else {
            url = "";
        }
        return url;
    }

    public static Integer getAccessType(String tileName, ADAPAuthObject authObj) {
        Integer accessType = 32;
        try {
            DataObject dObj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("AUDLeftTreeComponents", new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_NAME"), (Object)tileName, 0));
            Iterator iterator = dObj.getRows("AUDLeftTreeComponents");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                accessType = authObj.getAccessType((Long)row.get("ACTION_ID")) != null ? authObj.getAccessType((Long)row.get("ACTION_ID")) : accessType;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return accessType;
    }

    public static boolean isOldUIEnabled() throws Exception {
        String filePath;
        File file;
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        return (file = new File(filePath = productHome + File.separator + "webapps" + File.separator + "adap" + File.separator + "WEB-INF" + File.separator + "struts-config.xml")).length() > 20000L;
    }

    public static boolean enableDisableOldUI(boolean enable) throws Exception {
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String backupFile = productHome + File.separator + "webapps" + File.separator + "adap" + File.separator + "WEB-INF" + File.separator + "struts-config-backup.xml";
        String mainFile = productHome + File.separator + "webapps" + File.separator + "adap" + File.separator + "WEB-INF" + File.separator + "struts-config.xml";
        String tempFile = productHome + File.separator + "webapps" + File.separator + "adap" + File.separator + "WEB-INF" + File.separator + "struts-config-temp.xml";
        File file = new File(mainFile);
        boolean swap = false;
        try {
            Criteria updateCriteria = new Criteria(Column.getColumn((String)"ADAPReportURLClicks", (String)"URL_STRING"), (Object)"isOldUIEnabled", 0);
            DataObject dob = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("ADAPReportURLClicks", updateCriteria);
            Row r = dob.getFirstRow("ADAPReportURLClicks");
            if (enable && file.length() < 20000L) {
                logger.log(Level.INFO, "Enabling Old UI");
                r.set("NO_OF_CLICKS", (Object)1);
                swap = true;
            }
            if (!enable && file.length() > 20000L) {
                logger.log(Level.INFO, "Disabling Old UI");
                r.set("NO_OF_CLICKS", (Object)0);
                swap = true;
            }
            dob.updateRow(r);
            com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).update(dob);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (swap) {
            new File(mainFile).renameTo(new File(tempFile));
            new File(backupFile).renameTo(new File(mainFile));
            new File(tempFile).renameTo(new File(backupFile));
        }
        return swap;
    }
}

