/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.constant.Constable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigureDiskSpace {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static Hashtable getConfigureDiskSpace() {
        Hashtable<String, Constable> configureDiskSpace = new Hashtable<String, Constable>();
        try {
            Row row;
            DataObject dataObj = ConfigureDiskSpace.getDataObject();
            if (dataObj != null && (row = dataObj.getRow("AUDDISKSPACE")) != null) {
                configureDiskSpace.put("CONFIGURE_SPACE", (Long)row.get("CONFIGURE_SPACE"));
                configureDiskSpace.put("FREE_DISK_SPACE", (Long)row.get("FREE_DISK_SPACE"));
                configureDiskSpace.put("IS_CONFIGURED", (Boolean)row.get("IS_CONFIGURED"));
                configureDiskSpace.put("IS_NOTIFICATION_ENABLED", (Boolean)row.get("IS_NOTIFICATION_ENABLED"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configureDiskSpace;
    }

    public static boolean saveSettings(String diskSpaceVal, String enableVal, String isNotificationEnabled) {
        boolean b = true;
        try {
            boolean enable = true;
            if (enableVal.equals("false")) {
                enable = false;
            }
            boolean notifyEnabled = true;
            if (isNotificationEnabled.equals("false")) {
                notifyEnabled = false;
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDDISKSPACE", (String)"SNO"), (Object)1, 0);
            DataObject diskSpaceDO = CommonUtil.getPersistence(new boolean[0]).get("AUDDISKSPACE", crit);
            Row row = diskSpaceDO.getRow("AUDDISKSPACE");
            row.set("CONFIGURE_SPACE", (Object)Long.valueOf(diskSpaceVal));
            row.set("IS_CONFIGURED", (Object)enable);
            row.set("IS_NOTIFICATION_ENABLED", (Object)notifyEnabled);
            diskSpaceDO.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(diskSpaceDO);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }

    public static DataObject getDataObject() {
        DataObject dataObj = null;
        try {
            String tableName = "AUDDISKSPACE";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean calculateDiskSpace() {
        boolean b = true;
        Connection connection = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        String path = System.getProperty("server.dir");
        try {
            File file;
            Long freeSize;
            Long freeMegaBytes = -1L;
            if (path != null && (freeSize = Long.valueOf((file = new File(path)).getUsableSpace())) != null && !freeSize.equals(-1L)) {
                Long megaBytes = 0x100000L;
                freeMegaBytes = freeSize / megaBytes;
            }
            boolean updateB = ConfigureDiskSpace.updateIndb(freeMegaBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                b = false;
            }
        }
        return b;
    }

    public static Long getFreeSpace(String path) {
        Long freeBytes = 0L;
        try {
            Pattern p;
            Matcher m;
            String strFreeBytes = null;
            String temp = null;
            BufferedReader buff = null;
            Process pro = null;
            Runtime rt = Runtime.getRuntime();
            pro = rt.exec("cmd /c DIR /A-D \"" + path + "\"");
            buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            temp = buff.readLine();
            while (temp != null) {
                strFreeBytes = temp;
                temp = buff.readLine();
            }
            if (strFreeBytes == null) {
                pro = rt.exec("cmd /c DIR \"" + path + "\" | FIND \"bytes free\"");
                buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                strFreeBytes = buff.readLine();
            }
            if ((m = (p = Pattern.compile("\\s*\\d*\\D*(\\S*).*")).matcher(strFreeBytes)).matches()) {
                strFreeBytes = m.group(1);
                char[] c = strFreeBytes.toCharArray();
                strFreeBytes = "";
                for (int i = 0; i < c.length; ++i) {
                    if (c[i] < '0' || c[i] > '9') continue;
                    strFreeBytes = strFreeBytes + c[i];
                }
            } else {
                strFreeBytes = "-1";
            }
            freeBytes = Long.parseLong(strFreeBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            freeBytes = -1L;
        }
        return freeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getMSSQLServerDiskFreeSpace() {
        Long freeBytes = 0L;
        String dbName = CommonUtil.getDBServerName();
        if (dbName.equals("mssql")) {
            String query = "SELECT serverproperty('edition') as 'Edition',serverproperty('productversion') as 'Version',(size*8) 'Size' FROM sys.master_files WHERE DB_NAME(database_id) = DB_NAME() and physical_name like '%mdf'";
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                connection = RelationalAPI.getInstance().getConnection();
                statement = connection.createStatement();
                resultSet = QueryUtil.executeQuery("Get DB Version", statement, query);
                while (resultSet.next()) {
                    String edition = resultSet.getString("Edition");
                    String version = resultSet.getString("Version");
                    Long size = resultSet.getLong("Size");
                    String[] p = version.split("\\.");
                    int value = Integer.parseInt(p[0]);
                    if (version.indexOf("Express") != -1) {
                        if (value >= 8) {
                            freeBytes = 10484736L - size;
                            continue;
                        }
                        freeBytes = 4193894L - size;
                        continue;
                    }
                    query = "SELECT f.database_id, f.file_id, f.physical_name, total_bytes/1024 as 'TOTAL_DRIVE_SPACE', available_bytes/1024 as 'DISK_FREE_SPACE' FROM sys.master_files AS f CROSS APPLY sys.dm_os_volume_stats(f.database_id, f.file_id) where f.database_id=db_id() and f.physical_name like '%mdf'";
                    resultSet = QueryUtil.executeQuery("Get Disk space value ", statement, query);
                    while (resultSet.next()) {
                        freeBytes = resultSet.getLong("DISK_FREE_SPACE");
                    }
                }
                DataCruncher.closeConnection(connection, statement, resultSet);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                DataCruncher.closeConnection(connection, statement, resultSet);
            }
        }
        return freeBytes;
    }

    public static boolean updateIndb(Long freeMegaBytes) {
        boolean b = true;
        try {
            Long confDiskSpace;
            Criteria crit = new Criteria(Column.getColumn((String)"AUDDISKSPACE", (String)"SNO"), (Object)1, 0);
            DataObject diskSpaceDO = CommonUtil.getPersistence(new boolean[0]).get("AUDDISKSPACE", crit);
            Row row = diskSpaceDO.getRow("AUDDISKSPACE");
            row.set("FREE_DISK_SPACE", (Object)freeMegaBytes);
            diskSpaceDO.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(diskSpaceDO);
            boolean isNotificationEnabled = (Boolean)row.get("IS_NOTIFICATION_ENABLED");
            String emailAddress = ADSMPersUtil.getSyMParameter("EmailAddress");
            if (!emailAddress.equals("no")) {
                isNotificationEnabled = true;
            }
            if ((confDiskSpace = (Long)row.get("CONFIGURE_SPACE")) > freeMegaBytes && isNotificationEnabled) {
                ConfigureDiskSpace.sendAlertMail(confDiskSpace, freeMegaBytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }

    public static Hashtable isLowDiskSpace() {
        Hashtable<String, Long> lowDiskSpace = new Hashtable<String, Long>();
        try {
            DataObject dataObj = ConfigureDiskSpace.getDataObject();
            if (dataObj != null) {
                Row row = dataObj.getRow("AUDDISKSPACE");
                Long configureDiskSpace = (Long)row.get("CONFIGURE_SPACE");
                Long freeDiskSpace = (Long)row.get("FREE_DISK_SPACE");
                boolean b = (Boolean)row.get("IS_CONFIGURED");
                if (b && !freeDiskSpace.equals(-1L) && freeDiskSpace <= configureDiskSpace) {
                    lowDiskSpace.put("CONFIGURE_SPACE", configureDiskSpace);
                    lowDiskSpace.put("FREE_DISK_SPACE", freeDiskSpace);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lowDiskSpace;
    }

    private static void sendAlertMail(Long configureDiskSpace, Long freeMegaBytes) throws Exception {
        Row row;
        String toAddress;
        HashMap<String, Object> sendMailMap = new HashMap<String, Object>();
        DataObject dObj = EventErrorAlert.getDataObj();
        if (!dObj.isEmpty() && !(toAddress = (String)(row = dObj.getRow("SystemParams")).get("PARAM_VALUE")).equals("no")) {
            boolean isContentTypePlain = SendMailAPI.getInstance().getIsContentTypePlain();
            sendMailMap.put("toAddress", toAddress.split(","));
            sendMailMap.put("subject", rb.getString("adap.ConfigureDiskSpace.subject.Disk_Space"));
            if (isContentTypePlain) {
                sendMailMap.put("message", rb.handleGetObject("adap.ConfigureDiskSpace.message.Disk_Space", new String[]{Long.toString(freeMegaBytes), Long.toString(configureDiskSpace)}));
            } else {
                String urlStr = ADSMPersUtil.getProductUrl();
                sendMailMap.put("message", rb.handleGetObject("adap.ConfigureDiskSpace.message.Disk_Space_html", new String[]{Long.toString(freeMegaBytes), Long.toString(configureDiskSpace), urlStr}));
            }
            boolean sendMailStatus = SendMailAPI.getInstance().sendMail(sendMailMap);
        }
    }
}

