/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class MailAddressConfig {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static Hashtable getMailAddressConfig() {
        Hashtable<String, String> mailIdMap = new Hashtable<String, String>();
        try {
            DataObject dataObj = MailAddressConfig.getDataObj();
            if (dataObj != null) {
                Row row = dataObj.getRow("SystemParams");
                String mailId = (String)row.get("PARAM_VALUE");
                mailIdMap.put("PARAM_VALUE", mailId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mailIdMap;
    }

    public static DataObject getDataObj() {
        DataObject dataObj = null;
        try {
            String tableName = "SystemParams";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"PARAM_NAME"), (Object)"EmailAddress", 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObj;
    }

    public static boolean saveSettings(String toAddress) {
        boolean b = true;
        try {
            DataObject dataObj = MailAddressConfig.getDataObj();
            if (dataObj != null) {
                Row row = dataObj.getRow("SystemParams");
                row.set("PARAM_VALUE", (Object)toAddress);
                dataObj.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }

    public static void sendMail(String domainName, String dcName, String message) {
        System.out.println("Exception Mail Method call");
        try {
            Row row;
            String toAddress;
            HashMap<String, Object> map = new HashMap<String, Object>();
            DataObject dataObj = MailAddressConfig.getDataObj();
            if (dataObj != null && !(toAddress = (String)(row = dataObj.getRow("SystemParams")).get("PARAM_VALUE")).equals("no")) {
                String[] toAddressArray = toAddress.split(",");
                String subject = rb.getString("adap.MailAddressConfig.Failure_while_collecting_event_log");
                String sendMessage = rb.handleGetObject("adap.MailAddressConfig.htmlheadmeta_contenttexthtml_charsetiso88591_httpequivcontenttypestyle_typetextcssstyle1", new String[]{dcName, message});
                map.put("subject", subject);
                map.put("message", sendMessage);
                map.put("toAddress", toAddressArray);
                Vector<HashMap<String, Object>> inQ = new Vector<HashMap<String, Object>>();
                inQ.add(map);
                SendMailAPI.getInstance().addSendMailInQue(inQ);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

