/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TechnicianHandler {
    private static Logger logger = Logger.getLogger(TechnicianHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String[] userLDAPAttributes = new String[]{"sAMAccountName", "givenName", "sn", "initials", "mail", "name", "displayName", "description"};

    public static ArrayList<Hashtable> getUsers() {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        try {
            DataObject dbObj = TechnicianHandler.getUsersDO(null);
            Iterator it = dbObj.getRows("AaaUser");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long userId = (Long)r.get("USER_ID");
                Row r1 = dbObj.getRow("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userId, 0));
                Long loginId = (Long)r1.get("LOGIN_ID");
                Row r2 = dbObj.getRow("AaaAccount", new Criteria(Column.getColumn((String)"AaaAccount", (String)"LOGIN_ID"), (Object)loginId, 0));
                Long accountId = (Long)r2.get("ACCOUNT_ID");
                Row mapRow = dbObj.getRow("ADAPUserRoleMapping", new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"LOGIN_ID"), (Object)loginId, 0));
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("USER_ID", userId);
                hash.put("ROLE_ID", (Long)mapRow.get("ROLE_ID"));
                hash.put("ROLE_NAME", TDHandler.getRoleName((Long)mapRow.get("ROLE_ID")));
                hash.put("DISPLAY_NAME", mapRow.get("DISPLAY_NAME") != null ? (String)mapRow.get("DISPLAY_NAME") : r1.get("NAME"));
                hash.put("DOMAIN_NAME", (String)r1.get("DOMAINNAME"));
                hash.put("EMAIL_ADDRESS", mapRow.get("EMAIL_ADDRESS") != null ? (String)mapRow.get("EMAIL_ADDRESS") : "-");
                hash.put("NAME", r1.get("NAME"));
                hash.put("OBJECT_CLASS", "user");
                hash.put("DELEGATED_DOMAIN", mapRow.get("DELEGATED_DOMAIN") != null ? rb.getString((String)mapRow.get("DELEGATED_DOMAIN")) : "-");
                String domainName = "";
                domainName = r1.get("DOMAINNAME") == null ? rb.getString("adap.TechnicianHandler.ADAuditPlus_Authentication") : (String)r1.get("DOMAINNAME");
                hash.put("DOMAINNAME", domainName);
                list.add(hash);
            }
            TechnicianHandler.getUserTopLevel(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Long createUser(String domainName, String loginName, String password, Long roleId, String objectClass, String delegatedDomain) throws Exception {
        if ("".equals(objectClass) || objectClass != null && objectClass.equalsIgnoreCase("user")) {
            return TechnicianHandler.createUser(domainName, loginName, password, roleId, delegatedDomain);
        }
        logger.log(Level.INFO, "The configured Techinician's Object Class is " + objectClass);
        return TechnicianHandler.createUserTopLevel(domainName, loginName, password, roleId, objectClass, delegatedDomain);
    }

    public static Long createUser(String domainName, String loginName, String password, Long roleId, String delegatedDomain) throws Exception {
        UniqueValueHolder loginId = null;
        Long userId = null;
        try {
            userId = !domainName.equalsIgnoreCase("ADAP Authentication") ? TechnicianHandler.getUserId(loginName, domainName) : TechnicianHandler.getUserId(loginName, null);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while getting given users id from AaaUser Table. Message :" + e.getMessage());
        }
        if (userId != null) {
            throw new Exception(rb.getString("adap.TechnicianHandler.User_Account_Already_Exists"));
        }
        WritableDataObject dobj = new WritableDataObject();
        Row userRow = new Row("AaaUser");
        userRow.set("FIRST_NAME", (Object)loginName);
        dobj.addRow(userRow);
        Row loginRow = new Row("AaaLogin");
        loginRow.set("NAME", (Object)loginName);
        loginRow.set("USER_ID", userRow.get("USER_ID"));
        if (!domainName.equalsIgnoreCase("ADAP Authentication")) {
            loginRow.set("DOMAINNAME", (Object)domainName);
        } else {
            loginRow.set("DOMAINNAME", (Object)"ADAuditPlus Authentication");
        }
        dobj.addRow(loginRow);
        loginId = (UniqueValueHolder)loginRow.get("LOGIN_ID");
        Row accRow = new Row("AaaAccount");
        accRow.set("SERVICE_ID", (Object)AuthUtil.getServiceId((String)"System"));
        accRow.set("ACCOUNTPROFILE_ID", (Object)AuthUtil.getAccountProfileId((String)"Profile 2"));
        accRow.set("LOGIN_ID", loginRow.get("LOGIN_ID"));
        Row passwordRow = new Row("AaaPassword");
        passwordRow.set("PASSWDPROFILE_ID", (Object)AuthUtil.getPasswordProfileId((String)"Profile 2"));
        if (domainName.equalsIgnoreCase("ADAP Authentication")) {
            passwordRow.set("PASSWORD", (Object)password);
        } else {
            passwordRow.set("PASSWORD", (Object)"admin");
        }
        dobj.addRow(passwordRow);
        Row accPassRow = new Row("AaaAccPassword");
        accPassRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
        accPassRow.set("PASSWORD_ID", passwordRow.get("PASSWORD_ID"));
        dobj.addRow(accPassRow);
        Row accAuthRow = new Row("AaaAuthorizedRole");
        accAuthRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
        accAuthRow.set("ROLE_ID", (Object)AuthUtil.getRoleId((String)"Admin"));
        dobj.addRow(accAuthRow);
        dobj.addRow(accRow);
        int noOfSubAccounts = 0;
        noOfSubAccounts = -1;
        Row accOwnerProfileRow = new Row("AaaAccOwnerProfile");
        accOwnerProfileRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
        accOwnerProfileRow.set("ALLOWED_SUBACCOUNT", (Object)noOfSubAccounts);
        dobj.addRow(accOwnerProfileRow);
        AuthUtil.createUserAccount((DataObject)dobj);
        Row userRoleMap = new Row("ADAPUserRoleMapping");
        userRoleMap.set("ROLE_ID", (Object)roleId);
        userRoleMap.set("LOGIN_ID", (Object)((Long)loginId.getValue()));
        userRoleMap.set("USER_ID", userRow.get("USER_ID"));
        userRoleMap.set("DELEGATED_DOMAIN", (Object)delegatedDomain);
        if (!domainName.equals("ADAP Authentication")) {
            domainName = DomainDetailsAPI.getDomainName(domainName);
            Row userObjRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, loginName, "NAME", "user");
            if (userObjRow == null) {
                userObjRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, loginName, "SAM_ACCOUNT_NAME", "user");
            }
            userRoleMap.set("COMMON_NAME", userObjRow != null ? userObjRow.get("COMMON_NAME") : "-");
            userRoleMap.set("DISPLAY_NAME", userObjRow != null ? userObjRow.get("DISPLAY_NAME") : "-");
        }
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        dataObject.addRow(userRoleMap);
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        logger.log(Level.INFO, "Successfully Created Account for HelpDesk user : " + loginName + " of " + domainName + " domain");
        return (Long)loginId.getValue();
    }

    public static boolean updateUser(Long userId, Long roleId, String objectClass, String delegatedDomain) throws Exception {
        if (objectClass.equalsIgnoreCase("user")) {
            if (TechnicianHandler.isLoggedOnUser(userId)) {
                throw new Exception("Can't change the role to logged on user");
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userId, 0);
            DataObject dbObj = TechnicianHandler.getUsersDO(crit);
            Row row = dbObj.getRow("ADAPUserRoleMapping", (Criteria)null);
            row.set("ROLE_ID", (Object)roleId);
            row.set("DELEGATED_DOMAIN", (Object)delegatedDomain);
            dbObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dbObj);
        } else {
            TechnicianHandler.updateUserTopLevel(userId, roleId, "update", delegatedDomain);
        }
        return true;
    }

    public static boolean deleteUser(Long userId, String objectClass) throws Exception {
        if (objectClass.equalsIgnoreCase("user")) {
            if (TechnicianHandler.isLoggedOnUser(userId)) {
                throw new Exception("Can't delete logged on user");
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userId, 1);
            DataObject dbObj = TechnicianHandler.getUsersDO(crit = crit.and(new Criteria(Column.getColumn((String)"AaaRole", (String)"NAME"), (Object)"Admin", 0)));
            if (dbObj.isEmpty()) {
                throw new Exception("Atleast one admin user should be there");
            }
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaUser", criteria);
            CommonUtil.getPersistenceLite().delete(criteria);
        } else {
            TechnicianHandler.updateUserTopLevel(userId, null, "delete", null);
        }
        return true;
    }

    public static boolean changePassword(Long userId, String password) throws Exception {
        String loginName = (String)AuthDBUtil.getObject((String)"AaaLogin", (String)"NAME", (String)"USER_ID", (Object)userId);
        AuthUtil.changePasswordForUser((String)loginName, (String)"System", null, (String)password, (String)"ADAuditPlus Authentication");
        return true;
    }

    public static Iterator getRoles() {
        Iterator it = null;
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoles", (Criteria)null);
            it = obj.getRows("ADAPUserRoles");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return it;
    }

    public static boolean isDomainUserExist() {
        boolean status = false;
        return status;
    }

    public static boolean isLoggedOnUser(Long userId) {
        Credential cred = AuthUtil.getUserCredential();
        return cred != null && cred.getUserId().equals(userId);
    }

    private static DataObject getUsersDO(Criteria criteria) {
        DataObject dbObj = null;
        try {
            Table baseTable = Table.getTable((String)"AaaLogin");
            Table joinTable = Table.getTable((String)"AaaUser");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2);
            query.addJoin(join);
            Table accountTable = Table.getTable((String)"AaaAccount");
            Table authTable = Table.getTable((String)"AaaAuthorizedRole");
            Table roleTable = Table.getTable((String)"AaaRole");
            Table roleMapTable = Table.getTable((String)"ADAPUserRoleMapping");
            Join join1 = new Join(baseTable, accountTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            Join join2 = new Join(accountTable, authTable, new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 2);
            Join join3 = new Join(authTable, roleTable, new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 2);
            Join join4 = new Join(baseTable, roleMapTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            query.addJoin(join1);
            query.addJoin(join2);
            query.addJoin(join3);
            query.addJoin(join4);
            if (criteria != null) {
                query.setCriteria(criteria);
            }
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dbObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting Help desk user details");
            e.printStackTrace();
        }
        return dbObj;
    }

    public static boolean personalizeCheck(String userName, Long userId) {
        boolean personalizeCheck = true;
        try {
            Table table = Table.getTable((String)"AaaLogin");
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)userName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userId, 0));
            query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"*"));
            query.setCriteria(crit);
            DataObject dbObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dbObj.isEmpty()) {
                Row row = dbObj.getRow("AaaLogin");
                String loginName = (String)row.get("NAME");
                String domainName = (String)row.get("DOMAINNAME");
                personalizeCheck = loginName.equalsIgnoreCase("admin") && domainName.equals("ADAuditPlus Authentication");
            } else {
                personalizeCheck = false;
            }
        }
        catch (Exception e) {
            personalizeCheck = false;
            e.printStackTrace();
        }
        return personalizeCheck;
    }

    private static Long createUserTopLevel(String domainName, String loginName, String password, Long roleId, String objectClass, String delegatedDomain) throws Exception {
        boolean isConf = TechnicianHandler.isConfigured(loginName, domainName);
        if (isConf) {
            throw new Exception(rb.getString("adap.TechnicianHandler.User_Account_Already_Exists"));
        }
        DataObject dobj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row userRow = new Row("AUDTechnicianTopLevelConfig");
        userRow.set("OBJECT_GUID", (Object)loginName);
        userRow.set("OBJECT_CLASS", (Object)objectClass);
        userRow.set("DOMAIN_NAME", (Object)domainName);
        userRow.set("DESCRIPTION", (Object)"User's Top Level Configuration");
        userRow.set("STATUS", (Object)"ACTIVE");
        userRow.set("ROLE_ID", (Object)roleId);
        userRow.set("DELEGATED_DOMAIN", (Object)delegatedDomain);
        dobj.addRow(userRow);
        dobj = CommonUtil.getPersistence(new boolean[0]).add(dobj);
        return (Long)userRow.get("UNIQUE_ID");
    }

    private static boolean isConfigured(String loginName, String domainName) throws Exception {
        boolean isConf = true;
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"OBJECT_GUID"), (Object)loginName, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechnicianTopLevelConfig", crit);
        if (dObj.isEmpty()) {
            isConf = false;
        }
        return isConf;
    }

    private static void getUserTopLevel(ArrayList list) throws Exception {
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechnicianTopLevelConfig", (Criteria)null);
        if (!dObj.isEmpty()) {
            Iterator it = dObj.getRows("AUDTechnicianTopLevelConfig");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("USER_ID", (Long)row.get("UNIQUE_ID"));
                hash.put("ROLE_ID", (Long)row.get("ROLE_ID"));
                hash.put("ROLE_NAME", TDHandler.getRoleName((Long)row.get("ROLE_ID")));
                hash.put("DELEGATED_DOMAIN", row.get("DELEGATED_DOMAIN") != null ? rb.getString((String)row.get("DELEGATED_DOMAIN")) : "-");
                String domainName = DomainDetailsAPI.getDomainName((String)row.get("DOMAIN_NAME"));
                Row objRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, (String)row.get("OBJECT_GUID"), "OBJECT_GUID", (String)row.get("OBJECT_CLASS"));
                if (objRow != null) {
                    hash.put("NAME", (String)objRow.get("NAME"));
                    hash.put("DISPLAY_NAME", (String)objRow.get("NAME"));
                }
                hash.put("OBJECT_CLASS", (String)row.get("OBJECT_CLASS"));
                hash.put("DOMAIN_NAME", (String)row.get("DOMAIN_NAME"));
                list.add(hash);
            }
        }
    }

    private static void updateUserTopLevel(Long userId, Long roleId, String action, String delegatedDomain) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"UNIQUE_ID"), (Object)userId, 0);
        if (action.equalsIgnoreCase("delete")) {
            if (TechnicianHandler.isRelatedWithLoggedOnUser(userId)) {
                throw new Exception("Can't delete this group/OU, Because it is associated with logged on user");
            }
            logger.log(Level.INFO, "userId is " + userId);
            TechnicianHandler.deleteAssociateUserAccounts(userId);
            CommonUtil.getPersistenceLite().delete(crit);
        } else if (action.equalsIgnoreCase("update")) {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechnicianTopLevelConfig", crit);
            Row row = dObj.getFirstRow("AUDTechnicianTopLevelConfig");
            row.set("ROLE_ID", (Object)roleId);
            row.set("DELEGATED_DOMAIN", (Object)delegatedDomain);
            dObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
            TechnicianHandler.updateMembers(userId, roleId, delegatedDomain);
        }
    }

    private static void updateMembers(Long userId, Long roleId, String delegatedDomain) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"UNIQUE_ID"), (Object)userId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechUserMapping", crit);
        if (!dObj.isEmpty()) {
            Row row;
            Long[] idArray = new Long[dObj.size("AUDTechUserMapping")];
            int i = 0;
            Iterator iter = dObj.getRows("AUDTechUserMapping");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                idArray[i] = (Long)row.get("USER_ID");
                ++i;
            }
            crit = new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"USER_ID"), (Object)idArray, 8);
            dObj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoleMapping", crit);
            iter = dObj.getRows("ADAPUserRoleMapping");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                row.set("ROLE_ID", (Object)roleId);
                row.set("DELEGATED_DOMAIN", (Object)delegatedDomain);
                dObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
    }

    private static boolean isRelatedWithLoggedOnUser(Long id) throws Exception {
        Credential cred = AuthUtil.getUserCredential();
        Long userId = cred.getUserId();
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"UNIQUE_ID"), (Object)id, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"USER_ID"), (Object)userId, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechUserMapping", crit);
        return !dObj.isEmpty();
    }

    private static void deleteAssociateUserAccounts(Long userId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"UNIQUE_ID"), (Object)userId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechUserMapping", crit);
        if (!dObj.isEmpty()) {
            Iterator iterator = dObj.getRows("AUDTechUserMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                TechnicianHandler.deleteUser((Long)row.get("USER_ID"), "user");
            }
        }
    }

    public static ArrayList checkAndAddRequesterPrivileges(String loginName, String domainName, AdventNetResourceBundle rb) throws Exception {
        ArrayList policyList = new ArrayList();
        try {
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("memberOf");
            attributeList.add("distinguishedName");
            attributeList.add("objectGUID");
            String bindString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + loginName + "))";
            domainName = DomainDetailsAPI.getDomainName(domainName);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
            ArrayList list = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, bindString);
            Properties userprop = (Properties)list.get(0);
            ArrayList userDNList = (ArrayList)userprop.get("distinguishedName");
            String userDN = (String)userDNList.get(0);
            ArrayList userGroupList = (ArrayList)userprop.get("memberOf");
            ArrayList groupList = TechnicianHandler.getOUAndGroupList("ADSMGroupGeneralDetails");
            ArrayList ouList = TechnicianHandler.getOUAndGroupList("ADSMOUDetails");
            TechnicianHandler.getListFromGroup(policyList, groupList, userGroupList);
            TechnicianHandler.getListFromOU(policyList, ouList, userDN);
            if (policyList.isEmpty()) {
                Properties userdetails = TechnicianHandler.getUserPropertiesWithGroupDetails(domainName, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), userDN);
                userGroupList.add((Properties)userdetails.get("primaryGroupID"));
                TechnicianHandler.getListFromGroup(policyList, groupList, userGroupList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return policyList;
    }

    private static void getListFromOU(ArrayList policyList, ArrayList ouList, String userDN) throws Exception {
        for (int i = 0; i < ouList.size(); ++i) {
            Properties prop = (Properties)ouList.get(i);
            String ouDN = prop.getProperty("DISTINGUISHED_NAME");
            if (!userDN.toLowerCase().endsWith(ouDN.toLowerCase())) continue;
            Long policyId = (Long)prop.get("UNIQUE_ID");
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("policyId", policyId);
            hash.put("key", "OU");
            hash.put("tableName", "ADSMOUDetails");
            hash.put("roleId", (Long)prop.get("ROLE_ID"));
            hash.put("DELEGATED_DOMAIN", (String)prop.get("DELEGATED_DOMAIN"));
            policyList.add(hash);
        }
    }

    private static void getListFromGroup(ArrayList policyList, ArrayList groupList, ArrayList userGroupList) throws Exception {
        for (int i = 0; i < groupList.size(); ++i) {
            Properties prop = (Properties)groupList.get(i);
            String objectGuid = prop.getProperty("OBJECT_GUID");
            for (int j = 0; j < userGroupList.size(); ++j) {
                String userGroupGuid;
                Properties userGroupProp = (Properties)userGroupList.get(j);
                if (userGroupProp == null || (userGroupGuid = userGroupProp.getProperty("objectGUID")) == null || !userGroupGuid.equals(objectGuid)) continue;
                Long policyId = (Long)prop.get("UNIQUE_ID");
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("policyId", policyId);
                hash.put("key", "Group");
                hash.put("tableName", "ADSMGroupGeneralDetails");
                hash.put("roleId", (Long)prop.get("ROLE_ID"));
                hash.put("DELEGATED_DOMAIN", (String)prop.get("DELEGATED_DOMAIN"));
                policyList.add(hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getOUAndGroupList(String tableName) throws Exception {
        ArrayList<Properties> list = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"STATUS"), (Object)"ACTIVE", 0);
            Table baseTable = Table.getTable((String)"AUDTechnicianTopLevelConfig");
            Table joinTable = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            query.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("UNIQUE_ID", (Long)dataSet.getValue("UNIQUE_ID"));
                prop.put("OBJECT_GUID", (String)dataSet.getValue("OBJECT_GUID"));
                prop.setProperty("DISTINGUISHED_NAME", (String)dataSet.getValue("DISTINGUISHED_NAME"));
                prop.put("ROLE_ID", (Long)dataSet.getValue("ROLE_ID"));
                prop.put("DELEGATED_DOMAIN", (String)dataSet.getValue("DELEGATED_DOMAIN"));
                prop.put("IS_AUDIT_ENABLED", (Boolean)dataSet.getValue("IS_AUDIT_ENABLED"));
                prop.put("LOCALE_ID", (Long)dataSet.getValue("LOCALE_ID"));
                list.add(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return list;
    }

    public static Properties getUserPropertiesWithGroupDetails(String domainName, String defaultNamingContext, String userDN) {
        Properties properties = new Properties();
        try {
            ArrayList<String> attrList = new ArrayList<String>();
            for (String string : userLDAPAttributes) {
                attrList.add(string);
            }
            properties = ADHandler.getObjectProperties(domainName, 1L, userDN, attrList);
            attrList.add("primaryGroupID");
            properties = ADHandler.getObjectProperties(domainName, 1L, userDN, attrList);
            for (String string : userLDAPAttributes) {
                if (properties.get(string) != null) {
                    ArrayList userproplist = (ArrayList)properties.get(string);
                    properties.setProperty(string, userproplist.get(0).toString());
                    continue;
                }
                properties.setProperty(string, "-");
            }
            ArrayList primaryGroupRIDList = (ArrayList)properties.get("primaryGroupID");
            properties.put("primaryGroupID", TechnicianHandler.getPropertiesfromRID(domainName, (String)primaryGroupRIDList.get(0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static Properties getPropertiesfromRID(String domainName, String rid) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"SID_STRING"), (Object)rid, 11));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMGroupGeneralDetails", crit);
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("ADSMGroupGeneralDetails");
            Properties prop = new Properties();
            prop.setProperty("Display_Name", (String)row.get("NAME"));
            prop.setProperty("Distinguished_Name", (String)row.get("DISTINGUISHED_NAME"));
            prop.setProperty("objectRID", rid);
            prop.setProperty("groupType", (String)row.get("GROUP_TYPE"));
            prop.setProperty("objectGUID", (String)row.get("OBJECT_GUID"));
            return prop;
        }
        return null;
    }

    private static Long getUserId(String loginName, String domainName) throws Exception {
        Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0);
        c = c.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0));
        DataObject aaaLoginDO = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", c);
        return (Long)aaaLoginDO.getRow("AaaLogin").get(2);
    }

    public static String getDelegatedDomain(String delegatedDomain, AdventNetResourceBundle rb) throws Exception {
        String[] delegDomains = delegatedDomain.split(",");
        ArrayList domainsList = DomainHandler.getDomainList();
        if (delegDomains.length == 1) {
            return delegatedDomain;
        }
        if (delegDomains.length == domainsList.size()) {
            return "adap.common.text.All_Domains";
        }
        return delegatedDomain;
    }
}

